C
C
      SUBROUTINE RSEEDS (ISEND, JSEED, KTYPE)
C
C ACTION: versatile routine to set the seed for the U(0,1) generator
C AUTHOR: w.g.bardsley, university of manchester, u.k., 27/09/2012
C
C The general idea is to make sure the U(0,1) generator is initialised just 
C once to avoid repeated re-initialisation. However it may allow the input   
C a user-supplied seed interactively or by direct calls with some generators.
C Mostly it will just be called with ISEND not 1, 2, or 3, say ISEND = 0.
C
C Note: this version works with the Simfit version of RANDGEN because g05ccf$
C       and g05cbf$ first restore all 43 seeds to the defaults, then use either
C       the system clock or user-supplied seed to initialise. It (may) also
C       work with the NAG library depending on which U(0,1) generator is
C       linked.
C
C ISEND: (input) indicates the action required as follows:
C        ISEND = 1: initialise using system clock to non-repeatable state ... then idle subsequently
C        ISEND = 2: initialise using user-supplied seed to reatable state ... at every call
C        ISEND = 3: request action from user                              ... JSEED and KTYPE may be altered
C        Otherwise: probe to make sure inititilisation has happened then  ... JSEED and KTYPE returned
C JSEED: (input/output) seed
C KTYPE: (output) current seed type as follows:
C        KTYPE = 0: random seed has been set
C        KTYPE = 1: user has set seed  
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN)    :: ISEND  
      INTEGER, INTENT (INOUT) :: JSEED
      INTEGER, INTENT (OUT)   :: KTYPE
C
C Locals
C      
      INTEGER    JSEED_SAV  
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMCOL, NUMROW, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 2, NUMCOL = 2,
     +           NUMROW = 0, NTEXT = 12)
      CHARACTER (LEN = 100) LINE, TEXT(30)
      LOGICAL    REPEET
      LOGICAL    CBF_CALLED, CCF_CALLED
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   GETJ01, YESNO1
      EXTERNAL   G05CCF$, G05CBF$
      SAVE       JSEED_SAV 
      SAVE       CBF_CALLED, CCF_CALLED
      DATA       JSEED_SAV / 1 /
      DATA       CBF_CALLED, CCF_CALLED / .FALSE., .FALSE. /
      
      IF (ISEND.EQ.1) THEN
C
C ISEND = 1: impose a random seed but only call G05CCF$ the first time
C        
         KTYPE = 0
         CBF_CALLED = .FALSE.
         IF (.NOT.CCF_CALLED) THEN
            CALL G05CCF$
            CCF_CALLED = .TRUE.
         ENDIF   
      ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: impose a user-supplied seed and save JSEED
C      
         KTYPE = 1
         CCF_CALLED = .FALSE.
         CALL G05CBF$(JSEED)
         CBF_CALLED = .TRUE.
         JSEED_SAV = JSEED
      ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: user chooses and JSEED is saved if user-supplied seed is requested
C               
         WRITE (TEXT,100)
         LINE = TEXT(13)
         REPEET = .FALSE.
         CALL YESNO1 (ICOLOR, IX, IY, LSHADE, NUMCOL, NUMROW, NTEXT,
     +                LINE, TEXT,
     +                BORDER, FLASH, HIGH, REPEET)
         IF (REPEET) THEN
            CALL GETJ01 (JSEED, 
     +                  'Integer value for seed')
            CALL G05CBF$(JSEED)
            CBF_CALLED = .TRUE.
            CCF_CALLED = .FALSE.
            JSEED_SAV = JSEED
            KTYPE = 1
         ELSE
            IF (CCF_CALLED) THEN
               CBF_CALLED = .FALSE.
               KTYPE = 0
            ELSE
               CALL G05CCF$
               CBF_CALLED = .FALSE.
               CCF_CALLED = .TRUE.
               KTYPE = 0
            ENDIF      
         ENDIF     
      ELSE
C
C ISEND not in range (1,3) so compromise
C        
         IF (CCF_CALLED) THEN
            CBF_CALLED = .FALSE.
            KTYPE = 0
         ELSEIF (CBF_CALLED) THEN
            CCF_CALLED = .FALSE.
            KTYPE = 1   
         ELSE
            CALL G05CCF$
            CBF_CALLED = .FALSE.
            CCF_CALLED = .TRUE.
            KTYPE = 0
         ENDIF      
      ENDIF 
C
C In all cases except ISEND = 2 return JSEED = JSEED_SAV
C      
      IF (ISEND.NE.2) JSEED = JSEED_SAV
   
C
C Format statement
C      
  100 FORMAT (
     + 'For most purposes the random number generator is seeded using'
     +/'the system clock, and it should not be re-seeded during a run.'
     +/'However, sometimes there are reasons for users to set the seed'
     +/'to a repeatable initial state to generate identical sequences.'
     +/  
     +/'So you can choose a fixed seed to force the generator to start'
     +/'the sequence of pseudo-random numbers from a known point.'
     +/'However, generating the same sequences is not the usual way to'
     +/'perform simulation and this technique should be used with care.'
     +/
     +/'Note: Testing the U(0,1) generator cancels user-selected seeds.'
     +/ 
     +/'You input the seed ? (usually no)')
      END
C
C
