C
C
      SUBROUTINE RUNDAT (ISEND, NIN, NMAX, NNEG, NPOS, NRES, NRUN,
     +                   RESID, TITLE, ABORT)
C
C ACTION: read in data for run test
C AUTHOR: W.G.Bardsley, University of Manchester, U.K.
C         Derived from DATAIN of RSTEST 08/08/99
C         30/09/2002 replaced GETIGE by GETJGE
C         Date of this version30/08/2002
C
C         If ISEND = 1 then exit the subroutine with ISEND = 1 and
C         a set of residuals or correspondingly signed values
C         If ISEND = 2 then exit the subroutine with ISEND = 2 and
C         the current run data NNEG, NPOS, NRUN
C
      IMPLICIT   NONE
      INTEGER    NIN
      INTEGER    ISEND, M, N, NMAX, NNEG, NPOS, NRES, NRUN
      INTEGER    NBOT, NTOP
      INTEGER    NNEG1, NPOS1, NRUN1
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      DOUBLE PRECISION RESID(NMAX)
      CHARACTER  TITLE*(*)
      LOGICAL    REPEET
      LOGICAL    ABORT, FIXNPT
      PARAMETER (FIXNPT = .FALSE.)
      EXTERNAL   VECONE, GETJGE, PUTFAT, PUTWAR
      INTRINSIC  MAX, MIN
      SAVE       NNEG1, NPOS1, NRUN1
      DATA       NNEG1, NPOS1, NRUN1 / 10, 10, 10 /
      NRES = N1
      ABORT = .TRUE.
C
C Here if ISEND = 1
C Read NRES and RESID or similarly signed values from terminal
C
      IF (ISEND.EQ.N1) THEN
         CALL VECONE (NIN, NMAX, NRES, RESID, TITLE, ABORT, FIXNPT)
         IF (ABORT) THEN
             NRES = N0
             ISEND = N1
          ENDIF
C
C Enter here if ISEND = 2
C Read in NNEG, NPOS and NRUN from terminal
C
      ELSEIF (ISEND.EQ.N2) THEN
         ABORT = .FALSE.
         REPEET = .TRUE.
         NNEG = NNEG1
         NPOS = NPOS1
         NRUN = NRUN1
         DO WHILE (REPEET)
            IF (ABORT) CALL PUTFAT (
     +                'Impossible no. of runs ... Try again')
            CALL GETJGE (NNEG, N0, 'No. of negatives')
            CALL GETJGE (NPOS, N0, 'No. of positives')
            CALL GETJGE (NRUN, N1, 'No. of runs')
            M = MAX(NNEG, NPOS)
            N = MIN(NNEG, NPOS)
            IF (N.EQ.N0) THEN
               NBOT = N1
            ELSE
               NBOT = N2
            ENDIF
            IF (M.EQ.N) THEN
               NTOP = N2*N
            ELSE
               NTOP = N2*N + N1
            ENDIF
C
C Test for incorrect values
C
            ABORT = .FALSE.
            IF (NRUN.LT.NBOT .OR. NRUN.GT.NTOP) ABORT = .TRUE.
            IF (N.EQ.N0 .AND. NRUN.NE.N1) ABORT = .TRUE.
            IF (N.EQ.N1 .AND. NRUN.LT.N2) ABORT = .TRUE.
            IF (N.EQ.N1 .AND. M.EQ.N1 .AND. NRUN.NE.N2) ABORT = .TRUE.
            IF (N.LT.N1 .OR. NRUN.LT.N2) THEN
               CALL PUTWAR ('These values are a singular case')
            ENDIF
            REPEET = ABORT
         ENDDO
         NNEG1 = NNEG
         NPOS1 = NPOS
         NRUN1 = NRUN
      ENDIF
      END
C
C
