C
C
      SUBROUTINE RUNSIN (ISEND, NIN, NMAX, NOUT, NX, NY, NZ,
     +                   X, Y, Z,
     +                   TITLEX, TITLEY, TITLEZ)
C
C ACTION: Runs and signs
C AUTHOR: W.G.Bardsley, University of Manchester, U.K
C         Derived from RUNSIN of RSTEST 08/08/99
C         25/09/2002 replaced patch1 by table1
C         20/08/2007 edited for Version 6 and added ISEND = 4
C
C         ISEND = 0: read in 2 samples of equal length
C         ISEND = 1: read in a set of residuals
C         ISEND = 2: read in numbers interactively
C         ISEND = 3: vector is supplied
C         ISEND = 4: two vectors are supplied
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, NIN, NMAX, NOUT
      INTEGER,             INTENT (INOUT) :: NX, NY, NZ
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NMAX), Y(NMAX), Z(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLEX, TITLEY, TITLEZ
C
C Locals
C      
      INTEGER    N0, N1, N2, N3, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    ICOLOR, NUMTXT
      PARAMETER (NUMTXT = 10)
      INTEGER    ICOUNT, NNEG, NPOS, NRUN, NR1, NR5
      INTEGER    I, JSEND
      DOUBLE PRECISION PROBR, PROBS, PROBT
      CHARACTER  RTYPE*23, STYPE*23, TTYPE*23
      CHARACTER  TEXT(30)*100
      CHARACTER (LEN = 12) I12(6), FORM12 
      LOGICAL    ABORT
      LOGICAL    FIXNPT
      PARAMETER (FIXNPT = .TRUE.)
      EXTERNAL   RUNDAT, VECTWO
      EXTERNAL   PROBRS, PLEVEL, PUTFAT
      EXTERNAL   TABLE1
      EXTERNAL   FORM12
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
C
C Check ISEND and NMAX
C      
      IF(ISEND.LT.N0 .OR. ISEND.GT.N4 .OR. NMAX.LT.N1) RETURN
C
C Copy ISEND into JSEND so that ISEND is returned unchanged
C
      JSEND = ISEND
      IF (JSEND.EQ.N0) THEN
C
C Read in 2 vectors of equal length
C
         JSEND = N1
         IF (NX.NE.NY) THEN
            NX = - N1
            NY = - N1
         ENDIF
         CALL VECTWO (NIN, NMAX, NX, NY,
     +                X, Y,
     +                TITLEX, TITLEY, 
     +                ABORT, FIXNPT)
         IF (NX.NE.NY) THEN
            CALL PUTFAT ('NX not equal to NY after call to VECTWO')
            RETURN
         ENDIF
         NZ = NX
         DO I = N1, NZ
            Z(I) = X(I) - Y(I)
         ENDDO
      ELSEIF (JSEND.EQ.N1 .OR. JSEND.EQ.N2) THEN
C
C Read numbers or a vector
C
         CALL RUNDAT (JSEND, NIN, NMAX, NNEG, NPOS, NZ, NRUN,
     +                Z,
     +                TITLEZ,
     +                ABORT)
      ELSEIF (JSEND.EQ.N3) THEN
C
C The vector is supplied so redefine JSEND
C
         IF (NZ.GT.N1) THEN
            ABORT = .FALSE.
            JSEND = N1
         ELSE
            ABORT = .TRUE.
         ENDIF      
      ELSEIF (JSEND.EQ.N4) THEN
C
C Two vectors have been supplied so redefine JSEND
C      
         IF (NX.EQ.NY .AND. NX.GT.N1) THEN
            ABORT = .FALSE.
            JSEND = N1
            NZ = NX
            DO I = N1, NZ
               Z(I) = X(I) - Y(I)
            ENDDO
         ELSE
            NZ = N0
            ABORT = .TRUE.
         ENDIF      
      ENDIF
C
C Check if all is well
C
      IF (ABORT .OR. NZ.LT.N1) RETURN
C
C Calculate probabilities
C
      CALL PROBRS (JSEND, NOUT, NNEG, NPOS, NZ, NRUN, NR1, NR5,
     +             PROBR, PROBS, PROBT, Z)
      IF (NRUN.EQ.N0 .OR. PROBR.LT.0.0D+00) RETURN
      CALL PLEVEL (PROBR, RTYPE)
      CALL PLEVEL (PROBS, STYPE)
      CALL PLEVEL (PROBT, TTYPE)
      ICOUNT = ICOUNT + N1
      WRITE (NOUT,'(A)') ' '
      WRITE (NOUT,'(A)') '***'
      I12(1) = FORM12(ICOUNT)
      I12(2) = FORM12(NNEG)
      I12(3) = FORM12(NPOS)
      I12(4) = FORM12(NRUN)
      I12(5) = FORM12(NR1)
      I12(6) = FORM12(NR5)
      WRITE (NOUT,100) I12(1)
C      WRITE (NOUT,200) NNEG, NPOS, NRUN, PROBR, RTYPE, NR1, NR5,
C     +                 PROBT, TTYPE, PROBS, STYPE
C      WRITE (TEXT,300) ICOUNT,
C     +                 NNEG, NPOS, NRUN, PROBR, RTYPE, NR1, NR5,
C     +                 PROBT, TTYPE, PROBS, STYPE
      WRITE (NOUT,200) I12(2), I12(3), I12(4), PROBR, RTYPE, I12(5),
     +                 I12(6), PROBT, TTYPE, PROBS, STYPE
      WRITE (TEXT,300) I12(1),
     +                 I12(2), I12(3), I12(4), PROBR, RTYPE, I12(5),
     +                 I12(6), PROBT, TTYPE, PROBS, STYPE  
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
  100 FORMAT (
     +/1X,'Run and sign test',1X,A
     +/1X,'---------------------')
  200 FORMAT (
     + 1X,'Number of -ve signs ( n )          =',1X,A
     +/1X,'Number of +ve signs ( m )          =',1X,A
     +/1X,'Number of runs observed ( r )      =',1X,A
     +/1X,'p = P(runs =< r, given m and n)    =',F9.6,4X,A
     +/1X,'Critical number for 1% sig. level  =',1X,A
     +/1X,'Critical number for 5% sig. level  =',1X,A
     +/1X,'p = P(runs =< r, given m + n)      =',F9.6,4X,A
     +/1X,'2-tail sign test probability       =',F9.6,4X,A/)
  300 FORMAT (
     + 'Run and sign test',1X,A
     +/
     +/'Number of -ve signs ( n )         =',1X,A
     +/'Number of +ve signs ( m )         =',1X,A
     +/'Number of runs observed ( r )     =',1X,A
     +/'p = P(runs =< r, given m and n)   =',F9.6,6X,A
     +/'Critical number for 1% sig. level =',1X,A
     +/'Critical number for 5% sig. level =',1X,A
     +/'p = P(runs =< r, given m + n)     =',F9.6,6X,A
     +/'2-tail sign test probability      =',F9.6,6X,A)
      END
C
C
