c
c
      subroutine savvec (n,
     +                   x,
     +                   store)
c
c action: store/retrieve a vector
c author: w.g.bardsley, university of manchester, u.k., 17/05/2005 
c         05/06/2007 added intents, fname, sim256
c
c         n: (input/unchanged) size, n >= 1
c         x: if store = .true. (input/unchanged)
c            if store = .false. (output)
c     store: (input/unchanged)
c
      implicit   none
c
c arguments
c
      integer,          intent (in)    :: n
      double precision, intent (inout) :: x(n)
      logical,          intent (in)    :: store
c
c locals
c
      integer    i, ios, nout, nmax
      character  fname*1024, line*100, sim256*1024   
      character  word12*12
      parameter (word12 = 'f$savvec.tmp')
      external   getnou, putfat, sim256
      save       nmax
      data       nmax / 0 /
c
c find an unopened unit and try to connect to f$savvec.tmp
c                      
      fname = sim256(word12)
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      if (ios.ne.0) then
         write (line,100)
         call putfat (line)
         close (unit = nout)
         return
      endif
      if (store) then
c
c store x(1) to x(n)
c
         if (n.lt.1) then
            write (line,200)
            call putfat (line)
            close (unit = nout)
            return
         else
            do i = 1, n
               write (nout,'(1p,e16.8)',iostat=ios) x(i)
               if (ios.ne.0) then
                  write (line,300)
                  call putfat (line)
                  close (unit = nout)
                  return
               endif
            enddo
            if (n.gt.nmax) nmax = n
         endif
      else
c
c retrieve x(1) to x(n)
c
         if (n.gt.nmax) then
            write (line,400)
            call putfat (line)
            close (unit = nout)
            return
         else
            do i = 1, n
               read (nout,*,iostat=ios) x(i)
               if (ios.ne.0) then
                  write (line,400)
                  call putfat (line)
                  close (unit = nout)
                  return
               endif
            enddo
         endif
      endif
      close (unit = nout)   
c
c format statements
c      
  100 format (
     +'Cannot open ...f$savvec.tmp in call to SAVVEC')
  200 format (
     +'n < 1 in call to SAVVEC')
  300 format (
     +'Write error in call to SAVVEC ... use attrib -r ...f$savvec.tmp')
  400 format (
     +'Read error in call to SAVVEC ... use attrib -r ...f$savvec.tmp')
      end
c
c
