c
c
      subroutine savwrd (n,
     +                   x,
     +                   store)
c
c action: store/retrieve a character vector
c author: w.g.bardsley, university of manchester, u.k., 19/07/2005 
c         05/06/2006 added intents, fname, and sim256 
c         31/12/2007 altered behaviour so that n = nmax after saving and if more
c                    strings are requested than are stored, blanks are returned
c                    storing/retrieving is interrupted if x(1) = '%no_labels%'
c
c         n: (input/unchanged) size, n >= 1
c         x: if store = .true. (input/unchanged)
c            if store = .false. (output)
c     store: (input/unchanged)
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: n
      character (len = *), intent (inout) :: x(n)
      logical,             intent (in)    :: store
c
c locals
c
      integer    i, ios, nout, nmax 
      character  fname*1024, line*100, sim256*1024
      character  blank*1, no_labels*11, word12*12
      parameter (blank = ' ',
     +       no_labels = '%no_labels%',
     +          word12 = 'f$savwrd.tmp')
      intrinsic  min
      external   getnou, putfat, sim256
      save       nmax
      data       nmax / 0 /
c
c find an unopened unit and try to connect to f$savwrd.tmp
c                        
      fname = sim256(word12)
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      if (ios.ne.0) then
         write (line,100)
         call putfat (line)
         close (unit = nout)
         return
      endif
      if (store) then
c
c store = .true.: store x(1) to x(n)
c ===============
c
         if (n.lt.1) then
            write (line,200)
            call putfat (line)
            close (unit = nout)
            return
         else
            nmax = 0
            do i = 1, n
               write (nout,'(a)',iostat=ios) x(i)
               if (ios.ne.0) then
                  write (line,300)
                  call putfat (line)
                  close (unit = nout)
                  return
               endif
               nmax = nmax + 1
               if (i.eq.1) then
                 if (x(1).eq.no_labels) exit
               endif
            enddo
         endif
      else
c
c store = .false.: retrieve x(1) to x(n)
c ================
c
         if (n.lt.1) then 
            write (line,200)
            call putfat (line)
            close (unit = nout)
            return             
         elseif (nmax.eq.0) then
            do i = 1, n
               x(i) = blank
            enddo   
         else
            do i = 1, min(n,nmax)
               read (nout,'(a)',iostat=ios) x(i)
               if (ios.ne.0) then
                  write (line,400)
                  call putfat (line)
                  close (unit = nout)
                  return
               endif   
               if (i.eq.1) then
                  if (x(1).eq.no_labels) then
                     close (unit = nout)
                     return
                  endif   
               endif  
            enddo
            if (n.gt.nmax) then
               do i = nmax + 1, n
                  x(i) = blank
               enddo
            endif    
         endif
      endif
      close (unit = nout) 
c
c format statements
c      
  100 format (
     +'Cannot open ...f$savwrd.tmp in call to SAVWRD')
  200 format (
     +'n < 1 in call to SAVWRD')
  300 format (
     +'Write error in call to SAVWRD ... use attrib -r ...f$savwrd.tmp')
  400 format (
     +'Read error in call to SAVWRD ... use attrib -r ...f$savwrd.tmp')
      end
c
c
