c
c
      subroutine scores (isend, isx, ncol, nrmax, nrow, nvar,
     +                   v, x,
     +                   abort)
c
c action: return PCA scores      
c author: w.g.bardsley, university of manchester, u.k., 17/08/2010
c
c isend: sets the type of PCA (only isend = 1 implemented so far)
c   isx: isx(i) = 0 then suppress variable i 
c  ncol: number of columns
c nrmax: leading row dimension
c  nrow: actual row dimension
c  nvar: number of free variables
c     v: scores
c     x: data
c abort: error indicator
c
      implicit none
c
c arguments
c      
      integer,          intent (in)  :: isend, ncol, nrmax, nrow
      integer,          intent (in)  :: isx(ncol)
      integer,          intent (out) :: nvar
      double precision, intent (in)  :: x(nrmax,ncol) 
      double precision, intent (out) :: v(nrmax,ncol) 
      logical,          intent (out) :: abort 
c
c allocatable 
c      
      double precision, allocatable :: e(:,:), p(:,:), s(:), wk(:)
c
c locals
c      
      integer     i, ierr, ifail, lde, ldp, ldv, ldx, m, n
      double precision wt(2)
      character (len = 1) matrix, std, weight
      external   putfat, g03aaf$
c
c check
c   
      abort = .true.
      nvar = 0
      if (ncol.lt.2 .or. nrow.lt.2 .or. nrow.gt.nrmax) then
         call putfat ('Dimension error in call to scores')
         return
      endif 
      do i = 1, ncol
         if (isx(i).gt.0) nvar = nvar + 1
      enddo
      if (nvar.lt.2) then
         call putfat ('No. of free variables  < 2 in call to scores')          
         return
      endif 
c
c initialise
c      
      if (isend.eq.1) then
         matrix = 'C'
         std = 'Z'
         weight = 'U' 
      else
         return
      endif      
      n = nrow
      m = ncol 
      lde = nvar
      ldp = nvar
      ldv = nrmax
      ldx = nrmax
c
c allocate
c    
      ierr = 0 
      if (allocated(e)) deallocate(e, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(p)) deallocate(p, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(s)) deallocate(s, stat = ierr)
      if (ierr.ne.0) return   
      if (allocated(wk)) deallocate(wk, stat = ierr)
      if (ierr.ne.0) return  
      allocate(e(lde,6), stat = ierr)
      if (ierr.ne.0) return
      allocate(p(ldp,nvar), stat = ierr)
      if (ierr.ne.0) return 
      allocate(s(m), stat = ierr)
      if (ierr.ne.0) return     
      ifail = nvar*nvar + 5*(nvar - 1)  
      allocate(wk(ifail), stat = ierr)
      if (ierr.ne.0) return  
c
c calculate
c
      ifail = 1 
      call g03aaf$(matrix, std, weight, n, m, x, ldx, isx, s, wt, nvar,
     +             e, lde, p, ldp, v, ldv, wk, ifail)
      if (ifail.eq.0) abort = .false.       
c
c deallocate
c
      deallocate(e, stat = ierr)
      deallocate(p, stat = ierr)
      deallocate(s, stat = ierr)
      deallocate(wk, stat = ierr)
      end
c
c                 