C
C
      SUBROUTINE SIGMAS (N, 
     +                   X, Y, E)
C
C ACTION : Supply E(N), X(N), Y(N) and calculate number of distinct points
C          If there are replicates E can be replaced by sample SIGMAS
C          Otherwise the E values are unchanged and a warning is issued
C ADVICE : The X-values must be in increasing order
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          DBOS version ... 23/3/94
C          Win32 version .. 16/2/97
C          21/03/2018 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: N
      DOUBLE PRECISION, INTENT (IN)    :: X(N), Y(N)
      DOUBLE PRECISION, INTENT (INOUT) :: E(N)
C
C Locals
C      
      INTEGER    I, ICOUNT, J, NREPS
      INTEGER    ICOLOR, NUMHDR
      PARAMETER (ICOLOR = 1, NUMHDR = 17)
      INTEGER    NUMBLD(NUMHDR)
      INTEGER    COLOUR
      DOUBLE PRECISION SIGMA, SSQ, YBAR, YSUM
      DOUBLE PRECISION EPSI, RTOL, X02AJF$, X02AMF$
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  HEADER(NUMHDR)*100, LINE*100
      LOGICAL    DOSUMS, YES
      EXTERNAL   PUTFAT, TABLE1, ANSWER
      EXTERNAL   X02AJF$, X02AMF$
      INTRINSIC  ABS, SQRT, DBLE
      DATA       NUMBLD / NUMHDR*0 /
      IF (N.LT.2) RETURN
      NUMBLD(1) = 1
      YES = .FALSE.
      WRITE (HEADER,100)
      CALL ANSWER (ICOLOR, NUMBLD, NUMHDR, HEADER,
     +'Replace s by sample estimates (usually no) ?', YES)
      IF (.NOT.YES) RETURN
      DO I = 2, N
         IF (X(I).LT.X(I - 1)) THEN
            CALL PUTFAT ('Data to SIGMAS is not in increasing order')
            RETURN
         ENDIF
      ENDDO
      EPSI = X02AJF$()*(X(N) - X(1))
      RTOL = SQRT(X02AMF$())
      COLOUR = 15
      CALL TABLE1 (COLOUR, 'OPEN')
      COLOUR = 0
      NREPS = 1
      YSUM = Y(1)
      DO I = 2, N
         IF (ABS(X(I) - X(I - 1)).LE.EPSI) THEN
            DOSUMS = .FALSE.
            YSUM = YSUM + Y(I)
            NREPS = NREPS + 1
            IF (I.EQ.N) THEN
               DOSUMS = .TRUE.
               ICOUNT = 0
            ENDIF
         ELSE
            IF (NREPS.EQ.1) THEN
               DOSUMS = .FALSE.
               YSUM = Y(I)
               WRITE (LINE,200) I - 1
               CALL TABLE1 (COLOUR, LINE)
            ELSE
               DOSUMS = .TRUE.
               ICOUNT = 1
            ENDIF
            IF (I.EQ.N) THEN
               WRITE (LINE,200) N
               CALL TABLE1 (COLOUR, LINE)
            ENDIF
         ENDIF
         IF (DOSUMS) THEN
            YBAR = YSUM/DBLE(NREPS)
            SSQ = ZERO
            DO J = 1, NREPS
               SSQ = SSQ + (Y(I - NREPS + J - ICOUNT) - YBAR)**2
            ENDDO
            SIGMA = SQRT(SSQ/(DBLE(NREPS) - ONE))
            IF (SIGMA.LT.RTOL) THEN
               WRITE (LINE,300) RTOL, I - NREPS + 1 - ICOUNT, I - ICOUNT
               CALL TABLE1 (COLOUR, LINE)
            ELSE
               DO J = 1, NREPS
                  E(I - NREPS + J - ICOUNT) = SIGMA
               ENDDO
            ENDIF
            YSUM = Y(I)
            NREPS = 1
         ENDIF
      ENDDO
      CALL TABLE1 (COLOUR, 'CLOSE')
C
C Format statements
C      
  100 FORMAT (
     + 'The data are now in order of increasing x-values.'
     +/
     +/'If you have only single measurements (or < 3 replicates) of'
     +/'y  at each fixed x-value you should set all the s-values to'
     +/'s = 1, i.e. do unweighted regression, because any weighting'
     +/'based on such small samples would be unreliable.'
     +/
     +/'If you have at least 3 (but preferably  >= 5) replicates at'
     +/'each distinct x-value, you might wish to use the individual'
     +/'sample standard deviation estimates ( i.e.  standard errors'
     +/'of y at fixed x) for weighting the curve-fitting.'
     +/
     +/'You can now calculate sample standard deviations when there'
     +/'are replicates then use these to replace current s-values.'
     +/'Where there are replicates existing s-values are replaced.'
     +/'Where there are no replicates s-values are unchanged.'
     +/)
  200 FORMAT (1X,
     +'No replicates at data point number',I6,1X,'... s unchanged')
  300 FORMAT (1X,'Estimate <=',1P,E9.1,1X,
     +'from',I6,1X,'to',I6,1X,'... s unchanged')
      END
C
C


