C
C
      SUBROUTINE SIMSON (N,
     +                   AREA, X1, XN, Y)
C
C ACTION : Simpson's rule for area given end points X1, XN
C          and N function values Y where N is an odd integer
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,28/06/1991
C          19/10/95 edited
C          19/11/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      DOUBLE PRECISION, INTENT (IN)  :: X1, XN, Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: AREA
C
C Locals
C      
      INTEGER    I
      DOUBLE PRECISION SUM1, SUM2, SUM3
      DOUBLE PRECISION FOUR, THREE, TWO, ZERO
      PARAMETER (FOUR = 4.0D+00, THREE = 3.0D+00, TWO = 2.0D+00,
     +           ZERO = 0.0D+00)
      EXTERNAL   PUTFAT
      INTRINSIC  MOD
C
C First check that N is odd
C
      I = MOD(N,2)
      IF (I.EQ.0) THEN
         CALL PUTFAT ('N even in SIMSON ... Area set to 0')
         AREA = ZERO
         RETURN
      ENDIF
C
C Sum of outside ordinates
C
      SUM1 = Y(1) + Y(N)
C
C Sum of even ordinates
C
      SUM2 = ZERO
      DO I = 2, N - 1, 2
         SUM2 = SUM2 + Y(I)
      ENDDO
C
C Sum of odd ordinates
C
      SUM3 = ZERO
      DO I = 3, N - 2, 2
         SUM3 = SUM3 + Y(I)
      ENDDO
C
C Define area
C
      AREA = (XN - X1)*(SUM1 + FOUR*SUM2 + TWO*SUM3)/(THREE*(N - 1))
      END
C
C
