c
c
      subroutine spher1 (isend, itype, ncol, nout, nrmax, nrow, numneg,
     +                   a, b, c, d, p, s, x, y,
     +                   abort)
c
c action: test a matrix for sphericity
c author: w.g.bardsley, university of manchester, u.k., 09/09/2003
c         08/10/2003 revised to calculate W
c         09/05/2016 edited formats
c         07/07/2021 introduced e_formats and e_numbers, etc.
c         18/09/2021 added formgr 
c
c         isend (unchanged) has the following meaning:
c         isend = 0: no output, just return results
c         isend = 1: also output the results to display only
c         isend = 2: also output the results to file on nout only
c         isend = 3: also output the results to display and file on nout
c
c         itype (unchanged) has the following meaning:
c         itype = 1: a is the data matrix (returned unchanged)
c         itype = 2: a is the covariance matrix (returned unchanged)
c                    but nrow must then be the sample size used to
c                    estimate the covariance matrix as this is used
c                    to calculate the test statistic
c
c         ncol, nrmax, nrow: input dimensions (unchanged)
c         nout: pre-connected unit for error messages (unchanged)
c         numneg: returned as the no. of eigenvalues < epsi
c         a: input matrix (either data or covariance, unchanged)
c         b, c, y: workspaces but on successful return both b and c
c         will contain the covariance matrix
c         x: returned as the eigenvalues
c         d: returned as degrees of freedom
c         p: returned as the chi-square probability
c         s: returned as the test statistic - 2*log(lambda)
c         abort: returned as .true./.false. error indicator
c
      implicit   none
      integer    isend, itype, ncol, nout, nrmax, nrow, numneg
      integer    i, icolor, ifail, ir, issp, ix, j, m, n
      integer    icount, itemp
      double precision a(nrmax,ncol), b(nrmax,ncol), c(nrmax,ncol),
     +                 d, p, s, x(ncol), y(ncol)
      double precision arith, det, dncol, dnrow, denom, geom, trace,
     +                 wmauch
      double precision g01ecf$
      double precision zero, one, two
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00)
      double precision epsi
      parameter (epsi = 1.0d-07)
      character  line*100, resul*30, tail*1, text(30)*100
      character (len = 10) d10, formgr
      character (len = 12) form12, i12(4) 
      character (len = 13) d13(5), showlj
      logical    abort
      logical    e_formats, e_numbers 
      external   e_formats, form12, formgr, showlj
      external   putifa, putfat, plevel, table1
      external   g02baf$, f02aaf$, g01ecf$
      intrinsic  dble, log, nint, abs
      save       icount
      data       icount / 0 /
c
c set abort = .true. then initialise and check input parameters
c
      abort = .true.
      d = zero
      p = zero
      s = zero
      numneg = 0
c
c is isend in range
c
      if (isend.lt.0 .or. isend.gt.3 .or.
     +    itype.lt.1 .or. itype.gt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c are n and m in range
c
      if (ncol.lt.2 .or. nrow.lt.2) then
         write (line,200)
         call putfat (line)
         return
      endif
c
c check supplied matrix is a covariance matrix if itype = 2
c
      if (itype.eq.2) then
         do i = 1, ncol
            if (a(i,i).lt.zero) then
               write (line,300)
               call putfat (line)
               return
            endif
         enddo
         do i = 2, ncol
            do j = 1, i - 1
               if (abs(a(i,j) - a(j,i)).gt.zero) then
                  write (line,300)
                  call putfat (line)
                  return
               endif
            enddo
         enddo
      endif
c
c define dncol and dnrow
c
      e_numbers = e_formats()
      d10 = formgr(epsi)
      dncol = dble(ncol)
      dnrow = dble(nrow)
      if (itype.eq.1) then
c
c case 1: a general matrix has been supplied
c ======
c calculate the cross product matrix and put it in b
c note that g02baf$ does not change the input matrix a
c
         n = nrow
         m = ncol
         ix = nrmax
         issp = nrmax
         ir = nrmax
         ifail = 1
         call g02baf$(n, m, a, ix, x, y, b, issp, c, ir, ifail)
         call putifa (ifail, nout, 'G02BAF/SPHER1')
         if (ifail.ne.0) return
c
c transform matrix b into the covariance matrix
c
         denom = dnrow - one
         do j = 1, ncol
            do i = 1, ncol
               b(i,j) = b(i,j)/denom
            enddo
         enddo
      else
c
c case 2: a covariance matrix has been supplied
c ======
c copy matrix a containing the covariance matrix into matrix b
c
         do j = 1, ncol
            do i = 1, ncol
               b(i,j) = a(i,j)
            enddo
         enddo
      endif
c
c copy the covariance matrix into c
c
      do j = 1, ncol
         do i = 1, ncol
            c(i,j) = b(i,j)
         enddo
      enddo
c
c calculate the eigenvalues which will result in overwriting matrix b
c
      ir = nrmax
      m = ncol
      ifail = 1
      call f02aaf$(b, ir, m, x, y, ifail)
      call putifa (ifail, nout, 'F02AAF/SPHER1')
      if (ifail.ne.0) return

c copy the covariance matrix back into b
c
      do j = 1, ncol
         do i = 1, ncol
            b(i,j) = c(i,j)
         enddo
      enddo
c
c calculate the arithmetic and geometric means from the eigenvalues
c
      det = one
      trace = zero
      numneg = 0
      do i = 1, ncol
         if (x(i).lt.epsi) then
            x(i) = epsi
            numneg = numneg + 1
         endif
         trace = trace + x(i)
         det = det*x(i)
      enddo
      wmauch = det/((trace/dncol)**dncol)
      arith = trace/dncol
      geom = det**(one/dncol)
c
c abort if singular case
c
      if (arith.le.zero .or. geom.le.zero) return
c
c calculate the parameters for return
c
      d = (dncol - one)*(dncol + two)/two
      s = dncol*dnrow*log(arith/geom)
      ifail = 1
      tail = 'U'
      p = g01ecf$(tail, s, d, ifail)
      call putifa (ifail, nout, 'G01ECF/SPHER1')
      if (ifail.eq.0) then
         icount = icount + 1
         if (isend.gt.0) call plevel (p, resul)
      else
         return
      endif
      if (isend.eq.1 .or. isend.eq.3) then
         if (e_numbers) then
            write (text,400) icount, numneg, epsi, ncol, nrow, det, 
     +                       trace, wmauch, s, nint(d), p, resul
         else
            i12(1) = form12(numneg)
            i12(2) = form12(ncol)
            i12(3) = form12(nrow)
            itemp = nint(d)
            i12(4) = form12(itemp) 
            d13(2) = showlj(det)
            d13(3) = showlj(trace)
            d13(4) = showlj(wmauch)
            d13(5) = showlj(s) 
            write (text,450) icount, trim(i12(1)), trim(d10), 
     +                       i12(2), i12(3), d13(2), d13(3), d13(4),
     +                       d13(5), i12(4), p, resul
         endif  
         icolor = 15
         call table1 (icolor, 'OPEN')
         do i = 1, 13
            if (i.eq.1) then
               icolor = 4
            elseif (i.eq.3) then
               icolor = 1
            else
               icolor = 0
            endif
            call table1 (icolor, text(i))
         enddo
         call table1 (icolor, 'CLOSE')
      endif
      if (isend.eq.2 .or. isend.eq.3) then
         if (e_numbers) then
            write (nout,500) icount, numneg, epsi, ncol, nrow, det,
     +                       trace, wmauch, s, nint(d), p, resul
         else
            i12(1) = form12(numneg)
            i12(2) = form12(ncol)
            i12(3) = form12(nrow)
            itemp = nint(d)
            i12(4) = form12(itemp) 
            d13(2) = showlj(det)
            d13(3) = showlj(trace)
            d13(4) = showlj(wmauch)
            d13(5) = showlj(s) 
            write (nout,550) icount, trim(i12(1)), trim(d10), 
     +                       i12(2), i12(3), d13(2), d13(3), d13(4),
     +                       d13(5), i12(4), p, resul  
         endif         
      endif
c
c success so set abort = .false.
c
      abort = .false.
c
c format statements
c      
  100 format ('ISEND or ITYPE out of range in call to SPHER1')
  200 format ('Data matrix must have dimensions n >= 2 and m >= 2')
  300 format ('Data matrix is not a symmetrical covariance matrix')
  400 format (
     + 'Likelihood ratio sphericity test', i4
     +/
     +/'H0: Covariance matrix = k*Identity (for some k > 0)'
     +/
     +/'Number of small eigenvalues  =',i8,' (i.e. <',1p,e9.2,')'
     +/'Number of variables (m)      =',i8
     +/'Sample size (n)              =',i8,
     +/'Determinant of CV            =',1p,e13.5
     +/'Trace of CV                  =',   e13.5
     +/'Mauchly W statistic          =',   e13.5
     +/'LRTS = -2*log(lambda)        =',   e13.5
     +/'Degrees of Freedom           =',i8
     +/'p = P(chi-square >= LRTS)    =',0p,f7.4,2x,a)
  450 format (
     + 'Likelihood ratio sphericity test', i4
     +/
     +/'H0: Covariance matrix = k*Identity (for some k > 0)'
     +/
     +/'Number of small eigenvalues  =',1x,a,' (i.e. < ',a,')'
     +/'Number of variables (m)      =',1x,a
     +/'Sample size (n)              =',1x,a
     +/'Determinant of CV            =',1x,a
     +/'Trace of CV                  =',1x,a
     +/'Mauchly W statistic          =',1x,a
     +/'LRTS = -2*log(lambda)        =',1x,a
     +/'Degrees of Freedom           =',1x,a
     +/'p = P(chi-square >= LRTS)    =',0p,f7.4,2x,a)     
  500 format (
     +/1x,'Likelihood ratio sphericity test',i4
     +/1x,'------------------------------------'
     +/1x,'H0: Covariance matrix = k*Identity (for some k > 0)'
     +/
     +/1x,'Number of small eigenvalues  =',i8,' (i.e. <',1p,e9.2,')'
     +/1x,'Number of variables (m)      =',i8
     +/1x,'Sample size (n)              =',i8
     +/1x,'Determinant of CV            =',1p,e13.5
     +/1x,'Trace of CV                  =',   e13.5
     +/1x,'Mauchly W statistic          =',   e13.5
     +/1x,'LRTS = -2*log(lambda)        =',   e13.5
     +/1x,'Degrees of Freedom           =',i8
     +/1x,'p = P(chi-square >= LRTS)    =',0p,f7.4,2x,a)
  550 format (
     +/1x,'Likelihood ratio sphericity test', i4
     +/1x,'------------------------------------'
     +/1x,'H0: Covariance matrix = k*Identity (for some k > 0)'
     +/
     +/1x,'Number of small eigenvalues  =',1x,a,' (i.e. < ',a,')'
     +/1x,'Number of variables (m)      =',1x,a
     +/1x,'Sample size (n)              =',1x,a
     +/1x,'Determinant of CV            =',1x,a
     +/1x,'Trace of CV                  =',1x,a
     +/1x,'Mauchly W statistic          =',1x,a
     +/1x,'LRTS = -2*log(lambda)        =',1x,a
     +/1x,'Degrees of Freedom           =',1x,a
     +/1x,'p = P(chi-square >= LRTS)    =',0p,f7.4,2x,a)        
      end
c
c
