c
c
      subroutine spher2 (isend, itype, ncol, ndof, ng, nout, nrmax,
     +                   nrow, numneg,
     +                   a, b, c, d, eg, eh, el, p, s, wmauch, x, y,
     +                   abort)
c
c action: test a matrix for sphericity
c author: w.g.bardsley, university of manchester, u.k.
c         Derived from spher1 07/10/2003
c         15/06/2004 edited test for n and m to n >= m > 2
c         09/05/2016 edited formats
c         08/07/2021 added e_numbers and e_formats, etc.
c         18/09/2021 added formgr 
c
c         isend (unchanged) has the following meaning:
c         isend = 0: no output, just return results
c         isend = 1: also output the results to display only
c         isend = 2: also output the results to file on nout only
c         isend = 3: also output the results to display and file on nout
c
c         itype (unchanged) has the following meaning:
c         itype = 1: a is the data matrix (returned unchanged)
c         itype = 2: a is the covariance matrix (returned unchanged)
c                    but nrow must then be the sample size used to
c                    estimate the covariance matrix as this is used
c                    to calculate the test statistic
c
c         ncol, nrmax, nrow: input dimensions (unchanged)
c         ndof: input as no. degrees of freedom used to estimate CV (unchanged)
c         ng: input as no. of groups (unchanged)
c         nout: pre-connected unit for error messages (unchanged)
c         numneg: returned as the no. of eigenvalues < epsi
c         a: input matrix (either data or covariance, unchanged)
c         b, c, y: workspaces but on successful exit b contains the (ncol - 1)
c         by (ncol - 1) covariance matrix of orthonormal conrasts and c contains
c         the (ncol - 1) by ncol Helmert matrix of orthonormal contrasts
c         x: returned as the eigenvalues
c         d: returned as degrees of freedom
c         eg: returned as greenhouse geisser epsilon
c         eh: returned as huynh feldt epsilon
c         el: returned as limiting epsilon
c         p: returned as the chi-square probability
c         s: returned as the test statistic - 2*log(lambda)
c         wmauch: returned as Mauchly W
c         abort: returned as .true./.false. error indicator
c
      implicit   none
      integer    isend, itype, ncol, ndof, ng, nout, nrmax, nrow, numneg
      integer    i, icolor, ifail, ir, issp, ix, j, k, l, m, n, ncont
      integer    icount, itemp
      integer    jsend
      parameter (jsend = 1)
      double precision a(nrmax,ncol), b(nrmax,ncol), c(nrmax,ncol),
     +                 d, eg, eh, el, p, s, wmauch, x(ncol), y(ncol)
      double precision arith, bot, det, dncont, dndof, dng, dnrow,
     +                 denom, geom, temp, top, trace
      double precision g01ecf$
      double precision zero, one, two, six
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00,
     +           six = 6.0d+00)
      double precision epsi
      parameter (epsi = 1.0d-07)
      character  line*100, resul*30, tail*1, text(30)*100
      character (len = 10) d10, formgr
      character (len = 12) i12(4), form12
      character (len = 13) d13(8), showlj
      logical    abort, e_formats, e_numbers
      external   e_formats, form12, formgr, showlj
      external   putifa, putfat, plevel, table1, helmrt
      external   g02baf$, f02aaf$, g01ecf$
      intrinsic  dble, log, nint, abs, min
      save       icount
      data       icount / 0 /
c
c set abort = .true. then initialise and check input parameters
c
      abort = .true.
      d = zero
      eg = zero
      eh = zero
      el = zero
      p = zero
      s = zero
      numneg = 0
c
c is isend in range
c
      if (isend.lt.0 .or. isend.gt.3 .or.
     +    itype.lt.1 .or. itype.gt.2 .or.
     +    2*(ncol - 1).gt.nrmax) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c are n, m, ng, ndof in range
c
      if (ncol.le.2 .or. nrow.lt.ncol .or. ng.lt.1 .or. ndof.lt.1) then
         write (line,200)
         call putfat (line)
         return
      endif
c
c check supplied matrix is a covariance matrix if itype = 2
c
      if (itype.eq.2) then
         do i = 1, ncol
            if (a(i,i).lt.zero) then
               write (line,300)
               call putfat (line)
               return
            endif
         enddo
         do i = 2, ncol
            do j = 1, i - 1
               if (abs(a(i,j) - a(j,i)).gt.zero) then
                  write (line,300)
                  call putfat (line)
                  return
               endif
            enddo
         enddo
      endif
c
c define dncol and dnrow
c
      e_numbers = e_formats()
      d10 = formgr(epsi)
      dnrow = dble(nrow)
      if (itype.eq.1) then
c
c case 1: a general matrix has been supplied
c ======
c calculate the cross product matrix and put it in b
c note that g02baf$ does not change the input matrix a
c
         n = nrow
         m = ncol
         ix = nrmax
         issp = nrmax
         ir = nrmax
         ifail = 1
         call g02baf$(n, m, a, ix, x, y, b, issp, c, ir, ifail)
         call putifa (ifail, nout, 'G02BAF/SPHER2')
         if (ifail.ne.0) return
c
c transform matrix b into the covariance matrix
c
         denom = dnrow - one
         do j = 1, ncol
            do i = 1, ncol
               b(i,j) = b(i,j)/denom
            enddo
         enddo
      else
c
c case 2: a covariance matrix has been supplied
c ======
c copy matrix a containing the covariance matrix into matrix b
c
         do j = 1, ncol
            do i = 1, ncol
               b(i,j) = a(i,j)
            enddo
         enddo
      endif
c
c generate a helmert orthonormal contrast matrix
c
      call helmrt (jsend, nrmax, ncol, c, abort)
      ncont = ncol - 1
c
c form c*s and store in c from row ncont + 1 to 2*ncont
c
      do i = 1, ncont
         l = i + ncont
         do j = 1, ncol
            c(l,j) = zero
            do k = 1, ncol
               c(l,j) = c(l,j) + c(i,k)*b(j,k)
            enddo
         enddo
      enddo
c
c form c*s*c^T and store in b
c
      do i = 1, ncont
         l = i + ncont
         do j = 1, ncont
            b(i,j) = zero
            do k = 1, ncol
               b(i,j) = b(i,j) + c(l,k)*(c(j,k))
            enddo
         enddo
      enddo
c
c store b in c offset by ncont
c
      do j = 1, ncont
         do i = 1, ncont
            c(ncont + i,j) = b(i,j)
         enddo
      enddo
c
c calculate the eigenvalues which will result in overwriting matrix b
c
      ir = nrmax
      m = ncont
      ifail = 1
      call f02aaf$(b, ir, m, x, y, ifail)
      call putifa (ifail, nout, 'F02AAF/SPHER2')
      if (ifail.ne.0) return
c
c copy the covariance matrix of orthonormal contrasts back into b
c
      do j = 1, ncont
         do i = 1, ncont
            b(i,j) = c(ncont + i,j)
         enddo
      enddo
c
c calculate the arithmetic and geometric means from the eigenvalues
c
      det = one
      trace = zero
      numneg = 0
      do i = 1, ncont
         if (x(i).lt.epsi) then
            x(i) = epsi
            numneg = numneg + 1
         endif
         trace = trace + x(i)
         det = det*x(i)
      enddo
      dncont = dble(ncont)
      wmauch = det/((trace/dncont)**dncont)
      arith = trace/dncont
      geom = det**(one/dncont)
c
c abort if singular case
c
      if (arith.le.zero .or. geom.le.zero) return
c
c calculate the parameters for output
c
      d = (dncont - one)*(dncont + two)/two
      top = two*dncont*dncont + dncont + two
      bot = six*dncont
      dndof = dble(ndof)
      temp = dndof - top/bot
      s = dncont*temp*log(arith/geom)
      ifail = 1
      tail = 'U'
      p = g01ecf$(tail, s, d, ifail)
      call putifa (ifail, nout, 'G01ECF/SPHER2')
      if (ifail.eq.0) then
         icount = icount + 1
         if (isend.gt.0) call plevel (p, resul)
      else
         return
      endif
c
c now the epsilon values
c
      top = zero
      do i = 1, ncont
         top = top + x(i)
      enddo
      top = top*top
      bot = zero
      do i = 1, ncont
         bot = bot + x(i)*x(i)
      enddo
      bot = dncont*bot
      eg = top/bot
      top = dnrow*dncont*eg - two
      dng = min(one, dble(ng))
      bot = dncont*(nrow - dng - dncont*eg)
      eh = min(one, top/bot)
      el = one/dncont
      if (isend.eq.1 .or. isend.eq.3) then
         if (e_numbers) then
            write (text,400) icount, numneg, epsi, ncol, nrow, det,
     +                       trace,  wmauch, s, nint(d), p, resul, 
     +                       eg, eh, el
         else
            i12(1) = form12(numneg)
            i12(2) = form12(ncol)
            i12(3) = form12(nrow)
            itemp = nint(d)
            i12(4) = form12 (itemp) 
            d13(2) = showlj(det)
            d13(3) = showlj(trace)
            d13(4) = showlj(wmauch) 
            d13(5) = showlj(s)
            d13(6) = showlj(eg)
            d13(7) = showlj(eh)
            d13(8) = showlj(el)
            write (text,450) icount, trim(i12(1)), trim(d10), i12(2),
     +                       i12(3), d13(2), d13(3), d13(4), d13(5),
     +                       i12(4), p, resul, d13(6), d13(7), d13(8)
         endif  
         icolor = 15
         call table1 (icolor, 'OPEN')
         do i = 1, 16
            if (i.eq.1) then
               icolor = 4
            elseif (i.eq.3) then
               icolor = 1
            else
               icolor = 0
            endif
            call table1 (icolor, text(i))
         enddo
         call table1 (icolor, 'CLOSE')
      endif
      if (isend.eq.2 .or. isend.eq.3) then
         if (e_numbers) then
            write (nout,500) icount, numneg, epsi, ncol, nrow, det, 
     +                       trace, wmauch, s, nint(d), p, resul, eg, 
     +                       eh, el
         else
            i12(1) = form12(numneg)
            i12(2) = form12(ncol)
            i12(3) = form12(nrow)
            itemp = nint(d)
            i12(4) = form12 (itemp) 
            d13(2) = showlj(det)
            d13(3) = showlj(trace)
            d13(4) = showlj(wmauch) 
            d13(5) = showlj(s)
            d13(6) = showlj(eg)
            d13(7) = showlj(eh)
            d13(8) = showlj(el)             
            write (nout,550) icount, trim(i12(1)), trim(d10), i12(2),
     +                       i12(3), d13(2), d13(3), d13(4), d13(5),
     +                       i12(4), p, resul, d13(6), d13(7), d13(8)
         endif  
      endif
c
c success so set abort = .false.
c
      abort = .false.
c
c format statements
c      
  100 format (
     +'ISEND/ITYPE/NRMAX/NCOL out-of-range/illegal in call to SPHER2')
  200 format (
     +'Insufficient data: Must have n >= m, m > 2, ng >= 1, ndof >= 1')
  300 format (
     +'Data matrix supplied is not a symmetrical covariance matrix')
  400 format (
     + 'Sphericity test on CV of Helmert orthonormal contrasts', i4
     +/
     +/'H0: Covariance matrix = k*Identity (for some k > 0)'
     +/
     +/'Number of small eigenvalues =',i8,' (i.e. <',1p,e9.2,')'
     +/'Number of variables (m)     =',i8
     +/'Sample size (n)             =',i8,
     +/'Determinant of CV           =',1p,e13.5
     +/'Trace of CV                 =',   e13.5
     +/'Mauchly W statistic         =',   e13.5
     +/'LRTS = -2*log(lambda)       =',   e13.5
     +/'Degrees of Freedom          =',i8
     +/'p = P(chi-square >= LRTS)   =',0p,f9.4,2x,a
     +/'e (Geisser-Greenhouse)      =',f11.6
     +/'e (Huynh-Feldt)             =',f11.6
     +/'e (lower bound)             =',f11.6)
  450 format (
     + 'Sphericity test on CV of Helmert orthonormal contrasts', i4
     +/
     +/'H0: Covariance matrix = k*Identity (for some k > 0)'
     +/
     +/'Number of small eigenvalues =',1x,a,
     +' (i.e. < ',a,')'
     +/'Number of variables (m)     =',1x,a
     +/'Sample size (n)             =',1x,a,
     +/'Determinant of CV           =',1x,a
     +/'Trace of CV                 =',1x,a
     +/'Mauchly W statistic         =',1x,a
     +/'LRTS = -2*log(lambda)       =',1x,a
     +/'Degrees of Freedom          =',1x,a
     +/'p = P(chi-square >= LRTS)   =',0p,f7.4,2x,a
     +/'e (Geisser-Greenhouse)      =',1x,a
     +/'e (Huynh-Feldt)             =',1x,a
     +/'e (lower bound)             =',1x,a)     
  500 format (
     +/1x,'Sphericity test on CV of Helmert orthonormal contrasts',i4
     +/1x,'----------------------------------------------------------'
     +/1x,'H0: Covariance matrix = k*Identity (for some k > 0)'
     +/
     +/1x,'Number of small eigenvalues =',i8,' (i.e. <',1p,e9.2,')'
     +/1x,'Number of variables (m)     =',i8
     +/1x,'Sample size (n)             =',i8
     +/1x,'Determinant of CV           =',1p,e13.5
     +/1x,'Trace of CV                 =',   e13.5
     +/1x,'Mauchly W statistic         =',   e13.5
     +/1x,'LRTS = -2*log(lambda)       =',   e13.5
     +/1x,'Degrees of Freedom          =',i8
     +/1x,'p = P(chi-square >= LRTS)   =',0p,f9.4,2x,a
     +/1x,'e (Geisser-Greenhouse)      =',f11.6
     +/1x,'e (Huynh-Feldt)             =',f11.6
     +/1x,'e (lower bound)             =',f11.6)
  550 format (
     +/1x,'Sphericity test on CV of Helmert orthonormal contrasts',i4
     +/1x,'----------------------------------------------------------'
     +/1x,'H0: Covariance matrix = k*Identity (for some k > 0)'
     +/
     +/1x,'Number of small eigenvalues =',1x,a,
     +' (i.e. < ',a,')'
     +/1x,'Number of variables (m)     =',1x,a
     +/1x,'Sample size (n)             =',1x,a,
     +/1x,'Determinant of CV           =',1x,a
     +/1x,'Trace of CV                 =',1x,a
     +/1x,'Mauchly W statistic         =',1x,a
     +/1x,'LRTS = -2*log(lambda)       =',1x,a
     +/1x,'Degrees of Freedom          =',1x,a
     +/1x,'p = P(chi-square >= LRTS)   =',0p,f7.4,2x,a
     +/1x,'e (Geisser-Greenhouse)      =',1x,a
     +/1x,'e (Huynh-Feldt)             =',1x,a
     +/1x,'e (lower bound)             =',1x,a)    
      end
c
c
