c
c
      subroutine spl000 (nin, nout)
c
c Action: Spline calculations
c Author: w.g.bardsley, university of manchester, u.k., 21/09/2005
c         Note: weight is set as a parameter in this version
c         22/11/2007 introduced allocatable arrays
c
c   nin: (input/unchanged) unconnected unit for data input
c  nout: (input/unchanged) preconnected unit for output
c
      implicit none
c
c arguments
c
      integer, intent (in) :: nin, nout
c
c allocatable arrays
c     
      integer, allocatable :: iwrk(:)
      double precision, allocatable :: c(:), cc(:,:), h(:), res(:),
     +                                 rk(:), s(:), sreps(:), w(:),
     +                                 x(:), xreps(:), y(:), yhat(:),
     +                                 yreps(:)
c
c locals
c
      integer    i, ierr, ifail, isend, j, k, ncap7, ncol, nrow, method,
     +           mtype, nfit, ngraf, npts, nreps, nrmax
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart, ntext
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 13,
     +           nstart = 11, ntext = nstart + numopt - 1)
      integer    numbld(30), numpos(numopt)
      double precision rss
      double precision one
      parameter (one = 1.0d+00)
      character (len = 12) form12, word_i, word_g, word_n 
      character  fnamed*1024, fnamek*1024, sim256*1024, titled*80,
     +           titlek*80
      character  fname*1024, title*80
      character  line*100, text(30)*100, wordd*80, wordk*80
      character  cipherd*30, cipherk*30
      character  nodat*30, nospl*30, trim80*80
      parameter (nodat = 'No current data file',
     +           nospl = 'No current spline file')
      character  blank5*5
      parameter (blank5 = '     ')
      character  ctype*30, ctype0*30, ctype1*30, ctype2*30
      parameter (ctype0 = '[No current spline]',
     +           ctype1 = '[Spline from fitting data]',
     +           ctype2 = '[Spline from spline file]')
      character  defolt*1, weight*1
      parameter (defolt = 'W')
      logical    abort, first, newnc7, ready, repeet, reps, there
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   lbox01, spl001, spl003, trim80, putfat, getjm1, revpro,
     +           datchk, patch2, splfit, putifa, datsxy, m_fitone, 
     +           form12, sim256
      external   g10zaf$
      intrinsic  max, sqrt, min
      save       first
      save       ncap7, ngraf, npts, nrmax
      save       fnamed, fnamek
      data       first / .true. /  
      data       ncap7, ngraf, npts, nrmax / 0, 200, 0, 1000 /
      data       numbld / 30*0 /
      data       numpos / numopt*1 /
      if (first) then
         first = .false.
c
c initialise npts and install the default data file  
c        
         
         npts = 0
         fnamed = sim256('compare.tf1')
         inquire (file = fnamed, exist = there)
         if (there) then
            close (unit = nin)
            open (unit = nin, file = fnamed)
            read (nin,'(a)') titled
            read (nin,*) i, j
            if (i.eq.40 .and. j.eq.3) then
               npts = 40
            else
               fnamed = nodat
               npts = 0
            endif
            close (unit = nin)
         endif  
c
c initialise ncap7 and install the default spline file
c         
         ncap7 = 0
         fnamek = sim256('spline.tf2')
         inquire (file = fnamek, exist = there)
         if (there) then
            close (unit = nin)
            open (unit = nin, file = fnamek)
            read (nin,'(a)') titlek
            read (nin,*) i, j
            if (i.eq.20 .and. j.eq.1) then
               ncap7 = (i + 4)/2
            else
               fnamek = nospl
               ncap7 = 0
            endif
            close (unit = nin)
         endif  
      endif     
                 
c
c allocate
c      
      
      ierr = 0
      if (allocated(iwrk)) deallocate(iwrk, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(c)) deallocate(c, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(cc)) deallocate(cc, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(h)) deallocate(h, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(res)) deallocate(res, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(rk)) deallocate(rk, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(s)) deallocate(s, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(sreps)) deallocate(sreps, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xreps)) deallocate(xreps, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(yhat)) deallocate(yhat, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(yreps)) deallocate(yreps, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return   
        
      if (nrmax.lt.2*npts + ngraf) nrmax = 2*npts + ngraf
      allocate(iwrk(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(c(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(cc(nrmax,3), stat = ierr)
      if (ierr.ne.0) return
      allocate(h(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(res(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(rk(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(s(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(sreps(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(x(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(xreps(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(y(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(yhat(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(yreps(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(w(9*nrmax + 14), stat = ierr)
      if (ierr.ne.0) return
c
c initialise
c
      method = 0
      mtype = 1
      
      
      if (npts.gt.0) then
c
c read in the current curve fitting data
c        
         call datsxy (nin, nrmax, npts,
     +                s, x, y,
     +                fnamed, titled,
     +                abort)
         if (.not.abort) then
            call datchk (npts,
     +                   s, x, y,
     +                   abort)
         endif
         if (abort) then
            fnamed = nodat
            ready = .false.
            npts = 0
         else
c
c see if there are replicates...s,x, y will not be changed from now on
c
            ready = .true.
            nreps = 1
            do i = 2, npts
               if (x(i).gt.x(i - 1)) nreps = nreps + 1
            enddo
            if (nreps.eq.npts) then
               reps = .false.
            else
               reps = .true.
            endif
            write (nout,'(a)') blank5
            write (nout,'(a)') 'The current data file is:'
            write (nout,'(a)') trim80(fnamed)
         endif
      else
         abort = .true.
         ready = .false. 
         fnamed = nodat
         titled = nodat      
      endif
      
      if (ncap7.gt.0) then
c
c read in the current spline file data
c        
         close (unit = nin)
         open (nin, file = fnamek)
         read (nin,'(a)') titlek
         read (nin,*) i, j
         do k = 1, 2*ncap7 - 4
            read (nin,*) w(k)
         enddo
         close (unit = nin)    
         do i = 1, ncap7
            rk(i) = w(i)
         enddo
         do  i = 1, ncap7 - 4
            c(i) = w(ncap7 + i)
         enddo
         write (nout,'(a)') blank5
         write (nout,'(a)') 'The current spline file is:'
         write (nout,'(a)') trim80(fnamek)
         ctype = ctype2
         mtype = 2
      else 
        mtype = 0
        ctype = ctype0 
        fnamek = nospl
        titlek = nospl
      endif  
      
      weight = defolt
      numdec = numopt - 1
c
c main loop
c
      repeet = .true.
      do while (repeet)
         if (ncap7.le.0) then
            ncap7 = 0
            ctype = ctype0
            cipherk = nospl
            fnamek = nospl
         else
            cipherk = ' ***Ready***'
            if (mtype.eq.1) then
               ctype = ctype1
            else
               ctype = ctype2
            endif
         endif
         if (ready .and. npts.gt.1) then
            cipherd = ' ***Ready***'
         else
            ready = .false.
            npts = 0
            cipherd = nodat
            fnamed = nodat
         endif  
         wordd = trim80(fnamed)    
         wordk = trim80(fnamek)
         i = max(ncap7 - 8, 0)
         word_i = form12(i)
         word_g = form12(ngraf)
         word_n = form12(npts)
         numbld(1) = 1
         numbld(4) = 1
         numbld(8) = 1
         write (text,100) wordd, word_n, wordk, word_i, cipherd, 
     +                    cipherk, ctype, ctype, word_g
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, ntext,
     +                text,
     +                border, flash, high)
         numbld(1) = 0
         numbld(4) = 0
         numbld(8) = 0
         if (numdec.eq.1) then
c
c numdec = 1: input a data file
c ===========
c
            isend = 13
            ncol = 3
            nrow = npts
            if (npts.gt.1) then
               fname = fnamed
               title = titled
            else
               nrow = 0
               fname = nodat
               title = nodat
            endif      
            call m_fitone (isend, ncol, nin, nrow,
     +                     fname, title)
            if (nrow.gt.1) then
               npts = nrow 
               fnamed = fname
               titled = title
               if (npts.gt.nrmax + ngraf) then
                  ierr = 0
                  if (allocated(iwrk)) deallocate(iwrk, stat = ierr)
                  if (allocated(c)) deallocate(c, stat = ierr)
                  if (allocated(cc)) deallocate(cc, stat = ierr)
                  if (allocated(h)) deallocate(h, stat = ierr)
                  if (allocated(res)) deallocate(res, stat = ierr)
                  if (allocated(rk)) deallocate(rk, stat = ierr)
                  if (allocated(s)) deallocate(s, stat = ierr)
                  if (allocated(sreps)) deallocate(sreps, stat = ierr)
                  if (allocated(x)) deallocate(x, stat = ierr)
                  if (allocated(xreps)) deallocate(xreps, stat = ierr)
                  if (allocated(y)) deallocate(y, stat = ierr)
                  if (allocated(yhat)) deallocate(yhat, stat = ierr)
                  if (allocated(yreps)) deallocate(yreps, stat = ierr)
                  if (allocated(w)) deallocate(w, stat = ierr)  
        
                  nrmax = 2*npts + ngraf
                  allocate(iwrk(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(c(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(cc(nrmax,3), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(h(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(res(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(rk(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(s(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(sreps(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(x(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(xreps(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(y(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(yhat(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(yreps(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(w(9*nrmax + 14), stat = ierr)
                  if (ierr.ne.0) return
               endif  
               abort = .false.
            else
               abort = .true.
               fnamed = nodat
            endif
            if (.not.abort) then
               call datsxy (nin, nrmax, npts,
     +                      s, x, y,
     +                      fnamed, titled,
     +                      abort)   
            endif
            if (.not.abort) then
               call datchk (npts,
     +                      s, x, y,
     +                      abort)
            endif
            if (abort) then
               fnamed = nodat
               ready = .false.
               npts = 0
            else
c
c see if there are replicates...s,x,y will not be changed from now on
c
               ready = .true.
               nreps = 1
               do i = 2, npts
                  if (x(i).gt.x(i - 1)) nreps = nreps + 1
               enddo
               if (nreps.eq.npts) then
                  reps = .false.
               else
                  reps = .true.
               endif
               write (nout,'(a)') blank5
               write (nout,'(a)') 'The current data file is:'
               write (nout,'(a)') trim80(fnamed)
               numdec = 9
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: input a spline file
c ===========
c
            isend = 1
            call spl001 (isend, ncap7, nin, nrmax,
     +                   c, rk, w,
     +                   fnamek, titlek,
     +                   abort)
            if (abort) then
               mtype = 0
               ncap7 = 0
               fnamek = nospl
               numdec = numopt - 1
            else
               mtype = 2
               numdec = 5
            endif
         elseif (numdec.eq.3) then
c
c numdec = 3: create a spline file
c ===========
c
            numdec = 5
            if (ncap7.gt.0) then
               isend = 2
               call spl001 (isend, ncap7, nin, nrmax,
     +                      c, rk, w,
     +                      fnamek, titlek,
     +                      abort)
               if (abort) then
                  ncap7 = 0
                  fnamek = nospl
                  numdec = numopt - 1
               endif
            else
               numdec = numopt - 1
               write (line,400)
               call putfat (line)
            endif
         elseif (numdec.eq.4) then
c
c numdec = 4: read from a current spline file
c ===========
c            
            if (ncap7.gt.0) then 
               isend = 3
               call spl001 (isend, ncap7, nin, nrmax,
     +                      c, rk, w,
     +                      fnamek, titlek,
     +                      abort)
               if (abort) then
                  numdec = numopt - 1
                  mtype = 0
                  ncap7 = 0
                  fnamek = nospl
               else
                  mtype = 2
                  numdec = 5
               endif
            else
               numdec = numopt - 1
               write (line,400)
               call putfat (line)
            endif   
         elseif (numdec.eq.5) then
c
c numdec = 5: calculate
c ===========
c
            numdec = 2
            if (ncap7.gt.0) then
               if (mtype.eq.1) then
                  write (nout,600) wordd
               else
                  write (nout,700) wordk
               endif
               call spl003 (ngraf, ncap7, nout,
     +                      c, rk, w(1), w(ngraf + 1))
            else
               numdec = numopt - 1
               write (line,400)
               call putfat (line)
            endif
         elseif (numdec.ge.6 .and. numdec.le.9) then
c
c numdec = 6, 7, 8, or 9: fit
c =======================
c
            if (ready) then
               method = numdec - 5
               if (method.eq.1) then
c
c method = 1: E02BAF...always reciprocate the weights as splfit uses
c ----------- npts and sreps in the call to E02BAF which takes care
c             of all possible cases and weight is not used.
c             Note: s is not transformed for fitting, sreps = 1/s is used
c
                  ifail = 1
                  call g10zaf$('U', npts, x, y, w, nreps, xreps,
     +                         yreps, sreps, rss, iwrk, ifail)
                  call putifa (ifail, nout, 'G10ZAF/SPL000')
                  nfit = npts
                  do i = 1, npts
                     sreps(i) = one/s(i)
                  enddo
               elseif (method.eq.2) then
c
c method = 2: E02BEF...reciprocate the weights and action required if reps
c ----------- as splfit uses nfit, sreps, xreps, yreps in the call to EO2BEF
c             and weight is not used.
c             Note: s is not transformed for fitting, first w = 1/s^2 then
c             sreps is returned by G10AZF but then 1/sqrt(sreps), i.e.
c             effectively 1/s is used by E02BEF
c
                  nfit = npts
                  if (reps) then
                     if (weight.eq.'W') then
                        do i = 1, npts
                           w(i) = one/s(i)**2
                        enddo
                     else
                        do i = 1, npts
                           w(i) = one
                        enddo
                     endif
                     ifail = 1
                     call g10zaf$(weight, npts, x, y, w, nreps, xreps,
     +                            yreps, sreps, rss, iwrk, ifail)
                     call putifa (ifail, nout, 'G10ZAF/SPL000')
                     if (ifail.ne.0) then
                        ready = .false.
                        npts = 0
                        nreps = 0
                        nfit = 0
                        fnamed = nodat
                     else
                        nfit = nreps
                        do i = 1, nfit
                           sreps(i) = sqrt(sreps(i))
                        enddo
                     endif
                   else
                     nreps = nfit
                     do i = 1, nfit
                        xreps(i) = x(i)
                        yreps(i) = y(i)
                        sreps(i) = one/s(i)
                     enddo
                  endif
               elseif (method.le.4) then
c
c method = 3 or 4: G10ABF/G10ACF...adjust s and action required if reps
c ---------------- Note: s is not transformed but first w = 1/s^2 is used
c                  then sreps effectively = 1/s^2 is used i.e.
c                  nreps, sreps, xreps, yreps are used by G10ABF/G10ACF
c
                  if (weight.eq.'W') then
                     do i = 1, npts
                        w(i) = one/s(i)**2
                        sreps(i) = w(i)
                     enddo
                  else
                     do i = 1, npts
                        sreps(i) = one
                     enddo
                  endif
                  if (reps) then
                     ifail = 1
                     call g10zaf$(weight, npts, x, y, w, nreps, xreps,
     +                            yreps, sreps, rss, iwrk, ifail)
                     call putifa (ifail, nout, 'G10ZAF/SPL000')
                     if (ifail.ne.0) then
                        ready = .false.
                        npts = 0
                        nfit = 0
                        nreps = 0
                        fnamed = nodat
                     else
                        nfit = nreps
                     endif
                  else
                     nreps = npts
                     nfit = npts
                     do i = 1, npts
                        xreps(i) = x(i)
                        yreps(i) = y(i)
                     enddo
                  endif
               endif
               newnc7 = .false.
               call splfit (iwrk, method, ncap7, nfit, ngraf, nout,
     +                      npts, nreps, nrmax,
     +                      c, cc, h, res, rk, s, sreps, w, x, xreps,
     +                      y, yhat, yreps,
     +                      weight,
     +                      newnc7)
               if (newnc7 .and. ncap7.gt.0) mtype = 1
            else
               write (line,500)
               call putfat (line)
               numdec = 1
            endif
         elseif (numdec.eq.10) then
c
c numdec = 10: adjust ngraf
c ===========
c
            i = 2
            j = min(400,nrmax)
            write (line,800)
            call getjm1 (i, ngraf, j,
     +                   line)
            numdec = 5
         elseif (numdec.eq.11) then
c
c numdec = 11: review progress
c ===========
c
            call revpro (nout)
            numdec = 1
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c ====================
c
            write (text,900)
            i = 23
            numbld(1) = 1
            call patch2 (numbld, i,
     +                   text)
            numbld(1) = 0
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ================
c
            repeet = .false.
         endif
      enddo

      deallocate(iwrk, stat = ierr)
      deallocate(c, stat = ierr)
      deallocate(cc, stat = ierr)
      deallocate(h, stat = ierr)
      deallocate(res, stat = ierr)
      deallocate(rk, stat = ierr)
      deallocate(s, stat = ierr)
      deallocate(sreps, stat = ierr)
      deallocate(x, stat = ierr)
      deallocate(xreps, stat = ierr)
      deallocate(y, stat = ierr)
      deallocate(yhat, stat = ierr)
      deallocate(yreps, stat = ierr)
      deallocate(w, stat = ierr)
c
c format statements
c
  100 format (
     + 'Simfit spline fitting and calculating procedures'
     +/
     +/'Name of current curve fitting data file:'
     +/a
     +/'Number of data points =',1x,a 
     +/
     +/'Name of current spline knots file:'
     +/a
     +/'Number of interior knots =',1x,a
     +/
     +/'Data: input new data file',2x,a
     +/'Knots: input a new spline knots file',2x,a
     +/'Knots: Save as a spline knots file',2x,a
     +/'Knots: install from current spline file' 
     +/'Calculate:',2x,a
     +/'Fit: using fixed knots'
     +/'Fit: using F input by user'
     +/'Fit: using rho input by user'
     +/'Fit: using rho from generalised cross validation'
     +/'Change: number of plot points, current =',1x,a
     +/'Results'
     +/'Help'
     +/'Quit ... Exit spline procedures')
  400 format ('No current spline coefficients')
  500 format ('No current data set')
  600 format (
     +/'Spline knots and coefficients from fitting the file:'
     +/a)
  700 format (
     +/'Spline knots and coefficients taken from the file:'
     +/a)
  800 format ('Number of spline points to be plotted')
  900 format (
     + 'Spline fitting and data smoothing'
     +/
     +/'This procedure takes in spline knots and coefficients from a'
     +/'spline file, or reads data from a data file then fits a spline'
     +/'with k interior knots and corresponding coefficients which can'
     +/'be saved to a file for retrospective use, if required.'
     +/'The data file must be curve fit type file with (x,y), or else'
     +/'(x,y,s), with x in nondecreasing order, and s = the std. dev.'
     +/'of y from replicates, or s = 1 for unweighted fitting. All the'
     +/'replicates must be present, not means. For example compare.tf1.'
     +/'However, the program makes a compressed data set without'
     +/'replicates for the fitting process.'
     +/
     +/'Splines can be fitted by four alternative methods as follows.'
     +/'1.`Weighted least squares (k fixed from file or interactively).'
     +/'2.`Weighted least squares (k determined by a smoothing factor'
     +/'  `F) Here, large F leads to over-smoothing and small F leads'
     +/'  `to over-fitting. Knots are calculated automatically.'  
     +/'3.`Using n - 1 interior knots with smoothing factor rho input.'
     +/'4.`Using n - 1 interior knots with smoothing factor rho worked'
     +/'  `out by generalised cross validation.'
     +/'Spline coefficients from fitting then overwrite current splines'
     +/'for use in calibration, calculating areas, derivatives, etc.')
      end
c
c
