C
C
      SUBROUTINE SPL001 (ISEND, NCAP7, NINOUT, NMAX,
     +                   C, RK, W,
     +                   FNAME, TITLE,
     +                   ABORT)
C
C ACTION : ISEND = 1, Read in spline details from a file to workspace W
C                     then calculate NCAP7 and define RK and C
C          ISEND = 2, Write spline details to a file using workspace W
C                     with NCAP7, RK and C as supplied
C          ISEND = 3, read in from an existing spline file
C ADVICE : ISEND and NINOUT are unchanged, SPL002 checks for consistency
C AUTHOR : W. G. Bardsley, University of Manchester, UK, 14/12/92
C          11/08/1997 win32 version
C          21/09/2005 extensive revision
C          28/03/2015 added ISEND = 3
C
C  ISEND: (input/unchanged) 1 =< isend =< 2
C  NCAP7: (input/output) isend = 1...returned
C                        isend = 2...supplied
C NINOUT: (input/unchanged) unconnected unit for reading and writing
C   NMAX: (input/unchanged) dimension
C C, RK, W, FNAME, TITLE: (input/output) as for NCAP7 depending on ISEND
C  ABORT: (output) error indicator
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NINOUT, NMAX
      INTEGER,             INTENT (INOUT) :: NCAP7
      DOUBLE PRECISION,    INTENT (INOUT) :: C(NMAX), RK(NMAX),
     +                                       W(2*NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    I, IOS, NCOLS, NPTS, NROWS
      INTEGER    N1, N2, N4
      PARAMETER (N1 = 1, N2 = 2, N4 = 4)
      CHARACTER  LINE*100
      CHARACTER  HEADER*80, TFILE*10
      PARAMETER (HEADER = 'Selecting a spline knots file',
     +           TFILE = 'spline.tf2') 
      LOGICAL    THERE
      LOGICAL    YES
      PARAMETER (YES = .TRUE.)
      EXTERNAL   SPL002, VECOUT, VEC2IN, VEC5IN, PUTADV, PUTFAT
      ABORT = .TRUE.
      CLOSE (UNIT = NINOUT)
      IF (ISEND.EQ.N1) THEN
C
C ISEND = 1: Attempt to open a spline file
C
         NPTS = N2*NCAP7 - N4
         CALL VEC5IN (NINOUT, NPTS,
     +                FNAME, HEADER, TFILE, TITLE,        
     +                ABORT)
         CLOSE (UNIT = NINOUT)
         IF (.NOT.ABORT) THEN
            CALL VEC2IN (NINOUT, N2*NMAX, NPTS,
     +                   W,
     +                   FNAME, TITLE,
     +                   ABORT)              
            CLOSE (UNIT = NINOUT)
         ENDIF   
         IF (ABORT) RETURN
         CALL SPL002 (NPTS,
     +                W,
     +                ABORT)
         IF (ABORT) RETURN
         NCAP7 = (NPTS + N4)/N2
         DO I = N1, NCAP7
            RK(I) = W(I)
         ENDDO
         DO I = N1, NCAP7 - N4
            C(I) = W(NCAP7 + I)
         ENDDO
         ABORT = .FALSE.
         WRITE (LINE,100)
         CALL PUTADV (LINE)
      ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: Attempt to save a spline file
C
         DO I = N1, NCAP7
            W(I) = RK(I)
         ENDDO
         DO I = N1, NCAP7 - N4
            W(NCAP7 + I) = C(I)
         ENDDO
         NPTS = N2*NCAP7 - N4
         CALL SPL002 (NPTS,
     +                W,
     +                ABORT)
         IF (ABORT) RETURN
         TITLE = 'Data to evaluate a spline function'
         CLOSE (UNIT = NINOUT)
         CALL VECOUT (N1, N2*NMAX, NINOUT, NPTS,
     +                W,
     +                FNAME, TITLE,
     +                ABORT, YES, YES)
         CLOSE (UNIT = NINOUT)
         ABORT = .FALSE.
         WRITE (LINE,200)
         CALL PUTADV (LINE)
      ELSEIF (ISEND.EQ.3) THEN
C      
C ISEND = 3: read from an existing spline file
C      
         INQUIRE (FILE = FNAME, EXIST = THERE)
         IF (.NOT.THERE) RETURN
         OPEN (UNIT = NINOUT, FILE = FNAME, IOSTAT = IOS)  
         IF (IOS.NE.0) THEN
            CLOSE (UNIT = NINOUT)
            RETURN
         ENDIF
         READ (NINOUT,'(A)',IOSTAT=IOS) TITLE  
         IF (IOS.NE.0) THEN
            CLOSE (UNIT = NINOUT)
            RETURN
         ENDIF
         READ (NINOUT,*,IOSTAT=IOS) NROWS, NCOLS
         IF (NCOLS.NE.1 .OR. NROWS.LT.10) THEN
            CLOSE (UNIT = NINOUT)
            RETURN
         ENDIF
         NPTS = NROWS
         DO I = 1, NPTS
            READ (NINOUT,*,IOSTAT=IOS) W(I)
            IF (IOS.NE.0) THEN
               CLOSE (UNIT = NINOUT)
               RETURN
            ENDIF   
         ENDDO
         CLOSE (UNIT = NINOUT)
         CALL SPL002 (NPTS,
     +                W,
     +                ABORT)
         IF (ABORT) RETURN
         NCAP7 = (NPTS + N4)/N2
         DO I = N1, NCAP7
            RK(I) = W(I)
         ENDDO
         DO I = N1, NCAP7 - N4
            C(I) = W(NCAP7 + I)
         ENDDO
         ABORT = .FALSE. 
         WRITE (LINE,100) 
         CALL PUTADV (LINE)
      ELSE
         WRITE (LINE,300)
         CALL PUTFAT (LINE)
      ENDIF
C
C Format statement
C  
  100 FORMAT (
     +'Knots and coefficients have been initialised from a spline file')     
  200 FORMAT ('Knots and coefficients have been saved to a spline file')     
  300 FORMAT ('ISEND out of range in call to SPL001')
      END
C
C
