C
C
      SUBROUTINE SPL002 (N,
     +                   V,
     +                   ABORT)
C
C ACTION : Check that vector V is consistent as a spline set
C AUTHOR : W. G. Bardsley, University of Manchester, UK, 14/10/92
C          21/02/1994 DBOS version
C          19/10/1995 improved
C          21/09/2005 minor editing
C
C     N: (input/unchanged) dimension
C     V: (input/unchanged) vector
C ABORT: (output) error indicator
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)  :: N
      DOUBLE PRECISION, INTENT (IN)  :: V(N)
      LOGICAL,          INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    I, IERR, J, NCAP3, NCAP7
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMTXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMTXT = 9)
      INTEGER    NUMBLD(NUMTXT)
      INTEGER    N1, N2, N3, N4, N5, N8
      PARAMETER (N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N8 = 8)
      DOUBLE PRECISION EPSI, ONE
      PARAMETER (EPSI = 1.0D-06, ONE = 1.0D+00)
      DOUBLE PRECISION V1, V2
      CHARACTER  TEXT(NUMTXT)*100
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   PATCH1
      INTRINSIC  ABS, MAX
      DATA       NUMBLD / 1*1, 7*0, 1*1 /
      IERR = N1
      NCAP3 = (N - N4)/N2
      NCAP7 = (N + N4)/N2
      IF (NCAP3.LT.N4 .OR. NCAP7.LT.N8) GOTO 20
      IERR = N2
      IF (N.NE.(NCAP3 + NCAP7)) GOTO 20
      IERR = N3
      V1 = V(1) - EPSI*MAX(ONE, ABS(V(1)))
      V2 = V(1) + EPSI*MAX(ONE, ABS(V(1)))
      DO I = N1, N4
         IF (V(I).LT.V1 .OR. V(I).GT.V2) GOTO 20
      ENDDO
      IERR = N4
      DO I = N5, NCAP3
         IF (V(I).LT.V1) GOTO 20
         V1 = V(I) - EPSI*MAX(ONE, ABS(V(I)))
      ENDDO
      IERR = N5
      J = NCAP3 + N1
      V1 = V(J) - EPSI*MAX(ONE, ABS(V(J)))
      V2 = V(J) + EPSI*MAX(ONE, ABS(V(J)))
      DO I = J, NCAP7
         IF (V(I).LT.V1 .OR. V(I).GT.V2) GOTO 20
      ENDDO
C
C Data checks OK so return with ABORT = .FALSE.
C
      ABORT = .FALSE.
      RETURN
C
C LABEL 20: report error then return with ABORT = .TRUE.
C ========
C
   20 CONTINUE
      ABORT = .TRUE.
      WRITE (TEXT,100) IERR
      CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +             TEXT,
     +             BORDER)
C
C Format ststement
C     
  100 FORMAT (
     + '*FATAL* : Error number',I3,2X,'encountered with spline file'
     +/'Data in/for file is not consistent for spline'
     +/'There must be at least 12 items in/for file'
     +/'There must be at least 8 non-decreasing knots'
     +/'The first 4 of these knots must all be equal'
     +/'The next (N - 12)/2 must be non-decreasing'
     +/'The next 4 of these knots must all be equal'
     +/'Then there must be (N - 4)/2 coefficients'
     +/'ADVICE: Prepare spline file using SPLINE, CALCURVE, or COMPARE')
      END
C
C
