C
C
      SUBROUTINE SPL003 (N, NCAP7, NOUT,
     +                   C, RK, X, Y)
C
C ACTION : Evaluate spline and derivatives and plot if required
C          This version calculates length and curvature
C          Call SIMSON with NM1 = N - 1 if N is even
C AUTHOR : W. G. Bardsley, University of Manchester, UK, 13/12/92
C          21/02/1994 DBOS version
C          11/08/1997 win32 version
C          03/02/2001 added code to display defaults
C          21/09/2005 extensive editing, added calibration
C          01/11/2006 edited
C
C     N: (input/unchanged) number of points to plot
C NCAP7: (input/unchanged) no. of knots
C  NOUT: (input/unchanged) preconnected unit for results
C     C: (input/unchanged) spline coefficients
C    RK: (input/unchanged) spline knots
C     X: workspace
C     Y: workspace
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: N, NCAP7, NOUT
      DOUBLE PRECISION, INTENT (IN)    :: C(NCAP7), RK(NCAP7)
      DOUBLE PRECISION, INTENT (INOUT) :: X(N), Y(N)
C
C Locals
C
      INTEGER    L0, L1, L2, L3
      PARAMETER (L0 = 0, L1 = 1, L2 = 2, L3 = 3)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, N15 = 15)
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 9, IX = 0, IY = 0)
      INTEGER    NGRAF, NPTS, NTEMP
      PARAMETER (NGRAF = 100)
      INTEGER    I, IFAIL, J, LEFT, NBAR, NDEC, NM1, NPREV
      INTEGER    NUMOPT, NSTART, NTEXT
      PARAMETER (NUMOPT = 9, NSTART = 7, NTEXT = NSTART + NUMOPT + 6)
      INTEGER    MSHADE
      PARAMETER (MSHADE = 0)
      INTEGER    JUMBLD(4), KUMBLD(7), NUMBLD(30)
      INTEGER    IND, IR
      DOUBLE PRECISION ZERO, ONE, HALF
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, HALF = 0.5D+00)
      DOUBLE PRECISION RTODEG
      PARAMETER (RTODEG = 57.29578D+00)
      DOUBLE PRECISION AREA, S(4), TEMP,
     +                 X1, X2, XMAX, XMIN, XVAL,
     +                 Y1, Y2, YMAX, YMIN, YVAL
      DOUBLE PRECISION XDRV(N2), YDRV(N2)
      DOUBLE PRECISION ARCLEN, CURVAT, FX, FX1, FX2, XTEMP, YTEMP
      DOUBLE PRECISION ASAV, BSAV, XSAV
      DOUBLE PRECISION CC(17), TOLX, XX(N2), XXX(N2), YY(N2),
     +                 YYY(N2)
      DOUBLE PRECISION XGRAF(NGRAF), YGRAF(NGRAF)
      CHARACTER  (LEN = 13) D13(8), SHOWLJ, SHOWRJ
      CHARACTER  PTITLE*50, XTITLE*20, YTITLE*20
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      CHARACTER (LEN = 40) XFROMY
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ADDY, REPEET, YES
      LOGICAL    FIXED
      PARAMETER (FIXED = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   GETDL1, GETDG2, GKS004, PUTIFA, SIMSON, LSTBOX, PATCH1,
     +           GETR01, PUTADV, PUTFAT, TABLE1, SPLPLT
      EXTERNAL   E02BBF$, E02BCF$, C05AZF$
      INTRINSIC  ABS, MOD, SQRT, DBLE, MIN
      DATA       JUMBLD / 2*1, 2*0 /
      DATA       KUMBLD / 3*1, 4*0 /
      DATA       NUMBLD / 30*0 /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      ADDY = .FALSE.
      IF (MOD(N,N2).EQ.N0) THEN
         NM1 = N - N1
      ELSE
         NM1 = N
      ENDIF
      NPREV = N0
      XMIN = RK(1)
      XMAX = RK(NCAP7)
      YES = .TRUE.
      ASAV = XMIN
      BSAV = XMAX
      XSAV = HALF*(ASAV + BSAV)
      NDEC = NUMOPT
      XFROMY = ' '
C
C Main loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         X1 = ASAV
         X2 = BSAV
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) XMIN, XMAX, ASAV, BSAV, XFROMY
         ELSE
            D13(1) = SHOWRJ(XMIN)
            D13(2) = SHOWRJ(XMAX)
            D13(3) = SHOWRJ(ASAV)
            D13(4) = SHOWRJ(BSAV) 
            WRITE (TEXT,150) D13(1), D13(2), D13(3), D13(4), XFROMY
         ENDIF  
         NPREV = NDEC
         NUMBLD(1) = 4
         NUMBLD(3) = 1
         CALL LSTBOX (NUMBLD, NDEC, NUMOPT, NSTART, NTEXT,
     +                TEXT)
         NUMBLD(1) = 0
         NUMBLD(3) = 0
         IF (NDEC.EQ.N1) THEN
C
C Change range
C           
            IF (E_NUMBERS) THEN 
               WRITE (LINE,300) XMIN, XMAX
            ELSE
               D13(1) = SHOWLJ(XMIN)
               D13(2) = SHOWLJ(XMAX)  
               WRITE (LINE,350) TRIM(D13(1)), TRIM(D13(2))
            ENDIF  
            CALL GETDG2 (ASAV, BSAV, LINE)
            IF (ASAV.LT.XMIN .OR. ASAV.GT.XMAX) ASAV = XMIN
            IF (BSAV.LT.XMIN .OR. BSAV.GT.XMAX) BSAV = XMAX
            X1 = ASAV
            X2 = BSAV
         ELSEIF (NDEC.EQ.N2) THEN
C
C Evaluate spline and first three derivatives
C
            IF (E_NUMBERS) THEN
               WRITE (LINE,200) XMIN, XMAX
            ELSE
               D13(1) = SHOWLJ(XMIN)
               D13(2) = SHOWLJ(XMAX)
               WRITE (LINE,250) TRIM(D13(1)), TRIM(D13(2)) 
            ENDIF  
            CALL GETDL1 (XMIN, XSAV, XMAX,
     +                   LINE)
            X1 = XSAV
            IFAIL = N1
            LEFT = N1
            CALL E02BCF$(NCAP7, RK, C, X1, LEFT, S, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'E02BCF/SPL003')
            IF (IFAIL.EQ.N0) THEN
               IF (NPREV.NE.NDEC) WRITE (NOUT,700)
               WRITE (TEXT,700)
               TEXT(3) = ' '
               IF (E_NUMBERS) THEN
                  WRITE (LINE,800) X1, (S(I), I = N1, N4)
               ELSE
                  D13(1) = SHOWRJ(X1)
                  D13(2) = SHOWRJ(S(1))
                  D13(3) = SHOWRJ(S(2))
                  D13(4) = SHOWRJ(S(3))
                  D13(5) = SHOWRJ(S(4))
                  WRITE (LINE,850) (D13(I), I = 1, 5)
               ENDIF    
               WRITE (NOUT,'(A)') LINE 
               TEXT(4) = LINE
               I = N4
               CALL PATCH1 (ICOLOR, IX, IY, MSHADE, JUMBLD, I,
     +                      TEXT,
     +                      FIXED)
            ENDIF
         ELSEIF (NDEC.GE.N3 .AND. NDEC.LE.N6) THEN
C
C Area, arc length and absolute curvature, calibration, or plot
C
            X1 = ASAV
            X2 = BSAV
            IF (NDEC.EQ.N3) THEN
C
C Integrals
C
               AREA = (X2 - X1)/(DBLE(NM1) - ONE)
               X(1) = X1
               DO I = N2, NM1 - N1
                  X(I) = X(I - 1) + AREA
               ENDDO
               X(NM1) = X2
               DO I = N1, NM1
                  IFAIL = N1
                  CALL E02BBF$(NCAP7, RK, C, X(I), Y(I), IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'E02BBF/SPL003')
               ENDDO
               IF (IFAIL.EQ.N0) THEN
                  CALL SIMSON (NM1, 
     +                         AREA, X1, X2, Y)
                  DO I = N1, NM1
                     IF (IFAIL.EQ.N0) THEN
                        IFAIL = N1
                        LEFT = N1
                        CALL E02BCF$(NCAP7, RK, C, X(I), LEFT, S, IFAIL)
                        CALL PUTIFA (IFAIL, NOUT, 'E02BCF/SPL003')
                        IF (IFAIL.EQ.N0) Y(I) = SQRT(ONE + S(2)**2)
                     ENDIF
                  ENDDO
               ENDIF
               IF (IFAIL.EQ.N0) THEN
                  CALL SIMSON (NM1, ARCLEN, X1, X2, Y)
                  DO I = N1, NM1
                     IF (IFAIL.EQ.N0) THEN
                        IFAIL = N1
                        LEFT = N1
                        CALL E02BCF$(NCAP7, RK, C, X(I), LEFT, S, IFAIL)
                        CALL PUTIFA (IFAIL, NOUT, 'E02BCF/SPL003')
                        IF (IFAIL.EQ.N0) Y(I) = ABS(S(3))/(ONE+S(2)**2)
                     ENDIF
                  ENDDO
               ENDIF
               IF (IFAIL.EQ.N0) THEN
                  CALL SIMSON (NM1,
     +                         CURVAT, X1, X2, Y)
                  IF (NPREV.NE.NDEC) WRITE (NOUT,900)
                  WRITE (TEXT,900)
                  TEXT(3) = ' '
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,1000) X1, X2, AREA, ARCLEN, CURVAT,
     +                                 RTODEG*CURVAT
                  ELSE
                     D13(1) = SHOWRJ(X1)
                     D13(2) = SHOWRJ(X2)
                     D13(3) = SHOWRJ(AREA)
                     D13(4) = SHOWRJ(ARCLEN)
                     D13(5) = SHOWRJ(CURVAT)
                     TEMP = RTODEG*CURVAT
                     D13(6) = SHOWRJ(TEMP)
                     WRITE (LINE,1050) (D13(I), I = 1, 6)
                     
                  ENDIF  
                  WRITE (NOUT,'(A)') LINE
                  TEXT(4) = LINE
                  I = N4
                  CALL PATCH1 (ICOLOR, IX, IY, MSHADE, JUMBLD, I,
     +                         TEXT,
     +                         FIXED)
               ENDIF
            ELSEIF (NDEC.EQ.N4) THEN
C
C Predict x given y
C
               ADDY = .FALSE.
               X1 = ASAV
               X2 = BSAV
               WRITE (LINE,400)
               CALL GETR01 (YVAL, LINE)
               IFAIL = N1
               CALL E02BBF$(NCAP7, RK, C, X1, Y1, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'E02BBF/SPL003')
               IF (IFAIL.EQ.N0) THEN
                  FX1 = Y1 - YVAL
                  IFAIL = N1
                  CALL E02BBF$(NCAP7, RK, C, X2, Y2, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'E02BBF/SPL003')
                  IF (IFAIL.EQ.N0) THEN
                     FX2 = Y2 - YVAL 
                     IF (FX1*FX2.GE.ZERO) THEN
                        WRITE (LINE,500)
                        CALL PUTFAT (LINE)
                        IFAIL = N1
                     ENDIF
                  ENDIF
               ENDIF
               IF (IFAIL.EQ.N0) THEN
                  TOLX = 1.0D-04
                  IR = N0
                  IFAIL = N1
                  IND = N1
C
C LABEL 20: reverse communication point for C05AZF
C =========
C
   20             CONTINUE
                  CALL C05AZF$(X1, X2, FX, TOLX, IR, CC, IND, IFAIL)
                  IF (IND.NE.N0) THEN
                     IF (IND.LT.N2 .OR. IND.GT.N4) THEN
                        WRITE (LINE,500)
                        CALL PUTFAT (LINE)
                     ELSE
                        I = N1
                        CALL E02BBF$(NCAP7, RK, C, X1, Y1, I)
                        CALL PUTIFA (I, NOUT, 'E02BBF/SPL003')
                        IF (I.EQ.N0) THEN
                           FX = Y1 - YVAL
                           GOTO 20
                        ENDIF
                     ENDIF
                  ELSE
                     IF (IFAIL.EQ.N0) THEN
                        ADDY = .TRUE.
                        XVAL = HALF*(X1 + X2)
                        WRITE (NOUT,'(A)') BLANK
                        IF (E_NUMBERS) THEN
                           WRITE (LINE,600) YVAL, XVAL
                        ELSE
                           D13(1) = SHOWLJ(YVAL)
                           D13(2) = SHOWLJ(XVAL)
                           WRITE (LINE,650) TRIM(D13(1)), TRIM(D13(2))
                        ENDIF      
                        WRITE (NOUT,'(A)') LINE
                        CALL PUTADV (LINE)
                        XFROMY = 'and X predicted given Y'
                     ELSE
                        WRITE (LINE,500)
                        CALL PUTFAT (LINE)
                        XFROMY = ' '
                     ENDIF
                  ENDIF
               ENDIF
            ELSEIF (NDEC.EQ.N5) THEN
C
C Plots
C 
               X1 = ASAV
               X2 = BSAV  
               AREA = (X2 - X1)/(DBLE(N) - ONE)
               X(1) = X1
               DO I = N2, N - N1
                  X(I) = X(I - N1) + AREA
               ENDDO
               IFAIL = N0
               X(N) = X2
               DO I = N1, N
                  IF (IFAIL.EQ.N0) THEN
                     IFAIL = N1
                     CALL E02BBF$(NCAP7, RK, C, X(I), Y(I), IFAIL)
                     CALL PUTIFA (IFAIL, NOUT, 'E02BBF/SPL003')
                     IF (I.EQ.N1) THEN
                        YMIN = Y(1)
                        YMAX = Y(1)
                     ELSE
                        IF (Y(I).LT.YMIN) YMIN = Y(I)
                        IF (Y(I).GT.YMAX) YMAX = Y(I)
                     ENDIF
                  ENDIF
               ENDDO
               IF (IFAIL.EQ.N0) THEN
                  NTEMP = MIN(NCAP7 - N6, NGRAF)
                  NPTS = N0
                  IF (NTEMP.GT.N0) THEN
                     DO I = N1, NTEMP
                        IF (IFAIL.EQ.N0) THEN
                           XTEMP = RK(I + N3)
                           IF (XTEMP.GE.X1 .AND. XTEMP.LE.X2) THEN
                              IFAIL = N1
                              CALL E02BBF$(NCAP7, RK, C, XTEMP, YTEMP,
     +                                    IFAIL)
                              CALL PUTIFA (IFAIL, NOUT, 'E02BBF/SPL003')
                              IF (IFAIL.EQ.N0) THEN
                                 NPTS = NPTS + 1
                                 XGRAF(NPTS) = XTEMP
                                 YGRAF(NPTS) = YTEMP
                              ENDIF
                           ENDIF
                        ENDIF
                     ENDDO
                  ENDIF
               ENDIF
               IF (IFAIL.EQ.N0) THEN
                  XTITLE = 'Indep. Var.'
                  YTITLE = ' Dep. Var.'
                  YES = .TRUE.
                  IF (ADDY) THEN
                     XX(1) = X(1)
                     XX(2) = X(N)
                     YY(1) = YVAL
                     YY(2) = YVAL
                     XXX(1) = XVAL
                     XXX(2) = XVAL
                     YYY(1) = YMIN
                     YYY(2) = YMAX
                     PTITLE = 'Spline and X predicted from Y'
                     CALL GKS004 (L1, L2, L2,  L0,
     +                            L0, L0, L0,  L1,
     +                             N, N2, N2,  NPTS,
     +                             X, XX, XXX, XGRAF,
     +                             Y, YY, YYY, YGRAF,
     +                            PTITLE, XTITLE, YTITLE,
     +                            YES, YES)
                  ELSE
                     PTITLE = 'Cubic spline curve'
                     CALL GKS004 (L1,    L0, L0, L0,
     +                            L0,    L1, L0, L0,
     +                             N,  NPTS,  N,  N,
     +                             X, XGRAF,  X,  X,
     +                             Y, YGRAF,  Y,  Y,
     +                            PTITLE, XTITLE, YTITLE,
     +                            YES, YES)
                  ENDIF
               ENDIF
            ELSEIF (NDEC.EQ.N6) THEN
C
C Plots
C
               X1 = ASAV
               X2 = BSAV
               AREA = (X2 - X1)/(DBLE(N) - ONE)
               X(1) = X1
               DO I = N2, N - N1
                  X(I) = X(I - N1) + AREA
               ENDDO
               IFAIL = N0
               X(N) = X2
               DO I = N1, N
                  IF (IFAIL.EQ.N0) THEN
                     IFAIL = N1
                     CALL E02BBF$(NCAP7, RK, C, X(I), Y(I), IFAIL)
                     CALL PUTIFA (IFAIL, NOUT, 'E02BBF/SPL003')
                     IF (I.EQ.N1) THEN
                        YMIN = Y(1)
                        YMAX = Y(1)
                     ELSE
                        IF (Y(I).LT.YMIN) YMIN = Y(I)
                        IF (Y(I).GT.YMAX) YMAX = Y(I)
                     ENDIF
                  ENDIF
               ENDDO
               IF (IFAIL.EQ.N0) THEN
                  NTEMP = MIN(NCAP7 - N6, NGRAF)
                  NPTS = N0
                  IF (NTEMP.GT.N0) THEN
                     DO I = N1, NTEMP
                        IF (IFAIL.EQ.N0) THEN
                           XTEMP = RK(I + N3)
                           IF (XTEMP.GE.X1 .AND. XTEMP.LE.X2) THEN
                              IFAIL = N1
                              CALL E02BBF$(NCAP7, RK, C, XTEMP, YTEMP,
     +                                    IFAIL)
                              CALL PUTIFA (IFAIL, NOUT, 'E02BBF/SPL003')
                              IF (IFAIL.EQ.N0) THEN
                                 NPTS = NPTS + 1
                                 XGRAF(NPTS) = XTEMP
                                 YGRAF(NPTS) = YTEMP
                              ENDIF
                           ENDIF
                        ENDIF
                     ENDDO
                  ENDIF
               ENDIF
               IF (IFAIL.EQ.N0) THEN
                  IFAIL = N1
                  LEFT = N1
                  CALL E02BCF$(NCAP7, RK, C, X(1), LEFT, S, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'E02BCF/SPL003')
                  IF (IFAIL.EQ.N0) THEN
                     YDRV(1) = S(2)
                     YDRV(2) = S(2)
                     XDRV(1) = X(1)
                     XDRV(2) = X(1)
                     DO I = N1, N
                        IF (IFAIL.EQ.N0) THEN
                           IFAIL = N1
                           CALL E02BCF$(NCAP7, RK, C, X(I), LEFT, S,
     +                                  IFAIL)
                           CALL PUTIFA (IFAIL, NOUT, 'E02BCF/SPL003')
                           IF (IFAIL.EQ.N0) THEN
                              Y(I) = S(2)
                              IF (Y(I).LT.YDRV(1)) THEN
                                 XDRV(1) = X(I)
                                 YDRV(1) = Y(I)
                              ENDIF
                              IF (Y(I).GT.YDRV(2)) THEN
                                 XDRV(2) = X(I)
                                 YDRV(2) = Y(I)
                              ENDIF
                           ENDIF
                        ENDIF
                     ENDDO
                     IF (IFAIL.EQ.N0) THEN
                        IF (E_NUMBERS) THEN
                           WRITE (TEXT,1100) XMIN, XMAX, X1, X2,
     +                                       YDRV(1), XDRV(1),
     +                                       YDRV(2), XDRV(2)
                           WRITE (NOUT,1100) XMIN, XMAX, X1, X2,
     +                                       YDRV(1), XDRV(1),
     +                                       YDRV(2), XDRV(2)
                        ELSE
                           D13(1) = SHOWLJ(XMIN)
                           D13(2) = SHOWLJ(XMAX)
                           D13(3) = SHOWLJ(X1)
                           D13(4) = SHOWLJ(X2)
                           D13(5) = SHOWLJ(YDRV(1))
                           D13(6) = SHOWLJ(XDRV(1))
                           D13(7) = SHOWLJ(YDRV(2))
                           D13(8) = SHOWLJ(XDRV(2))
                           WRITE (TEXT,1150) (D13(I), I = 1, 8)
                           WRITE (NOUT,1150) (D13(I), I = 1, 8)
                        ENDIF  
                        I = N7
                        CALL PATCH1 (ICOLOR, IX, IY, MSHADE, KUMBLD, I,
     +                               TEXT,
     +                            FIXED)
                        PTITLE = ' First derivative '
                        XTITLE = 'Indep. Var.'
                        YTITLE = '1st. Deriv.'
                        YES = .TRUE.
                        CALL GKS004 (L1,   L0,   L0,   L0,
     +                               L0,   L3,   L0,   L0,
     +                                N,   N2,   N2,   N2,
     +                                X, XDRV, XDRV, XDRV,
     +                                Y, YDRV, YDRV, YDRV,
     +                               PTITLE, XTITLE, YTITLE,
     +                               YES, YES)
                     ENDIF
                  ENDIF
               ENDIF
            ENDIF
         ELSEIF (NDEC.EQ.N7) THEN
            CALL SPLPLT (NCAP7, N,
     +                   C, RK, X)         
         ELSEIF (NDEC.EQ.N8) THEN
C
C Table of knots and coefficients
C
            NBAR = NCAP7 - N7
            J = N15
            CALL TABLE1 (J, 'OPEN')
            J = N4
            CALL TABLE1 (J, '         Knots')
            J = N0
            DO I = N1, NCAP7 
               IF (E_NUMBERS) THEN
                  WRITE (LINE,'(1P,1X,E13.5)') RK(I)
               ELSE
                  D13(1) = SHOWRJ(RK(I))
                  WRITE (LINE,'(1X,A)') D13(1)
               ENDIF      
               CALL TABLE1 (J, LINE)
            ENDDO
            J = N4
            CALL TABLE1 (J, '  Coefficients')
            J = N0
            DO I = N1, NBAR + N3
               IF (E_NUMBERS) THEN
                  WRITE (LINE,'(1P,1X,E13.5)') C(I)
               ELSE
                  D13(1) = SHOWRJ(C(I))
                  WRITE (LINE,'(1X,A)') D13(1)  
               ENDIF  
               CALL TABLE1 (J, LINE)
            ENDDO
            CALL TABLE1 (J, 'CLOSE')
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Simfit spline calculation options'
     +/
     +/'X-range allowed and selected' 
     +/1P,1X,E13.5,',',1X,E13.5,'   : Limits available' 
     +/   1X,E13.5,',',1X,E13.5,'   : A, B selected' 
     +/
     +/'X-Range: select A = X_min, B = X_max' 
     +/'Evaluate: spline and derivatives'
     +/'Evaluate: Area-Length-Curvature'
     +/'Calibrate: predict X given Y'
     +/'Plot: spline and knots',1X,A
     +/'Plot: first derivative and mimimax positions'
     +/'Plot: spline and first three derivatives'
     +/'View: knots and coefficients'
     +/'Quit ... Exit spline calculations'
     +/
     +/'Note: Option 3 calculates the area under the spline curve,'
     +/'the arc length s (i.e. integral of sqrt[1 + (dy/dx)^2]dx),'
     +/'and also the total absolute curvature |K| (i.e. integral of'
     +/'|(d^2y/dx^2)/[1 + (dy/dx)^2]^(3/2)|ds, that is, integral of'
     +/'|(d^2y/dx^2)/[1 + (dy/dx)^2]|dx) over the range A to B.'
     +/'Any X predicted from Y will be overlayed onto the plot')
  150 FORMAT (
     + 'Simfit spline calculation options'
     +/
     +/'X-range allowed and selected' 
     +/1X,A13,',',1X,A13,'     :Limits available' 
     +/1X,A13,',',1X,A13,'     :A, B selected' 
     +/
     +/'X-Range: select A = X_min, B = X_max' 
     +/'Evaluate: spline and derivatives'
     +/'Evaluate: Area-Length-Curvature'
     +/'Calibrate: predict X given Y'
     +/'Plot: spline and knots',1X,A
     +/'Plot: first derivative and mimimax positions'
     +/'Plot: spline and first three derivatives'
     +/'View: knots and coefficients'
     +/'Quit ... Exit spline calculations'
     +/
     +/'Note: Option 3 calculates the area under the spline curve,'
     +/'the arc length s (i.e. integral of sqrt[1 + (dy/dx)^2]dx),'
     +/'and also the total absolute curvature |K| (i.e. integral of'
     +/'|(d^2y/dx^2)/[1 + (dy/dx)^2]^(3/2)|ds, that is, integral of'
     +/'|(d^2y/dx^2)/[1 + (dy/dx)^2]|dx) over the range A to B.'
     +/'Any X predicted from Y will be overlayed onto the plot')   
  200 FORMAT (
     +'X-value required, Min. =',1P,E13.5,', Max. =',E13.5)
  250 FORMAT (
     +'X-value required, Min. =',1X,A,', Max. =',1X,A)     
  300 FORMAT (
     +'Range A, B required, Min. =',1P,E13.5,', Max. =',E13.5)
  350 FORMAT (
     +'Range A, B required, Min. =',1X,A,', Max. =',1X,A)   
  400 FORMAT (
     +'Value of Y required to predict x = x(y)')
  500 FORMAT (
     +'(F(A) - Y))*(F(B) - Y)) > 0, change Y or the range A to B')
  600 FORMAT (
     +'For Y =',1P,E13.5,', X_predicted =',1P,E13.5)
  650 FORMAT (
     +'For Y =',1X,A,', X_predicted =',1X,A)   
  700 FORMAT (
     +/'       X-value        spline    1st.deriv.    2nd.deriv.',
     + '    3rd.deriv.')
  800 FORMAT (1P,5E14.5)
  850 FORMAT (5(1X,A13))
  900 FORMAT (
     +/'             A             B          Area',
     +'  s=Arc-length Integral|K|ds  (In degrees)')
 1000 FORMAT (1P,6(1X,E13.5))
 1050 FORMAT (6(1X,A13))
 1100 FORMAT (
     +/'Minimax slopes etc. in range (A,B) selected'
     +/
     +/'Min. indep. var. =',1P,E13.5,', Max. indep. var. =',E13.5
     +/'Min. selected(A) =',   E13.5,', Max. selected(B) =',E13.5
     +/'Min. 1st. deriv. =',   E13.5,', in range(A,B) at =',E13.5
     +/'Max. 1st. deriv. =',   E13.5,', in range(A,B) at =',E13.5)
 1150 FORMAT (
     +/'Minimax slopes etc. in range (A,B) selected'
     +/
     +/'Min. indep. var. =',1X,A,' Max. indep. var. =',1X,A
     +/'Min. selected(A) =',1X,A,' Max. selected(B) =',1X,A
     +/'Min. 1st. deriv. =',1X,A,' in range(A,B) at =',1X,A
     +/'Max. 1st. deriv. =',1X,A,' in range(A,B) at =',1X,A)    
      END
C
C
