C
C
      SUBROUTINE SPL004 (NCAP7, NFILE, NGRAF, NOUT, NMAX,
     +                   C, RK, W, XGRAF, YGRAF)
C
C ACTION : File splines or do calculations as required
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 18/12/92
C          21/02/1994 DBOS version
C          08/11/1997 win32 version
C          22/09/2005 upgraded
C
C NCAP7: (input/unchanged)
C NFILE: (input/unchanged) unopened unit for saving a spline file
C NGRAF: (input/unchanged) dimension
C  NOUT: (input/unchanged) preconnected unit for results
C  NMAX: (input/unchanged) dimension
C C, RK, W, XGRAF, YGRAF depend on whether the routine is called for
C the first or subsequent times, as follows.
C FIRST TIME: arbitrary, not referenced
C NEXT TIMES: C and RK are (input/unchanged),
C             W, XGRAF, YGRAF are workspaces
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NCAP7, NFILE, NGRAF, NOUT,
     +                                    NMAX
      DOUBLE PRECISION, INTENT (INOUT) :: C(NMAX), RK(NMAX), W(2*NMAX)
      DOUBLE PRECISION, INTENT (INOUT) :: XGRAF(NGRAF), YGRAF(NGRAF)
C
C Locals
C
      INTEGER    ISEND
      PARAMETER (ISEND = 2)
      INTEGER    ICOLOR, IX, IY, N0, N1, N5, N13
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, N0 = 0, N1 = 1, N5 = 5,
     +           N13 = 13)
      INTEGER    NUMBLD(N13)
      CHARACTER  FNAME*1024, TITLE*80
      CHARACTER  LINE*100, TEXT(N13)*100
      LOGICAL    FIRST, OUTPUT(2), YES
      EXTERNAL   SPL001, SPL003, ANSWER, YESNO2
      SAVE       FIRST, OUTPUT
      DATA       FIRST / .TRUE. /
      DATA       NUMBLD / N13*N0 /
      IF (FIRST) THEN
C
C First time find out the users intentions
C
         WRITE (TEXT,100)
         OUTPUT(1) = .FALSE.
         NUMBLD(N13) = N1
         WRITE (LINE,200)
         CALL ANSWER (ICOLOR, NUMBLD, N13,
     +                TEXT, LINE,
     +                OUTPUT(1))
         NUMBLD(N13) = N0
         WRITE (TEXT,300)
         OUTPUT(2) = .FALSE.
         NUMBLD(N5) = N1
         CALL ANSWER (ICOLOR, NUMBLD, N5,
     +                TEXT, LINE,
     +                OUTPUT(2))
         NUMBLD(N5) = N0
         FIRST = .FALSE.
      ENDIF
      IF (OUTPUT(1)) THEN
C
C Option to save a spline file
C
         YES = .FALSE.
         WRITE (LINE,400)
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                YES)
         IF (YES) CALL SPL001 (ISEND, NCAP7, NFILE, NMAX,
     +                         C, RK, W,
     +                         FNAME, TITLE,
     +                         YES)
      ENDIF
      IF (OUTPUT(2)) THEN
C
C Option to do calculations
C
         YES = .FALSE.
         WRITE (LINE,500)
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                YES)
         IF (YES) CALL SPL003 (NGRAF, NCAP7, NOUT,
     +                         C, RK, XGRAF, YGRAF)
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Advanced users may wish to save the best-fit spline knots'
     +/'and coefficients in a file. Such knot/coefficients files'
     +/'can be used subsequently by program SPLINE as follows.'
     +/
     +/'Display the spline over a selected range'
     +/'Estimate the area over a selected range'
     +/'Display the first 3 derivatives over a selected range'
     +/'Estimate minimum and maximum slope over a range'
     +/'Calculate first 3 derivatives at chosen x-values'
     +/'Estimate arc length and total |curvature|'
     +/'Calibrate (predict x given y)'
     +/
     +/'Your next choice remains for all of this run.')
  200 FORMAT ('Do you want this option (usually no) ?')
  300 FORMAT (
     + 'Advanced users may wish to use the current best-fit spline'
     +/'curve at appropriate points  during the program operation,'
     +/'e.g. for plotting derivatives, etc.'
     +/
     +/'Your next choice remains for all of this run.')
  400 FORMAT ('Write current best-fit spline to a file')
  500 FORMAT ('Calculate using current best-fit spline')
       END
C
C
