
c
c
      subroutine splfit (iwrk, method, ncap7, nfit, ngraf, nout, npts,
     +                   nreps, nrmax,
     +                   c, cc, h, res, rk, s, sreps, w, x, xreps, y,
     +                   yhat, yreps,
     +                   weight,
     +                   newnc7)
c
c action: fit splines
c author: w.g.bardsley, university of manchester, u.k., 22/09/2005
c         22/11/2007 revised for version 6
c         02/11/2012 temporarily reduced options in call to g10acf$ until I restore them
c         26/02/2022 added e_numbers and e_formats, etc.
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: method, nfit, ngraf, 
     +                                       nout, npts, nreps, nrmax
      integer,             intent (inout) :: iwrk(nrmax), ncap7
      double precision,    intent (in)    :: s(nrmax), sreps(nrmax), 
     +                                       x(nrmax), xreps(nrmax),
     +                                       y(nrmax), yreps(nrmax) 
      double precision,    intent (inout) :: c(nrmax), cc(nrmax,3),
     +                                       h(nrmax), res(nrmax),
     +                                       rk(nrmax), 
     +                                       w(9*nrmax + 14),
     +                                       yhat(nrmax)
      character (len = 1), intent (in)    :: weight
      logical,             intent (inout) :: newnc7
c
c locals
c
      integer    i, ifail, j, k, l, maxcal, nbar, ng1, ng2, ng3, nplot,
     +           ntemp, numdec, numopt
      integer    l1, l2, l3, l4, m1, m2, m3, m4, n1, n2, n3, n4
      parameter (l1 = 0, l2 = 1, l3 = 0, l4 = 0, m1 = 5, m2 = 0,
     +           m3 = 1, m4 = 0)
      integer    isend, itype, ncols, npar
      parameter (isend = 2, itype = 1, ncols = 1, npar = 4)
      integer    numsta, numtxt
      integer    numbld(30)
      double precision crit, delta, fp, rss, sf, ss, tol, u, xtemp,
     +                 x4(2), ytemp, y4(2)
      double precision xmax, xmin
      double precision df, rho, temp
      double precision zero, one, two, fmin
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00,
     +           fmin = 1.0d-08)
      character  line*100, text(30)*100
      character  mode*1, ptitle*50, xtitle*20, ytitle*20
      character (len = 60) reason
      character (len = 40) increase
      character (len = 13) d13(5), showlj, showrj
      character (len = 12) i12(2), form12, word12
      parameter (increase = 'Knots must be in increasing order')
      character  blank*1
      parameter (blank = ' ')
      logical    e_numbers, e_formats
      logical    again, repeet
      logical    file1, file2, graph, tshow1, tshow2
      logical    axes, gsave
      parameter (axes = .true., gsave = .true.)
      logical    curve, fixcol, fixrow, label, order, weights
      parameter (curve = .false., fixcol = .true., fixrow = .true.,
     +           label = .true., order = .true., weights = .false.)
      external   putfat, lstbox, putifa, getjm1, putadv, gks004, showlj, 
     +           form12, getdge, gksr01, revpro, spltrn, table1, editor,
     +           showrj, e_formats
      external   e02baf$, e02bbf$, e02bef$, g10abf$, g10acf$
      intrinsic  dble, max
      save       df, rho, sf
      data       df, rho, sf / one, one, one /
      data       numbld / 30*0 /
c
c check
c
      newnc7 = .false.
      if (method.lt.1 .or. method.gt.4) then
         write (line,100)
         call putfat (line)
         return
      endif
      if (nreps.lt.4) then
         write (line,200)
         call putfat (line)
         return
      endif
c
c initialise
c
      e_numbers = e_formats()
      xmax = x(npts)
      xmin = x(1)
      again = .true.
c
c start of outer loop
c ===================
c
      do while (again)
c
c Part 1: fitting------------------------------------------
c
      if (method.eq.1) then
c
c method = 1: fit using e02baf
c ===========
c
         
         write (text,300)
         numopt = 5
         numsta = 8
         numtxt = numsta + numopt - 1
         numdec = numopt
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.eq.1) then
c
c existing knots
c           
            if (ncap7.lt.8 .or. ncap7.gt.nreps + 4) then
               if (ncap7.lt.8) then
                  write (reason,'(a,i4,a)') 
     +'NCAP7 =', ncap7, ' < 8'
               else 
                  write (reason,'(a,i4,a,i4)')
     +'NCAP7 =',ncap7,' > NREPS + 4 =', nreps + 4  
               endif 
               write (line,400) reason
               call putfat (line)
               return
            endif
            ss = rk(ncap7)
            if (rk(1).lt.xmin  .or. rk(1).gt.xmin .or.
     +          ss.lt.xmax .or. ss.gt.xmax) then
                if (rk(1).lt.xmin) then
                  write (reason,'(a,1p,e12.4,a,e12.4)')
     +'First knot =', rk(1), ', First x =', xmin  
                else 
                    write (reason,'(a,1p,e12.4,a,e12.4)')
     +'Last knot =', ss, ', Last x =', xmax 
                endif                          
                write (line,400) reason
                call putfat (line)
                return
            endif
         elseif (numdec.eq.2) then
c
c knots at equal intervals
c
            if (nreps.gt.4) then         
               i = 0
               j = max(nreps - 4,0)
               write (line,500)
               ntemp = min(nreps/3,j)
               if (ntemp.lt.i) ntemp = i
               call getjm1 (i, ntemp, j,
     +                      line)
            else
               ntemp = 0
            endif   
            nbar = ntemp + 1
            delta = (xmax - xmin)/dble(nbar)
            ncap7 = nbar + 7
            do i = 1, ncap7
               if (i.le.4) then
                  rk(i) = xmin
               elseif (i.ge.ncap7 - 3) then
                  rk(i) = xmax
               else
                  rk(i) = rk(i - 1) + delta
               endif
            enddo
         elseif (numdec.eq.3) then
c
c knots at equal data spacings
c         
            if (nreps.gt.4) then
               i = 0
               j = max(nreps - 4,0)
               write (line,500)
               ntemp = min(nreps/3,j)
               if (ntemp.lt.i) ntemp = i
               call getjm1 (i, ntemp, j,
     +                     line)
            else
               ntemp = 0
            endif   
            nbar = ntemp + 1
            ncap7 = nbar + 7
            l = 0
            do i = 1, ncap7
               if (i.le.4) then
                  rk(i) = xmin
               elseif (i.ge.ncap7 - 3) then
                  rk(i) = xmax
               else
                  l = l + 1
                  j = nint(dble(l*nreps - l)/dble(ntemp + 1))  
                  if (j.lt.1) j = 1
                  if (j.ge.nreps - 1) j = nreps - 1 
                  k = j + 1
                  rk(i) = (xreps(j) + xreps(k))/two
               endif
            enddo   
         elseif (numdec.eq.4) then
c
c First knots at equal data spacings then edited
c         
            if (nreps.gt.4) then
               i = 0
               j = max(nreps - 4,0)
               write (line,500)
               ntemp = min(nreps/3,j)
               if (ntemp.lt.i) ntemp = i
               call getjm1 (i, ntemp, j,
     +                     line)
            else
               ntemp = 0
            endif   
            nbar = ntemp + 1
            ncap7 = nbar + 7
            l = 0
            do i = 1, ncap7
               if (i.le.4) then
                  rk(i) = xmin
               elseif (i.ge.ncap7 - 3) then
                  rk(i) = xmax
               else
                  l = l + 1
                  j = nint(dble(l*nreps - l)/dble(ntemp + 1))  
                  if (j.lt.1) j = 1
                  if (j.ge.nreps - 1) j = nreps - 1 
                  k = j + 1
                  rk(i) = (xreps(j) + xreps(k))/two
               endif
            enddo            
            if (ntemp.gt.0) then
               do i = 1, ntemp
                  w(i) = rk(i + 4)
               enddo
               call editor (isend, itype, ncols, ntemp, ntemp,
     +                      w,
     +                      increase,
     +                      curve, fixcol, fixrow, label, order,
     +                      weights) 
               if (w(1).le.xmin .or. w(ntemp).ge.xmax) then
                  call putfat ('Must have X_min < Knots < X_max')
               else
                  do i = 2, ntemp
                     if (w(i).lt.w(i - 1)) then
                        call putfat (increase)
                        return
                     endif
                  enddo      
                  do i = 1, ntemp
                     rk(i + 4) = w(i)
                  enddo
               endif                      
            endif  
         else
            return
         endif
         ifail = 1
         call e02baf$(npts, ncap7, x, y, sreps, rk, h, w, c, ss, ifail)
         if (ifail.eq.0) then
            newnc7 = .true.
            i12(1) = form12(npts)
            i12(2) = form12(ncap7 - 8) 
            if (e_numbers) then
               write (line,600) trim(i12(1)), ' data points, and ',
     +                     trim(i12(2)), ' fixed knots, SSQ =', ss
            else
                d13(1) = showlj(ss)
                write (line,650) trim(i12(1)), ' data points, and ',
     +                     trim(i12(2)), ' fixed knots, SSQ =',d13(1)   
            endif  
            write (nout,'(a)') blank
            write (nout,'(a)') line
            call putadv (line)
         else
            newnc7 = .false.
            call putifa (ifail, nout, 'E02BAF/SPLFIT')
            ncap7 = 0
            return
         endif
      elseif (method.eq.2) then
c
c method = 2: fit using e02bef$
c ===========
c
         if (e_numbers) then
            write (line,700) dble(nreps)
         else
            temp = dble(nreps)
            d13(1) = showlj(temp)
            write (line,750) d13(1) 
         endif  
         call getdge (sf, zero,
     +                line)
         if (sf.le.fmin) sf = fmin 
         i = nreps + 4
         j = 2*nrmax
         ifail = 1
         call e02bef$('C', nfit, xreps, yreps, sreps, sf, i, ncap7, rk,
     +                c, fp, w, j, iwrk, ifail)
         if (ifail.eq.0) then
            newnc7 = .true.
            i12(1) = form12(nfit)
            i12(2) = form12(ncap7 - 8)
            if (e_numbers) then
               write (line,600) trim(i12(1)), 
     +                          ' distinct data points, and ',
     +                          trim(i12(2)),
     +                         ' automatic knots, WSSQ =', fp
            else
               d13(1) = showlj(fp)
               write (line,650) trim(i12(1)), 
     +                          ' distinct data points, and ',
     +                          trim(i12(2)),
     +                         ' automatic knots, WSSQ =', d13(1)  
            endif  
            write (nout,'(a)') blank
            write (nout,'(a)') line
            call putadv (line)
         else
            newnc7 = .false.
            call putifa (ifail, nout, 'E02BEF/SPLFIT')
            ncap7 = 0
            return
         endif
      elseif (method.eq.3) then 
c
c method = 3: fit using g10abf 
c ===========
c
         write (line,800)
         call getdge (rho, zero,
     +                line)
         mode = 'F'
         ifail = 1
         call g10abf$(mode, weight, nreps, xreps, yreps, sreps, rho,
     +                yhat, cc, nrmax, rss, df, res, h, w, ifail)
         call putifa (ifail, nout, 'G10ABF/SPLFIT')
         write (line,900)
      elseif (method.eq.4) then
c
c method = 4: fit using g10acf
c ===========
c      
         mode = 'G'
         u = 1.0d+04
         tol = 1.0d-03
         crit = 3.0d+00
         maxcal = 40
         ifail = 1
         call g10acf$(mode, weight, nreps, xreps, yreps, sreps, yhat,
     +                cc, nrmax, rss, df, res, h, crit, rho, u, tol,
     +                maxcal, w, ifail)
         call putifa (ifail, nout, 'G10ACF/SPLFIT')
         write (line,1000)
      endif
      if (method.eq.3 .or. method.eq.4) then  
c
c map spline from g10abc or g10acf into B-spline format
c         
         if (ifail.eq.0) then
            j = 7*nrmax - 1
            k = 8*nrmax
            do i = 1, nreps
               j = j + 1
               k = k + 1
               w(j) = yhat(i)
               w(k) = res(i)
            enddo
            call spltrn (ncap7, nout, nreps, nrmax,
     +                   c, cc, rk, xreps, yhat, w)
            if (ncap7.gt.0) then
               newnc7 = .true.
               if (method.eq.3) then
                  word12 = form12(nreps)
                  if (e_numbers) then
                     write (text,1200) line, word12, rho, df, rss
                  else
                     d13(1) = showlj(rho)
                     d13(2) = showlj(df)
                     d13(3) = showlj(rss)
                     write (text,1250) line, word12, d13(1), d13(2),
     +                                 d13(3)
                  endif  
                  write (nout,'(a)') blank
                  j = 15
                  call table1 (j, 'OPEN')
                  do i = 1, 6
                     if (i.eq.1) then
                        j = 4
                     else
                        j = 0
                     endif
                     call table1 (j, text(i))
                     write (nout,'(a)') text(i)
                  enddo
                  call table1 (j, 'CLOSE')
               endif
            else
               newnc7 = .false.
            endif
         else
            newnc7 = .false.
            return
         endif
      endif
c
c Part 2: goodness of fit-------------------------------------------
c
c Note: first of all use the current b-splines to calculate yhat(i)
c       for i = 1 to npts, s(i) will be used for residuals analysis
c
      do i = 1, npts
         ifail = 1
         call e02bbf$(ncap7, rk, c, x(i), yhat(i), ifail)
         if (ifail.ne.0) then
            call putifa (ifail, nout, 'E02BBF/SPLFIT')
            newnc7 = .false.
            ncap7 = 0
            return
         endif
      enddo
      repeet = .true.
c
c start of inner loop
c ===================
c
      numdec = 1
      do while (repeet)
         write (text,1300)
         numopt = 8
         numsta = 3
         numtxt = numsta + numopt - 1
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.eq.1) then
c
c numdec = 1: plot best fit curve where:
c ----------- w(1) to w(ngraf) are x-coordinates, and
c             w(ngraf + 1) to w(2*ngraf) are y coordinates.
c
            delta = (xmax - xmin)/(dble(ngraf - 1))
            w(1) = xmin
            do i = 2, ngraf - 1
               w(i) = w(i - 1) + delta
            enddo
            w(ngraf) = xmax
            ifail = 0
            ng1 = ngraf
            do i = 1, ngraf
               if (ifail.eq.0) then
                  ifail = 1
                  call e02bbf$(ncap7, rk, c, w(i), ss, ifail)
                  if (ifail.eq.0) then
                     w(ng1 + i) = ss
                  else
                     call putifa (ifail, nout, 'E02BBF/SPLFIT')
                     write (line,1400)
                     call putfat (line)
                     newnc7 = .false.
                     ncap7 = 0
                     return
                  endif
               endif
            enddo
            nplot = 0
            ng2 = 2*nrmax
            ng3 = 3*nrmax
            if (ifail.eq.0) then
c
c calculate knots: w(2*nrmax + 1) to w(2*nrmax + nplot) are knot positions
c                  w(3*nrmax + 1) to w(3*nrmax + nplot) are knot values
c
               do i = 1, ncap7 - 6
                  xtemp = rk(i + 3)
                  call e02bbf$(ncap7, rk, c, xtemp, ytemp, ifail)
                  if (ifail.eq.0) then
                     nplot = nplot + 1
                     w(ng2 + i) = xtemp
                     w(ng3 + i) = ytemp
                  else
                     call putifa (ifail, nout, 'E02BBF/SPLFIT')
                     newnc7 = .false.
                     ncap7 = 0
                  endif
               enddo
            endif
            if (ifail.eq.0) then
c
c plot data (circles), best fit curve (solid lines), and knots (dots)
c
                n1 = npts
                n2 = ngraf
                n3 = nplot
                n4 = 0
                ptitle = 'Data and Best Fit Curve'
                xtitle = 'X'
                ytitle = 'Y'
                ng1 = ng1 + 1
                ng2 = ng2 + 1
                ng3 = ng3 + 1
                call gks004 (l1, l2, l3, l4,
     +                       m1, m2, m3, m4,
     +                       n1, n2, n3, n4,
     +                       x,   w(1), w(ng2), x4,
     +                       y, w(ng1), w(ng3), y4,
     +                       ptitle, xtitle, ytitle,
     +                       axes, gsave)
            endif
         elseif (numdec.ge.2 .and. numdec.le.5) then
c
c numdec = 2, 3, 4, or 5: goodness of fit
c -----------------------
c
            file1 = .false.
            file2 = .false.
            graph = .false.
            tshow1 = .false.
            tshow2 = .true.
            if (numdec.eq.3) then
               file2 = .true.
            elseif (numdec.eq.4) then
               graph = .true.
               tshow1 = .true.
            elseif (numdec.eq.5) then
               file1 = .true.
               file2 = .true.
               graph = .true.
               tshow1 = .true.
            endif
            call gksr01 (nout, npar, npts,
     +                   res, s, yhat, w, x, y,
     +                   file1, file2, graph, tshow1, tshow2)
            if (method.eq.3) then
               if (numdec.eq.4 .or. numdec.eq.5) then
                  j = 15
                  call table1 (j,'OPEN')
                  j = 4
                  write (line,1500)
                  call table1 (j, line)
                  if (numdec.eq.5) then
                     write (nout,'(a)') blank
                     write (nout,'(a)') line
                  endif
                  j = 0
                  k = 7*nrmax - 1
                  l = 8*nrmax
                  do i = 1, nreps
                     k = k + 1
                     l = l + 1
                     if (e_numbers) then
                        write (line,1600) i, xreps(i), yreps(i), w(k),
     +                                    w(l), h(i)
                     else
                        d13(1) = showrj(xreps(i))
                        d13(2) = showrj(yreps(i))
                        d13(3) = showrj(w(k))
                        d13(4) = showrj(w(l))
                        d13(5) = showrj(h(i))
                        write (line,1650) i, d13(1), d13(2), d13(3),
     +                                    d13(4), d13(5)
                     endif  
                     call table1 (j,line)
                     if (numdec.eq.5) write (nout,'(a)') line
                  enddo
                  call table1 (j, 'CLOSE')
               endif
            endif
         elseif (numdec.eq.6) then
c
c numdec = 6: re-fit
c -----------
c 
            if (method.eq.4) then
               again = .false.
            else   
               again = .true.
            endif   
            repeet = .false.
         elseif (numdec.eq.7) then
c
c numdec = 7: results
c -----------
c
            call revpro (nout)
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ----------------
c
            again = .false.
            repeet = .false.
         endif
      enddo
c
c end of inner loop
c =================
c
      enddo
c
c end of outer loop
c =================
c
  100 format ('METHOD out of range in call to SPLFIT')
  200 format ('Insufficient data ... must have no. distinct points > 3')
  300 format (
     + 'Fixing knot positions interactively'
     +/
     +/'Ideally knots should be used sparingly to prevent'
     +/'overfit, and should be placed closer together near'
     +/'features like turning points or asymptotes, by'
     +/'editing interactively.'   
     +/
     +/'Fit: knots used from the current set'
     +/'Fit: knots equally spaced along x-axis'
     +/'Fit: knots equally spaced between data'
     +/'Fit: knots set by editing interactively'
     +/'Quit ... Exit knot position settings')
  400 format ('Knots/data inconsistent: ',a)
  500 format ('Number of interior knots required')
  600 format ('From fit with ',a,a,a,a,1p,e13.5)
  650 format ('From fit with ',a,a,a,a,1x,a)
  700 format ('Scaling factor F >= 0 ... If s(i) = std.dev.y(i) try F ='
     +,1p,e13.5)
  750 format ('Scaling factor F >= 0 ... If s(i) = std.dev.y(i) try F ='
     +,1x,a)   
  800 format ('Value of rho required')
  900 format ('Rho input interactively ')
 1000 format ('Rho by generalised cross validation')
 1200 format (
     + 'Method used for spline fitting:'
     +/a
     +/'Number of distinct data points =',1x,a
     +/' rho =',1p,e13.5
     +/' DOF =',   e13.5
     +/'WSSQ =',   e13.5)
 1250 format (
     + 'Method used for spline fitting:'
     +/a
     +/'Number of distinct data points =',1x,a
     +/' rho =',1x,a
     +/' DOF =',1x,a
     +/'WSSQ =',1x,a)    
 1300 format (
     + 'Analysing the best-fit spline curve'
     +/
     +/'Plot the best-fit curve'
     +/'Analysis: short'
     +/'Analysis: short (add to results file)'
     +/'Analysis: full'
     +/'Analysis: full (add to results file)'
     +/'Re-fit'
     +/'Results'
     +/'Quit ... Exit analysis of spline fit')
 1400 format ('Cannot calculate best fit curve')
 1500 format (
     +'Number       X-value        Y-mean         Y-fit      Residual',
     +'      Leverage')
 1600 format (i6,1p,5(1x,e13.5))
 1650 format (i6,5(1x,a))
      end
c
c
