c
c
      subroutine splplt (ncap7, n,
     +                   c, dlambda, x)   
c
c action: plot a spline and first three derivatives
c author: w.g.bardsley, university of manchester, u.k. 22/04/2020
c
c ncap7 = number of interior knots + 7 
c      c = coefficients for the B splines  
c      n = dimension of array containing the data range x_min to x_max to be plotted (minumum 2)
c      x = array containing the x(i) data points to be used to calculate x_min and x_max        
c
c arguments
c        
      integer,          intent (in) :: ncap7, n
      double precision, intent (in) :: c(ncap7), dlambda(ncap7), x(n)   
c
c locals
c      
      integer    i, ifail, k, left, numdec, numopt, numtxt
      parameter (left = 1, numopt = 6, numtxt = 23)
      integer    numbld(numtxt)
      integer    npts 
      parameter (npts = 200)
      double precision s(4)
      double precision delta, xmax, xmin 
      double precision x1(npts), xtemp
      double precision y1(npts), y2(npts), y3(npts), y4(npts)
      character (len = 100) text(numtxt), line
      character (len = 80 ) opts(numopt), ptitle
      character (len = 12 ) form12, word12
      logical  repeet
      external e02bcf$, gks001, listbx, putadv, patch2, form12
      intrinsic len_trim, max, min
      data      numbld / numtxt*0 / 
c
c check
c      
      if (ncap7.lt.8) then
         call putadv ('NCAP7 < 1 in call to SPLPLT') 
         return
      endif 
      if (n.lt.2) then
         call putadv ('N < 2 in call to SPLPLT')
         return
      endif     
c
c calculate xmax, xmin, and x1
c     
      xmin = 1.0d+300
      xmax = - xmin
      do i = 1, n
         if (x(i).lt.xmin) xmin = x(i)
         if (x(i).gt.xmax) xmax = x(i)
      enddo   
      if (n.eq.2) then
         xmin = min(x(1), x(2))
         xmax = max(x(1), x(2))
      else         
         x1(1) = xmin
         x1(npts) = xmax
         delta = (xmax - xmin)/dble(npts - 1)
         do i = 2, npts - 1
            x1(i) = x1(i - 1) + delta
         enddo
      endif
c
c calculate spline and derivatives
c
      do i = 1, npts 
         ifail = 1
         xtemp = x1(i)
         call e02bcf$ (ncap7, dlambda, c, xtemp, left, s, ifail)
         if (ifail.ne.0) then
            write (line,'(a,i6)') 'From e02bcf$ ifail =', ifail
            call putadv (line)
         endif   
         y1(i) = s(1)
         y2(i) = s(2)
         y3(i) = s(3)
         y4(i) = s(4)      
      enddo   
c
c proceed to plotting
c     
      k = ncap7 - 8
      word12 = form12 (k)
      i = len_trim(word12)
      write (opts,100) 
      write (ptitle,200) word12(1:i)
      write (text,300)
      numbld(1) = 1
      numbld(12) = 1
      numdec = numopt - 1 
      repeet = .true.
      do while (repeet)
         call listbx (numdec, numopt,
     +                opts)         
         if (numdec.eq.1) then
            call gks001 (1, 0, npts,  
     +                   x1, y1,
     +                   ptitle, 'x', 'y')
         elseif (numdec.eq.2) then
            call gks001 (1, 0, npts,  
     +                   x1, y2,
     +                  'First Derivative (Approximate)', 'x', 'y')
         elseif (numdec.eq.3) then
            call gks001 (1, 0, npts,  
     +                   x1, y3,
     +                  'Second Derivative (Very Aproximate)', 'x', 'y')
         elseif (numdec.eq.4) then
            call gks001 (1, 0, npts,  
     +                   x1, y4,
     +                  'Third Derivative (Discontinuous)', 'x', 'y')
         elseif (numdec.eq.5) then
            call patch2 (numbld, numtxt,
     +                   text)  
         else
            repeet = .false. 
         endif
         numdec = numopt
      enddo
c
c format statement
c      
  100 format (
     + 'Plot the spline'
     +/'Plot the first derivative (Approximate)'
     +/'Plot the second derivative (Very Approximate)'
     +/'Plot the third derivative (Discontinuous)'
     +/'Help'
     +/'Quit ... Exit these plotting options')
  200 format ('Spline with ',a, ' Interior Knots') 
  300 format (
     + 'Effect of knot spacing, density, and tension on plot shape.'
     +/
     +/'The spline is represented internally as the sum of weighted'
     +/'B-splines, and this representation will be very dependent on'
     +/'the number of interior knots, their spacing, and method used'
     +/'to apply tension, if any. There is no objective ideal or'
     +/'optimum  number and spacing of knots for any given problem'
     +/'as this will have to be decided subjectively. This is all' 
     +/'explained in the Simfit reference manual. Some things'  
     +/'however about derivatives must be considered.'
     +/
     +/'Special restrictions concerning calculated spline derivatives'
     +/  
     +/'If the data are dense and fairly accurate then the best fit'
     +/'spline curve will usually be representative of the underlying'
     +/'model. Even then the first derivative should not be taken too'
     +/'seriously, as the spline equation is different between each'
     +/'interior knot and this can cause undulating first derivatives.'
     +/'Things are worse for second derivatives which can have linear'
     +/'sections, and the third derivative is usually a discontinuous'
     +/'succession of steps. Splines have continuous first and second'
     +/'derivatives at knots but are defined piecewise between knots.'
     +/'Note: Left-handed derivatives are calculated by this progam.')
      end  
c
c                