c
c
      subroutine spltrn (ncap7, nout, nreps, nrmax,
     +                   c, cc, rk, xreps, yhat, w)
c
c action: transform cc from g10abf and g10acf into ncap7, rk and c for e02 routines
c author: w.g.bardsley, university of manchester, u.k, 17/10/2005
c         30/03/2015 introduced INTENTS   
c
c NOTE: This is only a stop gap routine. I must rewrite it to calculate the
c ***** c array directly from the cc array instead of by simple least squares
c       fitting to temporary data using e02baf.
c
c ncap7: (output)
c  nout: (input/unchanged) preconnected unit for results
c nreps: (input/unchanged) number of distinct x-values supplied to g10abf/g10acf
c nrmax: (input/unchanged) dimension
c     c: (output) spline coefficients for e02 routines
c    cc: (input/unchanged) spline coefficients from g10abf/g10acf
c    rk: (output) knots for e02 routines
c xreps: (input/unchanged) the distinct x-values supplied to g10abf/g10acf
c  yhat: (input/unchanged) the best fit values from g10abf/g10acf
c     w: workspace
c
      implicit   none
c
c arguments
c
      integer,          intent (in)    :: nout, nreps, nrmax
      integer,          intent (out)   :: ncap7 
      double precision, intent (in)    :: cc(nrmax,3), xreps(nreps),
     +                                    yhat(nreps)
      double precision, intent (inout) :: c(nrmax), rk(nrmax), 
     +                                    w(9*nrmax + 14)
c
c locals
c
      integer    i, icount, ifail, jcount, n
      integer    nmin
      parameter (nmin = 1000)
      double precision d, delta, ss, t
      double precision one, two
      parameter (one = 1.0d+00, two = 2.0d+00)
      external   putifa
      external   e02baf$
      intrinsic  max, dble
c
c work out ncap7 and rk
c
      ncap7 = 0
c
c create four starting knots = x_min i.e. smallest data value
c
      do i = 1, 4
         ncap7 = ncap7 + 1
         rk(ncap7) = xreps(1)
      enddo
c
c create (nreps - 1) knots = sequential interior x_values
c
      do i = 2, nreps 
         ncap7 = ncap7 + 1
         rk(ncap7) = (xreps(i) + xreps(i - 1))/two
      enddo
c
c create four final knots = x_max i.e. largest data value
c
      do i = 1, 4
         ncap7 = ncap7 + 1
         rk(ncap7) = xreps(nreps)
      enddo
c
c now define n and calculate n temporary x-values for fitting
c
      n = max(nreps, nmin)
      delta = (xreps(nreps) - xreps(1))/(dble(n) - one)
      w(1) = xreps(1)
      do i = 2, n - 1
         w(i) = w(i - 1) + delta
      enddo
      w(n) = xreps(nreps)
c
c then calculate n temporary y-values (using Horners method) for fitting
c
      icount = 1
      jcount = n + 1
      w(jcount) = yhat(1)
      do i = 2, n - 1
         t = w(i)
         if (t.ge.xreps(icount + 1)) icount = icount + 1
         d = t - xreps(icount)
         jcount = jcount + 1
         w(jcount) = yhat(icount) + d*(cc(icount,1) +
     +                              d*(cc(icount,2) +
     +                              d*cc(icount,3)))
      enddo
      jcount = jcount + 1
      w(jcount) = yhat(nreps)
c
c and calculate n temporary weights for fitting
c
      do i = 1, n
         jcount = jcount + 1
         w(jcount) = one
      enddo
c
c finally find the least squares fit to the temporary data
c
      ifail = 1
      call e02baf$(n, ncap7, w(1), w(n + 1), w(2*n + 1), rk,
     +             w(3*n + 1), w(4*n + 1), c, ss, ifail)
c
c final check in case fitting has failed
c
      if (ifail.ne.0) then
         call putifa (ifail, nout, 'E02BAF/SPLTRN')
         ncap7 = 0
      endif
      end
c
c
