C
C
      SUBROUTINE SPOWB1 (NOUT, NPAR, PAR)
C
C ACTION: 1 sample binomial power
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 16/12/99
C
C         NOTE: P0 and P1 in this code are PAR(3) and PAR(11) in SPOWPR
C
C         01/01/2003 revised to use SPOWPR
C         03/02/2003 interchanged P0 and P1 to agree with Zar where
C                    p0 = sample and p = true and to agree with manual
C
C
      IMPLICIT   NONE
      INTEGER    NOUT, NPAR
      INTEGER    I, IADD, ICOUNT, IFAIL, ISEND, MAXN, N
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 0, NUMOPT = 10,
     +           NSTART = 8, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N11
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N11 = 11)
      INTEGER    NMAX
      PARAMETER (NMAX = 2000)
      DOUBLE PRECISION PAR(NPAR)
      DOUBLE PRECISION EPSI, FMIN
      PARAMETER (EPSI = 1.0D-06, FMIN = 0.0D+00)
      DOUBLE PRECISION ALPHA, BETA, P0, P1
      DOUBLE PRECISION ARG1, ARG2, BETA1, BETA2, BINOMP, BOT, DELTA,
     +                 DELTA1, DELTA2, P, POWER, RATIO, TOP, Z, ZA
      DOUBLE PRECISION X1(NMAX), X2(N2), X3(N1), X4(N1)
      DOUBLE PRECISION Y1(NMAX), Y2(N2), Y3(N1), Y4(N1)
      DOUBLE PRECISION G01EAF$, G01FAF$
      DOUBLE PRECISION ZERO, ONE, TWO, F100
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           F100 = 100.0D+00)
      CHARACTER  LINE*100, TAIL*1, TEXT(NTEXT)*100, WORD12*12
      CHARACTER  PTITLE*40, XTITLE*20, YTITLE*10
      LOGICAL    AGAIN, NOTYET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    LOGIC1, LOGIC2
      PARAMETER (LOGIC1 = .TRUE., LOGIC2 = .TRUE.)
      EXTERNAL   TRIML1, GETJGE, PUTIFA, LBOX01, PUTTXT, GKS004,
     +           SPOWPR, REVPRO
      EXTERNAL   G01EAF$, G01FAF$
      INTRINSIC  NINT, DBLE, SQRT, ABS
      SAVE       MAXN
      DATA       MAXN / 100 /
      DATA       NUMBLD / NTEXT*N0 /
      DATA       NUMPOS / NUMOPT*N1 /
C
C Initialise
C
      ALPHA = PAR(1)
      BETA = PAR(2)
      P0 = PAR(3)
      P1 = PAR(11)
      N = N2
      NUMBLD(N1) = N1
      NUMDEC = N1
      AGAIN = .TRUE.
C
C Main loop
C
      DO WHILE (AGAIN)
         POWER = F100*(ONE - BETA)
         WRITE (TEXT,100) ALPHA, F100*ALPHA, BETA,
     +                    POWER, P0, P1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.N1) THEN
C
C Get delta then n (Zar 23.35)
C
            ISEND = 10
            CALL SPOWPR (ISEND, NPAR, PAR)
            DELTA = PAR(10)
            IF (DELTA.LE.EPSI) THEN
C
C Error
C
               ISEND = 0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               BINOMP = P0
               TAIL = 'S'
               IFAIL = 1
               Z = G01FAF$(TAIL, ALPHA, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01FAF/SPOWB1')
               IF (IFAIL.EQ.0) THEN
                  TOP = Z*Z*BINOMP*(ONE - BINOMP)
                  BOT = DELTA*DELTA
                  N = NINT(TOP/BOT)
                  WRITE (WORD12,'(I12)') N
                  CALL TRIML1 (WORD12)
                  WRITE (NOUT,200) ALPHA, BINOMP, DELTA, WORD12
                  WRITE (LINE,200) ALPHA, BINOMP, DELTA, WORD12
                  CALL PUTTXT (LINE)
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Use ALPHA, BETA, P0, P1 to calculate N (zar 23.43)
C
            DELTA = P1 - P0
            TAIL ='L'
            IFAIL = 1
            P = ONE - ALPHA/TWO
            ZA = G01FAF$(TAIL, P, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FAF/SPOWB1')
            IF (IFAIL.EQ.0) THEN
               TOP = P1*(ONE - P1)
               BOT = P0*(ONE - P0)
               ZA = ZA*SQRT(TOP/BOT)
               TOP = BOT
            ENDIF
            IF (IFAIL.EQ.0) THEN
               NOTYET = .TRUE.
               I = 1
               ICOUNT = 0
            ELSE
               NOTYET = .FALSE.
            ENDIF
            DO WHILE (NOTYET .AND. ICOUNT.LT.NMAX)
               ICOUNT = ICOUNT + 1
               IF (I.LT.100) THEN
                  I = I + 1
               ELSEIF (I.LT.200) THEN
                  I = I + 2
               ELSEIF (I.LT.400) THEN
                  I = I + 4
               ELSEIF (I.LT.800) THEN
                  I = I + 8
               ELSEIF (I.LT.1600) THEN
                  I = I + 16
               ELSEIF (I.LT.3200) THEN
                  I = I + 32
               ELSE
                  I = I + 64
               ENDIF
               IF (IFAIL.EQ.0) THEN
                  BOT = DBLE(I)
                  RATIO = DELTA/SQRT(TOP/BOT)
                  ARG1 = RATIO - ZA
                  ARG2 = RATIO + ZA
                  TAIL = 'L'
                  BETA1 = G01EAF$(TAIL, ARG1, IFAIL)
                  IF (IFAIL.EQ.0) THEN
                     TAIL = 'U'
                     BETA2 = G01EAF$(TAIL, ARG2, IFAIL)
                  ENDIF
               ENDIF
               IF (IFAIL.EQ.0) THEN
                  P = BETA1 + BETA2
                  DELTA2 = POWER - F100*(BETA1 + BETA2)
                  IF (I.EQ.2) DELTA1 = DELTA2
                  IF (ABS(DELTA2).LT.FMIN .OR.
     +                DELTA1*DELTA2.LT.ZERO) THEN
                     NOTYET = .FALSE.
                     N = I
                  ENDIF
                  DELTA1 = DELTA2
               ELSE
                  NOTYET = .FALSE.
               ENDIF
            ENDDO
            IF (NOTYET) THEN
C
C Sample size calculation failed
C
               ISEND = -1
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               WRITE (WORD12,'(I12)') N
               CALL TRIML1 (WORD12)
               WRITE (LINE,300) ALPHA, BETA, P0, P1, WORD12
               CALL PUTTXT (LINE)
               WRITE (NOUT,'(A)') LINE
            ENDIF
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Use ALPHA, P0, P1, N to calculate BETA
C
            DELTA = P1 - P0
            CALL GETJGE (N, N2,
     +                  'sample size n (same in both groups)')
            TAIL ='L'
            IFAIL = N0
            P = ONE - ALPHA/TWO
            ZA = G01FAF$(TAIL, P, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FAF/SPOWB1')
            IF (IFAIL.EQ.N0) THEN
               TOP = P1*(ONE - P1)
               BOT = P0*(ONE - P0)
               ZA = ZA*SQRT(TOP/BOT)
               TOP = BOT
               BOT = DBLE(N)
               RATIO = DELTA/SQRT(TOP/BOT)
               ARG1 = RATIO - ZA
               ARG2 = RATIO + ZA
               TAIL = 'L'
               IFAIL = N0
               BETA1 = G01EAF$(TAIL, ARG1, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01EAF/SPOWB1')
               IF (IFAIL.EQ.N0) THEN
                  TAIL = 'U'
                  BETA2 = G01EAF$(TAIL, ARG2, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G01EAF/SPOWB1')
               ENDIF
               IF (IFAIL.EQ.N0) THEN
                  P = BETA1 + BETA2
                  WRITE (WORD12,'(I12)') N
                  CALL TRIML1 (WORD12)
                  WRITE (NOUT,400) ALPHA, P0, P1, F100*P, WORD12
                  WRITE (LINE,400) ALPHA, P0, P1, F100*P, WORD12
                  CALL PUTTXT (LINE)
               ENDIF
            ENDIF
            IF (IFAIL.NE.N0) THEN
               ISEND = N0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ENDIF
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C Plot Power = f(n)
C
            DELTA = P1 - P0
            TAIL ='L'
            IFAIL = N0
            P = ONE - ALPHA/TWO
            ZA = G01FAF$(TAIL, P, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FAF/SPOWB1')
            IF (IFAIL.EQ.N0) THEN
               TOP = P1*(ONE - P1)
               BOT = P0*(ONE - P0)
               ZA = ZA*SQRT(TOP/BOT)
               TOP = BOT
            ENDIF
            I = N2
            CALL GETJGE (MAXN, I, 'Maximum sample size of interest')
            ICOUNT = N0
            I = N1
            DO WHILE (I.LT.MAXN .AND. ICOUNT.LT.NMAX)
               IF (N.LE.100 .OR. I.LE.50) THEN
                  IADD = 1
               ELSEIF (I.LE.100) THEN
                  IADD = 2
               ELSEIF (I.LE.200) THEN
                  IADD = 4
               ELSEIF (I.LE.400) THEN
                  IADD = 8
               ELSEIF (I.LE.800) THEN
                  IADD = 16
               ELSE
                  IADD = 32
               ENDIF
               I = I + IADD
               IF (IFAIL.EQ.N0) THEN
                  BOT = DBLE(I)
                  RATIO = DELTA/SQRT(TOP/BOT)
                  ARG1 = RATIO - ZA
                  ARG2 = RATIO + ZA
                  TAIL = 'L'
                  IFAIL = N0
                  BETA1 = G01EAF$(TAIL, ARG1, IFAIL)
                  IF (IFAIL.EQ.N0) THEN
                     TAIL = 'U'
                     BETA2 = G01EAF$(TAIL, ARG2, IFAIL)
                  ENDIF
                  IF (IFAIL.EQ.N0) THEN
                     ICOUNT = ICOUNT + N1
                     P = BETA1 + BETA2
                     X1(ICOUNT) = DBLE(I)
                     Y1(ICOUNT) = F100*P
                  ENDIF
               ENDIF
            ENDDO
            IF (ICOUNT.GT.N1) THEN
               X2(1) = X1(1)
               X2(2) = X1(ICOUNT)
               Y2(1) = POWER
               Y2(2) = POWER
               WRITE (PTITLE,500) P0, P1, ALPHA
               XTITLE = '1-sample test size'
               YTITLE = '%Power'
               CALL GKS004 (N1, N2, N0, N0, N0, N0, N0, N0,
     +                      ICOUNT, N2, N1, N1,
     +                      X1, X2, X3, X4, Y1, Y2, Y3, Y4,
     +                      PTITLE, XTITLE, YTITLE, LOGIC1, LOGIC2)

            ELSE
               ISEND = N0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ENDIF
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C New p0
C
            ISEND = N3
            CALL SPOWPR (ISEND, NPAR, PAR)
            P0 = PAR(N3)
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N6) THEN
C
C New p1
C
            ISEND = N11
            CALL SPOWPR (ISEND, NPAR, PAR)
            P1 = PAR(N11)
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.NUMOPT - N3) THEN
C
C New alpha
C
            ISEND = N1
            CALL SPOWPR (ISEND, NPAR, PAR)
            ALPHA = PAR(N1)
         ELSEIF (NUMDEC.EQ.NUMOPT - N2) THEN
C
C New beta
C
            ISEND = N2
            CALL SPOWPR (ISEND, NPAR, PAR)
            BETA = PAR(N2)
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            AGAIN = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Calculations for 1 binomial distribution'
     +/
     +/'alpha =',F7.4,' (',F7.3,'% significance level)'
     +/'beta =',F7.4,' (',F7.3,'% power)'
     +/'p0 =',F7.4,' [theoretical]'
     +/'p1 =',F7.4,' [estimate]'
     +/
     +/'Calculate n = n(delta)'
     +/'Calculate n = n(beta)'
     +/'Calculate power = f(n)'
     +/'Plot power = f(n)'
     +/'Change p0'
     +/'Change p1'
     +/'Change alpha'
     +/'Change beta'
     +/'Results'
     +/'Quit ... Exit binomial calculations')
  200 FORMAT ('alpha =',F7.4,', known binomial p =',F7.4,
     +', delta =',F7.4,', n = ',A)
  300 FORMAT ('alpha =',F7.4,', beta =',F7.4,
     +', p0 =',F7.4,', p1 =',F7.4,', n = ',A)
  400 FORMAT ('alpha =',F7.4,
     +', p0 =',F7.4,', p1 =',F7.4,', power =',F8.3,'%, n = ',A)
  500 FORMAT ('p0=',F5.4,', p1=',F5.4,', alpha=',F5.4)
      END
C
C
