C
C
      SUBROUTINE SPOWB2 (NOUT, NPAR, PAR)
C
C ACTION: 2 sample binomial power
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 16/12/99
C
C         NOTE: P0 and P1 in this code are PAR(11) and PAR(14) in SPOWPR
C               where they are referred to (as in the menus in this code)
C               as P1 and P2 so that P0 is reserved for the theoretical p
C
C         02/05/2000 added odds ratio and log(odds ratio)
C         01/01/2003 revised to use SPOWPR
C         03/03/2003 revised to speed up plotting
C         17/11/2021 added E_NUMBERS and E_FORMATS, etc.
C
      IMPLICIT   NONE
      INTEGER    NOUT, NPAR
      INTEGER    I, IADD, ICOUNT, IFAIL, ISEND, MAXN, N
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 0, NUMOPT = 12,
     +           NSTART = 11, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N11, N14
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N7 = 7, N8 = 8, N11 = 11, N14 = 14)
      INTEGER    NMAX
      PARAMETER (NMAX = 2000)
      DOUBLE PRECISION PAR(NPAR)
      DOUBLE PRECISION EPSI
      PARAMETER (EPSI = 1.0D-06)
      DOUBLE PRECISION ALPHA, BETA, P0, P1
      DOUBLE PRECISION BOT, DELTA, DELTA2, P, POWER, TOP, ZA, ZB
      DOUBLE PRECISION OR1, ORLN, ORLOG
      DOUBLE PRECISION X1(NMAX), X2(N2), X3(N1), X4(N1)
      DOUBLE PRECISION Y1(NMAX), Y2(N2), Y3(N1), Y4(N1)
      DOUBLE PRECISION G01EAF$, G01FAF$
      DOUBLE PRECISION ONE, TWO, TEN, F100
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00,
     +           TEN = 10.0D+00, F100 = 100.0D+00)
      DOUBLE PRECISION ORMAX, ORMIN
      PARAMETER (ORMAX = 1.0D+06, ORMIN = ONE/ORMAX)
      CHARACTER (LEN = 13) D13(3), SHOWLJ
      CHARACTER  LINE*100, TAIL*1, TEXT(NTEXT)*100, WORD12*12
      CHARACTER  PTITLE*40, XTITLE*20, YTITLE*10
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    AGAIN
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    LOGIC1, LOGIC2
      PARAMETER (LOGIC1 = .TRUE., LOGIC2 = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   TRIML1, GETJGE, PUTIFA, LBOX01, PUTTXT, GKS004,
     +           GETDM1, SPOWPR, REVPRO
      EXTERNAL   G01EAF$, G01FAF$
      INTRINSIC  NINT, DBLE, SQRT, ABS, LOG, LOG10, EXP, TRIM
      SAVE       MAXN
      DATA       MAXN / 100 /
      DATA       NUMBLD / NTEXT*N0 /
      DATA       NUMPOS / NUMOPT*N1 /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      ALPHA = PAR(1)
      BETA = PAR(2)
      P0 = PAR(11)
      P1 = PAR(14)
      N = N2
      NUMBLD(N1) = N1
      NUMDEC = N1
      AGAIN = .TRUE.
      OR1 = P1*(ONE - P0)/(P0*(ONE - P1))
      ORLN = LOG(OR1)
      ORLOG = LOG10(OR1)
      DO WHILE (AGAIN)
         POWER = F100*(ONE - BETA)
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) ALPHA, F100*ALPHA, BETA,
     +                       POWER, P0, P1, OR1, ORLN, ORLOG
         ELSE
            D13(1) = SHOWLJ(OR1)
            D13(2) = SHOWLJ(ORLN)
            D13(3) = SHOWLJ(ORLOG) 
            WRITE (TEXT,150) ALPHA, F100*ALPHA, BETA,
     +                       POWER, P0, P1, D13(1), D13(2), D13(3)
         ENDIF  
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.N1) THEN
C
C Use ALPHA, BETA, P0, P1 to calculate N
C
            DELTA = P1 - P0
            IF (ABS(DELTA).LE.EPSI) THEN
               ISEND = N0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               TAIL ='L'
               IFAIL = N1
               P = ONE - ALPHA/TWO
               ZA = G01FAF$(TAIL, P, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01FAF/SPOWB2')
               TAIL ='L'
               IFAIL = N1
               P = ONE - BETA
               ZB = G01FAF$(TAIL, P, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01FAF/SPOWB2')
               IF (IFAIL.EQ.N0) THEN
                  TOP = (P0*(ONE - P0) +
     +                   P1*(ONE - P1))*(ZA + ZB)*(ZA + ZB)
                  BOT = DELTA*DELTA
                  N = NINT(TOP/BOT)
                  WRITE (WORD12,'(I12)') N
                  CALL TRIML1 (WORD12)
                  WRITE (NOUT,200) ALPHA, BETA, P0, P1, WORD12
                  WRITE (LINE,200) ALPHA, BETA, P0, P1, WORD12
                  CALL PUTTXT (LINE) 
                  IF (E_NUMBERS) THEN
                     WRITE (NOUT,300) OR1, ORLN, ORLOG
                  ELSE
                     D13(1) = SHOWLJ(OR1)
                     D13(2) = SHOWLJ(ORLN)
                     D13(3) = SHOWLJ(ORLOG)
                     WRITE (NOUT,350) TRIM(D13(1)), TRIM(D13(2)), D13(3) 
                  ENDIF  
               ENDIF
            ENDIF
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Use ALPHA, P0, P1, N to calculate BETA
C
            DELTA = P1 - P0
            IF (ABS(DELTA).LE.EPSI) THEN
               ISEND = N0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               CALL GETJGE (N, N2,
     +                     'sample size n (same in both groups)')
               TAIL ='L'
               IFAIL = N1
               P = ONE - ALPHA/TWO
               ZA = G01FAF$(TAIL, P, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01FAF/SPOWB2')
               IF (IFAIL.EQ.N0) THEN
                  DELTA = P1 - P0
                  TOP = DBLE(N)*DELTA*DELTA
                  BOT = P0*(ONE - P0) + P1*(ONE - P1)
                  ZB = SQRT(TOP/BOT) - ZA
                  TAIL = 'L'
                  IFAIL = N1
                  P = G01EAF$(TAIL, ZB, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G01EAF/SPOWB2')
                  IF (IFAIL.EQ.N0) THEN
                     WRITE (WORD12,'(I12)') N
                     CALL TRIML1 (WORD12)
                     WRITE (NOUT,400) ALPHA, P0, P1, F100*P, WORD12
                     WRITE (LINE,400) ALPHA, P0, P1, F100*P, WORD12
                     CALL PUTTXT (LINE)
                     IF (E_NUMBERS) THEN
                        WRITE (NOUT,300) OR1, ORLN, ORLOG
                     ELSE
                         D13(1) = SHOWLJ(OR1)
                         D13(2) = SHOWLJ(ORLN)
                        D13(3) = SHOWLJ(ORLOG)
                        WRITE (NOUT,350) TRIM(D13(1)), TRIM(D13(2)),
     +                                   D13(3)  
                     ENDIF  
                  ENDIF
               ENDIF
            ENDIF
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Plot Power = f(n)
C
            DELTA = P1 - P0
            DELTA2 = DELTA*DELTA
            IF (ABS(DELTA).LE.EPSI) THEN
               ISEND = N0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               TAIL ='L'
               I = N1
               CALL GETJGE (MAXN, I, 'Maximum sample size of interest')
               ICOUNT = N0
               I = N1
               P = ONE - ALPHA/TWO
               IFAIL = N1
               ZA = G01FAF$(TAIL, P, IFAIL)
               BOT = P0*(ONE - P0) + P1*(ONE - P1)
               DO WHILE (I.LT.MAXN .AND. ICOUNT.LT.NMAX)
                  IF (N.LE.100 .OR. I.LE.50) THEN
                     IADD = 1
                  ELSEIF (I.LE.100) THEN
                     IADD = 2
                  ELSEIF (I.LE.200) THEN
                     IADD = 4
                  ELSEIF (I.LE.400) THEN
                     IADD = 8
                  ELSEIF (I.LE.800) THEN
                     IADD = 16
                  ELSE
                     IADD = 32
                  ENDIF
                  I = I + IADD
                  IF (IFAIL.EQ.N0) THEN
                     TOP = DBLE(I)*DELTA2
                     ZB = SQRT(TOP/BOT) - ZA
                     IFAIL = N1
                     P = G01EAF$(TAIL, ZB, IFAIL)
                     IF (IFAIL.EQ.N0) THEN
                        ICOUNT = ICOUNT + N1
                        X1(ICOUNT) = DBLE(I)
                        Y1(ICOUNT) = F100*P
                     ENDIF
                  ENDIF
               ENDDO
               X2(1) = X1(1)
               X2(2) = X1(ICOUNT)
               Y2(1) = POWER
               Y2(2) = POWER
               WRITE (PTITLE,500) P0, P1, ALPHA
               XTITLE = '2-sample test size'
               YTITLE = '%Power'
               CALL GKS004 (N1, N2, N0, N0, N0, N0, N0, N0,
     +                      ICOUNT, N2, N1, N1,
     +                      X1, X2, X3, X4, Y1, Y2, Y3, Y4,
     +                      PTITLE, XTITLE, YTITLE, LOGIC1, LOGIC2)

            ENDIF
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C New p0
C
            ISEND = N11
            CALL SPOWPR (ISEND, NPAR, PAR)
            P0 = PAR(N11)
            OR1 = P1*(ONE - P0)/(P0*(ONE - P1))
            ORLN = LOG(OR1)
            ORLOG = LOG10(OR1)
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C New p1
C
            ISEND = N14
            CALL SPOWPR (ISEND, NPAR, PAR)
            P1 = PAR(N14)
            OR1 = P1*(ONE - P0)/(P0*(ONE - P1))
            ORLN = LOG(OR1)
            ORLOG = LOG10(OR1)
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N6) THEN
C
C New odds ratio
C
            BOT = ORMIN
            TOP = ORMAX
            CALL GETDM1 (BOT, OR1, TOP, 'New value for Odds-Ratio')
            P1 = OR1*P0/(ONE - P0 + OR1*P0)
            PAR(N11) = P1
            ORLN = LOG(OR1)
            ORLOG = LOG10(OR1)
         ELSEIF (NUMDEC.EQ.N7) THEN
C
C New ln(odds ratio)
C
            BOT = LOG(ORMIN)
            TOP = LOG(ORMAX)
            CALL GETDM1 (BOT, ORLN, TOP, 'New value for ln(Odds-Ratio)')
            OR1 = EXP(ORLN)
            P1 = OR1*P0/(ONE - P0 + OR1*P0)
            PAR(N11) = P1
            ORLOG = LOG10(OR1)
         ELSEIF (NUMDEC.EQ.N8) THEN
C
C New log10(odds ratio)
C
            BOT = LOG10(ORMIN)
            TOP = LOG10(ORMAX)
            CALL GETDM1 (BOT, ORLOG, TOP,
     +                  'New value for log10(Odds-Ratio)')
            OR1 = TEN**(ORLOG)
            P1 = OR1*P0/(ONE - P0 + OR1*P0)
            PAR(N11) = P1
            ORLN = LOG(OR1)
         ELSEIF (NUMDEC.EQ.NUMOPT - N3) THEN
C
C New alpha
C
            ISEND = N1
            CALL SPOWPR (ISEND, NPAR, PAR)
            ALPHA = PAR(N1)
         ELSEIF (NUMDEC.EQ.NUMOPT - N2) THEN
C
C New beta
C
            ISEND = N2
            CALL SPOWPR (ISEND, NPAR, PAR)
            BETA = PAR(N2)
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Calculations for 2 binomial distributions'
     +/
     +/'alpha =',F7.4,' (',F7.3,'% significance level)'
     +/'beta =',F7.4,' (',F7.3,'% power)'
     +/'p1 =',F7.4,' [control]'
     +/'p2 =',F7.4,' [treatment]'
     +/'Odds-ratio =',1P,E11.3
     +/'ln(Odds-Ratio) =',1P,E11.3
     +/'log10(Odds-Ratio) =',1P,E11.3
     +/
     +/'Calculate n'
     +/'Calculate power = f(n)'
     +/'Plot power = f(n)'
     +/'Change p1'
     +/'Change p2'
     +/'Change Odds-Ratio'
     +/'Change ln(Odds-Ratio)'
     +/'Change log10(Odds-Ratio)'
     +/'Change alpha'
     +/'Change beta'
     +/'Results'
     +/'Quit ... Exit binomial calculations')
  150 FORMAT (
     + 'Calculations for 2 binomial distributions'
     +/
     +/'alpha =',F7.4,' (',F7.3,'% significance level)'
     +/'beta =',F7.4,' (',F7.3,'% power)'
     +/'p1 =',F7.4,' [control]'
     +/'p2 =',F7.4,' [treatment]'
     +/'Odds-ratio =',1X,A
     +/'ln(Odds-Ratio) =',1X,A
     +/'log10(Odds-Ratio) =',1X,A
     +/
     +/'Calculate n'
     +/'Calculate power = f(n)'
     +/'Plot power = f(n)'
     +/'Change p1'
     +/'Change p2'
     +/'Change Odds-Ratio'
     +/'Change ln(Odds-Ratio)'
     +/'Change log10(Odds-Ratio)'
     +/'Change alpha'
     +/'Change beta'
     +/'Results'
     +/'Quit ... Exit binomial calculations')   
  200 FORMAT ('alpha =',F7.4,', beta =',F7.4,
     +', p1 =',F7.4,', p2 =',F7.4,', n = ',A)
  300 FORMAT ('Odds-Ratio =',1P,E10.3,', ln(Odds-Ratio) =',E10.3,
     +', log10(Odds ratio) =',E10.3)
  350 FORMAT ('Odds-Ratio =',1X,A,', ln(Odds-Ratio) =',1X,A,
     +', log10(Odds ratio) =',1X,A)   
  400 FORMAT ('alpha =',F7.4,
     +', p1 =',F7.4,', p2 =',F7.4,', power =',F8.3,'%, n = ',A)
  500 FORMAT ('p1=',F5.4,', p2=',F5.4,', alpha=',F5.4)
      END
C
C
