C
C
      SUBROUTINE SPOWCC (NOUT, NPAR, PAR)
C
C ACTION: tests on 1, 2 correlation coefficients
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 23/12/2002
C         26/11/2021 added E_NUMBERS and E_FORMATS, etc.
C
C
      IMPLICIT   NONE
      INTEGER    NOUT, NPAR
      INTEGER    NMAX
      PARAMETER (NMAX = 2000)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NSTART, NTEXT, NUMOPT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NSTART = 9,
     +           NUMOPT = 11, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMDEC, NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    I, IADD, ICOUNT, IFAIL, ISEND, JCOLOR, MAXN, N, NH1,
     +           NSAMP, NSAMP1, NSAMP2
      DOUBLE PRECISION PAR(NPAR)
      DOUBLE PRECISION ALPHA, BETA
      DOUBLE PRECISION F, R, RCRIT, RL1, RL2, R0, R1, R2, S, T
      DOUBLE PRECISION ABSR, BOT, DZ, TOP, Z, ZA, ZB, Z1, Z2
      DOUBLE PRECISION B, DELTA1, DELTA2, DF, P, W
      DOUBLE PRECISION POWER, POWER1
      DOUBLE PRECISION ONE, TWO, THREE, F100, ZERO, EPSI
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, EPSI = 1.0D-06,
     +           THREE = 3.0D+00, F100 = 100.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION HALF, PNT05
      PARAMETER (HALF = 0.5D+00, PNT05 = 0.05D+00)
      DOUBLE PRECISION FMIN
      PARAMETER (FMIN = 1.0D-06)
      DOUBLE PRECISION G01EAF$, G01FAF$, G01EBF$, G01FBF$
      DOUBLE PRECISION X1(NMAX), X2(N2), X3(N1), X4(N1)
      DOUBLE PRECISION Y1(NMAX), Y2(N2), Y3(N1), Y4(N1)
      CHARACTER (LEN = 13) D13(3), SHOWLJ
      CHARACTER (LEN = 12) I12(3), FORM12
      CHARACTER (LEN = 10) D10, FORMGR
      CHARACTER  TEXT(NTEXT)*100
      CHARACTER  TAIL*1
      CHARACTER  PTITLE*50, XTITLE*40, YTITLE*40
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    NOTYET, REPEET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    LOGIC1, LOGIC2
      PARAMETER (LOGIC1 = .TRUE., LOGIC2 = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, FORMGR, SHOWLJ
      EXTERNAL   LBOX01, PUTFAT, GETJGE, SPOWPR, REVPRO, TABLE1
      EXTERNAL   G01EAF$, G01FAF$, G01EBF$, G01FBF$
      EXTERNAL   GKS004
      INTRINSIC  ABS, DBLE, SQRT, LOG, NINT
      SAVE       MAXN, N, NSAMP, NSAMP1, NSAMP2
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT* 1 /
      DATA       MAXN, N, NSAMP1, NSAMP2 / 100, 20, 20, 20 /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      ALPHA = PAR(1)
      BETA = PAR(2)
      R0 = PAR(9)
      R1 = PAR(7)
      R2 = PAR(8)
      NUMBLD(1) = 1
      NUMDEC = NUMOPT
      REPEET = .TRUE.
C
C Main loop
C
      DO WHILE (REPEET)
         POWER = F100*(ONE - BETA)
         WRITE (TEXT,100) ALPHA, F100*ALPHA, BETA,
     +                    POWER, R0, R1, R2
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.3 .OR. NUMDEC.EQ.4) THEN
C
C Check that R1 not equal to R2
C
            IF(ABS(R1 - R2).LT.EPSI) THEN
               CALL PUTFAT ('R1 = R2 ... Choose new values')
               NUMDEC = 8
            ENDIF
         ENDIF
         IF (NUMDEC.EQ.1) THEN
C
C H0: rho = 0
C
            I = 3
            CALL GETJGE (NSAMP1, I, 'Sample size to estimate R1')
            NSAMP = NSAMP1
            R = R1
            ABSR = ABS(R)
            DF = DBLE(NSAMP - 2)
            IFAIL = 0
C
C Work out the critical W value (Zar 18.6)
C
            TAIL = 'S'
            T = G01FBF$(TAIL, PNT05, DF, IFAIL)
            TOP = T**2
            BOT = T**2 + DF
            W = SQRT(TOP/BOT)
            IF (IFAIL.EQ.0) THEN
C
C Work out the confidence limits (Zar. 18.12)
C
               TOP = R - W
               BOT = ONE - R*W
               RL1 = TOP/BOT
               TOP = R + W
               BOT = ONE + R*W
               RL2 = TOP/BOT
C
C Do the test (Zar 18.4)
C
               TOP = ONE - R**2
               BOT = DF
               S = SQRT(TOP/BOT)
               T = R/S
               TAIL = 'S'
               P = G01EBF$(TAIL, T, DF, IFAIL)
C
C Work out the critical R value (Zar 18.6)
C
               IF (IFAIL.EQ.0) THEN
                  TAIL = 'S'
                  T = G01FBF$(TAIL, ALPHA, DF, IFAIL)
                  TOP = T**2
                  BOT = T**2 + DF
                  RCRIT = SQRT(TOP/BOT)
               ENDIF
C
C Work out the power (Zar 18.18)
C
               IF (IFAIL.EQ.0) THEN
                  TOP = ONE + RCRIT
                  BOT = ONE - RCRIT
                  ZA = HALF*LOG(TOP/BOT)
                  TOP = ONE + ABSR
                  BOT = ONE - ABSR
                  Z = HALF*LOG(TOP/BOT)
                  ZB = (Z - ZA)*SQRT(DF - ONE)
                  TAIL = 'U'
                  B = G01EAF$(TAIL, ZB, IFAIL)
                  POWER1 = F100*(ONE - B)
               ENDIF
C
C Calculate N given R1 or R2
C
               IF (IFAIL.EQ.0) THEN
                  NOTYET = .TRUE.
                  ICOUNT = 0
                  I = 3
                  DO WHILE (NOTYET .AND. ICOUNT.LT.NMAX)
                     ICOUNT = ICOUNT + 1
                     IF (I.LT.100) THEN
                        I = I + 1
                     ELSEIF (I.LT.200) THEN
                        I = I + 2
                     ELSEIF (I.LT.400) THEN
                        I = I + 4
                     ELSEIF (I.LT.800) THEN
                        I = I + 8
                     ELSEIF (I.LT.1600) THEN
                        I = I + 16
                     ELSE
                        I = I + 32
                     ENDIF
                     DF = DBLE(I - 2)
C
C Work out the critical R value (Zar 18.6)
C
                     IF (IFAIL.EQ.0) THEN
                        TAIL = 'S'
                        T = G01FBF$(TAIL, ALPHA, DF, IFAIL)
                        TOP = T**2
                        BOT = T**2 + DF
                        RCRIT = SQRT(TOP/BOT)
                     ENDIF
C
C Work out the power (Zar 18.18)
C
                     IF (IFAIL.EQ.0) THEN
                        TOP = ONE + RCRIT
                        BOT = ONE - RCRIT
                        ZA = HALF*LOG(TOP/BOT)
                        TOP = ONE + ABSR
                        BOT = ONE - ABSR
                        Z = HALF*LOG(TOP/BOT)
                        ZB = (Z - ZA)*SQRT(DF - ONE)
                        TAIL = 'U'
                        B = G01EAF$(TAIL, ZB, IFAIL)
                        F = F100*(ONE - B)
                     ENDIF
                     IF (IFAIL.EQ.0) THEN
                        DELTA2 = F - POWER
                        IF (I.EQ.4) DELTA1 = DELTA2
                        IF (ABS(DELTA2).LT.FMIN .OR.
     +                      DELTA1*DELTA2.LT.ZERO) THEN
                           NOTYET = .FALSE.
                           N = I
                        ENDIF
                        DELTA1 = DELTA2
                     ELSE
                        NOTYET = .FALSE.
                     ENDIF
                  ENDDO
                  IF (NOTYET) THEN
C
C Sample size calculation failed
C
                     ISEND = -1
                     CALL SPOWPR (ISEND, NPAR, PAR)
                     N = -1
                  ENDIF
               ENDIF
C
C Work out the sample size given R0 (Zar 18.19)
C
               IF (IFAIL.EQ.0) THEN
                  TAIL = 'U'
                  Z = HALF*ALPHA
                  ZA = G01FAF$(TAIL, Z, IFAIL)
                  IF (IFAIL.EQ.0) THEN
                     ZB = G01FAF$(TAIL, BETA, IFAIL)
                     TOP = ONE + R0
                     BOT = ONE - R0
                     Z = HALF*LOG(TOP/BOT)
                     TOP = ZB + ZA
                     BOT = Z
                     NH1 = NINT((TOP/BOT)**2 + THREE)
                  ENDIF
               ENDIF
               IF (IFAIL.EQ.0) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (TEXT,200) ALPHA, BETA, R, R0, NSAMP,
     +                                RL1, RL2, P, POWER1, N, NH1
                  ELSE
                     I12(1) = FORM12(NSAMP)
                     I12(2) = FORM12(N)
                     I12(3) = FORM12(NH1) 
                      WRITE (TEXT,250) ALPHA, BETA, R, R0, I12(1),
     +                                 RL1, RL2, P, POWER1,
     +                                 TRIM(I12(2)), TRIM(I12(3))
                  ENDIF  
                  JCOLOR = 15
                  CALL TABLE1 (JCOLOR, 'OPEN')
                  WRITE (NOUT,'(A)') BLANK
                  DO I = 1, 11
                     IF (I.EQ.1) THEN
                        JCOLOR = 4
                     ELSE
                        JCOLOR = 0
                     ENDIF
                     CALL TABLE1 (JCOLOR, TEXT(I))
                     WRITE (NOUT,'(A)') TEXT(I)
                  ENDDO
                  CALL TABLE1 (JCOLOR, 'CLOSE')
               ELSE
C
C Error
C
                  ISEND = 0
                  CALL SPOWPR (ISEND, NPAR, PAR)
               ENDIF
            ENDIF
            NUMDEC = 8
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Plot
C
            R = R1
            ABSR = ABS(R)
            IFAIL = 0
            POWER = F100*(ONE - BETA)
            ICOUNT = 0
            I = 2
            CALL GETJGE (MAXN, I, 'Maximum sample size for plotting')
            I = 3
            DO WHILE (IFAIL.EQ.0 .AND. I.LT.MAXN .AND.
     +                ICOUNT.LT.NMAX)
               IF (MAXN.LE.100 .OR. I.LE.50) THEN
                  IADD = 1
               ELSEIF (I.LE.100) THEN
                  IADD = 2
               ELSEIF (I.LE.200) THEN
                  IADD = 4
               ELSEIF (I.LE.400) THEN
                  IADD = 8
               ELSEIF (I.LE.800) THEN
                 IADD = 16
               ELSE
                  IADD = 32
               ENDIF
               I = I + IADD
C
C Work out the critical R value (Zar 18.6)
C
               DF = DBLE(I - 2)
               IF (IFAIL.EQ.0) THEN
                  TAIL = 'S'
                  T = G01FBF$(TAIL, ALPHA, DF, IFAIL)
                  TOP = T**2
                  BOT = T**2 + DF
                  RCRIT = SQRT(TOP/BOT)
               ENDIF
C
C Work out the power (Zar 18.18)
C
               IF (IFAIL.EQ.0) THEN
                  TOP = ONE + RCRIT
                  BOT = ONE - RCRIT
                  ZA = HALF*LOG(TOP/BOT)
                  TOP = ONE + ABSR
                  BOT = ONE - ABSR
                  Z = HALF*LOG(TOP/BOT)
                  ZB = (Z - ZA)*SQRT(DF - ONE)
                  TAIL = 'U'
                  B = G01EAF$(TAIL, ZB, IFAIL)
                  IF (IFAIL.EQ.0) THEN
                     ICOUNT = ICOUNT + 1
                     X1(ICOUNT) = DBLE(I)
                     Y1(ICOUNT) = F100*(ONE - B)
                  ENDIF
               ENDIF
            ENDDO
            IF (IFAIL.EQ.0 .AND. ICOUNT.GT.1) THEN
               X2(1) = X1(1)
               X2(2) = X1(ICOUNT)
               Y2(1) = POWER
               Y2(2) = POWER
               WRITE (PTITLE,300) R
               XTITLE = 'Sample Size'
               WRITE (YTITLE,600) ALPHA
               CALL GKS004 (N1, N2, N0, N0, N0, N0, N0, N0,
     +                      ICOUNT, N2, N1, N1,
     +                      X1, X2, X3, X4, Y1, Y2, Y3, Y4,
     +                      PTITLE, XTITLE, YTITLE, LOGIC1, LOGIC2)
            ELSE
C
C Error
C
               ISEND = 0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ENDIF
            NUMDEC = 8
         ELSEIF (NUMDEC.EQ.3) THEN
C
C R1 = R2
C

            IF (NSAMP1.LT.4) NSAMP1 = 4
            IF (NSAMP2.LT.4) NSAMP2 = 4
            I = 4
            CALL GETJGE (NSAMP1, I, 'Sample size to estimate R1')
            CALL GETJGE (NSAMP2, I, 'Sample size to estimate R2')
C
C Create transforms (Zar 18.8)
C
            TOP = ONE + R1
            BOT = ONE - R1
            Z1 = HALF*LOG(TOP/BOT)
            TOP = ONE + R2
            BOT = ONE - R2
            Z2 = HALF*LOG(TOP/BOT)
            DZ = ABS(Z1 - Z2)
C
C Do the test (Zar 18.21, 18.22
C
            S = SQRT(ONE/DBLE(NSAMP1 - 3) + ONE/DBLE(NSAMP2 - 3))
            Z = DZ/S
            IFAIL = 0
            TAIL = 'S'
            P = G01EAF$(TAIL, Z, IFAIL)
            IF (IFAIL.EQ.0) THEN
C
C Calculate the power (Zar 18.28)
C
               TAIL = 'U'
               T = ALPHA/TWO
               ZA = G01FAF$(TAIL, T, IFAIL)
               ZB = Z - ZA
               IF (IFAIL.EQ.0) THEN
                  B = G01EAF$(TAIL, ZB, IFAIL)
                  IF (IFAIL.EQ.0) THEN
                     POWER1 = F100*(ONE - B)
C
C Sample size (Zar 18.29)
C
                     T = BETA
                     ZB = G01FAF$(TAIL, T, IFAIL)
                     IF (IFAIL.EQ.0) THEN
                        TOP = ZA + ZB
                        BOT = DZ
                        N = NINT(TWO*(TOP/BOT)**2 + THREE)
                        IF (E_NUMBERS) THEN
                           WRITE (TEXT,400) ALPHA, BETA,
     +                                      R1, NSAMP1, Z1,
     +                                      R2, NSAMP2, Z2,
     +                                      P, POWER1, DZ, N
                        ELSE
                           I12(1) = FORM12(NSAMP1)
                           D13(1) = SHOWLJ(Z1)
                           I12(2) = FORM12(NSAMP2)
                           D13(2) = SHOWLJ(Z2)
                           D13(3) = SHOWLJ(DZ)
                           I12(3) = FORM12(N)
                           WRITE (TEXT,450) ALPHA, BETA,
     +                                      R1, TRIM(I12(1)), D13(1),
     +                                      R2, TRIM(I12(2)), D13(2),
     +                                      P, POWER1, D13(3), I12(3)  
                        ENDIF  
                        JCOLOR = 15
                        CALL TABLE1 (JCOLOR, 'OPEN')
                        WRITE (NOUT,'(A)') BLANK
                        DO I = 1, 9
                           IF (I.EQ.1) THEN
                              JCOLOR = 4
                           ELSE
                              JCOLOR = 0
                           ENDIF
                           CALL TABLE1 (JCOLOR, TEXT(I))
                           WRITE (NOUT,'(A)') TEXT(I)
                        ENDDO
                        CALL TABLE1 (JCOLOR, 'CLOSE')
                     ENDIF
                  ENDIF
               ENDIF
            ENDIF
            IF (IFAIL.NE.0) THEN
C
C Error
C
               ISEND = 0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ENDIF
            NUMDEC = 9
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Plot
C
            I = 2
            CALL GETJGE (MAXN, I, 'Maximum sample size for plotting')
C
C Create transforms (Zar 18.8) and ZA (Zar 18.28)
C
            TOP = ONE + R1
            BOT = ONE - R1
            Z1 = HALF*LOG(TOP/BOT)
            TOP = ONE + R2
            BOT = ONE - R2
            Z2 = HALF*LOG(TOP/BOT)
            DZ = ABS(Z1 - Z2)
            TAIL = 'U'
            T = ALPHA/TWO
            IFAIL = 0
            ZA = G01FAF$(TAIL, T, IFAIL)
            ICOUNT = 0
            I = 3
            DO WHILE (IFAIL.EQ.0 .AND. I.LT.MAXN .AND.
     +                ICOUNT.LT.NMAX)
               IF (MAXN.LE.100 .OR. I.LE.50) THEN
                  IADD = 1
               ELSEIF (I.LE.100) THEN
                  IADD = 2
               ELSEIF (I.LE.200) THEN
                  IADD = 4
               ELSEIF (I.LE.400) THEN
                  IADD = 8
               ELSEIF (I.LE.800) THEN
                 IADD = 16
               ELSE
                  IADD = 32
               ENDIF
               I = I + IADD
C
C Calculate the power (Zar 18.23, 18.28)
C
               S = SQRT(TWO/DBLE(I - 3))
               ZB = DZ/S - ZA
               B = G01EAF$(TAIL, ZB, IFAIL)
               IF (IFAIL.EQ.0) THEN
                  ICOUNT = ICOUNT + 1
                  X1(ICOUNT) = DBLE(I)
                  Y1(ICOUNT) = F100*(ONE - B)
               ENDIF
            ENDDO
            IF (IFAIL.EQ.0 .AND. ICOUNT.GT.1) THEN
               X2(1) = X1(1)
               X2(2) = X1(ICOUNT)
               Y2(1) = POWER
               Y2(2) = POWER
               IF (E_NUMBERS) THEN
                  WRITE (PTITLE,500) DZ
               ELSE
                  D10 = FORMGR(DZ)
                  WRITE (PTITLE,550) D10
               ENDIF      
               XTITLE = 'Sample Size'
               WRITE (YTITLE,600) ALPHA
               CALL GKS004 (N1, N2, N0, N0, N0, N0, N0, N0,
     +                      ICOUNT, N2, N1, N1,
     +                      X1, X2, X3, X4, Y1, Y2, Y3, Y4,
     +                      PTITLE, XTITLE, YTITLE, LOGIC1, LOGIC2)
            ELSE
C
C Error
C
               ISEND = 0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ENDIF
            NUMDEC = 9
         ELSEIF (NUMDEC.EQ.5) THEN
C
C New alpha
C
            ISEND = 1
            CALL SPOWPR (ISEND, NPAR, PAR)
            ALPHA = PAR(1)
            NUMDEC = 4
         ELSEIF (NUMDEC.EQ.6) THEN
C
C New beta
C
            ISEND = 2
            CALL SPOWPR (ISEND, NPAR, PAR)
            BETA = PAR(2)
            NUMDEC = 3
         ELSEIF (NUMDEC.EQ.7) THEN
C
C New theoretical R0
C
            ISEND = 9
            CALL SPOWPR (ISEND, NPAR, PAR)
            R0 = ABS(PAR(9))
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.8) THEN
C
C New R1
C
            ISEND = 7
            CALL SPOWPR (ISEND, NPAR, PAR)
            R1 = PAR(7)
            NUMDEC = 9
         ELSEIF (NUMDEC.EQ.9) THEN
C
C New R2
C
            ISEND = 8
            CALL SPOWPR (ISEND, NPAR, PAR)
            R2 = PAR(8)
            NUMDEC = 4
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Results
C
            CALL REVPRO (NOUT)
            NUMDEC = 9
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Power for correlations tests (normal distributions)'
     +/
     +/'Current alpha =',F7.4,' (',F7.2,'% sig. level)'
     +/'Current beta =',F7.4,' (',F7.2,'% power)'
     +/'Current R0 =',F7.4,' (theoretical corr. coeff.)'
     +/'Current R1 =',F7.4,' (sample 1 corr. coeff.)'
     +/'Current R2 =',F7.4,' (sample 2 corr. coeff.)'
     +/
     +/'1 sample, H0: rho = 0, H1: |rho| > 0 (or > R0)'
     +/'1 sample, plot power = f(n)'
     +/'2 samples, H0: rho1 = rho2, H1: |rho1 - rho2| > 0'
     +/'2 samples, plot power = f(n)'
     +/'Change alpha'
     +/'Change beta'
     +/'Change R0 (R theoretical)'
     +/'Change R1 (R from sample 1)'
     +/'Change R2 (R from sample 2)'
     +/'Results'
     +/'Quit ... Exit power for correlation tests')
  200 FORMAT (
     + 'H0: rho = 0, H1: |rho| > 0 (or > R0)'
     +/'Current alpha        =',F8.4
     +/'Current beta         =',F8.4
     +/'Corr. coeff. R1      =',F8.4
     +/'Corr. coeff. R0      =',F8.4
     +/'Sample size          =',I8
     +/'95% conf. limits     =',F8.4,',',F8.4
     +/'Two tailed t-test, p =',F8.4
     +/'Power of this test   =',F8.3,'%'
     +/'N for H1: |rho| > 0  =',I8,' (R1 given)'
     +/'N for H1: |rho| > R0 =',I8,' (R1 arbitrary)')
  250 FORMAT (
     + 'H0: rho = 0, H1: |rho| > 0 (or > R0)'
     +/'Current alpha        =',F7.4
     +/'Current beta         =',F7.4
     +/'Corr. coeff. R1      =',F7.4
     +/'Corr. coeff. R0      =',F7.4
     +/'Sample size          =',1X,A
     +/'95% conf. limits     =',F7.4,',',F7.4
     +/'Two tailed t-test, p =',F7.4
     +/'Power of this test   =',F7.3,'%'
     +/'N for H1: |rho| > 0  =',1X,A,' (R1 given)'
     +/'N for H1: |rho| > R0 =',1X,A,' (R1 arbitrary)')   
  300 FORMAT ('R =',F7.4,', 2-tail test for |rho| > 0')
  400 FORMAT (
     + 'H0: rho1 = rho2, H1: |rho1 - rho2|> 0'
     +/'Current alpha          =',0P,F8.4
     +/'Current beta           =',0P,F8.4
     +/'R1, N1, Z1             =',0P,F8.4,',',I7,',',1P,E11.3
     +/'R2, N2, Z2             =',0P,F8.4,',',I7,',',1P,E11.3
     +/'Two-tailed Z-test, p   =',0P,F8.4
     +/'Power of this test     =',0P,F8.3,'%'
     +/'For a Z-diff |z1 - z2| =',1P,E11.3
     +/'sample size N required =',I8)
  450 FORMAT (
     + 'H0: rho1 = rho2, H1: |rho1 - rho2|> 0'
     +/'Current alpha          =',F7.4
     +/'Current beta           =',F7.4
     +/'R1, N1, Z1             =',F7.4,',',1X,A,',',1X,A
     +/'R2, N2, Z2             =',F7.4,',',1X,A,',',1X,A
     +/'Two-tailed Z-test, p   =',F7.4
     +/'Power of this test     =',F7.3,'%'
     +/'For a Z-diff |z1 - z2| =',1X,A
     +/'sample size N required =',1X,A)     
  500 FORMAT ('Power for |Z1 - Z2| =',1P,E10.3)
  550 FORMAT ('Power for |Z1 - Z2| =',1X,A)
  600 FORMAT ('%Power (alpha =',F7.4,')')
      END
C
C
