C
C
      SUBROUTINE SPOWCS (NOUT, NPAR, PAR)
C
C ACTION: chi-square power
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 31/12/2002
C         26/11/2021 added E_NUMBERS and E_FORMATS, etc.
C
C         NOTE: FMIN is the smallest difference in the iteration so
C               FMIN = 0 forces a sign change in the root finding
C
      IMPLICIT   NONE
      INTEGER    NOUT, NPAR
      INTEGER    MAXIT, NMAX, NVMAX
      PARAMETER (MAXIT = 100, NMAX = 2000, NVMAX = 5000)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NSTART, NTEXT, NUMOPT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NSTART = 8,
     +           NUMOPT = 9, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    ITYPE, KTEXT, KUMOPT, NCOLS
      PARAMETER (ITYPE = 1, KTEXT = 21, KUMOPT = 8, NCOLS = 1)
      INTEGER    NUMDEC, NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    I, IADD, ICOUNT, IFAIL, ISEND, MAXN, N, NCELLS, NDOF,
     +           NIN
      DOUBLE PRECISION PAR(NPAR)
      DOUBLE PRECISION ALPHA, BETA
      DOUBLE PRECISION CHISQ1, CHISQ2
      DOUBLE PRECISION B, DF, P, RLAMDA
      DOUBLE PRECISION DELTA1, DELTA2, POWER, R0, R1, SUM0, SUM1
      DOUBLE PRECISION P0(NVMAX), P1(NVMAX), PTEMP(NVMAX)
      DOUBLE PRECISION EPSI, ONE, FMIN, F100, ZERO
      PARAMETER (EPSI = 1.0D-06, ONE = 1.0D+00,
     +           FMIN = 1.0D-04, F100 = 100.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION TOL
      PARAMETER (TOL = 1.0D-06)
      DOUBLE PRECISION G01FCF$, G01GCF$
      DOUBLE PRECISION X1(NMAX), X2(N2), X3(N1), X4(N1)
      DOUBLE PRECISION Y1(NMAX), Y2(N2), Y3(N1), Y4(N1)
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER (LEN = 10) D10, FORMGR
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  FNAME*1024, TITLE*80
      CHARACTER  PTITLE*50, XTITLE*40, YTITLE*40
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, AGAIN, FIRST, NOTYET, REPEET
      LOGICAL    FLASH, HIGH
      PARAMETER (FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    BORDER, FIXNPT, LABELS
      PARAMETER (BORDER = .FALSE., FIXNPT = .FALSE., LABELS = .FALSE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .TRUE.,
     +           LABEL = .TRUE., ORDER = .FALSE., WEIGHT = .FALSE.)
      LOGICAL    LOGIC1, LOGIC2
      PARAMETER (LOGIC1 = .TRUE., LOGIC2 = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, FORMGR, SHOWLJ
      EXTERNAL   LBOX01, GETJGE, SPOWPR, REVPRO, PUTTXT, PUTADV,
     +           LBOX02, GETDGE, VEC1IN, GETNOU, EDITOR, PATCH1
      EXTERNAL   G01FCF$, G01GCF$
      EXTERNAL   GKS004
      INTRINSIC  ABS, DBLE, TRIM
      SAVE       FIRST
      SAVE       P0, P1
      SAVE       MAXN, N, NCELLS, NDOF
      SAVE       CHISQ1, CHISQ2
      DATA       FIRST / .TRUE. /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT* 1 /
      DATA       MAXN, N, NCELLS, NDOF / 100, 20, 10, 100 /
      DATA       CHISQ1, CHISQ2 / ONE, ONE /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      ALPHA = PAR(1)
      BETA = PAR(2)
      IF (FIRST) THEN
         FIRST = .FALSE.
         DO I = 1, NVMAX
            P0(I) = DBLE(I)
            P1(I) = DBLE(I) + 1
         ENDDO
      ENDIF
      NUMDEC = 7
      REPEET = .TRUE.
C
C Main loop
C
      DO WHILE (REPEET)
         POWER = F100*(ONE - BETA)
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) ALPHA, F100*ALPHA, BETA,
     +                       POWER, CHISQ1, NDOF
         ELSE
            D13(1) = SHOWLJ(CHISQ1)
            I12(1) = FORM12(NDOF)
            WRITE (TEXT,150) ALPHA, F100*ALPHA, BETA,
     +                       POWER, TRIM(D13(1)), TRIM(I12(1))  
         ENDIF  
         NUMBLD(1) = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (NUMDEC.EQ.1) THEN
C
C Calculate
C
            IFAIL = 0
            DF = DBLE(NDOF)
            P = ONE - ALPHA
            CHISQ2 = G01FCF$(P, DF, IFAIL)
            IF (IFAIL.EQ.0) THEN
               NOTYET = .TRUE.
               I = 1
               ICOUNT = 0
            ELSE
               NOTYET = .FALSE.
            ENDIF
            DO WHILE (NOTYET .AND. ICOUNT.LT.NMAX)
               ICOUNT = ICOUNT + 1
               IF (I.LT.100) THEN
                  I = I + 1
               ELSEIF (I.LT.200) THEN
                  I = I + 2
               ELSEIF (I.LT.400) THEN
                  I = I + 4
               ELSEIF (I.LT.800) THEN
                  I = I + 8
               ELSEIF (I.LT.1600) THEN
                  I = I + 16
               ELSEIF (I.LT.3200) THEN
                  I = I + 32
               ELSE
                  I = I + 64
               ENDIF
               IF (IFAIL.EQ.0) THEN
                  RLAMDA = DBLE(I)*CHISQ1
                  B = G01GCF$(CHISQ2, DF, RLAMDA, TOL, MAXIT, IFAIL)
                  DELTA2 = BETA - B
                  IF (I.EQ.2) DELTA1 = DELTA2
                  IF (ABS(DELTA2).LT.FMIN .OR.
     +                DELTA1*DELTA2.LT.ZERO) THEN
                     NOTYET = .FALSE.
                     N = I
                  ENDIF
                  DELTA1 = DELTA2
               ELSE
                  NOTYET = .FALSE.
               ENDIF
            ENDDO
            IF (NOTYET) THEN
C
C Sample size calculation failed
C
               ISEND = -1
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (LINE,200) ALPHA, BETA, CHISQ1, NDOF, CHISQ2, N
               ELSE
                  D13(1) = SHOWLJ(CHISQ1)
                  I12(1) = FORM12(NDOF)
                  D13(2) = SHOWLJ(CHISQ2)
                  I12(2) = FORM12(N)
                  WRITE (LINE,250) ALPHA, BETA, TRIM(D13(1)),
     +                             TRIM(I12(1)), TRIM(D13(2)), 
     +                             TRIM(I12(2))
               ENDIF  
               CALL PUTTXT (LINE)
               WRITE (NOUT,'(A)') LINE
            ENDIF
            NUMDEC = 5
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Plot
C
            I = 2
            CALL GETJGE (MAXN, I, 'Maximum sample size for plotting')
            IFAIL = 0
            DF = DBLE(NDOF)
            P = ONE - ALPHA
            CHISQ2 = G01FCF$(P, DF, IFAIL)
            IF (IFAIL.EQ.0) THEN
               I = 1
               ICOUNT = 0
            ELSE
               I = MAXN
               ICOUNT = MAXN
            ENDIF
            DO WHILE (IFAIL.EQ.0 .AND. I.LT.MAXN .AND.
     +                ICOUNT.LT.NMAX)
               IF (MAXN.LE.100 .OR. I.LE.50) THEN
                  IADD = 1
               ELSEIF (I.LE.100) THEN
                  IADD = 2
               ELSEIF (I.LE.200) THEN
                  IADD = 4
               ELSEIF (I.LE.400) THEN
                  IADD = 8
               ELSEIF (I.LE.800) THEN
                 IADD = 16
               ELSE
                  IADD = 32
               ENDIF
               I = I + IADD
               RLAMDA = DBLE(I)*CHISQ1
               IF (IFAIL.EQ.0) B = G01GCF$(CHISQ2, DF, RLAMDA, TOL,
     +                                     MAXIT, IFAIL)
               IF (IFAIL.EQ.0) THEN
                  ICOUNT = ICOUNT + 1
                  X1(ICOUNT) = DBLE(I)
                  Y1(ICOUNT) = F100*(ONE - B)
               ENDIF
            ENDDO
            IF (IFAIL.EQ.0 .AND. ICOUNT.GT.1) THEN
               X2(1) = X1(1)
               X2(2) = X1(ICOUNT)
               Y2(1) = POWER
               Y2(2) = POWER
               IF (E_NUMBERS) THEN
                  WRITE (PTITLE,300) CHISQ1, NDOF
               ELSE
                  D10 = FORMGR(CHISQ1)
                  I12(1) = FORM12(NDOF)
                  WRITE (PTITLE,350) TRIM(D10), TRIM(I12(1))
               ENDIF  
               XTITLE = 'Sample Size'
               WRITE (YTITLE,600) ALPHA
               CALL GKS004 (N1, N2, N0, N0, N0, N0, N0, N0,
     +                      ICOUNT, N2, N1, N1,
     +                      X1, X2, X3, X4, Y1, Y2, Y3, Y4,
     +                      PTITLE, XTITLE, YTITLE, LOGIC1, LOGIC2)
            ELSE
C
C Error
C
               ISEND = 0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ENDIF
            NUMDEC = 5
         ELSEIF (NUMDEC.EQ.3) THEN
C
C New alpha
C
            ISEND = 1
            CALL SPOWPR (ISEND, NPAR, PAR)
            ALPHA = PAR(1)
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.4) THEN
C
C New beta
C
            ISEND = 2
            CALL SPOWPR (ISEND, NPAR, PAR)
            BETA = PAR(2)
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.5) THEN
C
C New SSQ
C
            AGAIN = .TRUE.
            DO WHILE (AGAIN)
               WRITE (TEXT,400) NCELLS
               NUMDEC = 1
               CALL LBOX02 (ICOLOR, IXL, IYL, NUMDEC, KUMOPT, NUMPOS,
     +                      TEXT)
               IF (NUMDEC.EQ.1) THEN
C
C Input directly
C
                  CALL GETDGE (CHISQ1, EPSI,
     +                        'New ssq = sum(p0 - pi)^2/p0')
                  AGAIN = .FALSE.
               ELSEIF (NUMDEC.EQ.2) THEN
C
C Calculate ssq from vectors
C
                  SUM0 = ZERO
                  SUM1 = ZERO
                  DO I = 1, NCELLS
                     SUM0 = SUM0 + P0(I)
                     SUM1 = SUM1 + P1(I)
                  ENDDO
                  CHISQ1 = ZERO
                  DO I = 1, NCELLS
                     R0 = P0(I)/SUM0
                     R1 = P1(I)/SUM1
                     CHISQ1 = CHISQ1 + (R0 - R1)**2/R0
                  ENDDO
                  AGAIN = .FALSE.
               ELSEIF (NUMDEC.EQ.3 .OR. NUMDEC.EQ.4) THEN
C
C Input p0 or p1
C
                  ISEND = 3
                  CALL GETNOU (NIN)
                  CLOSE (UNIT = NIN)
                  CALL VEC1IN (ISEND, NIN, NVMAX, N,
     +                         PTEMP,
     +                         FNAME, TITLE,
     +                         ABORT, FIXNPT, LABELS)
                  CLOSE (UNIT = NIN)
                  IF (.NOT.ABORT .AND. N.GT.1) THEN
                     ICOUNT = 0
                     DO I = 1, N
                        IF (PTEMP(I).LT.EPSI) THEN
                           ICOUNT = ICOUNT + 1
                           PTEMP(I) = EPSI
                        ENDIF
                     ENDDO
                     IF (ICOUNT.GT.0) THEN
                        IF (E_NUMBERS) THEN
                           WRITE (LINE,500) EPSI, ICOUNT
                        ELSE
                           D13(1) = SHOWLJ(EPSI)
                           I12(1) = FORM12(ICOUNT)
                           WRITE (LINE,550) TRIM(D13(1)), I12(1) 
                        ENDIF  
                        CALL PUTADV (LINE)
                     ENDIF
                     IF (NUMDEC.EQ.3) THEN
                        DO I = 1, N
                          P0(I) = PTEMP(I)
                        ENDDO
                     ELSE
                        DO I = 1, N
                           P1(I) = PTEMP(I)
                        ENDDO
                     ENDIF
                  ENDIF
               ELSEIF (NUMDEC.EQ.5 .OR. NUMDEC.EQ.6) THEN
C
C Edit p0 or p1
C
                  IF (NUMDEC.EQ.5) THEN
                     LINE = 'The p0 vector with p0(i) > 0'
                     DO I = 1, NCELLS
                        PTEMP(I) = P0(I)
                     ENDDO
                  ELSE
                     LINE = 'The p1 vector with p1(i) > 0'
                     DO I = 1, NCELLS
                         PTEMP(I) = P1(I)
                     ENDDO
                  ENDIF
                  ISEND = 2
                  CALL EDITOR (ISEND, ITYPE, NCOLS, NVMAX, NCELLS,
     +                         PTEMP,
     +                         LINE,
     +                         CURVE, FIXCOL, FIXROW, LABEL, ORDER,
     +                         WEIGHT)
                  ICOUNT = 0
                  DO I = 1, NCELLS
                     IF (PTEMP(I).LT.EPSI) THEN
                        ICOUNT = ICOUNT + 1
                        PTEMP(I) = EPSI
                     ENDIF
                  ENDDO
                  IF (ICOUNT.GT.0) THEN
                     WRITE (LINE,500) EPSI, ICOUNT
                     CALL PUTADV (LINE)
                  ENDIF
                  IF (NUMDEC.EQ.5) THEN
                     DO I = 1, NCELLS
                        P0(I) = PTEMP(I)
                    ENDDO
                  ELSE
                     DO I = 1, NCELLS
                        P1(I) = PTEMP(I)
                     ENDDO
                  ENDIF
                  NUMDEC = 1
               ELSEIF (NUMDEC.EQ.7) THEN
C
C input NCELLS
C
                 I = 2
                 CALL GETJGE (NCELLS, I, 'Number of cells required')
               ELSEIF (NUMDEC.EQ.KUMOPT) THEN
                  AGAIN = .FALSE.
               ENDIF
            ENDDO
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.6) THEN
C
C New NDOF
C
            I = 2
            CALL GETJGE (NDOF, I, 'New ndof (degrees of freedom)')
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C Help
C
            WRITE (TEXT,700)
            NUMBLD(1) = 1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD,
     +                   KTEXT, TEXT, BORDER)
            NUMBLD(1) = 0
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Results
C
            CALL REVPRO (NOUT)
            NUMDEC = 5
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Power for chi-square tests'
     +/
     +/'Current alpha =',F7.4,' (',F7.2,'% sig. level)'
     +/'Current beta =',F7.4,' (',F7.2,'% power)'
     +/'Current ssq =',1P,E10.3,' (sum of (p0 - pi)^2/p0)'
     +/'Current ndof =',I6,' (degrees of freedom)'
     +/
     +/'Calculate'
     +/'Plot'
     +/'Change alpha'
     +/'Change beta'
     +/'Change ssq = sum of (p0 - p1)^2/p0'
     +/'Change ndof = no. degrees of freedom'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit tests for chi-square power')
  150 FORMAT (
     + 'Power for chi-square tests'
     +/
     +/'Current alpha =',F7.4,' (',F7.2,'% sig. level)'
     +/'Current beta =',F7.4,' (',F7.2,'% power)'
     +/'Current ssq =',1X,A,' (sum of (p0 - pi)^2/p0)'
     +/'Current ndof =',1X,A,' (degrees of freedom)'
     +/
     +/'Calculate'
     +/'Plot'
     +/'Change alpha'
     +/'Change beta'
     +/'Change ssq = sum of (p0 - p1)^2/p0'
     +/'Change ndof = number of degrees of freedom'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit tests for chi-square power')   
  200 FORMAT ('alpha=',F6.4,',beta=',F6.4,',ssq=',1P,E9.3,
     +',ndof=',I5,',chi-sq.=',1P,E9.3,',N=',I6)
  250 FORMAT ('alpha=',F6.4,',beta=',F6.4,',ssq=',A,
     +',ndof=',A,',chi-sq.=',A,',N=',A)   
  300 FORMAT ('ssq=',1P,E10.3,',ndof =',i5)
  350 FORMAT ('ssq=',A,',ndof =',A)
  400 FORMAT (
     + 'Input ssq directly'
     +/'Calculate ssq from vectors'
     +/'Install p0 vector'
     +/'Install p1 vector'
     +/'Edit p0 vector'
     +/'Edit p1 vector'
     +/'Change no. cells (current =',I7,')'
     +/'Quit ... Exit non-central chi-square calculations')
  500 FORMAT ('Number of p-values =< 0 reset to',1P,E10.3,' =',I6)
  550 FORMAT ('Number of p-values =< 0 reset to',1X,A,' =',1X,A)
  600 FORMAT ('%Power (alpha=',F5.4,')')
  700 FORMAT (
     + 'The non-central chi-square parameter (lambda = N*ssq)'
     +/
     +/'The calculation assumes multinomial parameters as follows:'
     +/'H0: the probabilities are p0(i), i = 1, 2, ..., m'
     +/'H1: the probabilities are p1(i), i = 1, 2, ..., m'
     +/'m = the number of cells'
     +/'ndof = degrees of freedom (m - 1- no. parameters estimated)'
     +/'ssq = sum of [p0(i) - p1(i)]**2/p0(i) for i = 1, 2, ..., m'
     +/'N = sample size (i.e. E[frequency(i)] = N*p0(i))'
     +/'lambda = N*ssq (non-central chi-square parameter).'
     +/
     +/'You can input ssq directly or input vectors p0 and p1 which'
     +/'can be used to calculate ssq as required. Note that p0 and'
     +/'p1 values must be nonnegative but they need not be < 1, nor'
     +/'is it necessary that they should add to 1 since p0 and p1'
     +/'values are normalised to probabilities when required using'
     +/'p0(i) := p0(i)/[sum of p0(i), for i = 1, 2, ..., m] and'
     +/'p1(i) := p1(i)/[sum of p1(i), for i = 1, 2, ..., m]. That is,'
     +/'p0(i) and p1(i) can be frequencies instead of probabilities.'
     +/'For contingency tables with r rows and c columns the order of'
     +/'the m = r*c cells does not matter but ndof = (r - 1)*(c - 1).')
      END
C
C
