C
C
      SUBROUTINE SPOWER (NOUT)
C
C ACTION : Statistical power/sample size calculations
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 20/2/98
C          07/11/1999 altered main menu and defined p = p0
C          23/12/1999 added SPOWNK and altered output to results file
C          02/05/2000 removed P1 from menu and set default beta = 0.2
C          20/12/2002 revised for variance, correlation, chi-sq, Fisher
C          25/01/2003 added Fisher exact
C          13/11/2013 added INTENT and minor editing
C
C METHODS: Biostatistical Analysis J.H.Zar, Prentice Hall 3rd Ed 1996
C          pages 526-527
C          Epidemiology in Medicine Hennekens C.H. and Buring.J.E.
C          Little Brown and Co. Boston 1987 pages 258-264
C
C
      IMPLICIT   NONE
C
C Argument
C      
      INTEGER, INTENT (IN) :: NOUT
C
C Locals
C      
      INTEGER    ICOLOR, IXL, IYL, JCOLOR, LSHADE
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, JCOLOR = 9, LSHADE = 1)
      INTEGER    K0, K1, NMAX, NPAR
      PARAMETER (K0 = 0, K1 = 1, NMAX = 30, NPAR = 20)
      INTEGER    NSTART, NTEXT, NUMBLD(NMAX), NUMDEC, NUMOPT,
     +           NUMPOS(NMAX)
      INTEGER    N, N1, N2
      DOUBLE PRECISION ONE, TWO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION PAR(NPAR)
      DOUBLE PRECISION ALPHA, BETA
      DOUBLE PRECISION DELTA
      DOUBLE PRECISION D, H
      DOUBLE PRECISION P0, P1, P2
      DOUBLE PRECISION R0, R1, R2
      DOUBLE PRECISION VAR0, VAR, VAR2
      DOUBLE PRECISION BOT, TOP
      PARAMETER (ALPHA = 0.05D+00, BETA = 0.2D+00,
     +           DELTA = 0.1D+00,
     +           D = 1.0D+00, H = 1.0D+00,
     +           P0 = 0.5D+00, P1 = 0.6D+00, P2 = 0.7D+00,
     +           VAR0 = 3.0D+00, VAR = 1.0D+00, VAR2 = 2.0D+00,
     +           R0 = 0.2D+00, R1 = 0.5D+00, R2 = -0.5D+00)
      CHARACTER  LINE*100, TEXT(NMAX)*100, LABEL(3)*10
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    FIRST
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_BOT = .FALSE., TAB_MID = .FALSE.,
     +           TAB_TOP = .FALSE.)
      LOGICAL    AGAIN, FRAME, NEXT, UPDOWN
      EXTERNAL   SPOWB1, SPOWB2, SPOWN1, SPOWN2, SPOWNK, SPOWVR,
     +           SPOWCC, SPOWCS, SPOWFE
      EXTERNAL   LBOX01, PUTFAT, PUTTXT, TRIML1, GETJGE, TUTOR1, REVPRO
      INTRINSIC  DBLE, NINT
      SAVE       FIRST
      SAVE       PAR
      SAVE       N, N1
      DATA       FIRST / .TRUE. /
      DATA       N, N1 / 20, 20 /
      DATA       PAR / NPAR*ONE /
      DATA       NUMBLD / NMAX*0 /
      DATA       NUMPOS / NMAX*1 /
      IF (FIRST) THEN
C
C First time round initialise PAR
C
         FIRST = .FALSE.
         PAR(1) = ALPHA
         PAR(2) = BETA
         PAR(3) = P0
         PAR(4) = VAR
         PAR(5) = VAR2
         PAR(6) = VAR0
         PAR(7) = R1
         PAR(8) = R2
         PAR(9) = R0
         PAR(10) = DELTA
         PAR(11) = P1
         PAR(12) = H
         PAR(13) = D
         PAR(14) = P2
         PAR(15) = P1
         PAR(16) = P2
      ENDIF
      NUMBLD(1) = 1
      NUMOPT = 13
      NUMDEC = NUMOPT - 2
      AGAIN = .TRUE.
C
C Main loop
C
      DO WHILE (AGAIN)
         WRITE (TEXT,100)
         NSTART = 3
         NTEXT = NUMOPT + 2
         NUMBLD(1) = 4
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +                TAB_TOP, TAB_MID, TAB_BOT)
         NUMBLD(1) = 0 
         IF (NUMDEC.EQ.1) THEN
C
C Method 1
C
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,'(A)') ' Power analysis for 1 binomial'
            CALL SPOWB1 (NOUT, NPAR, PAR)
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Method 2
C
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,'(A)') ' Power analysis for 2 binomials'
            CALL SPOWB2 (NOUT, NPAR, PAR)
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Method 2 (Fisher Exact)
C
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,'(A)') ' Power analysis for Fisher Exact'
            CALL SPOWFE (NOUT, NPAR, PAR)
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Method 3
C
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,'(A)') ' Power analysis for 1 normal (t test)'
            CALL SPOWN1 (NOUT, NPAR, PAR)
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Method 4
C
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,'(A)') ' Power analysis for 2 normals (t test)'
            CALL SPOWN2 (NOUT, NPAR, PAR)
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Method 5
C
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,'(A)') ' Power analysis for k normals (ANOVA)'
            CALL SPOWNK (NOUT, NPAR, PAR)
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Method 6
C
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,'(A)') ' Power analysis for 1, 2 variances'
            CALL SPOWVR (NOUT, NPAR, PAR)
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Method 7
C
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,'(A)') ' Power analysis for 1, 2 correlations'
            CALL SPOWCC (NOUT, NPAR, PAR)
         ELSEIF (NUMDEC.EQ.9) THEN
C
C Method 8
C
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,'(A)') ' Power analysis for chi-square'
            CALL SPOWCS (NOUT, NPAR, PAR)
         ELSEIF (NUMDEC.EQ.10) THEN
C
C Correction for unequal n
C
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,'(A)') ' Power analysis for unequal n'
            CALL GETJGE (N, K1, 'sample size recommended for the test')
            N2 = NINT((DBLE(N) + ONE)/TWO) + K1
            CALL GETJGE (N1, N2,
     +                  'the fixed sample size n1 (>= (n + 1)/2)')
            IF (2*N1 - N.LE.K0) THEN
               CALL PUTFAT ('Calculation impossible for this n1')
            ELSE
               TOP = DBLE(N*N1)
               BOT = TWO*DBLE(N1) - DBLE(N)
               N2 = NINT(TOP/BOT)
               WRITE (LABEL(1),'(I10)') N
               WRITE (LABEL(2),'(I10)') N1
               WRITE (LABEL(3),'(I10)') N2
               CALL TRIML1 (LABEL(1))
               CALL TRIML1 (LABEL(2))
               CALL TRIML1 (LABEL(3))
               WRITE (NOUT,900) LABEL(1), LABEL(2), LABEL(3)
               WRITE (LINE,900) LABEL(1), LABEL(2), LABEL(3)
               CALL PUTTXT (LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C Help
C
            NTEXT = 20
            WRITE (TEXT,1000)
            FRAME = .FALSE.
            NEXT = .TRUE.
            UPDOWN = .TRUE.
            NTEXT = 20
            NUMBLD(1) = 1
            NUMBLD(7) = 1
            NUMBLD(15) = 1
            NUMBLD(18) = 1
            CALL TUTOR1 (JCOLOR, NUMBLD, NTEXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            NUMBLD(1) = 0
            NUMBLD(7) = 0
            NUMBLD(15) = 0
            NUMBLD(18) = 0
            WRITE (TEXT,2000)
            NUMBLD(1) = 1
            CALL TUTOR1 (JCOLOR, NUMBLD, NTEXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            NUMBLD(1) = 0
            WRITE (TEXT,3000)
            NUMBLD(1) = 1
            NUMBLD(9) = 1
            NUMBLD(17) = 1
            CALL TUTOR1 (JCOLOR, NUMBLD, NTEXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            NUMBLD(1) = 0
            NUMBLD(9) = 0
            NUMBLD(17) = 0
            WRITE (TEXT,4000)
            NUMBLD(1) = 1
            NUMBLD(11) = 1
            NUMBLD(18) = 1
            CALL TUTOR1 (JCOLOR, NUMBLD, NTEXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            NUMBLD(1) = 0
            NUMBLD(11) = 0
            NUMBLD(18) = 0
            WRITE (TEXT,5000)
            NUMBLD(1) = 1
            NUMBLD(11) = 1
            NUMBLD(18) = 1
            CALL TUTOR1 (JCOLOR, NUMBLD, NTEXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            NUMBLD(1) = 0
            NUMBLD(11) = 0
            NUMBLD(18) = 0
            WRITE (TEXT,6000)
            NUMBLD(1) = 1
            NUMBLD(13) = 1
            NUMBLD(18) = 1
            CALL TUTOR1 (JCOLOR, NUMBLD, NTEXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            NUMBLD(1) = 0
            NUMBLD(13) = 0
            NUMBLD(18) = 0
            WRITE (TEXT,7000)
            NUMBLD(1) = 1
            NUMBLD(15) = 1
            NEXT = .FALSE.
            CALL TUTOR1 (JCOLOR, NUMBLD, NTEXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            NUMBLD(1) = 0
            NUMBLD(15) = 0
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
            CALL REVPRO (NOUT)
         ELSE
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Statistical power and sample size calculations'
     +/
     +/'Case 1: 1 binomial sample (1 proportion)'
     +/'Case 2: 2 binomial samples (2 proportions)'
     +/'Case 2: 2 binomial samples (Fisher Exact)'
     +/'Case 3: 1 sample t test (1 mean)'
     +/'Case 4: 2 sample t test (2 means)'
     +/'Case 5: k sample F test (ANOVA, k means)'
     +/'Case 6: 1 or 2 sample variances (chi-sq., F)'
     +/'Case 7: 1 or 2 sample correlations (t, Z)'
     +/'Case 8: chi-square test (non-central chi-sq.)'
     +/'n2 = n*n1/(2*n1 - n) ... unequal sample sizes'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit power and sample size calculations')
  900 FORMAT (
     +' n2(n1,n): n estimated = ',A,'n1 fixed = ',A,
     +'n2 calculated = ',A)
 1000 FORMAT (
     + 'Case 1'
     +/'This is used when you suspect that a binomial parameter has the'
     +/'actual value p0 but you want to know what sample size to use to'
     +/'estimate p0 as p_hat = X/N with an error of at most delta, i.e.'
     +/'|p0 - p_hat| =< delta. You set p0 and delta to get N, etc.'
     +/' '
     +/'Case 2'
     +/'This is when you estimate proportions p1 and p2 for a binomial'
     +/'test or assume theoretical proportions p1 and p2 for a Fisher'
     +/'Exact test with identical sample sizes. You fix a significance'
     +/'level alpha and the required power 100*(1 - beta) then see what'
     +/'n gives this power as p1, p2 are varied. You can input odds'
     +/'ratios or log(odds ratios) instead of the p1, p2 values'
     +/' '
     +/'Plotting Power = f(n)'
     +/'After selecting alpha, p1 and p2 you can plot power = f(n).'
     +/' '
     +/'Case 3'
     +/'This is used when you want to explore the precision with which'
     +/'the mean can be estimated from a normal population.')
 2000 FORMAT (
     + 'Further details concerning case 3 (true mean = mu_0)'
     +/
     +/'h: this is the half-width of the confidence interval for the'
     +/'true mean using a t-distribution with the sample mean and'
     +/'variance (i.e. h = t(alpha|nu)s/sqrt[n]). You input the value'
     +/'required for h and the program estimates the sample size that'
     +/'is necessary if the true mean is to lie in the range defined by'
     +/'X_bar - h < mu_0 < X_bar + h (at the 100*alpha% sig. level).'
     +/'d: this is the minimum difference between the true mean and'
     +/'alternative mean that can be detected, i.e. |mu_0 - mu_1| =< d'
     +/'at the 100*alpha% sig. level with power = 100*(1 - beta)%.'
     +/
     +/'The options (given alpha, beta and s^2) are:'
     +/'Input h: calculate n (beta not required)'
     +/'Input d: calculate n'
     +/'Input n: calculate d'
     +/'Input n and d: calculate beta'
     +/'The program uses a t-distribution, not a normal approximation,'
     +/'and employs iterative methods to locate integer solutions to'
     +/'inequalities bracketing the quantities of interest.')
 3000 FORMAT (
     + 'Case 4 (true means = mu_1 and mu_2)'
     +/
     +/'This is just the same as case 3 except that now h refers to'
     +/'the difference between sample means |X1_bar - X2_bar| and'
     +/'d to the means |mu_1 - mu_2|. Another difference is that the'
     +/'variance estimate is now the pooled estimate of variance and'
     +/'the calculation assumes two equal sample sizes.'
     +/
     +/'Plotting Power = f(n)'
     +/
     +/'First use the main menu to set appropriate values for alpha'
     +/'and the sample variance, then select the Case of interest'
     +/'and decide whether to use a 2-tailed or 1-tailed test. If you'
     +/'are in doubt use default values. You specify the largest sample'
     +/'size of interest, and power = f(n) is plotted up to this limit.'
     +/
     +/'Unequal sample sizes (What to do if n1 does not equal n2)'
     +/
     +/'This is when you find that a sample size of n is required but,'
     +/'as n1 is fixed, you calculate n2 using n2 = n*n1/(2*n1 - n).')
 4000 FORMAT (
     + 'Case 5'
     +/
     +/'This is for Analysis of Variance with these definitions:'
     +/'alpha: significance level'
     +/'beta: power = 100(1 - beta)'
     +/'k: number of groups'
     +/'s^2: variance (assumed identical in each group)'
     +/'n: sample size  (assumed identical in each group)'
     +/'d: minimum detectable difference between group means'
     +/
     +/'Plotting Power = f(n)'
     +/
     +/'You fix parameters of interest then plot power as a function'
     +/'of sample size with a range chosen so that the f(n) curve cuts'
     +/'the required power level. The program then estimates the sample'
     +/'size required for this power.'
     +/
     +/'Calculating Power (after plotting)'
     +/
     +/'This option allows you to calculate power = f(n) accurately')
 5000 FORMAT (
     + 'Case 6'
     +/
     +/'This is for variance ratio tests with these definitions:'
     +/'alpha: significance level'
     +/'beta: power = 100(1 - beta)'
     +/'s0^2: a chosen limiting theoretical variance'
     +/'s1^2: variance estimate in sample 1 (sample size n1)'
     +/'s2^2: variance estimate in sample 2 (sample size n2)'
     +/'n: minimum sample size required (assuming n1 = n2 = n)'
     +/
     +/'1 sample (One-tailed chi-square test)'
     +/'Given s0^2 and s1^2 there are two possible alternatives:'
     +/'H0: sigma^2 =< s0^2, H1: sigma^2 > s0^2'
     +/'H0: sigma^2 >= s0^2, H1: sigma^2 < s0^2, where sigma^2 is the'
     +/'supposed population variance. Statistics depend on the ratio'
     +/'s1^2/s0^2 but it may not always be possible to estimate n.'
     +/
     +/'2 samples (Two-tailed variance ratio F test)'
     +/'This only depends on the larger of s1^2/s2^2 or s2^2/s1^2, so'
     +/'estimation of n is more robust than for the one tailed test.')
 6000 FORMAT (
     + 'Case 7'
     +/
     +/'This tests correlation coefficients with these definitions:'
     +/'alpha: significance level'
     +/'beta: power = 100(1 - beta)'
     +/'R0: a chosen limiting theoretical rho'
     +/'R1: correlation coefficient from sample 1 (size n1)'
     +/'R2: correlation coefficient from sample 2 (size n2)'
     +/'n: minimum sample size required (assuming n1 = n2 = n)'
     +/'Z1 = 0.5*log[(1 + R1)/(1 - R1)]'
     +/'Z2 = 0.5*log[(1 + R2)/(1 - R2)]'
     +/
     +/'1 sample'
     +/'Given R0 and R1 there are two possible alternatives:'
     +/'H0: rho = 0, H1: |rho| > 0'
     +/'H0: rho = 0, H1: |rho| > R0'
     +/
     +/'2 samples'
     +/'Given R1 and R2 calculations depend on |Z1 - Z2| as follows:'
     +/'H0: rho1 = rho2, H1: |rho1 - rho2| > 0.')
 7000 FORMAT (
     + 'Case 8'
     +/
     +/'This calculates for chi-square tests with these definitions:'
     +/'alpha: significance level'
     +/'beta: power = 100(1 - beta)%'
     +/'m: no. of cells, i.e. no. of observed or expected frequencies'
     +/'H0: probabilities are p0(i) for i = 1, 2, ..., m'
     +/'H1: probabilities are p1(i) for i = 1, 2, ..., m'
     +/'ssq = sum of [p0(i) - p1(i)]**2/p0(i) for i = 1, 2, ..., m'
     +/'ndof: m - 1 - no. of parameters estimated from the sample, or'
     +/'ndof: (r - 1)(c - 1) for a r by c contingency table'
     +/'N: minimum sample size given alpha and beta'
     +/'lambda: N*ssq non-central chi-square parameter.'
     +/
     +/'Setting the values for ssq, m and ndof.'
     +/'You can set ssq directly or calculate from p0 and p1 given two'
     +/'vectors of length at least m. The p0, p1 vectors can be either'
     +/'probabilies or frequencies as they are normalised to sum unity'
     +/'when ssq is calculated. For contingency tables set m = r*c and'
     +/'p0(i) and p1(i) as frequencies in either column or row order.')
      END
C
C
