C
C
      SUBROUTINE SPOWFE (NOUT, NPAR, PAR)
C
C ACTION: 2 sample Fisher exact
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 16/12/99
C
C         NOTE: P0 and P1 in this code are PAR(15) and PAR(16) in SPOWPR
C               where they are referred to (as in the menus in this code)
C               as P1 and P2
C
C         02/05/2000 added odds ratio and log(odds ratio)
C         01/01/2003 revised to use SPOWPR
C         18/06/2004 FXPOWER now called APS280
C         17/11/2021 added E_NUMBERS and E_FORMATS, etc.
C
      IMPLICIT   NONE
      INTEGER    NOUT, NPAR
      INTEGER    I, IADD, ICOUNT, IFAIL, ISEND, M, MAXN, N
      INTEGER    JCOUNT, TOTAL
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 0, NUMOPT = 12,
     +           NSTART = 11, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N15, N16
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N7 = 7, N8 = 8, N15 = 15, N16 = 16)
      INTEGER    NMAX
      PARAMETER (NMAX = 2000)
      DOUBLE PRECISION PAR(NPAR)
      DOUBLE PRECISION EPSI, ERROR, TOL
      PARAMETER (EPSI = 1.0D-06, TOL = 1.0D-10)
      DOUBLE PRECISION ALPHA, BETA, P0, P1
      DOUBLE PRECISION BOT, DELTA, DELTA1, DELTA2, F, P, POWER, TOP
      DOUBLE PRECISION OR1, ORLN, ORLOG
      DOUBLE PRECISION X1(NMAX), X2(N2), X3(N1), X4(N1)
      DOUBLE PRECISION Y1(NMAX), Y2(N2), Y3(N1), Y4(N1)
      DOUBLE PRECISION APS280
      DOUBLE PRECISION ZERO, ONE, TEN, FMIN, F100
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, 
     +           TEN = 10.0D+00, FMIN = 0.1D+00, F100 = 100.0D+00)
      DOUBLE PRECISION ORMAX, ORMIN
      PARAMETER (ORMAX = 1.0D+06, ORMIN = ONE/ORMAX)
      CHARACTER (LEN = 13) D13(3), SHOWLJ
      CHARACTER  LINE*100, TEXT(NTEXT)*100, WORD12*12
      CHARACTER  PTITLE*40, XTITLE*30, YTITLE*30
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    AGAIN, NOTYET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    LOGIC1, LOGIC2
      PARAMETER (LOGIC1 = .TRUE., LOGIC2 = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   TRIML1, GETJGE, PUTIFA, LBOX01, PUTTXT, GKS004,
     +           GETDM1, SPOWPR, REVPRO, PUTADV
      EXTERNAL   APS280
      INTRINSIC  DBLE, ABS, LOG, LOG10, EXP
      SAVE       MAXN
      DATA       MAXN / 100 /
      DATA       NUMBLD / NTEXT*N0 /
      DATA       NUMPOS / NUMOPT*N1 /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      ALPHA = PAR(1)
      BETA = PAR(2)
      P0 = PAR(15)
      P1 = PAR(16)
      N = N2
      NUMBLD(N1) = N1
      NUMDEC = N1
      AGAIN = .TRUE.
      OR1 = P1*(ONE - P0)/(P0*(ONE - P1))
      ORLN = LOG(OR1)
      ORLOG = LOG10(OR1)
      DO WHILE (AGAIN)
         POWER = F100*(ONE - BETA)
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) ALPHA, F100*ALPHA, BETA,
     +                       POWER, P0, P1, OR1, ORLN, ORLOG
         ELSE
            D13(1) = SHOWLJ(OR1)
            D13(2) = SHOWLJ(ORLN)
            D13(3) = SHOWLJ(ORLOG)
            WRITE (TEXT,150) ALPHA, F100*ALPHA, BETA,
     +                       POWER, P0, P1, D13(1), D13(2), D13(3)
         ENDIF  
         
         IF (NUMDEC.LT.N1 .OR. NUMDEC.GT.NUMOPT) NUMDEC = N4
         
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.LE.N3 .AND. P0.GE.P1) THEN
            NUMDEC = N0
            CALL PUTADV ('Must have p2 > p1 for 1-tail test power')
         ENDIF
         IF (NUMDEC.EQ.N1) THEN
C
C Use ALPHA, BETA, P0, P1 to calculate N
C
            NOTYET = .TRUE.
            ICOUNT = 0
            I = 1
            DO WHILE (NOTYET .AND. ICOUNT.LT.NMAX)
               ICOUNT = ICOUNT + 1
               IF (I.LT.100) THEN
                  I = I + 1
               ELSEIF (I.LT.200) THEN
                  I = I + 2
               ELSEIF (I.LT.400) THEN
                  I = I + 4
               ELSEIF (I.LT.800) THEN
                  I = I + 8
               ELSEIF (I.LT.1600) THEN
                  I = I + 16
               ELSE
                  I = I + 32
               ENDIF
               M = I
               P = APS280 (M, P0, P1, ALPHA, TOL, ERROR, JCOUNT,
     +                     TOTAL, IFAIL)
               IF (IFAIL.EQ.0) THEN
                  F = F100*P
                  DELTA2 = F - POWER
                  IF (I.EQ.2) DELTA1 = DELTA2
                  IF (ABS(DELTA2).LT.FMIN .OR.
     +                DELTA1*DELTA2.LT.ZERO) THEN
                     NOTYET = .FALSE.
                     N = I
                  ENDIF
                  DELTA1 = DELTA2
               ELSE
                  NOTYET = .FALSE.
               ENDIF
            ENDDO
            IF (IFAIL.NE.0 .OR. NOTYET) THEN
C
C Error
C
               ISEND = 0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               WRITE (WORD12,'(I12)') I
               CALL TRIML1 (WORD12)
               WRITE (LINE,200) ALPHA, BETA, P0, P1, WORD12
               WRITE (NOUT,200) ALPHA, BETA, P0, P1, WORD12
               CALL PUTTXT (LINE)
            ENDIF
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Use ALPHA, P0, P1, N to calculate BETA
C
            DELTA = P1 - P0
            IF (ABS(DELTA).LE.EPSI) THEN
               ISEND = N0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               CALL GETJGE (N, N2,
     +                     'sample size n (same in both groups)')
               P = APS280 (N, P0, P1, ALPHA, TOL, ERROR, JCOUNT,
     +                     TOTAL, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'APS280/SPOWFE')
               IF (IFAIL.EQ.N0) THEN
                  WRITE (WORD12,'(I12)') N
                  CALL TRIML1 (WORD12)
                  WRITE (NOUT,400) ALPHA, P0, P1, F100*P, WORD12
                  WRITE (LINE,400) ALPHA, P0, P1, F100*P, WORD12
                  CALL PUTTXT (LINE)
                  IF (E_NUMBERS) THEN
                     WRITE (NOUT,300) OR1, ORLN, ORLOG
                  ELSE
                     D13(1) = SHOWLJ(OR1)
                     D13(2) = SHOWLJ(ORLN)
                     D13(3) = SHOWLJ(ORLOG)
                     WRITE (NOUT,350) TRIM(D13(1)), TRIM(D13(2)), D13(3)
                  ENDIF  
               ENDIF
            ENDIF
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Plot Power = f(n)
C
            DELTA = P1 - P0
            IF (ABS(DELTA).LE.EPSI) THEN
               ISEND = N0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               I = N1
               CALL GETJGE (MAXN, I, 'Maximum sample size of interest')
               ICOUNT = N0
               I = N1
               DO WHILE (I.LT.MAXN .AND. ICOUNT.LT.NMAX)
                  IF (N.LE.100 .OR. I.LE.50) THEN
                     IADD = 1
                  ELSEIF (I.LE.100) THEN
                     IADD = 2
                  ELSEIF (I.LE.200) THEN
                     IADD = 4
                  ELSEIF (I.LE.400) THEN
                     IADD = 8
                  ELSEIF (I.LE.800) THEN
                     IADD = 16
                  ELSE
                     IADD = 32
                  ENDIF
                  I = I + IADD
                  M = I
                  P = APS280 (M, P0, P1, ALPHA, TOL, ERROR, JCOUNT,
     +                        TOTAL, IFAIL)
                  IF (IFAIL.EQ.N0) THEN
                     ICOUNT = ICOUNT + N1
                     X1(ICOUNT) = DBLE(I)
                     Y1(ICOUNT) = F100*P
                  ENDIF
               ENDDO
               X2(1) = X1(1)
               X2(2) = X1(ICOUNT)
               Y2(1) = POWER
               Y2(2) = POWER
               WRITE (PTITLE,500) P0, P1, ALPHA
               XTITLE = '2-sample test size'
               YTITLE = '%Power (Fisher Exact)'
               CALL GKS004 (N1, N2, N0, N0, N0, N0, N0, N0,
     +                      ICOUNT, N2, N1, N1,
     +                      X1, X2, X3, X4, Y1, Y2, Y3, Y4,
     +                      PTITLE, XTITLE, YTITLE, LOGIC1, LOGIC2)

            ENDIF
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C New p0
C
            ISEND = N15
            CALL SPOWPR (ISEND, NPAR, PAR)
            P0 = PAR(N15)
            OR1 = P1*(ONE - P0)/(P0*(ONE - P1))
            ORLN = LOG(OR1)
            ORLOG = LOG10(OR1)
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C New p1
C
            ISEND = N16
            CALL SPOWPR (ISEND, NPAR, PAR)
            P1 = PAR(N16)
            OR1 = P1*(ONE - P0)/(P0*(ONE - P1))
            ORLN = LOG(OR1)
            ORLOG = LOG10(OR1)
            AGAIN = .TRUE.
         ELSEIF (NUMDEC.EQ.N6) THEN
C
C New odds ratio
C
            BOT = ORMIN
            TOP = ORMAX
            CALL GETDM1 (BOT, OR1, TOP, 'New value for Odds-Ratio')
            P1 = OR1*P0/(ONE - P0 + OR1*P0)
            PAR(N16) = P1
            ORLN = LOG(OR1)
            ORLOG = LOG10(OR1)
         ELSEIF (NUMDEC.EQ.N7) THEN
C
C New ln(odds ratio)
C
            BOT = LOG(ORMIN)
            TOP = LOG(ORMAX)
            CALL GETDM1 (BOT, ORLN, TOP, 'New value for ln(Odds-Ratio)')
            OR1 = EXP(ORLN)
            P1 = OR1*P0/(ONE - P0 + OR1*P0)
            PAR(N16) = P1
            ORLOG = LOG10(OR1)
         ELSEIF (NUMDEC.EQ.N8) THEN
C
C New log10(odds ratio)
C
            BOT = LOG10(ORMIN)
            TOP = LOG10(ORMAX)
            CALL GETDM1 (BOT, ORLOG, TOP,
     +                  'New value for log10(Odds-Ratio)')
            OR1 = TEN**(ORLOG)
            P1 = OR1*P0/(ONE - P0 + OR1*P0)
            PAR(N16) = P1
            ORLN = LOG(OR1)
         ELSEIF (NUMDEC.EQ.NUMOPT - N3) THEN
C
C New alpha
C
            ISEND = N1
            CALL SPOWPR (ISEND, NPAR, PAR)
            ALPHA = PAR(N1)
         ELSEIF (NUMDEC.EQ.NUMOPT - N2) THEN
C
C New beta
C
            ISEND = N2
            CALL SPOWPR (ISEND, NPAR, PAR)
            BETA = PAR(N2)
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            AGAIN = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Fisher Exact power for H0: p1 = p2, H1: p1 > p2'
     +/
     +/'alpha =',F7.4,' (',F7.3,'% significance level)'
     +/'beta =',F7.4,' (',F7.3,'% power)'
     +/'p1 =',F7.4,' [theoretical]'
     +/'p2 =',F7.4,' [theoretical]'
     +/'Odds-ratio =',1P,E11.3
     +/'ln(Odds-Ratio) =',1P,E11.3
     +/'log10(Odds-Ratio) =',1P,E11.3
     +/
     +/'Calculate n'
     +/'Calculate power = f(n)'
     +/'Plot power = f(n)'
     +/'Change p1'
     +/'Change p2'
     +/'Change Odds-Ratio'
     +/'Change ln(Odds-Ratio)'
     +/'Change log10(Odds-Ratio)'
     +/'Change alpha'
     +/'Change beta'
     +/'Results'
     +/'Quit ... Exit Fisher exact power calculations')
  150 FORMAT (
     + 'Fisher Exact power for H0: p1 =< p2, H1: p1 > p2'
     +/
     +/'alpha =',F7.4,' (',F7.3,'% significance level)'
     +/'beta =',F7.4,' (',F7.3,'% power)'
     +/'p1 =',F7.4,' [theoretical]'
     +/'p2 =',F7.4,' [theoretical]'
     +/'Odds-ratio =',1X,A
     +/'ln(Odds-Ratio) =',1X,A
     +/'log10(Odds-Ratio) =',1X,A
     +/
     +/'Calculate n'
     +/'Calculate power = f(n)'
     +/'Plot power = f(n)'
     +/'Change p1'
     +/'Change p2'
     +/'Change Odds-Ratio'
     +/'Change ln(Odds-Ratio)'
     +/'Change log10(Odds-Ratio)'
     +/'Change alpha'
     +/'Change beta'
     +/'Results'
     +/'Quit ... Exit Fisher exact power calculations')   
  200 FORMAT ('alpha =',F7.4,', beta =',F7.4,
     +', p1 =',F7.4,', p2 =',F7.4,', n = ',A)
  300 FORMAT ('Odds-Ratio =',1P,E10.3,', ln(Odds-Ratio) =',E10.3,
     +', log10(Odds ratio) =',E10.3)
  350 FORMAT ('Odds-Ratio =',1X,A,', ln(Odds-Ratio) =',1X,A,
     +', log10(Odds ratio) =',1X,A)   
  400 FORMAT ('alpha =',F7.4,
     +', p1 =',F7.4,', p2 =',F7.4,', power =',F8.3,'%, n = ',A)
  500 FORMAT ('p1=',F5.4,', p2=',F5.4,', alpha=',F5.4)
      END
C
C
