C
C
      SUBROUTINE SPOWN2 (NOUT, NPAR, PAR)
C
C ACTION: tests on 2 normal distributions
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 22/8/98
C
C         NOTE: set FMIN = 0 to force sign change in root finding
C
C         09/12/1999 added plot for power = f(n)
C         01/01/2003 added SPOWPR
C         13/11/2013 added INTENTS and minor editing
C         23/11/2021 added E_NUMBERS and E_FORMATS, etc.
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,           INTENT (IN)   :: NOUT, NPAR
      DOUBLE PRECISION, INTENT (INOUT) :: PAR(NPAR)
C
C Locals
C      
      INTEGER    NMAX
      PARAMETER (NMAX = 2000)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NSTART, NTEXT, NUMOPT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NSTART = 9,
     +           NTEXT = 19, NUMOPT = 11)
      INTEGER    NUMDEC, NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    I, IADD, ICOUNT, IFAIL, ISEND, MAXN, N, NTAILS
      DOUBLE PRECISION ALPHA, BETA, VAR
      DOUBLE PRECISION B, H, H2, D, D2, DI, DF, DN, F, P, P1, P2, T, T1,
     +                 T2
      DOUBLE PRECISION DELTA1, DELTA2, POWER, VAR2
      DOUBLE PRECISION ONE, TWO, FMIN, F100, ZERO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00,
     +           FMIN = 0.01D+00, F100 = 100.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION G01EBF$, G01FBF$
      DOUBLE PRECISION X1(NMAX), X2(N2), X3(N1), X4(N1)
      DOUBLE PRECISION Y1(NMAX), Y2(N2), Y3(N1), Y4(N1)
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      CHARACTER (LEN = 12) I12, FORM12
      CHARACTER (LEN = 10) D10, FORMGR
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      CHARACTER  TAIL*1, TAIL1*1, TAIL2*1
      PARAMETER (TAIL = 'L', TAIL1 = 'L', TAIL2 = 'U')
      CHARACTER  PTITLE*40, XTITLE*20, YTITLE*30
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    NOTYET, REPEET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    LOGIC1, LOGIC2
      PARAMETER (LOGIC1 = .TRUE., LOGIC2 = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, FORMGR, SHOWLJ
      EXTERNAL   LBOX01, PUTTXT, GETJGE, PUTADV, SPOWPR, REVPRO
      EXTERNAL   G01EBF$, G01FBF$
      EXTERNAL   GKS004
      INTRINSIC  ABS, DBLE, SQRT, TRIM
      SAVE       MAXN, N, NTAILS
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT* 1 /
      DATA       MAXN, N, NTAILS / 100, 20, 2 /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      ALPHA = PAR(1)
      BETA = PAR(2)
      VAR = PAR(4)
      H = PAR(12)
      D = PAR(13)
      NUMBLD(1) = 1
      NUMDEC = NUMOPT
      REPEET = .TRUE.
C
C Main loop
C
      DO WHILE (REPEET)
         POWER = F100*(ONE - BETA)
         VAR2 = TWO*VAR
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) NTAILS, ALPHA, F100*ALPHA, BETA,
     +                       POWER, VAR
         ELSE
            D13(1) = SHOWLJ(VAR)  
            WRITE (TEXT,150) NTAILS, ALPHA, F100*ALPHA, BETA,
     +                       POWER, TRIM(D13(1))
         ENDIF  
         NUMBLD(1) = 4
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (NUMDEC.LE.5) THEN
            IF (NTAILS.EQ.1) THEN
               P = ONE - ALPHA
            ELSE
               P = ONE - ALPHA/TWO
            ENDIF
            P1 = P
            P2 = BETA
         ENDIF
         IF (NUMDEC.EQ.1) THEN
C
C Input h then calculate n (Zar eqn.8.20)
C
            ISEND = 12
            CALL SPOWPR (ISEND, NPAR, PAR)
            H = PAR(12)
            H2 = H**2
            NOTYET = .TRUE.
            IFAIL = 0
            ICOUNT = 0
            I = 1
            DO WHILE (NOTYET .AND. ICOUNT.LT.NMAX)
               ICOUNT = ICOUNT + 1
               IF (I.LT.100) THEN
                  I = I + 1
               ELSEIF (I.LT.200) THEN
                  I = I + 2
               ELSEIF (I.LT.400) THEN
                  I = I + 4
               ELSEIF (I.LT.800) THEN
                  I = I + 8
               ELSEIF (I.LT.1600) THEN
                  I = I + 16
               ELSE
                  I = I + 32
               ENDIF
               DI = DBLE(I)
               DF = TWO*(DI - ONE)
               T = G01FBF$(TAIL, P, DF, IFAIL)
               IF (IFAIL.EQ.0) THEN
                  T2 = T**2
                  F = VAR2*T2/H2
                  DELTA2 = F - DI
                  IF (I.EQ.2) DELTA1 = DELTA2
                  IF (ABS(DELTA2).LT.FMIN .OR.
     +                DELTA1*DELTA2.LT.ZERO) THEN
                     NOTYET = .FALSE.
                     N = I
                  ENDIF
                  DELTA1 = DELTA2
               ELSE
                  NOTYET = .FALSE.
               ENDIF
            ENDDO
            IF (IFAIL.NE.0 .OR. NOTYET) THEN
C
C Error
C
               ISEND = 0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (LINE,200) H, ALPHA, VAR, N
                  WRITE (NOUT,200) H, ALPHA, VAR, N
               ELSE
                  D13(1) = SHOWLJ(H)
                  D13(2) = SHOWLJ(VAR)
                  I12 = FORM12(N)
                  WRITE (LINE,250) TRIM(D13(1)), ALPHA, TRIM(D13(2)),
     +                             I12
                  WRITE (NOUT,250) TRIM(D13(1)), ALPHA, TRIM(D13(2)),
     +                             I12
               ENDIF  
               CALL PUTTXT (LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Input d then calculate n (Zar eqn. 8.22)
C
            ISEND = 13
            CALL SPOWPR (ISEND, NPAR, PAR)
            D = PAR(13)
            D2 = D**2
            NOTYET = .TRUE.
            IFAIL = 0
            ICOUNT = 0
            I = 1
            DO WHILE (NOTYET .AND. ICOUNT.LT.NMAX)
               ICOUNT = ICOUNT + 1
               IF (I.LT.100) THEN
                  I = I + 1
               ELSEIF (I.LT.200) THEN
                  I = I + 2
               ELSEIF (I.LT.400) THEN
                  I = I + 4
               ELSEIF (I.LT.800) THEN
                  I = I + 8
               ELSEIF (I.LT.1600) THEN
                  I = I + 16
               ELSE
                  I = I + 32
               ENDIF
               DI = DBLE(I)
               DF = TWO*(DI - ONE)
               T1 = G01FBF$(TAIL1, P1, DF, IFAIL)
               IF (IFAIL.EQ.0) THEN
                  T2 = G01FBF$(TAIL2, P2, DF, IFAIL)
                  IF (IFAIL.EQ.0) THEN
                     F = VAR2*(T1 + T2)**2/D2
                     DELTA2 = F - DI
                     IF (I.EQ.2) DELTA1 = DELTA2
                     IF (ABS(DELTA2).LT.FMIN .OR.
     +                  DELTA1*DELTA2.LT.ZERO) THEN
                        NOTYET = .FALSE.
                        N = I
                     ENDIF
                  ELSE
                     NOTYET = .FALSE.
                  ENDIF
               ELSE
                  NOTYET = .FALSE.
               ENDIF
            ENDDO
            IF (IFAIL.NE.0 .OR. NOTYET) THEN
C
C Error
C
               ISEND = 0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (LINE,300) D, ALPHA, BETA, VAR, N
                  WRITE (NOUT,300) D, ALPHA, BETA, VAR, N
               ELSE
                  D13(1) = SHOWLJ(D)
                  D13(2) = SHOWLJ(VAR)
                  I12 = FORM12(N)  
                  WRITE (LINE,350) TRIM(D13(1)), ALPHA, BETA,
     +                             TRIM(D13(2)), I12
                  WRITE (NOUT,350) TRIM(D13(1)), ALPHA, BETA,
     +                             TRIM(D13(2)), I12
               ENDIF  
               CALL PUTTXT (LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Input n then calculate d (Zar eqn. 8.23)
C
            I = 2
            CALL GETJGE (N, I, 'The sample size intended (n)')
            DN = DBLE(N)
            IFAIL = 0
            DF = TWO*(DN - ONE)
            T1 = G01FBF$(TAIL1, P1, DF, IFAIL)
            IF (IFAIL.EQ.0) THEN
               T2 = G01FBF$(TAIL2, P2, DF, IFAIL)
               IF (IFAIL.EQ.0) D = SQRT(VAR2/DN)*(T1 + T2)
            ENDIF
            IF (IFAIL.NE.0) THEN
C
C Error
C
               ISEND = 0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (LINE,400) N, ALPHA, BETA, VAR, D
                  WRITE (NOUT,400) N, ALPHA, BETA, VAR, D
               ELSE
                  I12 = FORM12(N)
                  D13(1) = SHOWLJ(VAR)
                  D13(2) = SHOWLJ(D)
                  WRITE (LINE,450) TRIM(I12), ALPHA, BETA, TRIM(D13(1)),
     +                             D13(2)
                  WRITE (NOUT,450) TRIM(I12), ALPHA, BETA, TRIM(D13(1)),
     +                             D13(2)
               ENDIF  
               CALL PUTTXT (LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Input n and d then estimate beta (Zar eqn. 8.24)
C
            ISEND = 13
            CALL SPOWPR (ISEND, NPAR, PAR)
            D = PAR(13)
            I = 2
            CALL GETJGE (N, I, 'The sample size intended (n)')
            DN = DBLE(N)
            IFAIL = 0
            DF = TWO*(DN - ONE)
            T1 = G01FBF$(TAIL1, P1, DF, IFAIL)
            IF (IFAIL.EQ.0) THEN
               T2 = D/SQRT(VAR2/DN) - T1
               B = G01EBF$(TAIL2, T2, DF, IFAIL)
               IF (IFAIL.EQ.0) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,500) N, D, ALPHA, VAR, B
                     WRITE (NOUT,500) N, D, ALPHA, VAR, B
                  ELSE
                     I12 = FORM12(N)
                     D13(1) = SHOWLJ(D)
                     D13(2) = SHOWLJ(VAR)
                     WRITE (LINE,550) TRIM(I12), TRIM(D13(1)), ALPHA,
     +                                TRIM(D13(2)), B
                     WRITE (NOUT,550) TRIM(I12), TRIM(D13(1)), ALPHA,
     +                                TRIM(D13(2)), B
                   ENDIF 
                  CALL PUTTXT (LINE)
               ELSE
C
C Error
C
                  ISEND = 0
                  CALL SPOWPR (ISEND, NPAR, PAR)
               ENDIF
            ELSE
C
C Error
C
               ISEND = 0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ENDIF
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Input n and d then plot beta
C
            ISEND = 13
            CALL SPOWPR (ISEND, NPAR, PAR)
            D = PAR(13)
            I = 1
            CALL GETJGE (MAXN, I, 'Maximum sample size of interest (n)')
            N = MAXN
            ICOUNT = 0
            I = 1
            DO WHILE (I.LT.N .AND. ICOUNT.LT.NMAX)
               IF (N.LE.100 .OR. I.LE.50) THEN
                  IADD = 1
               ELSEIF (I.LE.100) THEN
                  IADD = 2
               ELSEIF (I.LE.200) THEN
                  IADD = 4
               ELSEIF (I.LE.400) THEN
                  IADD = 8
               ELSEIF (I.LE.800) THEN
                 IADD = 16
               ELSE
               IADD = 32
               ENDIF
               I = I + IADD
               DN = DBLE(I)
               IFAIL = 0
               DF = TWO*(DN - ONE)
               T1 = G01FBF$(TAIL1, P1, DF, IFAIL)
               IF (IFAIL.EQ.0) THEN
                  T2 = D/SQRT(VAR2/DN) - T1
                  B = G01EBF$(TAIL2, T2, DF, IFAIL)
                  IF (IFAIL.EQ.0) THEN
                     ICOUNT = ICOUNT + 1
                     X1(ICOUNT) = DBLE(I)
                     Y1(ICOUNT) = F100*(ONE - B)
                  ENDIF
               ENDIF
            ENDDO
            X2(1) = X1(1)
            X2(2) = X1(ICOUNT)
            Y2(1) = POWER
            Y2(2) = POWER
            IF (E_NUMBERS) THEN
               WRITE (PTITLE,700) NTAILS, ALPHA, D
            ELSE
               D10 = FORMGR(D)
               WRITE (PTITLE,750) NTAILS, ALPHA, D10  
            ENDIF  
            XTITLE = '2-sample test size'
            IF (E_NUMBERS) THEN
               WRITE (YTITLE,800) VAR
            ELSE
               D10 = FORMGR(VAR)  
               WRITE (YTITLE,850) TRIM(D10)
            ENDIF    
            CALL GKS004 (N1, N2, N0, N0, N0, N0, N0, N0,
     +                   ICOUNT, N2, N1, N1,
     +                   X1, X2, X3, X4, Y1, Y2, Y3, Y4,
     +                   PTITLE, XTITLE, YTITLE, LOGIC1, LOGIC2)
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Change number of tails
C
            IF (NTAILS.EQ.1) THEN
               NTAILS = 2
            ELSE
               NTAILS = 1
            ENDIF
            WRITE (LINE,600) NTAILS
            CALL PUTADV (LINE)
            NUMDEC = 2
         ELSEIF (NUMDEC.EQ.7) THEN
C
C alpha
C
            ISEND = 1
            CALL SPOWPR (ISEND, NPAR, PAR)
            ALPHA = PAR(1)
         ELSEIF (NUMDEC.EQ.8) THEN
C
C beta
C
            ISEND = 2
            CALL SPOWPR (ISEND, NPAR, PAR)
            BETA = PAR(2)
         ELSEIF (NUMDEC.EQ.9) THEN
C
C Variance
C
            ISEND = 4
            CALL SPOWPR (ISEND, NPAR, PAR)
            VAR = PAR(4)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     +I2,' tail t test calculations (2 normal distributions)'
     +/
     +/'Current alpha =',F7.4,' (',F7.2,'% sig. level)'
     +/'Current beta =',F7.4,' (',F7.2,'% power)'
     +/'Current s^2 =',1P,E10.3,'  (sample variance)'
     +/'h = conf. region half width as in (X1_bar - X2_bar) +/- h'
     +/'d = min. difference between mu_1 and mu_2'
     +/
     +/'Input h: calculate n'
     +/'Input d: calculate n'
     +/'Input n: calculate d'
     +/'Input d: calculate beta = f(n)'
     +/'Input d: plot power = f(n)'
     +/'Change number of tails'
     +/'Change alpha'
     +/'Change beta'
     +/'Change s^2'
     +/'Results'
     +/'Quit ... Exit power tests for two normal distributions')
  150 FORMAT (
     +I2,' tail t test calculations (2 normal distributions)'
     +/
     +/'Current alpha =',F7.4,' (',F7.2,'% sig. level)'
     +/'Current beta =',F7.4,' (',F7.2,'% power)'
     +/'Current s^2 =',1X,A,'  (sample variance)'
     +/'h = conf. region half width as in (X1_bar - X2_bar) +/- h'
     +/'d = min. difference between mu_1 and mu_2'
     +/
     +/'Input h: calculate n'
     +/'Input d: calculate n'
     +/'Input n: calculate d'
     +/'Input d: calculate beta = f(n)'
     +/'Input d: plot power = f(n)'
     +/'Change number of tails'
     +/'Change alpha'
     +/'Change beta'
     +/'Change s^2'
     +/'Results'
     +/'Quit ... Exit power tests for two normal distributions')    
  200 FORMAT ('h =',1P,E10.3,', alpha =',0P,F7.4,
     +', s^2 =',1P,E10.3,': n =',I6)
  250 FORMAT ('h =',1X,A,', alpha =',F7.4,
     +', s^2 =',1X,A,': n =',1X,A)   
  300 FORMAT ('d =',1P,E10.3,', alpha =',0P,F7.4,', beta =',F7.4,
     +', s^2 =',1P,E10.3,': n =',I6)
  350 FORMAT ('d =',1X,A,', alpha =',F7.4,', beta =',F7.4,
     +', s^2 =',1X,A,': n =',1X,A)    
  400 FORMAT ('n =',I6,', alpha =',F7.4,', beta =',F7.4,
     +', s^2 =',1P,E10.3,': d =',E10.3)
  450 FORMAT ('n =',1X,A,', alpha =',F7.4,', beta =',F7.4,
     +', s^2 =',1X,A,': d =',1X,A)   
  500 FORMAT ('n =',I6,', d =',1P,E10.3,', alpha =',0P,F7.4,
     +', s^2 =',1P,E10.3,': beta =',0P,F7.4)
  550 FORMAT ('n =',1X,A,', d =',1X,A,', alpha =',F7.4,
     +', s^2 =',1X,A,': beta =',F7.4)   
  600 FORMAT ('Calculations will now be for ',I1,' tailed tests')
  700 FORMAT (I1,'-Tail t,alpha=',F5.4,',d=',1P,E9.3)
  750 FORMAT (I1,'-Tail t,alpha=',F5.4,',d=',A)
  800 FORMAT ('%Power (s^2=',1P,E9.3,')')
  850 FORMAT ('%Power (s^2=',A,')')
      END
C
C
