C
C
      SUBROUTINE SPOWNK (NOUT, NPAR, PAR)
C
C ACTION: Power calculations for ANOVA
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 21/12/99
C         After Zar: Biostatistical analysis, 3rd edition p.194
C         and Pearson and Hartley, Biometrika, 1951, 38 p.112-130
C         22/12/2002 added call to SPOWPR
C         24/11/2021 added E_NUMBERS and E_FORMATS, etc.
C 
      IMPLICIT   NONE
      INTEGER    NOUT, NPAR
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    MAXIT, NMAX
      PARAMETER (MAXIT = 250, NMAX = 2000)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NSTART, NTEXT, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 0, NSTART = 10,
     +           NUMOPT = 10, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    I, IADD, ICOUNT, IFAIL, ISEND, J, K, L, M1, M2, N
      DOUBLE PRECISION PAR(NPAR)
      DOUBLE PRECISION ALPHA, BETA, VAR
      DOUBLE PRECISION BETA1, DELTA, DF1, DF2, DK, DKI, DN, DNI, F, P,
     +                 PHI2, POWER, POWER1, RLAMDA
      DOUBLE PRECISION X1(NMAX), X2(N2), X3(N1), X4(N1)
      DOUBLE PRECISION Y1(NMAX), Y2(N2), Y3(N1), Y4(N1)
      DOUBLE PRECISION G01GDF$, G01FDF$
      DOUBLE PRECISION ONE, TWO, F100, TOL
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, F100 = 100.0D+00,
     +           TOL = 5.0D-06)
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER (LEN = 10) D10, FORMGR
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      CHARACTER  PTITLE*40, XTITLE*30, YTITLE*30
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    AGAIN
      LOGICAL    LOGIC1, LOGIC2, LOGIC3
      PARAMETER (LOGIC1 = .FALSE., LOGIC2 = .FALSE., LOGIC3 = .TRUE.)
      LOGICAL    PLOT1, PLOT2
      PARAMETER (PLOT1 = .TRUE., PLOT2 = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, FORMGR, SHOWLJ
      EXTERNAL   LBOX01, PUTTXT, GETJGE, PUTIFA, GKS004, SPOWPR, REVPRO
      EXTERNAL   G01GDF$, G01FDF$
      INTRINSIC  DBLE, NINT, TRIM
      SAVE       K, L, N
      DATA       K, L, N / 4, 100, 20 /
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      ALPHA = PAR(1)
      BETA = PAR(2)
      VAR = PAR(4)
      DELTA = PAR(13)
      NUMBLD(1) = 1
      NUMDEC = NUMOPT
      AGAIN = .TRUE.
C
C Main loop
C
      DO WHILE (AGAIN)
         POWER = F100*(ONE - BETA)
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) ALPHA, F100*ALPHA, BETA, POWER, VAR, DELTA,
     +                       K, N
         ELSE
            D13(1) = SHOWLJ(VAR)
            D13(2) = SHOWLJ(DELTA)
            I12(1) = FORM12(K)
            I12(2) = FORM12(N)
            WRITE (TEXT,150) ALPHA, F100*ALPHA, BETA, POWER,
     +                       TRIM(D13(1)), TRIM(D13(2)),
     +                       TRIM(I12(1)), TRIM(I12(2)) 
         ENDIF  
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, TEXT,
     +                LOGIC1, LOGIC2, LOGIC3)


         IF (NUMDEC.EQ.1) THEN
c
c Change ALPHA
c
            ISEND = 1
            CALL SPOWPR (ISEND, NPAR, PAR)
            ALPHA = PAR(1)
         ELSEIF (NUMDEC.EQ.2) THEN
c
c Change BETA
c
            ISEND = 2
            CALL SPOWPR (ISEND, NPAR, PAR)
            BETA = PAR(2)
         ELSEIF (NUMDEC.EQ.3) THEN
c
c Change VAR
c
            ISEND = 4
            CALL SPOWPR (ISEND, NPAR, PAR)
            VAR = PAR(4)
         ELSEIF (NUMDEC.EQ.4) THEN
c
c Change DELTA
c
            ISEND = 13
            CALL SPOWPR (ISEND, NPAR, PAR)
            DELTA = PAR(13)
         ELSEIF (NUMDEC.EQ.5) THEN
c
c Change k
c
            IFAIL = 2
            CALL GETJGE (K, IFAIL, 'Number of groups required (i.e. k)')
         ELSEIF (NUMDEC.EQ.6) THEN
c
c Change n
c
            IFAIL = 2
            CALL GETJGE (N, IFAIL, 'Sample size required (i.e. n)')
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Define parameters
C
            DK = DBLE(K)
            DN = DBLE(N)
            DF1 = DK - ONE
            DF2 = DK*(DN - ONE)
C
C Calculate the F value
C
            P = ONE - ALPHA
            IFAIL = 1
            F = G01FDF$(P, DF1, DF2, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FDF/SPOWNK')
C
C Calculate PHI^2 (ZAR section 10.3, p194, third edition
C
            IF (IFAIL.EQ.0) THEN
               PHI2 = DN*DELTA**2/(TWO*DK*VAR)
C
C Calculate LAMBDA (Pearson and Hartley, Biometrika 1951, 38, 112-130
C
               RLAMDA = PHI2*(DF1 + ONE)
C
C Calculate BETA
C
               IFAIL = 1
               BETA1 = G01GDF$(F, DF1, DF2, RLAMDA, TOL, MAXIT, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01GDF/SPOWNK')
               IF (IFAIL.EQ.0) THEN
                  POWER1 = F100*(ONE - BETA1)
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,200) ALPHA, VAR, DELTA, K, N, POWER1
                     WRITE (NOUT,200) ALPHA, VAR, DELTA, K, N, POWER1
                  ELSE
                     D13(1) = SHOWLJ(VAR)
                     D13(2) = SHOWLJ(DELTA)
                     I12(1) = FORM12(K)
                     I12(2) = FORM12(N) 
                     WRITE (LINE,250) ALPHA, TRIM(D13(1)), TRIM(D13(2)),
     +                                TRIM(I12(1)), TRIM(I12(2)), POWER1
                     WRITE (NOUT,250) ALPHA, TRIM(D13(1)), TRIM(D13(2)),
     +                                TRIM(I12(1)), TRIM(I12(2)), POWER1
                  ENDIF  
                  CALL PUTTXT (LINE)
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Plot
C
            I = 2
            IF (L.LT.I) L = I
            CALL GETJGE (L, I,
     +                  'The maximum sample size of interest (n)')
            ICOUNT = 0
            I = 1
            DO WHILE (I.LT.L .AND. ICOUNT.LT.NMAX)
               IF (L.LE.100 .OR. I.LE.50) THEN
                  IADD = 1
               ELSEIF (I.LE.100) THEN
                  IADD = 2
               ELSEIF (I.LE.200) THEN
                  IADD = 4
               ELSEIF (I.LE.400) THEN
                  IADD = 8
               ELSEIF (I.LE.800) THEN
                  IADD = 16
               ELSE
                  IADD = 32
               ENDIF
               I = I + IADD
C
C Define parameters (using K as before but using I now, not N)
C
               DKI = DBLE(K)
               DNI = DBLE(I)
               DF1 = DKI - ONE
               DF2 = DKI*(DNI - ONE)

C
C Calculate the F value
C
               P = ONE - ALPHA
               IFAIL = 1
               F = G01FDF$(P, DF1, DF2, IFAIL)
C
C Calculate PHI^2 (ZAR section 10.3, p194, third edition
C
               IF (IFAIL.EQ.0) THEN
                  PHI2 = DNI*DELTA**2/(TWO*DKI*VAR)
C
C Calculate LAMBDA (Pearson and Hartley, Biometrika 1951, 38, 112-130
C
                  RLAMDA = PHI2*(DF1 + ONE)
C
C Calculate BETA
C
                  IFAIL = 1
                  BETA1 = G01GDF$(F, DF1, DF2, RLAMDA, TOL, MAXIT,
     +                            IFAIL)
                  IF (IFAIL.EQ.0) THEN
                     POWER1 = F100*(ONE - BETA1)
                     ICOUNT = ICOUNT + 1
                     X1(ICOUNT) = DNI
                     Y1(ICOUNT) = POWER1
                  ENDIF
               ENDIF
            ENDDO
            IF (E_NUMBERS) THEN
               WRITE (PTITLE,300) ALPHA, DELTA
               WRITE (XTITLE,400) K
               WRITE (YTITLE,500) VAR
            ELSE
               D10 = FORMGR(DELTA)
               WRITE (PTITLE,350) ALPHA, D10
               I12(1) = FORM12(K)
               WRITE (XTITLE,450) TRIM(I12(1))
               D10 = FORMGR(VAR) 
               WRITE (YTITLE,550) TRIM(D10) 
            ENDIF  
            X2(1) = X1(1)
            X2(2) = X1(ICOUNT)
            Y2(1) = POWER
            Y2(2) = Y2(1)
            CALL GKS004 (N1, N2, N0, N0, N0, N0, N0, N0,
     +                   ICOUNT, N2, N1, N1,
     +                   X1, X2, X3, X4, Y1, Y2, Y3, Y4,
     +                   PTITLE, XTITLE, YTITLE, PLOT1, PLOT2)
            IF (Y1(2).LT.POWER .AND. Y1(ICOUNT).GT.POWER) THEN
               M1 = N0
               M2 = N0
               I = N0
               J = I + N1
               DO WHILE (M1.EQ.N0 .AND. J.LT.ICOUNT)
                  I = I + N1
                  J = I + N1
                  IF (Y1(I).LE.POWER .AND. Y1(J).GE.POWER) THEN
                     M1 = NINT(X1(I))
                     M2 = NINT(X1(J))
                  ENDIF
               ENDDO
               IF (M1.GT.N0 .AND. M2.GT.M1) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,200) ALPHA, VAR, DELTA, K, M2, Y1(J)
                     WRITE (NOUT,200) ALPHA, VAR, DELTA, K, M2, Y1(J)
                  ELSE
                     D13(1) = SHOWLJ(VAR)
                     D13(2) = SHOWLJ(DELTA)
                     I12(1) = FORM12(K)
                     I12(2) = FORM12(M2) 
                     WRITE (LINE,250) ALPHA, TRIM(D13(1)), TRIM(D13(2)),
     +                                TRIM(I12(1)), TRIM(I12(2)), Y1(J)
                     WRITE (NOUT,250) ALPHA, TRIM(D13(1)), TRIM(D13(2)),
     +                                TRIM(I12(1)), TRIM(I12(2)), Y1(J)
                  ENDIF  
                  CALL PUTTXT (LINE)
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Power calculations for Analysis of Variance'
     +/
     +/'alpha =',F7.4,' (',F7.2,'% sig. level)'
     +/'beta =',F7.4,' (',F7.2,'% power)'
     +/'s^2 =',1P,E10.3,' (variance)'
     +/'d =',1P,E10.3,' (difference between means)'
     +/'k =',I4,' (number of groups)'
     +/'n =',I6,' (sample size per group)'
     +/
     +/'Change alpha'
     +/'Change beta'
     +/'Change s^2'
     +/'Change d'
     +/'Change k'
     +/'Change n'
     +/'Calculate Power'
     +/'Plot-Power/Calculate-n'
     +/'Results'
     +/'Quit ... Exit ANOVA power calculations')
  150 FORMAT (
     + 'Power calculations for Analysis of Variance'
     +/
     +/'alpha =',F7.4,' (',F7.2,'% sig. level)'
     +/'beta =',F7.4,' (',F7.2,'% power)'
     +/'s^2 =',1X,A,' (variance)'
     +/'d =',1X,A,' (difference between means)'
     +/'k =',1X,A,' (number of groups)'
     +/'n =',1X,A,' (sample size per group)'
     +/
     +/'Change alpha'
     +/'Change beta'
     +/'Change s^2'
     +/'Change d'
     +/'Change k'
     +/'Change n'
     +/'Calculate Power'
     +/'Plot-Power/Calculate n'
     +/'Results'
     +/'Quit ... Exit ANOVA power calculations')   
  200 FORMAT ('alpha =',F7.4,', s^2 =',1P,E8.2,', d =',E8.2,', k =',I4,
     +', n =',I6,', Power =',0P,F7.2,'%')
  250 FORMAT ('alpha =',F7.4,', s^2 =',1X,A,', d =',1X,A,', k =',1X,A,
     +', n =',1X,A,', Power =',F7.2,'%')     
  300 FORMAT ('ANOVA:alpha=',F5.4,',d=',1P,E9.3)
  350 FORMAT ('ANOVA:alpha=',F5.4,',d=',A)
  400 FORMAT ('Sample Size n (k =',I4,')')
  450 FORMAT ('Sample Size n (k =',1X,A,')')
  500 FORMAT ('%Power (s^2=',1P,E9.3,')')
  550 FORMAT ('%Power (s^2=',A,')')
      END

C
C
