C
C
      SUBROUTINE SPOWPR (ISEND, NPAR, PAR)
C
C action: return parameters for power calculations
C author: w.g.bardsley, university of manchester, u.k., 22/12/2002
C
C         ISEND = -1: failure to calculate n
C         ISEND =  0: singular calculation
C         ISEND =  1: alpha
C         ISEND =  2: beta
C         ISEND =  3: p0
C         ISEND =  4: s^2 = s1^2
C         ISEND =  5: s2^2
C         ISEND =  6: sigma0^2
C         ISEND =  7: R = R1
C         ISEND =  8: R2
C         ISEND =  9: R0
C         ISEND = 10: 0 < delta < 1
C         ISEND = 11: p1 sample
C         ISEND = 12: h
C         ISEND = 13: d
C         ISEND = 14: p2 sample
C         ISEND = 15: p1 theory
C         ISEND = 16: p2 theory
C
      IMPLICIT   NONE
      INTEGER    ISEND, NPAR
      DOUBLE PRECISION PAR(NPAR)
      DOUBLE PRECISION ALPHA, BETA, D, DELTA, H, P, R, VAR
      DOUBLE PRECISION BOT, TOP
      DOUBLE PRECISION EPSI, ONE, ZTOL
      PARAMETER (EPSI = 1.0D-06, ONE = 1.0D+00, ZTOL = 1.0D-10)
      EXTERNAL   GETDM1, GETDGE, PUTFAT, PUTWAR
      INTRINSIC  ABS
      IF (ISEND.LE.NPAR .AND. ISEND.GE.-1 .AND. ISEND.LE.16) THEN
         IF (ISEND.EQ.-1) THEN
C
C Failure to calculate n
C
            CALL PUTWAR (
     +'Calculation failed ... Change parameters or test procedure')
         ELSEIF (ISEND.EQ.0) THEN
C
C Singular calculation
C
            CALL PUTFAT (
     +     'Calculation is singular for the current parameters')
         ELSEIF (ISEND.EQ.1) THEN
C
C Re-set alpha
C
            ALPHA = PAR(1)
            BOT = EPSI
            TOP = ONE - EPSI
            CALL GETDM1 (BOT, ALPHA, TOP,
     +     'alpha required ... usually 0.05 (5%) or 0.01 (1%)')
            PAR(1) = ALPHA
         ELSEIF (ISEND.EQ.2) THEN
C
C Re-set beta
C
            BETA = PAR(2)
            BOT = EPSI
            TOP = ONE - EPSI
            CALL GETDM1 (BOT, BETA, TOP,
     +'beta required ... usually 0.3 (70%), 0.2 (80%) or 0.1 (90%)')
            PAR(2) = BETA
         ELSEIF (ISEND.EQ.3) THEN
C
C Re-set P0
C
            P = PAR(3)
            BOT = EPSI
            TOP = ONE - EPSI
            CALL GETDM1 (BOT, P, TOP,
     +     'p0 required ... the theoretical binomial parameter')
            PAR(3) = P
         ELSEIF (ISEND.EQ.4) THEN
C
C Re-set sigma squared
C
            VAR = PAR(4)
            CALL GETDGE (VAR, EPSI,
     +     's1^2 required ... the sample variance')
            PAR(4) = VAR
         ELSEIF (ISEND.EQ.5) THEN
C
C Re-set sigma2 squared
C
            VAR = PAR(5)
            CALL GETDGE (VAR, EPSI,
     +     's2^2 required ... the second sample variance')
            PAR(5) = VAR
         ELSEIF (ISEND.EQ.6) THEN
C
C Re-set theoretical sigma squared
C
            VAR = PAR(6)
            CALL GETDGE (VAR, EPSI,
     +     'sig0^2 required ... the theoretical variance limit')
            PAR(6) = VAR
         ELSEIF (ISEND.EQ.7) THEN
C
C Correlation coefficient
C

            R = PAR(7)
            TOP = ONE - EPSI
            BOT = - TOP
            CALL GETDM1 (BOT, R, TOP,
     +'R required ... sample corr. coefficient (not R-squared)')
            PAR(7) = R
         ELSEIF (ISEND.EQ.8) THEN
C
C Correlation coefficient
C

            R = PAR(8)
            TOP = ONE - EPSI
            BOT = - TOP
            CALL GETDM1 (BOT, R, TOP,
     +'R2 required ... second sample corr. coefficient (not R-squared)')
            PAR(8) = R
         ELSEIF (ISEND.EQ.9) THEN
C
C Correlation coefficient
C

            R = PAR(9)
            TOP = ONE - EPSI
            BOT = - TOP
            CALL GETDM1 (BOT, R, TOP,
     +'R0 required ... theoretical corr. coeff. (used to estimate N)')
            PAR(9) = ABS(R)
            IF (PAR(9).LT.EPSI) PAR(9) = EPSI
         ELSEIF (ISEND.EQ.10) THEN
C
C Delta
C
            DELTA = PAR(10)
            BOT = EPSI
            TOP = ONE - EPSI
            CALL GETDM1 (BOT, DELTA, TOP,
     +'Delta ... maximum error allowed in binomial parameter estimate')
            PAR(10) = DELTA
         ELSEIF (ISEND.EQ.11) THEN
C
C Re-set P1
C
            P = PAR(11)
            BOT = EPSI
            TOP = ONE - EPSI
            CALL GETDM1 (BOT, P, TOP,
     +'p1 required ... binomial parameter estimated from sample 1')
            PAR(11) = P
         ELSEIF (ISEND.EQ.12) THEN
C
C Re-set half width h
C
            H = PAR(12)
            CALL GETDGE (H, ZTOL,
     +     'h-value required ... minimum detectable half width')
            PAR(12) = H
         ELSEIF (ISEND.EQ.13) THEN
C
C Re-set difference d
C
            D = PAR(13)
            CALL GETDGE (D, ZTOL,
     +     'd-value required ... minimum detectable difference')
            PAR(13) = D
         ELSEIF (ISEND.EQ.14) THEN
C
C Re-set P2
C
            P = PAR(14)
            BOT = EPSI
            TOP = ONE - EPSI
            CALL GETDM1 (BOT, P, TOP,
     +'p2 required ... binomial parameter estimated from sample 2')
            PAR(14) = P
         ELSEIF (ISEND.EQ.15) THEN
C
C Re-set P1
C
            P = PAR(15)
            BOT = EPSI
            TOP = ONE - EPSI
            CALL GETDM1 (BOT, P, TOP,
     +'p1 (theoretical) ... for Fisher exact H0: p1 = p2, H1: p1 > p2')
            PAR(15) = P
         ELSEIF (ISEND.EQ.16) THEN
C
C Re-set P2
C
            P = PAR(16)
            BOT = EPSI
            TOP = ONE - EPSI
            CALL GETDM1 (BOT, P, TOP,
     +'p2 (theoretical) ... for Fisher exact H0: p1 = p2, H1: p1 > p2')
            PAR(16) = P
         ENDIF
      ELSE
         CALL PUTFAT ('ISEND out of range in call to SPOWPR')
      ENDIF
      END
c
c
