C
C
      SUBROUTINE SPOWVR (NOUT, NPAR, PAR)
C
C ACTION: tests on 1, 2 variances
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 23/12/2002
C         26/11/2021 added E_NUMBERS and E_FORMATS, etc.
C
C         NOTE: FMIN is the smallest difference in the iteration so
C               FMIN = 0 forces a sign change in the root finding
C
      IMPLICIT   NONE
      INTEGER    NOUT, NPAR
      INTEGER    NMAX
      PARAMETER (NMAX = 2000)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NSTART, NTEXT, NUMOPT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NSTART = 9,
     +           NUMOPT = 11, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMDEC, NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    I, IADD, ICOUNT, IFAIL, ISEND, JCOLOR, MAXN, N, NSAMP,
     +           NSAMP2, NUMPLT
      DOUBLE PRECISION PAR(NPAR)
      DOUBLE PRECISION ALPHA, BETA, VAR
      DOUBLE PRECISION BOT, CHISQ1, CHISQ2, THEORY, TOP, VAR2
      DOUBLE PRECISION B, DF, DF2, DM, F, P, P1, P2, Q1, Q2
      DOUBLE PRECISION DELTA1, DELTA2, POWER
      DOUBLE PRECISION CHIL95, CHIU95, FRATIO, XVL95, XVU95, ZA, ZB
      DOUBLE PRECISION EPSI, ONE, TWO, FMIN, F100, ZERO
      PARAMETER (EPSI = 1.0D-38, ONE = 1.0D+00, TWO = 2.0D+00,
     +           FMIN = 0.0D+00, F100 = 100.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION PNT025, PNT975
      PARAMETER (PNT025 = 0.025D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION G01FCF$, G01ECF$, G01EDF$, G01EAF$, G01FAF$
      DOUBLE PRECISION X1(NMAX), X2(N2), X3(N1), X4(N1)
      DOUBLE PRECISION Y1(NMAX), Y2(N2), Y3(N1), Y4(N1)
      CHARACTER (LEN = 13) D13(6), SHOWLJ
      CHARACTER (LEN = 12) I12(3), FORM12
      CHARACTER  TEXT(NTEXT)*100
      CHARACTER  TAIL*1
      CHARACTER  PTITLE*50, XTITLE*40, YTITLE*40
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    NOTYET, REPEET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    LOGIC1, LOGIC2
      PARAMETER (LOGIC1 = .TRUE., LOGIC2 = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   LBOX01, PUTFAT, GETJGE, SPOWPR, REVPRO, TABLE1, PUTWAR,
     +           LBOX02
      EXTERNAL   G01ECF$, G01FCF$, G01EDF$, G01EAF$, G01FAF$
      EXTERNAL   GKS004
      INTRINSIC  ABS, DBLE, SQRT, LOG, NINT
      SAVE       MAXN, N, NSAMP, NSAMP2
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT* 1 /
      DATA       MAXN, N, NSAMP, NSAMP2 / 100, 20, 20, 20 /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      ALPHA = PAR(1)
      BETA = PAR(2)
      VAR = PAR(4)
      VAR2 = PAR(5)
      THEORY = PAR(6)
      NUMBLD(1) = 1
      NUMDEC = NUMOPT
      REPEET = .TRUE.
C
C Main loop
C
      DO WHILE (REPEET)
         POWER = F100*(ONE - BETA)
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) ALPHA, F100*ALPHA, BETA,
     +                       POWER, THEORY, VAR, VAR2
         ELSE
            D13(1) = SHOWLJ(THEORY)
            D13(2) = SHOWLJ(VAR)
            D13(3) = SHOWLJ(VAR2) 
            WRITE (TEXT,150) ALPHA, F100*ALPHA, BETA,
     +                       POWER, TRIM(D13(1)), TRIM(D13(2)),
     +                       TRIM(D13(3))
         ENDIF  
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.1) THEN
C
C H0: sigma^2 =< sigma0^2, H1: sigma^2 > sigma0^2 (Zar eqn.7.19)
C
C Option 1, Step 1: get the sample size
C
            I = 2
            CALL GETJGE (NSAMP, I, 'sample size used to estimate s1^2')
            DF = DBLE(NSAMP - 1)
C
C Option 1, Step 2: do the test (Zar. 7.18)
C
            CHISQ1 = DF*VAR/THEORY
            TAIL = 'U'
            IFAIL = 0
            P1 = G01ECF$(TAIL, CHISQ1, DF, IFAIL)
            IF (IFAIL.EQ.0) THEN
C
C Option 1, Step 3: calculate the power (Zar eqn. 7.21)
C
               P = ONE - ALPHA
               F = THEORY/VAR
               CHISQ2 = F*G01FCF$(P, DF, IFAIL)
               IF (IFAIL.EQ.0) THEN
                  P2 = G01ECF$(TAIL, CHISQ2, DF, IFAIL)
                  IF (IFAIL.EQ.0) THEN
                     NOTYET = .TRUE.
                     B = ONE - P2
                     Q1 = BETA
                     Q2 = ONE - ALPHA
                  ELSE
                     NOTYET = .FALSE.
                  ENDIF
               ENDIF
            ELSE
               NOTYET = .FALSE.
            ENDIF
            ICOUNT = 0
C
C Option 1, Step 4: calculate N
C
            I = 1
            DO WHILE (NOTYET .AND. ICOUNT.LT.NMAX)
               ICOUNT = ICOUNT + 1
               IF (I.LT.100) THEN
                  I = I + 1
               ELSEIF (I.LT.200) THEN
                  I = I + 2
               ELSEIF (I.LT.400) THEN
                  I = I + 4
               ELSEIF (I.LT.800) THEN
                  I = I + 8
               ELSEIF (I.LT.1600) THEN
                  I = I + 16
               ELSE
                  I = I + 32
               ENDIF
               DF = DBLE(I - 1)
               IF (IFAIL.EQ.0) TOP = G01FCF$(Q1, DF, IFAIL)
               IF (IFAIL.EQ.0) BOT = G01FCF$(Q2, DF, IFAIL)
               IF (IFAIL.EQ.0) THEN
                  DELTA2 = F - TOP/BOT
                  IF (I.EQ.2) DELTA1 = DELTA2
                  IF (ABS(DELTA2).LT.FMIN .OR.
     +                DELTA1*DELTA2.LT.ZERO) THEN
                     NOTYET = .FALSE.
                     N = I
                  ENDIF
                  DELTA1 = DELTA2
               ELSE
                  NOTYET = .FALSE.
               ENDIF
            ENDDO
C
C Option 1, Step 5: restore DF then calculate 95% confidence limits
C
            DF = DBLE(NSAMP - 1)
            IF (IFAIL.EQ.0) CHIL95 = G01FCF$(PNT025, DF, IFAIL)
            IF (IFAIL.EQ.0) CHIU95 = G01FCF$(PNT975, DF, IFAIL)
            IF (IFAIL.NE.0) THEN
C
C Error
C
               ISEND = 0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               IF (NOTYET) THEN
C
C Sample size calculation failed
C
                  ISEND = - 1
                  CALL SPOWPR (ISEND, NPAR, PAR)
                  N = -1
               ELSE
                  XVL95 = DF*VAR/CHIU95
                  XVU95 = DF*VAR/CHIL95
                  IF (E_NUMBERS) THEN
                     WRITE (TEXT,200) THEORY, THEORY, VAR, NSAMP, XVL95,
     +                                XVU95, CHISQ1, P1, F100*(ONE - B),
     +                                ALPHA, N, ALPHA, BETA
                  ELSE
                     D13(1) = SHOWLJ(THEORY)
                     D13(2) = SHOWLJ(THEORY)
                     D13(3) = SHOWLJ(VAR)
                     I12(1) = FORM12(NSAMP)
                     D13(4) = SHOWLJ(XVL95)
                     D13(5) = SHOWLJ(XVU95)
                     D13(6) = SHOWLJ(CHISQ1)
                     I12(2) = FORM12(N) 
                     WRITE (TEXT,250) TRIM(D13(1)), D13(2), D13(3),
     +                                I12(1), TRIM(D13(4)), D13(5),
     +                                D13(6), P1, F100*(ONE - B),
     +                                ALPHA, TRIM(I12(2)), ALPHA, BETA

                  ENDIF  
                  WRITE (NOUT,'(A)') BLANK
                  JCOLOR = 15
                  CALL TABLE1 (JCOLOR, 'OPEN')
                  DO I = 1, 8
                     IF (I.EQ.1) THEN
                        JCOLOR = 4
                     ELSE
                        JCOLOR = 0
                     ENDIF
                     CALL TABLE1 (JCOLOR, TEXT(I))
                     WRITE (NOUT,'(A)') TEXT(I)
                  ENDDO
                  CALL TABLE1 (JCOLOR, 'CLOSE')
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN
C-----------------------------------------------------------------------
C
C H0: sigma^2 >= sigma0^2, H1: sigma^2 < sigma0^2 (Zar eqn.7.19)
C Step 1: get the sample size
C
            I = 2
            CALL GETJGE (NSAMP, I, 'sample size used to estimate s1^2')
            DF = DBLE(NSAMP - 1)
C
C Step 2: do the test (Zar. 7.18)
C
            CHISQ1 = DF*VAR/THEORY
            TAIL = 'L'
            IFAIL = 0
            P1 = G01ECF$(TAIL, CHISQ1, DF, IFAIL)
            IF (IFAIL.EQ.0) THEN
C
C Step 3: calculate the power (Zar eqn. 7.21)
C
               P = ALPHA
               F = THEORY/VAR
               CHISQ2 = F*G01FCF$(P, DF, IFAIL)
               IF (IFAIL.EQ.0) THEN
                  P2 = G01ECF$(TAIL, CHISQ2, DF, IFAIL)
                  IF (IFAIL.EQ.0) THEN
                     NOTYET = .TRUE.
                     B = ONE - P2
                     Q1 = ONE - BETA
                     Q2 = ALPHA
                  ELSE
                     NOTYET = .FALSE.
                  ENDIF
               ENDIF
            ELSE
               NOTYET = .FALSE.
            ENDIF
            ICOUNT = 0
C
C Step 4: calculate N
C
            I = 1
            DO WHILE (NOTYET .AND. ICOUNT.LT.NMAX)
               ICOUNT = ICOUNT + 1
               IF (I.LT.100) THEN
                  I = I + 1
               ELSEIF (I.LT.200) THEN
                  I = I + 2
               ELSEIF (I.LT.400) THEN
                  I = I + 4
               ELSEIF (I.LT.800) THEN
                  I = I + 8
               ELSEIF (I.LT.1600) THEN
                  I = I + 16
               ELSE
                  I = I + 32
               ENDIF
               DF = DBLE(I - 1)
               IF (IFAIL.EQ.0) TOP = G01FCF$(Q1, DF, IFAIL)
               IF (IFAIL.EQ.0) BOT = G01FCF$(Q2, DF, IFAIL)
               IF (IFAIL.EQ.0) THEN
                  DELTA2 = F - TOP/BOT
                  IF (I.EQ.2) DELTA1 = DELTA2
                  IF (ABS(DELTA2).LT.FMIN .OR.
     +                DELTA1*DELTA2.LT.ZERO) THEN
                     NOTYET = .FALSE.
                     N = I
                  ENDIF
                  DELTA1 = DELTA2
               ELSE
                  NOTYET = .FALSE.
               ENDIF
            ENDDO
C
C Step 5: restore DF then calculate 95% confidence limits
C
            DF = DBLE(NSAMP - 1)
            IF (IFAIL.EQ.0) CHIL95 = G01FCF$(PNT025, DF, IFAIL)
            IF (IFAIL.EQ.0) CHIU95 = G01FCF$(PNT975, DF, IFAIL)
            IF (IFAIL.NE.0) THEN
C
C Error
C
               ISEND = 0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ELSE
               IF (NOTYET) THEN
C
C Sample size calculation failed
C
                  ISEND = -1
                  CALL SPOWPR (ISEND, NPAR, PAR)
                  N = -1
               ELSE
                  XVL95 = DF*VAR/CHIU95
                  XVU95 = DF*VAR/CHIL95
                  IF (E_NUMBERS) THEN
                     WRITE (TEXT,300) THEORY, THEORY, VAR, NSAMP, XVL95,
     +                                XVU95, CHISQ1, P1, F100*(ONE - B),
     +                                ALPHA, N, ALPHA, BETA
                  ELSE
                     D13(1) = SHOWLJ(THEORY)
                     D13(2) = D13(1)
                     D13(3) = SHOWLJ(VAR)
                     I12(1) = FORM12(NSAMP)
                     D13(4) = SHOWLJ(XVL95)
                     D13(5) = SHOWLJ(XVU95)
                     D13(6) = SHOWLJ(CHISQ1)
                     I12(2) = FORM12(N)
                     WRITE (TEXT,350) TRIM(D13(1)), D13(2), D13(3),
     +                                I12(1), TRIM(D13(4)), D13(5),
     +                                D13(6), P1, F100*(ONE - B),
     +                                ALPHA, TRIM(I12(2)), ALPHA, BETA
                  ENDIF  
                  WRITE (NOUT,'(A)') BLANK
                  JCOLOR = 15
                  CALL TABLE1 (JCOLOR, 'OPEN')
                  DO I = 1, 8
                     IF (I.EQ.1) THEN
                        JCOLOR = 4
                     ELSE
                        JCOLOR = 0
                     ENDIF
                     CALL TABLE1 (JCOLOR, TEXT(I))
                     WRITE (NOUT,'(A)') TEXT(I)
                  ENDDO
                  CALL TABLE1 (JCOLOR, 'CLOSE')
               ENDIF
            ENDIF
C-----------------------------------------------------------------------
         ELSEIF (NUMDEC.EQ.3) THEN
            IF (ABS(VAR - VAR2).LE.EPSI) CALL PUTWAR (
     +         'You should not have s1^2 = s0^2 for this option')
C
C Variance ratio test
C
            I = 2
            CALL GETJGE (NSAMP, I, 'sample size used to estimate s1^2')
            CALL GETJGE (NSAMP2, I, 'sample size used to estimate s2^2')
            IFAIL = 0
            TAIL = 'S'
            P = ALPHA
            ZA = G01FAF$(TAIL, P, IFAIL)
            IF (IFAIL.EQ.0 .AND. VAR.GT.VAR2 + EPSI) THEN
C
C s1^2 > s2^2
C
               IFAIL = 0
               DF = DBLE(NSAMP - 1)
               DF2 = DBLE(NSAMP2 - 1)
               DM = DF/DF2
               FRATIO  = VAR/VAR2
               BOT = LOG(FRATIO)
               ZB = SQRT(TWO*DM*DBLE(NSAMP2 - 2)/(DM + ONE))*BOT
     +               - ZA
               TAIL = 'L'
               POWER = F100*G01EAF$(TAIL, ZB, IFAIL)
               TAIL = 'U'
               ZB = G01FAF$(TAIL, BETA, IFAIL)
               TOP = ZA + ZB
               N = NINT((TOP/BOT)**2 + TWO)
            ELSEIF (IFAIL.EQ.0 .AND. VAR.LT.VAR2 - EPSI) THEN
C
C s1^2 < s2^2
C
               IFAIL = 0
               DF = DBLE(NSAMP2 - 1)
               DF2 = DBLE(NSAMP - 1)
               DM = DF/DF2
               FRATIO = VAR2/VAR
               BOT = LOG(FRATIO)
               ZB = SQRT(TWO*DM*DBLE(NSAMP - 2)/(DM + ONE))*BOT
     +               - ZA
               TAIL = 'L'
               POWER = F100*G01EAF$(TAIL, ZB, IFAIL)
               TAIL = 'U'
               ZB = G01FAF$(TAIL, BETA, IFAIL)
               TOP = ZA + ZB
               N = NINT((TOP/BOT)**2 + TWO)
            ELSE
               IFAIL = -1
            ENDIF
            IF (IFAIL.EQ.0) THEN
               TAIL = 'U'
               P1 = G01EDF$(TAIL, FRATIO, DF, DF2, IFAIL)
            ENDIF
            IF (IFAIL.EQ.0) THEN
               IF (E_NUMBERS) THEN
                  WRITE (TEXT,400) VAR, VAR2, NSAMP, NSAMP2, FRATIO, P1,
     +                             POWER, ALPHA, N, ALPHA, BETA
               ELSE
                  D13(1) = SHOWLJ(VAR)
                  D13(2) = SHOWLJ(VAR2)
                  I12(1) = FORM12(NSAMP)
                  I12(2) = FORM12(NSAMP2)
                  D13(3) = SHOWLJ(FRATIO)
                  I12(3) = FORM12(N)
                  WRITE (TEXT,450) D13(1), D13(2), I12(1), I12(2),
     +                             D13(3), P1, POWER, ALPHA, 
     +                             TRIM(I12(3)), ALPHA, BETA
               ENDIF  
               WRITE (NOUT,'(A)') BLANK
               JCOLOR = 15
               CALL TABLE1 (JCOLOR, 'OPEN')
               DO I = 1, 9
                  IF (I.EQ.1) THEN
                     JCOLOR = 4
                  ELSE
                     JCOLOR = 0
                  ENDIF
                  CALL TABLE1 (JCOLOR, TEXT(I))
                  WRITE (NOUT,'(A)') TEXT(I)
               ENDDO
               CALL TABLE1 (JCOLOR, 'CLOSE')
            ELSE
C
C Error
C
               ISEND = 0
               CALL SPOWPR (ISEND, NPAR, PAR)
            ENDIF
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Plot
C           
            IF (E_NUMBERS) THEN 
               WRITE (TEXT,500) THEORY, THEORY, THEORY, THEORY, VAR,
     +                          VAR2
            ELSE
               D13(1) = SHOWLJ(THEORY) 
               D13(2) = SHOWLJ(VAR)
               D13(3) = SHOWLJ(VAR2)
                WRITE (TEXT,550) TRIM(D13(1)), TRIM(D13(1)),
     +                           TRIM(D13(1)), TRIM(D13(1)), 
     +                           TRIM(D13(2)), TRIM(D13(3))
            ENDIF  
            I = 4
            NUMPLT = 3
            CALL LBOX02 (ICOLOR, IXL, IYL, NUMPLT, I, NUMPOS, TEXT)
            IF (NUMPLT.EQ.3 .AND. ABS(VAR - VAR2).LE.EPSI) THEN
               CALL PUTFAT ('Not defined for s1^2 = s2^2')
               NUMPLT = 4
            ENDIF
            IF (NUMPLT.LT.4) THEN
               IFAIL = 0
               PTITLE = TEXT(NUMPLT)(1:50)
               POWER = F100*(ONE - BETA)
               ICOUNT = 0
               I = 2
               CALL GETJGE (MAXN, I, 'Maximum sample size for plotting')
               IF (NUMPLT.EQ.1) THEN
                  P = ONE - ALPHA
                  F = THEORY/VAR
                  TAIL = 'U'
               ELSEIF (NUMPLT.EQ.2) THEN
                  P = ALPHA
                  F = THEORY/VAR
                  TAIL = 'L'
               ELSE
                  IF (VAR.GT.VAR2) THEN
                     FRATIO = VAR/VAR2
                  ELSE
                     FRATIO = VAR2/VAR
                  ENDIF
                  BOT = LOG(FRATIO)
                  TAIL = 'S'
                  P = ALPHA
                  ZA = G01FAF$(TAIL, P, IFAIL)
                  TAIL = 'L'
               ENDIF
               I = 1
               DO WHILE (IFAIL.EQ.0 .AND. I.LT.MAXN .AND.
     +                   ICOUNT.LT.NMAX)
                  IF (MAXN.LE.100 .OR. I.LE.50) THEN
                     IADD = 1
                  ELSEIF (I.LE.100) THEN
                     IADD = 2
                  ELSEIF (I.LE.200) THEN
                     IADD = 4
                  ELSEIF (I.LE.400) THEN
                     IADD = 8
                  ELSEIF (I.LE.800) THEN
                    IADD = 16
                  ELSE
                     IADD = 32
                  ENDIF
                  I = I + IADD
                  IF (NUMPLT.EQ.1) THEN
                     DF = DBLE(I - 1)
                     CHISQ2 = F*G01FCF$(P, DF, IFAIL)
                     IF (IFAIL.EQ.0) THEN
                        P2 = G01ECF$(TAIL, CHISQ2, DF, IFAIL)
                        IF (IFAIL.EQ.0) THEN
                           B = ONE - P2
                           ICOUNT = ICOUNT + 1
                           X1(ICOUNT) = DBLE(I)
                          Y1(ICOUNT) = F100*(ONE - B)
                        ENDIF
                     ENDIF
                  ELSEIF (NUMPLT.EQ.2) THEN
                     DF = DBLE(I - 1)
                     CHISQ2 = F*G01FCF$(P, DF, IFAIL)
                     IF (IFAIL.EQ.0) THEN
                        P2 = G01ECF$(TAIL, CHISQ2, DF, IFAIL)
                        IF (IFAIL.EQ.0) THEN
                           B = ONE - P2
                           ICOUNT = ICOUNT + 1
                           X1(ICOUNT) = DBLE(I)
                           Y1(ICOUNT) = F100*(ONE - B)
                        ENDIF
                     ENDIF
                  ELSE
                     ZB = SQRT(DBLE(I - 2))*BOT - ZA
                     P = F100*G01EAF$(TAIL, ZB, IFAIL)
                     IF (IFAIL.EQ.0) THEN
                        ICOUNT = ICOUNT + 1
                        X1(ICOUNT) = DBLE(I)
                        Y1(ICOUNT) = P
                     ENDIF
                  ENDIF
               ENDDO
               IF (IFAIL.EQ.0 .AND. ICOUNT.GT.1) THEN
                  X2(1) = X1(1)
                  X2(2) = X1(ICOUNT)
                  Y2(1) = POWER
                  Y2(2) = POWER
                  XTITLE = 'Sample Size'
                  WRITE (YTITLE,600) ALPHA
                  CALL GKS004 (N1, N2, N0, N0, N0, N0, N0, N0,
     +                         ICOUNT, N2, N1, N1,
     +                         X1, X2, X3, X4, Y1, Y2, Y3, Y4,
     +                         PTITLE, XTITLE, YTITLE, LOGIC1, LOGIC2)
               ELSE
C
C Error
C
                  ISEND = 0
                  CALL SPOWPR (ISEND, NPAR, PAR)
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.5) THEN
C
C New alpha
C
            ISEND = 1
            CALL SPOWPR (ISEND, NPAR, PAR)
            ALPHA = PAR(1)
         ELSEIF (NUMDEC.EQ.6) THEN
C
C New beta
C
            ISEND = 2
            CALL SPOWPR (ISEND, NPAR, PAR)
            BETA = PAR(2)
         ELSEIF (NUMDEC.EQ.7) THEN
C
C New theoretical variance
C
            ISEND = 6
            CALL SPOWPR (ISEND, NPAR, PAR)
            THEORY = PAR(6)
         ELSEIF (NUMDEC.EQ.8) THEN
C
C New sample variance 1
C
            ISEND = 4
            CALL SPOWPR (ISEND, NPAR, PAR)
            VAR = PAR(4)
         ELSEIF (NUMDEC.EQ.9) THEN
C
C New sample variance 2
C
            ISEND = 5
            CALL SPOWPR (ISEND, NPAR, PAR)
            VAR2 = PAR(5)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Power for variance tests (normal distributions)'
     +/
     +/'Current alpha =',F7.4,' (',F7.2,'% sig. level)'
     +/'Current beta =',F7.4,' (',F7.2,'% power)'
     +/'Current s0^2 =',1P,E11.4,' (theoretical variance)'
     +/'Current s1^2 =',1P,E11.4,' (first sample variance)'
     +/'Current s2^2 =',1P,E11.4,' (second sample variance)'
     +/
     +/'1 sample: H0: s1^2 =< s0^2; H1: s1^2 > s0^2'
     +/'1 sample: H0: s1^2 >= s0^2; H1: s1^2 < s0^2'
     +/'2 samples: 2-tailed variance ratio test'
     +/'Plot power'
     +/'Change alpha'
     +/'Change beta'
     +/'Change s0^2 (theoretical variance)'
     +/'Change s1^2 (first sample variance)'
     +/'Change s2^2 (second sample variance)'
     +/'Results'
     +/'Quit ... Exit power calculations for variance tests')
 150  FORMAT ( 
     + 'Power for variance tests (normal distributions)'
     +/
     +/'Current alpha =',F7.4,' (',F7.2,'% sig. level)'
     +/'Current beta =',F7.4,' (',F7.2,'% power)'
     +/'Current s0^2 =',1X,A,' (theoretical variance)'
     +/'Current s1^2 =',1X,A,' (first sample variance)'
     +/'Current s2^2 =',1X,A,' (second sample variance)'
     +/
     +/'1 sample: H0: s1^2 =< s0^2; H1: s1^2 > s0^2'
     +/'1 sample: H0: s1^2 >= s0^2; H1: s1^2 < s0^2'
     +/'2 samples: 2-tailed variance ratio test'
     +/'Plot power'
     +/'Change alpha'
     +/'Change beta'
     +/'Change s0^2 (theoretical variance)'
     +/'Change s1^2 (first sample variance)'
     +/'Change s2^2 (second sample variance)'
     +/'Results'
     +/'Quit ... Exit power calculations for variance tests')   
  200 FORMAT (
     + 'Test for H0: s1^2 =<',1P,E11.4,' H1: s1^2 >',E11.4
     +/'Sample variance s1^2 =',E12.4
     +/'Sample size          =',I8
     +/'95% con.lim.for s1^2 =',E12.4,',',E12.4
     +/'Test statistic (C)   =',E12.4
     +/'p = P(chi-sq >= C)   =',0P,F8.4
     +/'Power of this test   =',0P,F8.4,'% (for alpha =',0P,F7.4,')'
     +/'Minimal sample size  =',I8,
     +' (for alpha =',0P,F7.4,', beta =',0P,F7.4,')')
  250 FORMAT (
     + 'Test for H0: s1^2 =<',1X,A,' H1: s1^2 >',1X,A
     +/'Sample variance s1^2 =',1X,A
     +/'Sample size          =',1X,A
     +/'95% con.lim.for s1^2 =',1X,A,',',1X,A
     +/'Test statistic (C)   =',1X,A
     +/'p = P(chi-sq >= C)   =',F7.4
     +/'Power of this test   =',F8.4,'% (for alpha =',F7.4,')'
     +/'Minimal sample size  =',1X,A,
     +' (for alpha =',F7.4,', beta =',F7.4,')')     
  300 FORMAT (
     + 'Test for H0: s1^2 >=',1P,E11.4,' H1: s1^2 <',E11.4
     +/'Sample variance s1^2 =',E12.4
     +/'Sample size          =',I8
     +/'95% con.lim.for s1^2 =',E12.4,',',E12.4
     +/'Test statistic (C)   =',E12.4
     +/'p = P(chi-sq =< C)   =',0P,F8.4
     +/'Power of this test   =',0P,F8.4,'% (for alpha =',0P,F7.4,')'
     +/'Minimal sample size  =',I8,
     +' (for alpha =',0P,F7.4,', beta =',0P,F7.4,')')
  350 FORMAT (
     + 'Test for H0: s1^2 >=',1X,A,' H1: s1^2 <',1X,A
     +/'Sample variance s1^2 =',1X,A
     +/'Sample size          =',1X,A
     +/'95% con.lim.for s1^2 =',1X,A,',',1X,A
     +/'Test statistic (C)   =',1X,A
     +/'p = P(chi-sq =< C)   =',F7.4
     +/'Power of this test   =',F8.4,'% (for alpha =',F7.4,')'
     +/'Minimal sample size  =',1X,A,
     +' (for alpha =',F7.4,', beta =',F7.4,')')   
  400 FORMAT (
     + 'Two-tailed variance ratio (F) test'
     +/'Sample variance s1^2 =',1P,E11.4
     +/'Sample variance s2^2 =',E11.4
     +/'Sample size n1       =',I7
     +/'Sample size n2       =',I7
     +/'Variance ratio (VR)  =',1P,E11.4
     +/'p = P(F >= VR)       =',0P,F7.4
     +/'Power of this test   =',0P,F7.3,'% (for alpha =',0P,F7.4,')'
     +/'Minimal sample size  =',I7,
     +' (for alpha =',0P,F7.4,', beta =',0P,F7.4,')')
  450 FORMAT (
     + 'Two-tailed variance ratio (F) test'
     +/'Sample variance s1^2 =',1X,A
     +/'Sample variance s2^2 =',1X,A
     +/'Sample size n1       =',1X,A
     +/'Sample size n2       =',1X,A
     +/'Variance ratio (VR)  =',1X,A
     +/'p = P(F >= VR)       =',F7.4
     +/'Power of this test   =',F7.3,'% (for alpha =',F7.4,')'
     +/'Minimal sample size  =',1X,A,
     +' (for alpha =',F7.4,', beta =',F7.4,')')   
  500 FORMAT (
     + 'H0:s1^2=<',1P,E10.4,',H1:s1^2>',E10.4
     +/'H0:s1^2>=',1P,E10.4,',H1:s1^2<',E10.4
     +/'2-tail F Test, s1^2=',E10.4,',s2^2=',E10.4
     +/'Quit ... Exit these results')
  550 FORMAT (
     + 'H0:s1^2=<',A,',H1:s1^2>',A
     +/'H0:s1^2>=',A,',H1:s1^2<',A
     +/'2-tail F Test, s1^2=',A,',s2^2=',A
     +/'Quit ... Exit these results')   
  600 FORMAT ('%Power (alpha =',F7.4,')')
      END
C
C
