c
c
      subroutine surv00 (ncmax, nrmax, nrows, nvmax,
     +                   a)
c
c action: check if survival data are consistent and return nvmax if OK
c author: w.g.bardsley, university of manchester, u.k., 26/10/2009
c
      implicit none
c
c arguments
c      
      integer,          intent (in)  :: ncmax, nrmax, nrows
      integer,          intent (out) :: nvmax  
      double precision, intent (in)  :: a(nrmax,ncmax)    
c
c locals
c      
      integer    i, j, k, n
      double precision zero
      parameter (zero = 0.0d+00)
      external   putfat 
      intrinsic  nint
c
c initialise
c      
      nvmax = 0
c
c check parameters supplied
c      
      if (ncmax.lt.3) then
         call putfat ('Survival data sets must have at least 3 columns')
         return
      endif
      if (nrows.lt.2) then
         call putfat ('Survival data sets must have at least 2 rows')
         return
      endif 
c
c check data supplied and calculate n
c        
      n = 0
      do i = 1, nrows
         if (a(i,1).lt.zero) then
            call putfat ('Time in column 1 must be nonnegative')
            return
         endif   
         j = nint(a(i,2))
         if (j.lt.0 .or. j.gt.1) then
            call putfat ('Censorship index in column 2 must be 0 or 1')
            return
         endif
         k = nint(a(i,3))
         if (k.lt.0) then
            call putfat ('Frequency in column 3 must be nonnegative')
            return
         endif
         if (k.gt.0) n = n + k      
      enddo
c
c assign nvmax = total number of observations
c      
      nvmax = n
      end
c
c        
            