C
C
      SUBROUTINE SURV02 (M2, M3, NCMAX2, NCMAX3, NIN, NOUT, NRMAX2, 
     +                   NRMAX3,
     +                   A2, A3, 
     +                   FNAME2, FNAME3, TITLE2, TITLE3,
     +                   SUPPLY)
C
C ACTION : Analyse survival times
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          02/10/2007 derived from SURVIV
C          27/10/2009 added calls to SURV00
C          30/06/2010 corrected code for the extra point at (0,1)
C          04/07/2010 added call to SURV03 to generate steps starting at (0,1) and
C                     completely re-worked the step plotting arrays
C          14/05/2013 removed P from call to SVDATA
C          28/11/2013 added call to SURV04 
C
C Note: the units (NIN, NOUT), dimensions (NCMAX?, NRMAX?) and SUPPLY are
C       (input/unchanged) and everything else is workspace
C       also NCMAX >= 3 and NVMAX >= NRMAX since used for unravelling
C       Further, on exit from SVDATA the values are in nondecreasing order of time 
C
C     IC = censoring code, : 0 = failure, 1 = right censored
C    IC1 = second set of censoring codes
C  ICVEC = full censoring code
C  IFREQ = frequencies
C IFREQ1 = second set of frequencies
C      M = size of A3 (= M3)
C      N = size of A2 (= M2)
C    IWK = workspace
C NCMAX2 = dimension
C NCMAX3 = dimension
C    NIN = input unit
C   NOUT = output unit
C NRMAX2 = dimension
C NRMAX3 = dimension
C  NVMAX = dimension
C      A2 = array to hold data matrix
C      A3 = array to hold data matrix
C      P = probabilities, i.e. KMS(t)
C   PSIG = std. dev. P
C  PSTEP = workspace
C      T = times (may be replicates)
C   TIME = workspace
C     T1 = second set of times
C     TP = distinct times
C   TVEC = all times (no replicates)
C     WK = workspace
C FNAME2 = file with A2
C FNAME3 = file with A3
C TITLE2 = title of A2
C TITLE3 = title of A3
C SUPPLY = .TRUE. then supply all data
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX2, NCMAX3, NIN, NOUT, 
     +                                       NRMAX2, NRMAX3
      INTEGER,             INTENT (INOUT) :: M2, M3
      DOUBLE PRECISION,    INTENT (INOUT) :: A2(NRMAX2,NCMAX2),
     +                                       A3(NRMAX3,NCMAX3)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME2, FNAME3,
     +                                       TITLE2, TITLE3
      LOGICAL,             INTENT (IN)    :: SUPPLY
C
C Allocatables
C     
      INTEGER,          ALLOCATABLE :: IC(:), IC1(:), IFREQ(:),
     +                                 IFREQ1(:), IWK(:)
      INTEGER,          ALLOCATABLE :: ICVEC(:) 
      DOUBLE PRECISION, ALLOCATABLE :: P(:), P1(:), PSIG(:),
     +                                 T(:), TP(:), T1(:) 
      DOUBLE PRECISION, ALLOCATABLE :: WK(:)
      DOUBLE PRECISION, ALLOCATABLE :: STEP(:), TIME(:), TVEC(:)
C
C Locals
C 
      INTEGER    NGRAF
      PARAMETER (NGRAF = 2)
      INTEGER    N0, N1, N2, N3, N4, N6, N10
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N6 = 6, 
     +           N10 = 10)
      INTEGER    JCOLOR, NUMOPT, NUMSTA, NUMTXT
      INTEGER    NUMBLD(30)
      INTEGER    I, IADD2, IERR, IFAIL, ISEND, JCOUNT, M, N
      INTEGER    NA, NAP1, NB, NBP1, ND, NMAX, NRMAX, NVEC,
     +           NVMAX, NVMAX2, NVMAX3, NWMAX
      INTEGER    NCENSA, NCENSB, NPLOTA, NPLOTB, NSUM(6)
      INTEGER    NMIN
      PARAMETER (NMIN = 10000)
      DOUBLE PRECISION TMAX_A, TMAX_B 
      DOUBLE PRECISION ONE, RTOL
      PARAMETER (ONE = 1.0D+00, RTOL = 1.0D-250) 
      DOUBLE PRECISION ARG, ARG1, ARG2, PVAL, QMH, THETA, THETA1, THETA2
      DOUBLE PRECISION G01ECF$
      DOUBLE PRECISION XGRAF(NGRAF), YGRAF(NGRAF)
      CHARACTER (LEN = 13) D13(4), SHOWLJ 
      CHARACTER  BLANK*1, FREQ*1
      PARAMETER (BLANK = ' ', FREQ = 'F')
      CHARACTER  TEXT(30)*100
      CHARACTER  SYMBOL*23
      CHARACTER  PTITLE*50, XTITLE*40, YTITLE*40
      CHARACTER  TRIM80*80
      CHARACTER (LEN = 12) FORM12, WORD12(6)
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    YES
      PARAMETER (YES = .TRUE.)
      LOGICAL    ABORT, AGAIN
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   PUTIFA, LSTBOX, TABLE1, GKS004, PUTADV, PLEVEL, TRIM80
      EXTERNAL   SVDATA, SVCOMP, SURV00, SURV03, SURV04, FORM12
      EXTERNAL   G12AAF$, G01ECF$
      INTRINSIC  LOG, MAX 
      SAVE       JCOUNT
      DATA       JCOUNT / 0 /
      DATA       NUMBLD /30*0 /
      E_NUMBERS = E_FORMATS()
C
C Check dimensions 
C      
      IF (NIN.LT.1 .OR. NOUT.LT.1 .OR. NRMAX2.LT.2 .OR. NRMAX3.LT.2 .OR.
     +    NCMAX2.LT.3 .OR. NCMAX3.LT.3) RETURN
C
C Check data then allocate
C      
      NMAX = MAX(NRMAX2,NRMAX3) 
      IF (SUPPLY) THEN
         CALL SURV00 (NCMAX2, NRMAX2, M2, NVMAX2,
     +                A2)
         IF (NVMAX2.LE.0) RETURN
         CALL SURV00 (NCMAX3, NRMAX3, M3, NVMAX3,
     +                A3)
         IF (NVMAX3.LE.0) RETURN  
         NVMAX = MAX(NVMAX2,NVMAX3,NMIN)
         NWMAX = N2*NVMAX + N6
      ELSE
         NVMAX = MAX(N10*NRMAX, NMIN)
         NWMAX = NVMAX  
      ENDIF 
                      
      IERR = 0
      IF (ALLOCATED(IC)) DEALLOCATE(IC, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      IF (ALLOCATED(IC1)) DEALLOCATE(IC1, STAT = IERR)
      IF (IERR.NE.0) RETURN   
      IF (ALLOCATED(IFREQ)) DEALLOCATE(IFREQ, STAT = IERR)
      IF (IERR.NE.0) RETURN  
      IF (ALLOCATED(IFREQ1)) DEALLOCATE(IFREQ1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(IWK)) DEALLOCATE(IWK, STAT = IERR)
      IF (IERR.NE.0) RETURN     
      IF (ALLOCATED(ICVEC)) DEALLOCATE(ICVEC, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(P)) DEALLOCATE(P, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      IF (ALLOCATED(P1)) DEALLOCATE(P1, STAT = IERR)
      IF (IERR.NE.0) RETURN   
      IF (ALLOCATED(PSIG)) DEALLOCATE(PSIG, STAT = IERR)
      IF (IERR.NE.0) RETURN   
      IF (ALLOCATED(T)) DEALLOCATE(T, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(T1)) DEALLOCATE(T1, STAT = IERR)
      IF (IERR.NE.0) RETURN  
      IF (ALLOCATED(TP)) DEALLOCATE(TP, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      IF (ALLOCATED(WK)) DEALLOCATE(WK, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(STEP)) DEALLOCATE(STEP, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(TIME)) DEALLOCATE(TIME, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(TVEC)) DEALLOCATE(TVEC, STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Allocate variables limited by maximumm of NRMAX2 and NRMAX3
C        
      NRMAX = NMAX
      ALLOCATE(IC(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN 
      ALLOCATE(IC1(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN   
      ALLOCATE(IFREQ(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(IFREQ1(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN  
      ALLOCATE(IWK(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(P(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(P1(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN  
      ALLOCATE(PSIG(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(T(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(T1(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN  
      ALLOCATE(TP(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Allocate variables limited by unrolled sizes
C       
      ALLOCATE(ICVEC(NVMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (SUPPLY) THEN
         ALLOCATE(STEP(NWMAX), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(TIME(NWMAX), STAT = IERR)
         IF (IERR.NE.0) RETURN
      ELSE      
         ALLOCATE(STEP(NVMAX), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(TIME(NVMAX), STAT = IERR)
         IF (IERR.NE.0) RETURN
      ENDIF 
      ALLOCATE(TVEC(NWMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN    
      ALLOCATE(WK(NWMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN  
C
C Compare two samples A2 (N, IC, IFREQ) and A3 (M, IC1, IFREQ1)
C
      IF (.NOT.SUPPLY) THEN
         CALL PUTADV (
     +   'Now input the first set of survival times (A)')
         FNAME2 = BLANK
      ENDIF   
      CALL SVDATA (IC, ICVEC, IFREQ, M2, NCMAX2, NIN, NRMAX2, NVEC,
     +             NVMAX,
     +             A2, T, TVEC,
     +             FNAME2, TITLE2,
     +             ABORT, SUPPLY)
      IF (ABORT) GOTO 20
      N = M2  
      IF (.NOT.SUPPLY) THEN   
         CALL PUTADV ('Now input the second set of survival times (B)')
         FNAME3 = BLANK
      ENDIF   
      CALL SVDATA (IC1, ICVEC, IFREQ1, M3, NCMAX3, NIN, NRMAX3, NVEC,
     +             NVMAX,
     +             A3, T1, TVEC,
     +             FNAME3, TITLE3,
     +             ABORT, SUPPLY)
      IF (ABORT) GOTO 20
      M = M3  
      DO I = 1, 6
         NSUM(I) = 0
      ENDDO
      DO I = 1, M2
         IF (IC(I).EQ.0) THEN
            NSUM(1) = NSUM(1) + IFREQ(I)
         ELSE
            NSUM(2) = NSUM(2) + IFREQ(I)
         ENDIF
      ENDDO
      NSUM(3) = NSUM(1) + NSUM(2)    
      DO I = 1, M3
         IF (IC1(I).EQ.0) THEN
            NSUM(4) = NSUM(4) + IFREQ1(I)
         ELSE
            NSUM(5) = NSUM(5) + IFREQ1(I)
         ENDIF
      ENDDO
      NSUM(6) = NSUM(4) + NSUM(5) 
      DO I = 1, 6
         WORD12(I) = FORM12(NSUM(I))
      ENDDO                  
C
C Do the comparison
C
      CALL SVCOMP (N, M, NWMAX, IC, IC1, IFREQ, IFREQ1,
     +             QMH, T, T1, THETA, THETA1, THETA2, WK,
     +             ABORT)
      IF (.NOT.ABORT) THEN
         IFAIL = N1
         PVAL = G01ECF$('U', QMH, ONE, IFAIL)
         CALL PLEVEL (PVAL, SYMBOL)
C
C Output results to screen and file
C
         JCOUNT = JCOUNT + N1
         WRITE (NOUT,100) JCOUNT, TRIM80(FNAME2), TRIM80(FNAME3),
     +                   (WORD12(I), I = 1, 6)  
         IF (E_NUMBERS) THEN     
            WRITE (NOUT,200) QMH, PVAL, SYMBOL, THETA, THETA1, THETA2
            WRITE (TEXT,200) QMH, PVAL, SYMBOL, THETA, THETA1, THETA2
         ELSE
            D13(1) = SHOWLJ(QMH)
            D13(2) = SHOWLJ(THETA)
            D13(3) = SHOWLJ(THETA1)
            D13(4) = SHOWLJ(THETA2)
            WRITE (TEXT,210) D13(1), PVAL, SYMBOL, D13(2), D13(3),
     +                       D13(4) 
            WRITE (NOUT,210) D13(1), PVAL, SYMBOL, D13(2), D13(3),
     +                       D13(4) 
         ENDIF  
         JCOLOR = 15
         CALL TABLE1 (JCOLOR, 'OPEN')
         DO I = 1, 10
            IF (I.LE.2) THEN
               JCOLOR = 4
            ELSEIF (I.EQ.7 .AND. SYMBOL.NE.BLANK) THEN
               JCOLOR = 1
            ELSE
               JCOLOR = 0
            ENDIF
            CALL TABLE1 (JCOLOR, TEXT(I))
         ENDDO
         CALL TABLE1 (JCOLOR, 'CLOSE')
C
C Create plots to check for proportional hazards assumption
C First call G12AAF for A-data
C
         IFAIL = 1
         CALL G12AAF$(N, T, IC, FREQ, IFREQ, ND, TP, P, PSIG, IWK,
     +                IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G12AAF/SURVIV')
         IF (IFAIL.NE.N0) GOTO 20
C
C Save distinct times and Kaplan-Meier S(t) in TVEC and STEP
C
         NA = N2*ND + N1
         CALL SURV03 (ND, 
     +                P, STEP(N1), TVEC(N1), TP,
     +                ABORT) 
         IF (ABORT) GOTO 20
C
C TMAX_A = last time point, TMIN_A = first failure point
C           
         TMAX_A = T(N)
         IF (TP(ND).LT.TMAX_A) THEN
C
C Extend data if there are censored points beyond the last failure
C           
            NAP1 = NA + N1
            STEP(NAP1) = STEP(NA)
            TVEC(NAP1) = TMAX_A
         ELSE
            NAP1 = NA   
         ENDIF   
C
C Now call G12AAF for B-data
C
         IFAIL = 1
         CALL G12AAF$(M, T1, IC1, FREQ, IFREQ1, ND, TP, P1, PSIG, IWK,
     +                IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G12AAF/SURVIV')
         IF (IFAIL.NE.N0) GOTO 20
C
C Save distinct times and Kaplan-Meier S(t) in TVEC and STEP
C
         NB = N2*ND + N1
         CALL SURV03 (ND,
     +                P1, STEP(NAP1 + N1), TVEC(NAP1 + N1), TP,
     +                ABORT) 
         IF (ABORT) GOTO 20
C
C TMAX_B = last time point, TMIN_B = first failure point
C           
         TMAX_B = T1(M)
         IF (TP(ND).LT.TMAX_B) THEN
C
C Extend data if there are censored points beyond the last failure
           
            NBP1 = NB + N1
            STEP(NAP1 + NBP1) = STEP(NAP1 + NB)
            TVEC(NAP1 + NBP1) = TMAX_B  
         ELSE
            NBP1 = NB   
         ENDIF  
         ISEND = 1
         AGAIN = .TRUE.
         DO WHILE (AGAIN)
C
C Loop over the options ... NA and NB, etc must not be changed in this loop 
C           
            WRITE (TEXT,300) (WORD12(I), I = 1, 6)
            NUMOPT = 5
            NUMSTA = 10 
            NUMTXT = NUMSTA + NUMOPT - 1
            NUMBLD(1) = 4
            CALL LSTBOX (NUMBLD, ISEND, NUMOPT, NUMSTA, NUMTXT,
     +                   TEXT)
            NUMBLD(1) = 0
            IF (ISEND.EQ.N1) THEN
C
C ISEND = 1: KMS(t) simple plot using all the steps
C ==========
C
               PTITLE = 'Kaplan-Meier S(t) Survivor Curves'
               XTITLE = 'Time'
               YTITLE = 'KMS(t)'
               CALL GKS004 (N1, N1, N0, N0,
     +                      N0, N0, N0, N0,
     +                      NA, NB, N1, N1,
     +                      TVEC(N1), TVEC(NAP1 + N1), XGRAF, XGRAF,
     +                      STEP(N1), STEP(NAP1 + N1), YGRAF, YGRAF,
     +                      PTITLE, XTITLE, YTITLE,
     +                      YES, YES)
            ELSEIF (ISEND.EQ.N2) THEN
C
C ISEND = 2: KMS(t) advanced: search for censored A data 
C ==========
C
               CALL SURV04 (IC, IFREQ, N, NCENSA,
     +                      P, WK, T, TIME)               
C
C KMS(t) advanced: search for censored B data 
C
               CALL SURV04 (IC1, IFREQ1, M, NCENSB,
     +                      P1, WK(NCENSA + N1), T1,  TIME(NCENSA + N1))               
               PTITLE = 'Extended KMS(t) Curves (+ if Censored)'
               XTITLE = 'Time'
               YTITLE = 'KMS(t)'
               CALL GKS004 (  N1,   N1,     N0,     N0,
     +                        N0,   N0,     N2,     N2,
     +                      NAP1, NBP1, NCENSA, NCENSB,
     +                      TVEC(N1), TVEC(NAP1 + N1),
     +                      TIME(N1), TIME(NCENSA + N1),
     +                      STEP(N1), STEP(NAP1 + N1),
     +                      WK(N1), WK(NCENSA + N1),
     +                      PTITLE, XTITLE, YTITLE,
     +                      YES, YES)
            ELSEIF (ISEND.EQ.N3) THEN
C
C ISEND = 3: Plot H(t)
C ==========
C 
               IADD2 = N1
               NPLOTA = N0
               DO I = N1, (NA - N1)/N2
                  IADD2 = IADD2 + N2  
                  ARG = STEP(IADD2)
                  IF (ARG.GT.RTOL) THEN
                     NPLOTA = NPLOTA + N1
                     WK(NPLOTA) = -LOG(ARG)
                     TIME(NPLOTA) = TVEC(IADD2)
                  ENDIF 
               ENDDO
               IADD2 = IADD2 + N1
               NPLOTB = N0
               DO I = N1, (NB - N1)/N2
                  IADD2 = IADD2 + N2  
                  ARG = STEP(IADD2)
                  IF (ARG.GT.RTOL) THEN
                     NPLOTB = NPLOTB + N1
                     WK(NPLOTA + NPLOTB) = -LOG(ARG)
                     TIME(NPLOTA + NPLOTB) = TVEC(IADD2)
                  ENDIF   
               ENDDO
               IF (NPLOTA.GT.N0 .AND. NPLOTB.GT.N0) THEN
                  PTITLE = 'Cumulative Hazard Curves'
                  XTITLE = 'Time'
                  YTITLE = '-log[KMS(t)]'
                  CALL GKS004 (N1,         N2, N0, N0,
     +                         N1,         N1, N0, N0,
     +                         NPLOTA, NPLOTB, N1, N1,
     +                         TIME(N1), TIME(NPLOTA + N1), XGRAF,
     +                         XGRAF,
     +                         WK(N1), WK(NPLOTA + N1), YGRAF, YGRAF,
     +                         PTITLE, XTITLE, YTITLE,
     +                         YES, YES)
               ENDIF
            ELSEIF (ISEND.EQ.N4) THEN
C
C ISEND = 4: Plot log(H(t)) against log(t)
C ==========
C 
               IADD2 = N1
               NPLOTA = N0
               DO I = N1, (NA - N1)/N2
                  IADD2 = IADD2 + N2
                  ARG1 = TVEC(IADD2)
                  ARG2 = STEP(IADD2)
                  IF (ARG1.GT.RTOL .AND. ARG2.GT.RTOL .AND.
     +                                   ARG2.LT.ONE) THEN
                     NPLOTA = NPLOTA + N1
                     TIME(NPLOTA) = LOG(ARG1)
                     WK(NPLOTA) = LOG(-LOG(ARG2))
                  ENDIF  
               ENDDO
               IADD2 = IADD2 + N1
               NPLOTB = N0
               DO I = N1, (NB - N1)/N2
                  IADD2 = IADD2 + N2
                  ARG1 = TVEC(IADD2)
                  ARG2 = STEP(IADD2)
                  IF (ARG1.GT.RTOL .AND. ARG2.GT.RTOL .AND.
     +                                   ARG2.LT.ONE) THEN
                     NPLOTB = NPLOTB + N1                    
                     TIME(NPLOTA + NPLOTB) = LOG(ARG1)
                     WK(NPLOTA + NPLOTB) = LOG(-LOG(ARG2))
                  ENDIF   
               ENDDO
               IF (NPLOTA.GT.N0 .AND. NPLOTB.GT.N0) THEN
                  PTITLE = 'Log-Log Cumulative Hazard Curves'
                  XTITLE = 'log[Time]'
                  YTITLE = 'log[-log{KMS(t)}]'
                  CALL GKS004 (N1,         N2, N0, N0,
     +                         N1,         N1, N0, N0,
     +                         NPLOTA, NPLOTB, N1, N1,
     +                         TIME(N1), TIME(NPLOTA + N1), XGRAF,
     +                         XGRAF,
     +                         WK(N1), WK(NPLOTA + N1), YGRAF, YGRAF,
     +                         PTITLE, XTITLE, YTITLE,
     +                         YES, YES)
               ENDIF 
            ELSE
               AGAIN = .FALSE.
            ENDIF
         ENDDO
      ENDIF
C
C LABEL 20: deallocate
C      
   20 CONTINUE  
      DEALLOCATE(IC, STAT = IERR)
      DEALLOCATE(IC1, STAT = IERR)
      DEALLOCATE(IFREQ, STAT = IERR)
      DEALLOCATE(IFREQ1, STAT = IERR)
      DEALLOCATE(IWK, STAT = IERR)
      DEALLOCATE(ICVEC, STAT = IERR)
      DEALLOCATE(P, STAT = IERR)
      DEALLOCATE(P1, STAT = IERR)
      DEALLOCATE(PSIG, STAT = IERR)
      DEALLOCATE(T, STAT = IERR)
      DEALLOCATE(T1, STAT = IERR)
      DEALLOCATE(TP, STAT = IERR)
      DEALLOCATE(WK, STAT = IERR)
      DEALLOCATE(STEP, STAT = IERR)
      DEALLOCATE(TIME, STAT = IERR)
      DEALLOCATE(TVEC, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     +/1X,'Double Survival Analysis no.',I4
     +/1X,'==============================='
     +/1X,'File name (A-data)'
     +/A
     +/1X,'File name (B-data)'
     +/A
     +/'Data set A: number failed =',1x,a
     +/'Data set A: number censored =',1x,a
     +/'Data set A: sample size =',1x,a
     +/'Data set B: number failed =',1x,a
     +/'Data set B: number censored =',1x,a
     +/'Data set B: sample size =',1x,a)
  200 FORMAT (
     +/' Results for the Mantel-Haenszel (log-rank) test'
     +/
     +/' H0: h_A(t) = h_B(t)       (equal hazards)'
     +/' H1: h_A(t) = theta*h_B(t) (proportional hazards)'
     +/' QMH test statistic     =',1P,E13.5
     +/' p = P(chi-sq. >= QMH)  =',0P,F8.4,1X,A
     +/' Estimate for theta     =',1P,E13.5
     +/' Lower 95% conf. limit  =',   E13.5
     +/' Upper 95% conf. limit  =',   E13.5
     +/)
  210 FORMAT (
     +/' Results for the Mantel-Haenszel (log-rank) test'
     +/
     +/' H0: h_A(t) = h_B(t)       (equal hazards)'
     +/' H1: h_A(t) = theta*h_B(t) (proportional hazards)'
     +/' QMH test statistic     =',1X,A13
     +/' p = P(chi-sq. >= QMH)  =',F7.4,1X,A
     +/' Estimate for theta     =',1X,A13
     +/' Lower 95% conf. limit  =',1X,A13
     +/' Upper 95% conf. limit  =',1X,A13
     +/)   
  300 FORMAT (
     + 'Analysis of two sets of survival data'
     +/
     +/'Data set A: number failed =',1x,a
     +/'Data set A: number censored =',1x,a
     +/'Data set A: sample size =',1x,a
     +/'Data set B: number failed =',1x,a
     +/'Data set B: number censored =',1x,a
     +/'Data set B: sample size =',1x,a
     +/
     +/'Plot KMS(t) curves'
     +/'Plot KMS(t) curves with censored points'
     +/'Plot H(t) against t (test exponential)'
     +/'Plot log[H(t)] against log(t) (test Weibull)'
     +/'Quit ... Exit survival analysis for 2 data sets')
      END
C
C
