C
C
      SUBROUTINE SURV03 (ND, 
     +                   P, STEP, TIME, TP,
     +                   ABORT)
C
C ACTION: calculate STEP and TIME using output from G12AAF
C AUTHOR: w.g.bardsley, university of manchester, u.k., 04/07/2010 
C
C         ND: dimension > 1
C          P: 0 =< P =< 1
C       STEP: Y-coordinate for Kaplan-Meier curve
C       TIME: X-coordinate for Kaplan-Meier curve
C         TP: distinct times >= 0
C      ABORT: error indicator      
C
      IMPLICIT NONE
C
C Arguments
C  
      INTEGER,          INTENT (IN)  :: ND
      DOUBLE PRECISION, INTENT (IN)  :: P(ND), TP(ND)
      DOUBLE PRECISION, INTENT (OUT) :: STEP(2*ND + 1), TIME(2*ND + 1)
      LOGICAL,          INTENT (OUT) :: ABORT    
C
C Locals
C      
      INTEGER    I, NSTEP
      INTEGER    N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      DOUBLE PRECISION P_PREV, T_PREV
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   PUTFAT
C
C Initialise ABORT then check values supplied
C      
      ABORT = .TRUE.
      IF (ND.LT.N2) THEN
         CALL PUTFAT ('SURV03 called with ND < 2')
         RETURN
      ENDIF   
      P_PREV = ONE
      T_PREV = ZERO
      DO I = N1, ND
         IF (P(I).LT.ZERO .OR. P(I).GT.ONE) THEN
            CALL PUTFAT ('SURV03 called with P < 0 or P > 1')
            RETURN
         ENDIF 
         IF (P(I).GT.P_PREV) THEN
            CALL PUTFAT ('SURV03 called with P increasing')
            RETURN
         ENDIF
         P_PREV = P(I) 
         IF (TP(I).LT.ZERO) THEN
            CALL PUTFAT ('SURV03 called with T < 0')
            RETURN
         ENDIF
         IF (TP(I).LT.T_PREV) THEN
            CALL PUTFAT ('SURV03 called with T decreasing')
            RETURN
         ENDIF
         T_PREV = TP(I)
      ENDDO 
C
C Set ABORT = .FALSE. then calculate coordinates
C           
      ABORT = .FALSE.  
C
C Two extra points for the origin
C          
      NSTEP = N1
      STEP(NSTEP) = ONE
      TIME(NSTEP) = ZERO
      
      NSTEP = NSTEP + N1
      STEP(NSTEP) = ONE
      TIME(NSTEP) = TP(N1)
C
C Two points for each of ND - 1 points
C      
      DO I = N1, ND - N1
         NSTEP = NSTEP + N1
         STEP(NSTEP) = P(I)
         TIME(NSTEP) = TP(I)
         NSTEP = NSTEP + N1
         STEP(NSTEP) = P(I)
         TIME(NSTEP) = TP(I + N1)
      ENDDO
C
C The final point
C      
      NSTEP = NSTEP + N1
      STEP (NSTEP) = P(ND)
      TIME(NSTEP) = TP(ND)
      END
C
C      


