c     
c
      subroutine surv04 (ic, ifreq, n, ncens, 
     +                   p, pcens, t, tcens)
c
c action: return censorship values after a call to g12aaf
c author: w.g.bardsley, university of manchester, u.k., 27/11/2013
c
c This routine assumes ic, ifreq, and t values are re-ordered original values 
c i.e, n values with t in nondecreasing order while p is in nonincreasing order
c
c     ic: 0 for failure, 1 for censorship
c  ifreq: frequencies >= 0      
c      n: dimension > 1
c  ncens: number of censored observations >= 0
c      p: probability estimates at failure points from g12aaf
c  pcens: probability estimates at censored points
c      t: time in original data
c  tcens: time at censorship
c
       implicit none
c
c arguments
c        
       integer,          intent (in)  :: n, ic(n), ifreq(n)
       integer,          intent (out) :: ncens
       double precision, intent (in)  :: p(n), t(n) 
       double precision, intent (out) :: pcens(n), tcens(n)
c
c locals
c       
      integer    i, icount 
      double precision pval, test
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character (len = 100) line
      external   putfat
c
c initialise then check input data
c      
      ncens = 0
      if (n.lt.2) then
         call putfat ('n must be >= 2 in call to SURV04')
         return
      endif 
      test = zero
      icount = 0  
      do i = 1, n
c
c frequencies must be nonnegative
c        
         if (ifreq(i).lt.0) then
             write (line,100) i
             call putfat (line) 
             ncens = 0
             return
         endif
c
c t must be in nondecreasing order
c
         if (i.gt.1) then
            if (t(i).lt.t(i - 1)) then
               write (line,200) i
               call putfat (line) 
               ncens = 0
               return
            endif 
         endif
c
c p must be nononcreasing
c           
         if (ic(i).eq.0) then
            if (t(i).gt.test) then
               test = t(i)
               icount = icount + 1
               if (icount.gt.1) then     
                  if (p(icount).gt.p(icount - 1)) then
                     write (line,300) i
                     call putfat (line)
                     ncens = 0
                     return
                  endif   
               endif   
            endif   
         elseif (ic(i).eq.1) then
            ncens = ncens + 1   
         else
c
c ic must be 0 or 1
c           
            write (line,400) i
            call putfat (line)
            ncens = 0
            return
         endif  
         
        
      enddo
c
c generate ncens, pcens, tcens
c     
      if (ncens.gt.0) then 
         icount = 0
         ncens = 0
         pval = one
         test = zero
         do i = 1, n  
            if (ifreq(i).gt.0) then
c
c action only if frequency > 0
c              
               if (ic(i).eq.0) then
                  if (t(i).gt.test) then
c
c redefine pval it t(i) has increased
c                    
                     test = t(i)
                     icount = icount + 1
                     pval = p(icount)
                  endif   
               else
                  ncens = ncens + 1
                  pcens(ncens) = pval
                  tcens(ncens) = t(i)
               endif      
            endif
         enddo 
      endif   
c
c format statements
c  
  100 format ('ifreq < 0 in call to SURV04 at data point',i6)    
  200 format ('Time decreasing in call to SURV04 at data point',i6)      
  300 format ('P increasing in call to SURV04 at data point',i6) 
  400 format ('ic not 0 or 1 in call to SURV04 at data point',i6)         
      end
c
c        