C
C
      SUBROUTINE SURVIV (IC, ICVEC, IC1, IFREQ, IFREQ1, IWK, NCMAX,
     +                   NGRAF, NIN, NOUT, NRMAX, NVMAX,
     +                   A, P, PSIG, STEP, T, TIME, TP, TVEC, T1, WK,
     +                   XGRAF, YGRAF,
     +                   SUPPLY)
C
C ACTION : Analyse survival times
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 26/4/96
C          22/08/1998 Win32 version
C          29/07/2003 extensive revision
C          24/02/2006 edited
C          14/05/2013 removed P from call to SVDATA
C
C Note: the units (NIN, NOUT) and dimensions (NCMAX, NRMAX, NVMAX) are
C       (input/unchanged) and everything else is workspace
C       also NCMAX >= 3 and NVMAX >= NRMAX since used for unravelling
C
C     IC = censoring code, : 0 = failure, 1 = right censored
C    IC1 = second set of censoring codes
C  ICVEC = full censoring code
C  IFREQ = frequencies
C IFREQ1 = second set of frequencies
C    IWK = workspace
C  NCMAX = dimension
C  NGRAF = no. best fit points
C    NIN = input unit
C   NOUT = output unit
C  NRMAX = dimension
C  NVMAX = dimension
C      A = array to hold data matrix
C      P = probabilities, i.e. KMS(t)
C   PSIG = std. dev. P
C  PSTEP = workspace
C      T = times (may be replicates)
C   TIME = workspace
C     T1 = second set of times
C     TP = distinct times
C   TVEC = all times (no replicates)
C     WK = workspace
C  XGRAF = best-fit Weibull times
C  YGRAF = best-fit Weibull curve
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NCMAX, NGRAF, NIN, NOUT, NRMAX, NVMAX
      INTEGER    IC(NRMAX), ICVEC(NVMAX), IC1(NRMAX), IFREQ(NRMAX),
     +           IFREQ1(NRMAX), IWK(NRMAX)
      DOUBLE PRECISION A(NRMAX,NCMAX), P(NRMAX), PSIG(NRMAX),
     +                 STEP(NVMAX), T(NRMAX), TIME(NVMAX), TP(NRMAX),
     +                 TVEC(NVMAX), T1(NRMAX), WK(NVMAX), XGRAF(NGRAF),
     +                 YGRAF(NGRAF)
      LOGICAL    SUPPLY
C
C Locals
C
      INTEGER    MAXIT
      PARAMETER (MAXIT = 250)
      INTEGER    N0, N1, N2, N3, N4, N8
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N8 = 8)
      INTEGER    ICOLOR, JCOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 3)
      INTEGER    NUMPOS(10)
      INTEGER    I, IADD1, ICOUNT, IFAIL, ISEND, JCOUNT
      INTEGER    M, N, NA, NAP1, NB, NBP1, ND, NDOF, NIT, NSTEP, NVEC
      INTEGER    NCENSA, NCENSB
      DOUBLE PRECISION BETA, CORR, DEV, GAMMA, SEBETA, SEGAM, TEMP
      DOUBLE PRECISION TEST, TMAX, TMIN
      DOUBLE PRECISION EPSI, ONE, PNT05, PNT975, RTOL, START, TOL, TWO
      PARAMETER (EPSI = 1.0D-38, ONE = 1.0D+00, PNT05 = 0.05D+00,
     +           PNT975 = 0.975D+00, RTOL = 1.0D-250, START = -1.0D+00,
     +           TOL = 0.0001D+00, TWO = 2.0D+00)
      DOUBLE PRECISION PVAL, QMH, THETA, THETA1, THETA2
      DOUBLE PRECISION HATA, HATLAM, SEHATA, SEHLAM
      DOUBLE PRECISION XBETA, XSTART, XSTOP
      DOUBLE PRECISION G01ECF$, G01FBF$, G01EBF$
      DOUBLE PRECISION ALPHA, ARGVAL, CV, D1, D2, PARAM(5), STDERR(5),
     +                 TE, TH, TSIG(5), TSTAT, TVAL(5)
      CHARACTER  FNAME1*1024, FNAME3*1024, TITLE1*80, TITLE3*80
      CHARACTER  BLANK*1, CENS*1, FREQ*1
      CHARACTER (LEN = 13) D13(5), SHOWLJ, SHOWRJ
      PARAMETER (BLANK = ' ', CENS = 'C', FREQ = 'F')
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  SYMBOL*23, SYMPAR(5)*8, TYPE1(5)*2
      CHARACTER  PTITLE*50, XTITLE*40, YTITLE*40
      CHARACTER  CHOP80*80, TRIM80*80
      LOGICAL    YES
      PARAMETER (YES = .TRUE.)
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    ABORT, AGAIN, FIRST, REPEET
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   PUTIFA, LBOX02, TABLE1, DIVIDE, GKS004, PUTADV,
     +           PLEVEL, REVPRO, CHOP80, TRIM80
      EXTERNAL   SVDATA, SVCOMP, THWEIB
      EXTERNAL   G12AAF$, G07BEF$, G01ECF$, G01FBF$, G01EBF$
      INTRINSIC  EXP, LOG, ABS, MAX, SQRT, DBLE
      SAVE       FIRST
      SAVE       ICOUNT, JCOUNT
      DATA       FIRST / .TRUE. /
      DATA       ICOUNT, JCOUNT / 0, 0 /
      DATA       NUMPOS / 10*1 /
      E_NUMBERS = E_FORMATS()
      IF (FIRST) THEN
         FIRST = .FALSE.
         CALL PUTADV (
     +'Data format must be: time, code, frequency (see survive.tf1)')
      ENDIF
      ISEND = 1
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C Start of analysis.....................................................
C

   20 CONTINUE
      WRITE (TEXT,100)
      NUMOPT = 4
      CALL LBOX02 (ICOLOR, IX, IY, ISEND, NUMOPT, NUMPOS,
     +             TEXT)
      IF (ISEND.EQ.1) THEN
C
C.......................................................................
C Part 1: Analyse 1 sample
C.......................................................................
C
C
C Get data for analysis of 1 sample
C
         FNAME1 = BLANK
         CALL SVDATA (IC, ICVEC, IFREQ, N, NCMAX, NIN, NRMAX, NVEC,
     +                NVMAX,
     +                A, T, TVEC,
     +                FNAME1, TITLE1,
     +                ABORT, SUPPLY)
         IF (ABORT) GOTO 20
C
C Call G12AAF
C
         IFAIL = 1
         CALL G12AAF$(N, T, IC, FREQ, IFREQ, ND, TP, P, PSIG, IWK,
     +                IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G12AAF/SURVIV')
         IF (IFAIL.NE.N0) GOTO 20
C
C Call G07BEF
C
         IFAIL = N1
         GAMMA = START
         CALL G07BEF$(CENS, NVEC, TVEC, ICVEC, BETA, GAMMA, TOL, MAXIT,
     +                SEBETA, SEGAM, CORR, DEV, NIT, WK, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G07BEF/SURVIV')
         IF (IFAIL.NE.N0) GOTO 20
C
C Transform beta
C
         HATLAM = EXP(BETA)
         SEHLAM = HATLAM*SEBETA
         HATA = HATLAM**(ONE/GAMMA)
         D1 = HATA/GAMMA
         D2 = - HATA*BETA/(GAMMA**2)
         CV = CORR*SEBETA*SEGAM
         ARGVAL = (D1*SEBETA)**2 + (D2*SEGAM)**2 + TWO*D1*D2*CV
         SEHATA = SQRT(MAX(RTOL,ARGVAL))
C
C Calculate parameter details
C
         CALL THWEIB (BETA, CORR, GAMMA, SEBETA, SEGAM, TH, TE)
         SYMPAR(1) = '       B'
         SYMPAR(2) = '    beta'
         SYMPAR(3) = '  lambda'
         SYMPAR(4) = '       A'
         SYMPAR(5) = '  t-half'
         PARAM(1) = GAMMA
         PARAM(2) = BETA
         PARAM(3) = HATLAM
         PARAM(4) = HATA
         PARAM(5) = TH
         STDERR(1) = SEGAM
         STDERR(2) = SEBETA
         STDERR(3) = SEHLAM
         STDERR(4) = SEHATA
         STDERR(5) = TE
         IFAIL = 1
         NDOF = N - 2
         TSTAT = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G01FBF/DATOUT')
         DO I = 1, 5
            IF (STDERR(I).LT.RTOL) STDERR(I) = RTOL
            ARGVAL = ABS(PARAM(I)/STDERR(I))
            IFAIL = 1
            ALPHA = ONE - G01EBF$('Lower-tail', ARGVAL, DBLE(NDOF),
     +                            IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01EBF/DATOUT')
            TSIG(I) = TWO*ALPHA
            TVAL(I) = TSTAT*STDERR(I)
            IF (TSIG(I).GT.PNT05) THEN
               TYPE1(I) = ' *'
            ELSE
               TYPE1(I) = BLANK
            ENDIF
         ENDDO
C
C Create best fit curve
C
         XSTART = TP(1)
         XSTOP = TP(ND)
         CALL DIVIDE (NGRAF, XGRAF, XSTART, XSTOP)
         XBETA = EXP(BETA)
         DO I = N1, NGRAF
            YGRAF(I) = EXP(-XBETA*XGRAF(I)**GAMMA)
         ENDDO
C
C Create step curve
C
         NSTEP = N1
         STEP(NSTEP) = P(NSTEP)
         TIME(NSTEP) = TP(NSTEP)
         DO I = N2, ND
            NSTEP = NSTEP + N1
            STEP(NSTEP) = P(I - N1)
            TIME(NSTEP) = TP(I)
            NSTEP = NSTEP + N1
            STEP(NSTEP) = P(I)
            TIME(NSTEP) = TP(I)
         ENDDO
C
C Write details and parameters to output file
C
         ICOUNT = ICOUNT + N1
         WRITE (NOUT,200) ICOUNT, TRIM80(FNAME1), CHOP80(TITLE1)
         WRITE (NOUT,300)
         IF (E_NUMBERS) THEN
            WRITE (NOUT,400) (SYMPAR(I), PARAM(I), STDERR(I),
     +                        PARAM(I) - TVAL(I),
     +                        PARAM(I) + TVAL(I), TSIG(I),
     +                        TYPE1(I), I = 1, 5)
         ELSE
            DO I = 1, 5
               D13(1) = SHOWRJ(PARAM(I))
               D13(2) = SHOWRJ(STDERR(I))
               TEMP = PARAM(I) - TVAL(I)
               D13(3) = SHOWRJ(TEMP)
               TEMP = PARAM(I) + TVAL(I)
               D13(4) = SHOWRJ(TEMP)  
               WRITE (NOUT,410) SYMPAR(I), D13(1), D13(2), D13(3),
     +                          D13(4), TSIG(I), TYPE1(I)  
            ENDDO 
         ENDIF       
         WRITE (NOUT,450) CORR
C
C Subsidiary loop for data output from analysis of 1 data set
C
         AGAIN = .TRUE.
         DO WHILE (AGAIN)
            NUMDEC = 1
            NUMOPT = 5
            WRITE (TEXT,500)
            CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                   TEXT)
            IF (NUMDEC.EQ.1) THEN
C
C Plot
C
               PTITLE = 'Kaplan-Meier S(t) and Best Fit Weibull Curve'
               XTITLE = 'Time'
               YTITLE = 'KMS(t)'
               CALL GKS004 (N1, N2, N0, N0,
     +                      N0, N0, N0, N0,
     +                      NSTEP, NGRAF, NGRAF, NGRAF,
     +                      TIME, XGRAF, XGRAF, XGRAF,
     +                      STEP, YGRAF, YGRAF, YGRAF,
     +                      PTITLE, XTITLE, YTITLE,
     +                      YES, YES)
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Output data from G12AAF to screen
C
               JCOLOR = 15
               CALL TABLE1 (JCOLOR, 'OPEN')
               WRITE (LINE,600)
               JCOLOR = 4
               CALL TABLE1 (JCOLOR, LINE)
               JCOLOR = 0
               IF (E_NUMBERS) THEN
                  DO I = 1, ND
                     WRITE (LINE,700) TP(I), P(I), PSIG(I)
                     CALL TABLE1 (JCOLOR, LINE)
                  ENDDO
               ELSE
                  DO I = 1, ND
                     D13(1) = SHOWRJ(TP(I))  
                     WRITE (LINE,710) D13(1), P(I), PSIG(I)
                     CALL TABLE1 (JCOLOR, LINE)
                  ENDDO    
               ENDIF  
               CALL TABLE1 (JCOLOR, 'CLOSE')
            ELSEIF (NUMDEC.EQ.3) THEN
C
C Output data from G12AAF to file
C
               WRITE (NOUT,600)
               IF (E_NUMBERS) THEN
                  DO I = 1, ND
                     WRITE (NOUT,700) TP(I), P(I), PSIG(I)
                  ENDDO
               ELSE
                  DO I = 1, ND
                    D13(1) = SHOWRJ(TP(I))
                    WRITE (NOUT,710) D13(1), P(I), PSIG(I)
                  ENDDO  
               ENDIF  
            ELSEIF (NUMDEC.EQ.4) THEN
C
C Output data from G07BEF to screen
C
               WRITE (TEXT,300)
               JCOLOR = 15
               CALL TABLE1 (JCOLOR, 'OPEN')
               DO I = 1, 7
                  IF (I.EQ.1 .OR. I.EQ.7) THEN
                     JCOLOR = 4
                  ELSE
                     JCOLOR = 0
                  ENDIF
                  CALL TABLE1 (JCOLOR, TEXT(I))
               ENDDO
               IF (E_NUMBERS) THEN
                  WRITE (TEXT,400) (SYMPAR(I), PARAM(I), STDERR(I),
     +                              PARAM(I) - TVAL(I),
     +                              PARAM(I) + TVAL(I), TSIG(I),
     +                              TYPE1(I), I = 1, 5)
               ELSE
                  DO I = 1, 5
                     D13(1) = SHOWRJ(PARAM(I))
                     D13(2) = SHOWRJ(STDERR(I))
                     TEMP = PARAM(I) - TVAL(I)
                     D13(3) = SHOWRJ(TEMP)
                     TEMP = PARAM(I) + TVAL(I)
                     D13(4) = SHOWRJ(TEMP)  
                     WRITE (TEXT(I),410) SYMPAR(I), D13(1), D13(2),
     +                                   D13(3), D13(4), TSIG(I),
     +                                   TYPE1(I)  
                  ENDDO 
               ENDIF  
               JCOLOR = 0
               DO I = 1, 5
                  CALL TABLE1 (JCOLOR, TEXT(I))
               ENDDO
               WRITE (TEXT(1),450) CORR
               CALL TABLE1 (JCOLOR, TEXT(1))
               CALL TABLE1 (JCOLOR, 'CLOSE')
            ELSEIF (NUMDEC.EQ.5) THEN
               AGAIN = .FALSE.
            ENDIF
         ENDDO
      ELSEIF (ISEND.EQ.2) THEN
C
C.......................................................................
C Part 2: Analyse 2 samples
C.......................................................................
C
C
C
C Compare two samples A (N, IC, IFREQ) and B (M, IC1, IFREQ1)
C
         CALL PUTADV ('Now input the first set of survival times (A)')
         FNAME1 = BLANK
         CALL SVDATA (IC, ICVEC, IFREQ, N, NCMAX, NIN, NRMAX, NVEC,
     +                NVMAX,
     +                A, T, TVEC,
     +                FNAME1, TITLE1,
     +                ABORT, SUPPLY)
         IF (ABORT) GOTO 20
C
C Initialise TMAX and TMIN
C
         TMAX = TVEC(NVEC)
         TMIN = TVEC(N1)
         CALL PUTADV ('Now input the second set of survival times (B)')
         FNAME3 = BLANK
         CALL SVDATA (IC1, ICVEC, IFREQ1, M, NCMAX, NIN, NRMAX, NVEC,
     +                NVMAX,
     +                A, T1, TVEC,
     +                FNAME3, TITLE3,
     +                ABORT, SUPPLY)
         IF (ABORT) GOTO 20
C
C Adjust TMAX and TMIN
C
         IF (TVEC(N1).LT.TMIN) TMIN = TVEC(N1)
         IF (TVEC(NVEC).GT.TMAX) TMAX = TVEC(NVEC)
C
C Do the comparison
C
         CALL SVCOMP (N, M, NVMAX, IC, IC1, IFREQ, IFREQ1,
     +                QMH, T, T1, THETA, THETA1, THETA2, WK,
     +                ABORT)
         IF (.NOT.ABORT) THEN
            IFAIL = N1
            PVAL = G01ECF$('U', QMH, ONE, IFAIL)
            CALL PLEVEL (PVAL, SYMBOL)
C
C Output results to screen and file
C
            JCOUNT = JCOUNT + N1
            WRITE (NOUT,800) JCOUNT, TRIM80(FNAME1), TRIM80(FNAME3)
            IF (E_NUMBERS) THEN
               WRITE (NOUT,900) QMH, PVAL, SYMBOL, THETA, THETA1, THETA2
               WRITE (TEXT,900) QMH, PVAL, SYMBOL, THETA, THETA1, THETA2
            ELSE
              D13(1) = SHOWLJ(QMH)
              D13(2) = SHOWLJ(THETA)
              D13(3) = SHOWLJ(THETA1)
              D13(4) = SHOWLJ(THETA2)   
              WRITE (NOUT,910) D13(1), PVAL, SYMBOL, D13(2), D13(3),
     +                         D13(4)
              WRITE (TEXT,910) D13(1), PVAL, SYMBOL, D13(2), D13(3),
     +                         D13(4)
            ENDIF  
            JCOLOR = 15
            CALL TABLE1 (JCOLOR, 'OPEN')
            DO I = 1, 9
               IF (I.LE.2) THEN
                  JCOLOR = 4
               ELSEIF (I.EQ.7 .AND. SYMBOL.NE.BLANK) THEN
                  JCOLOR = 1
               ELSE
                  JCOLOR = 0
               ENDIF
               CALL TABLE1 (JCOLOR, TEXT(I))
            ENDDO
            CALL TABLE1 (JCOLOR, 'CLOSE')
C
C Create plots to check for proportional hazards assumption
C First call G12AAF for A-data
C
            IFAIL = 1
            CALL G12AAF$(N, T, IC, FREQ, IFREQ, ND, TP, P, PSIG, IWK,
     +                   IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G12AAF/SURVIV')
            IF (IFAIL.NE.N0) GOTO 20
C
C Save distinct times and Kaplan-Meier S(t) in TVEC and STEP
C
            NA = N0
            DO I = N1, ND
               IF (P(I).GT.EPSI) THEN
                 NA = NA + N1
                 TVEC(NA) = TP(I)
                 STEP(NA) = P(I)
               ENDIF
            ENDDO
C
C Add 1 extra point at t = TMAX
C
            NAP1 = NA + N1
            TVEC(NAP1) = TMAX
            STEP(NAP1) = STEP(NA)
C
C Now call G12AAF for B-data
C
            IFAIL = 1
            CALL G12AAF$(M, T1, IC1, FREQ, IFREQ1, ND, TP, P, PSIG, IWK,
     +                   IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G12AAF/SURVIV')
            IF (IFAIL.NE.N0) GOTO 20
C
C Save distinct times and Kaplan-Meier S(t) in TVEC and STEP
C
            NB = N0
            DO I = N1, ND
               IF (P(I).GT.EPSI) THEN
                  NB = NB + N1
                  TVEC(NAP1 + NB) = TP(I)
                  STEP(NAP1 + NB) = P(I)
               ENDIF
            ENDDO
C
C Add 1 extra point at t = TMAX
C
            NBP1 = NB + N1
            TVEC(NAP1 + NBP1) = TMAX
            STEP(NAP1 + NBP1) = STEP(NAP1 + NB)
            ISEND = 1
            AGAIN = .TRUE.
            DO WHILE (AGAIN)
               WRITE (TEXT,1000)
               NUMOPT = 5
               CALL LBOX02 (ICOLOR, IX, IY, ISEND, NUMOPT, NUMPOS,
     +                      TEXT)
               IF (ISEND.EQ.N1) THEN
C
C KMS(t) simple
C
                  PTITLE = 'Kaplan-Meier S(t) Survivor Curves'
                  XTITLE = 'Time'
                  YTITLE = 'KMS(t)'
                  CALL GKS004 (N8, N8, N0, N0,
     +                         N0, N0, N0, N0,
     +                         NA, NB, N1, N1,
     +                         TVEC(N1), TVEC(NAP1 + N1), XGRAF, XGRAF,
     +                         STEP(N1), STEP(NAP1 + N1), YGRAF, YGRAF,
     +                         PTITLE, XTITLE, YTITLE,
     +                         YES, YES)
               ELSEIF (ISEND.EQ.N2) THEN
C
C KMS(t) advanced: search for censored A data
C
                  IADD1 = N1
                  TEST = TVEC(IADD1)
                  NCENSA = N0
                  DO I = N1, N
                     IF (IC(I).EQ.N0) THEN
                        IF (T(I).GT.TEST) THEN
                           IADD1 = IADD1 + N1
                           TEST = TVEC(IADD1)
                        ENDIF
                     ELSEIF(IFREQ(I).GT.N0) THEN
                        NCENSA = NCENSA + N1
                        WK(NCENSA) = STEP(IADD1)
                        TIME(NCENSA) = T(I)
                     ENDIF
                  ENDDO
C
C KMS(t) advanced: search for censored B data
C
                  IADD1 = NAP1 + N1
                  TEST = TVEC(IADD1)
                  NCENSB = N0
                  DO I = N1, M
                     IF (IC1(I).EQ.N0) THEN
                        IF (T1(I).GT.TEST) THEN
                           IADD1 = IADD1 + N1
                           TEST = TVEC(IADD1)
                        ENDIF
                     ELSEIF (IFREQ1(I).GT.N0) THEN
                        NCENSB = NCENSB + N1
                        WK(NCENSA + NCENSB) = STEP(IADD1)
                        TIME(NCENSA + NCENSB) = T1(I)
                     ENDIF
                  ENDDO
                  PTITLE = 'Extended KMS(t) Curves (+ if Censored)'
                  XTITLE = 'Time'
                  YTITLE = 'KMS(t)'
                  CALL GKS004 (N8, N8, N0, N0,
     +                         N0, N0, N2, N2,
     +                         NAP1, NBP1, NCENSA, NCENSB,
     +                         TVEC(N1), TVEC(NAP1 + N1),
     +                         TIME(N1), TIME(NCENSA + N1),
     +                         STEP(N1), STEP(NAP1 + N1),
     +                         WK(N1), WK(NCENSA + N1),
     +                         PTITLE, XTITLE, YTITLE,
     +                         YES, YES)
               ELSEIF (ISEND.EQ.N3) THEN
C
C Plot H(t)
C
                  DO I = N1, NA
                     WK(I) = -LOG(STEP(I))
                  ENDDO
                  DO I = N1, NB
                     WK(NAP1 + I) = -LOG(STEP(NAP1 + I))
                  ENDDO
                  PTITLE = 'Cumulative Hazard Curves'
                  XTITLE = 'Time'
                  YTITLE = '-log[KMS(t)]'
                  CALL GKS004 (N1, N2, N0, N0,
     +                         N1, N1, N0, N0,
     +                         NA, NB, N1, N1,
     +                         TVEC(N1), TVEC(NAP1 + N1), XGRAF, XGRAF,
     +                         WK(N1), WK(NAP1 + N1), YGRAF, YGRAF,
     +                         PTITLE, XTITLE, YTITLE,
     +                         YES, YES)
               ELSEIF (ISEND.EQ.N4 .AND. TMIN.GT.EPSI) THEN
C
C Plot log(H(t)) against log(t)
C
                  DO I = N1, NA
                     TIME(I) = LOG(TVEC(I))
                  ENDDO
                  DO I = N1, NB
                     TIME(NAP1 + I) = LOG(TVEC(NAP1 + I))
                  ENDDO
                  DO I = N1, NA
                     WK(I) = LOG(-LOG(STEP(I)))
                  ENDDO
                  DO I = N1, NB
                     WK(NAP1 + I) = LOG(-LOG(STEP(NAP1 + I)))
                  ENDDO
                  PTITLE = 'Log-Log Cumulative Hazard Curves'
                  XTITLE = 'log[Time]'
                  YTITLE = 'log[-log{KMS(t)}]'
                  CALL GKS004 (N1, N2, N0, N0,
     +                         N1, N1, N0, N0,
     +                         NA, NB, N1, N1,
     +                         TIME(N1), TIME(NAP1 + N1), XGRAF, XGRAF,
     +                         WK(N1), WK(NAP1 + N1), YGRAF, YGRAF,
     +                         PTITLE, XTITLE, YTITLE,
     +                         YES, YES)
               ELSE
                  AGAIN = .FALSE.
               ENDIF
            ENDDO
         ENDIF
      ELSEIF (ISEND.EQ.3) THEN
         CALL REVPRO (NOUT)
      ELSEIF (ISEND.EQ.4) THEN
         REPEET = .FALSE.
      ENDIF
C
C End of analysis.......................................................
C
      ENDDO
  100 FORMAT (
     + 'Analyse 1 sample (Kaplan-Meier/Weibull)'
     +/'Compare 2 samples (Mantel-Haenszel/log-rank)'
     +/'Results'
     +/'Quit ... Exit these survival analysis options')
  200 FORMAT (
     +/1X,'Single Survival Analysis no.',I4
     +/1X,'================================'
     +/1X,'File name'
     +/A
     +/1X,'Data title'
     +/A
     +/)
  300 FORMAT (
     + ' Alternative MLE Weibull parameterizations',
     +/
     +/' S(t) = exp[-{exp(beta)}t^B]'
     +/'      = exp[-{lambda}t^B]'
     +/'      = exp[-{A*t}^B]'
     +/
     +/'Parameter    Value      Std. err.  Lower95%cl  Upper95%cl    p')
  400 FORMAT (A8,1P,E13.4,3E12.3,0P,F8.4,A2) 
  410 FORMAT (A8,4A13,F8.4,A2)     
  450 FORMAT (' Correlation coefficient(beta,B) =',F8.4)
  500 FORMAT (
     + 'Plot KMS(t) curve'
     +/'Display KMS(t) table'
     +/'Write table to file'
     +/'Display parameters'
     +/'Quit ... Exit these Kaplan-Meier options')
  600 FORMAT ('    Time        KMS(t)  Std.Err.')
  700 FORMAT (2X,1P,E11.3,0P,2F9.4)
  710 FORMAT (A13,2F9.4)
  800 FORMAT (
     +/1X,'Double Survival Analysis no.',I4
     +/1X,'==============================='
     +/1X,'File name (A-data)'
     +/A
     +/1X,'File name (B-data)'
     +/A)
  900 FORMAT (
     +/' Results for the Mantel-Haenszel (log-rank) test'
     +/
     +/' H0: h_A(t) = h_B(t)       (equal hazards)'
     +/' H1: h_A(t) = theta*h_B(t) (proportional hazards)'
     +/' QMH test statistic     =',1P,E11.3
     +/' p = P(chi-sq. >= QMH)  =',0P,F11.4,1X,A
     +/' Estimate for theta     =',1P,E11.3
     +/' 95% conf. range        =',   E11.3, ',',E11.3
     +/)
  910 FORMAT (
     +/' Results for the Mantel-Haenszel (log-rank) test'
     +/
     +/' H0: h_A(t) = h_B(t)       (equal hazards)'
     +/' H1: h_A(t) = theta*h_B(t) (proportional hazards)'
     +/' QMH test statistic     =',1X,A13
     +/' p = P(chi-sq. >= QMH)  =',F11.4,1X,A
     +/' Estimate for theta     =',1X,A13
     +/' 95% conf. range        =',1X,A13, ',',1X,A13
     +/)     
 1000 FORMAT (
     + 'KMS(t) (simple plot)'
     +/'KMS(t) (advanced plot)'
     +/'H(t) against t (test exponential)'
     +/'log[H(t)] against log(t) (test Weibull)'
     +/'Quit ... Exit these survival analysis plotting options')
      END
C
C
