C
C
      SUBROUTINE SVCOMP (NA, NB, NMAX, ICA, ICB, IFREQA, IFREQB, 
     +                   QMH, TA, TB, THETA, THETA1, THETA2, W,
     +                   ABORT)
C
C ACTION : Compare two samples of censored survival times
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 14/6/96
C ADVICE : See Marubini and Valsecchi pp 92-98 (J Wiley, 1995)
C          Note that the two sub-loops can be optimised for one pass
C          calculation. Current code is temporary but works ok.
C          Note also that [Z(1 - alpha/2)]^2 = 3.8416
C          27/08/1998 Improved the sub-loops by previous sorting but it
C                     can still be improved
C          28/07/2003 revised and removed sorting of TA and TB as it is
C                     assumed that data must be sorted into increasing order
C          02/20/2007 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: NA, NB, NMAX, ICA(NA), ICB(NB),
     +                                  IFREQA(NA), IFREQB(NB)
      DOUBLE PRECISION, INTENT (IN)  :: TA(NA), TB(NB)
      DOUBLE PRECISION, INTENT (OUT) :: QMH,  THETA, THETA1, THETA2,
     +                                  W(NMAX)
      LOGICAL,          INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    I, IKA, IKB, NDIST, NTOTAL
      INTEGER    NAC, NAD, NAJ, NBC, NBD, NBJ, NDAJ, NDBJ, NDJ, NJ
      DOUBLE PRECISION TEMP, TEST
      DOUBLE PRECISION FOUR, TWO, ZSQD, ZERO
      PARAMETER (ZERO = 0.0D+00, FOUR = 4.0D+00, TWO = 2.0D+00,
     +           ZSQD = 3.8416D+00)
      DOUBLE PRECISION EJ, VJ, RJ, SJ, WJ
      DOUBLE PRECISION SUMDAJ, SUMDBJ, SUMDJ
      DOUBLE PRECISION SUMEJ, SUMVJ, SUMRJ, SUMSJ, SUMWJ
      DOUBLE PRECISION ROOT
      CHARACTER  LINE*100
      EXTERNAL   NXSORT, PUTFAT
      INTRINSIC  DBLE, SQRT
C
C Check
C
      ABORT = .FALSE.
      QMH = ZERO
      THETA = ZERO
      THETA1 = ZERO
      THETA2 = ZERO
      IF (NA + NB.GT.NMAX) THEN
         ABORT = .TRUE.
         CALL PUTFAT ('Samples too large  ...  use frequencies')
         RETURN
      ENDIF
C
C Make a vector (NTOTAL = NA + NB) then sort it into ascending order
C During the calculation work out NJ the total number of data points
C
      NAJ = N0
      NBJ = N0
      DO I = N1, NA
         NAJ = NAJ + IFREQA(I)
         W(I) = TA(I)
      ENDDO
      NTOTAL = NA
      DO I = N1, NB
         NTOTAL = NTOTAL + N1
         NBJ = NBJ + IFREQB(I)
         W(NTOTAL) = TB(I)
      ENDDO
      CALL NXSORT (NTOTAL, W)
C
C Find the number of distinct time points (NDIST)
C
      NDIST = N1
      DO I = N2, NTOTAL
         IF (W(I).GT.W(NDIST)) THEN
            NDIST = NDIST + N1
            W(NDIST) = W(I)
         ENDIF
      ENDDO
C
C Loop through all the distinct points
C
      IKA = N0
      IKB = N0
      SUMDAJ = ZERO
      SUMDBJ = ZERO
      SUMDJ = ZERO
      SUMEJ = ZERO
      SUMVJ = ZERO
      SUMRJ = ZERO
      SUMSJ = ZERO
      SUMWJ = ZERO
      NJ = NAJ + NBJ
      DO I = N1, NDIST
C
C Initialise all counters for each new distinct time point
C NAC = no. A censored at this time
C NAD = no. A failing at this time
C NBC = no. B censored at this time
C NBD = no. B failing at this time
C
         TEST = W(I)
         NAC = N0
         NAD = N0
         NBC = N0
         NBD = N0
C
C Scan the TA vector from IKA upwards
C
   20    CONTINUE
         IF (IKA.LT.NA) THEN
            TEMP = TA(IKA + 1)
            IF (TEMP.LE.TEST) THEN
               IKA = IKA + 1
               IF (ICA(IKA).EQ.N0) THEN
                   NAD = NAD + IFREQA(IKA)
               ELSE
                   NAC = NAC + IFREQA(IKA)
               ENDIF
               GOTO 20
            ENDIF
         ENDIF
C
C Scan the TB vector
C
   40    CONTINUE
         IF (IKB.LT.NB) THEN
            TEMP = TB(IKB + 1)
            IF (TEMP.LE.TEST) THEN
               IKB = IKB + 1
               IF (ICB(IKB).EQ.N0) THEN
                   NBD = NBD + IFREQB(IKB)
               ELSE
                   NBC = NBC + IFREQB(IKB)
               ENDIF
               GOTO 40
            ENDIF
         ENDIF
C
C Do the sums
C ===========
C NJ = no. surviving up to this time
C NDAJ = no. A failing at this time
C NDBJ = no. B failing at this time
C NDJ = no. A and B failing at this time
C
         NDAJ = NAD
         NDBJ = NBD
         NDJ = NDAJ + NDBJ
         IF (NDJ.GT.N0 .AND. NJ.GT.N1) THEN
            EJ = DBLE(NAJ*NDJ)/DBLE(NJ)
            VJ = DBLE(NAJ*NBJ*NDJ*(NJ - NDJ))/DBLE(NJ*NJ*(NJ - N1))
            RJ = DBLE(NDAJ*(NBJ - NDBJ))/DBLE(NJ)
            SJ = DBLE(NDBJ*(NAJ - NDAJ))/DBLE(NJ)
            WJ = DBLE(NDAJ*(NBJ - NDBJ)*(NAJ - NDAJ + NDBJ + N1) +
     +      (NAJ - NDAJ)*(NDBJ*(NBJ - NDBJ + NDAJ + N1)))/DBLE(NJ*NJ)
            SUMDAJ = SUMDAJ + DBLE(NDAJ)
            SUMDBJ = SUMDBJ + DBLE(NDBJ)
            SUMDJ = SUMDJ + DBLE(NDJ)
            SUMEJ = SUMEJ + EJ
            SUMVJ = SUMVJ + VJ
            SUMRJ = SUMRJ + RJ
            SUMSJ = SUMSJ + SJ
            SUMWJ = SUMWJ + WJ
         ENDIF
C
C Now adjust NJ to allow for censoring and failing at this time
C

         IF (I.LT.NDIST) THEN
            NAJ = NAJ - NAC - NAD
            NBJ = NBJ - NBC - NBD
            NJ = NAJ + NBJ
         ENDIF
      ENDDO
      IF (SUMVJ.GT.ZERO .AND. SUMSJ.GT.ZERO) THEN
C
C Calculate the chi-square statistic QMH
C
         QMH = (SUMDAJ - SUMEJ)**2/SUMVJ
C
C Calculate THETA and 95% confidence limits
C
         THETA = SUMRJ/SUMSJ
         ROOT = SQRT((FOUR*SUMRJ*SUMSJ + ZSQD*SUMWJ)*ZSQD*SUMWJ)
         THETA1 = (TWO*SUMRJ*SUMSJ + ZSQD*SUMWJ - ROOT)/(TWO*SUMSJ**2)
         THETA2 = (TWO*SUMRJ*SUMSJ + ZSQD*SUMWJ + ROOT)/(TWO*SUMSJ**2)
      ELSE
         ABORT = .TRUE.
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
      ENDIF
  100 FORMAT ('Calculation of QMH and theta is not possible')
      END
C
C
