C
C
      SUBROUTINE SVDATA (IC, ICVEC, IFREQ, N, NCMAX, NIN, NRMAX, NVEC,
     +                   NVMAX,
     +                   A, T, TVEC,
     +                   FNAME, TITLE,
     +                   ABORT, SUPPLY)
C
C ACTION : Read in a sample of censored survival times
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 26/4/96
C          
C          28/07/2003 revised to make sure times are in increasing order
C          27/07/2004 added call to MTSORT to rearrange if this is required
C          02/10/2007 added SUPPLy to argument list
C          14/05/2013 removed B from argument list
C
C           NIN: (input/unchanged) unconnected unit for data input
C         NRMAX: (input/unchanged) dimension
C         NVMAX: (input/unchanged) dimension
C         ABORT: (output) only returned as .FALSE. if successful
C        SUPPLY: (input/unchanged) as follows:        
C                 SUPPLY = .TRUE. then input A (as N by 3), FNAME, and TITLE            
C                 SUPPLY = .FALSE. then read in A, FNAME, and TITLE
C
C Notes: 1) ICVEC(NVEC) and T(NVEC) have frequencies unrolled for G07BEF
C        2) So NVMAX must be large enough to unroll T, i.e. NVMAX >> N
C        3) B is no longer used by MATTIN
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NIN, NRMAX, NVMAX
      INTEGER,             INTENT (INOUT) :: N
      INTEGER,             INTENT (OUT)   :: IC(NRMAX), ICVEC(NVMAX),
     +                                       IFREQ(NRMAX), NVEC 
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,NCMAX)
      DOUBLE PRECISION,    INTENT (OUT)   :: T(NRMAX), TVEC(NVMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (IN)    :: SUPPLY
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    ISEND
      PARAMETER (ISEND = 2)
      INTEGER    N0, N1, N2, N3
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    I, ITEMP, J, NCOL, NROW
      DOUBLE PRECISION B(5), TEMP
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  LINE*100
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .TRUE., FIXROW = .FALSE., LABEL = .TRUE.)
      EXTERNAL   PUTFAT, MATTIN, MTSORT
      INTRINSIC  NINT
      
C
C Initialise
C 
      IF (NCMAX.LT.3 .OR. NIN.LT.1 .OR. NRMAX.LT.2 .OR. NVMAX.LT.2) THEN
         ABORT = .TRUE.
         RETURN
      ELSE   
         ABORT = .FALSE. 
         CLOSE (UNIT = NIN)
         NVEC = N0
         DO I = N1, NRMAX
            IC(I) = N0
            IFREQ(I) = N0
            T(I) = ZERO
         ENDDO  
         DO I = N1, NVMAX
           ICVEC(I) = N0
           TVEC(I) = ZERO
         ENDDO 
         B(1) = ZERO
         NCOL = N3  
      ENDIF  
C
C Read in the data and check the title
C
      
      IF (SUPPLY) THEN
C
C SUPPLY = .TRUE. so check the MATRIX supplied
C        
         IF (N.LT.2) THEN
            WRITE (LINE,100)
            CALL PUTFAT (LINE)
            ABORT = .TRUE.
            RETURN
         ENDIF  
         NROW = N           
      ELSE
C
C SUPPLY = .FALSE. so get the user to open a file
C        
         CALL MATTIN (ISEND, N3, NCOL, NIN, NRMAX, NROW,
     +                A, B,
     +                FNAME, TITLE,
     +                ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) RETURN
         N = NROW  
      ENDIF 
        
C
C Rearrange if necessary
C
      CALL MTSORT (NCOL, NRMAX, NROW,
     +             A,
     +             ABORT)
C
C Check for sufficient data points
C
      IF (ABORT) THEN
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C Main loop to check then define variables
C
      DO I = N1, N
C
C Times must be nonnegative
C
         TEMP = A(I,N1)
         IF (TEMP.LT.ZERO) THEN
            ABORT = .TRUE.
            WRITE (LINE,200) I
            CALL PUTFAT (LINE)
            RETURN
         ELSE
            T(I) = TEMP
         ENDIF
C
C Times must be in nondecreasing order
C
         IF (I.GT.N1) THEN
            IF (T(I).LT.T(I - N1)) THEN
               ABORT = .TRUE.
               WRITE (LINE,300) I, I - N1
               CALL PUTFAT (LINE)
               RETURN
            ENDIF
         ENDIF
C
C Censoring code must be 0 or 1
C
         ITEMP = NINT(A(I,N2))
         IF (ITEMP.EQ.N0) THEN
            IC(I) = N0
         ELSEIF (ITEMP.EQ.N1) THEN
            IC(I) = N1
         ELSE
            ABORT = .TRUE.
            WRITE (LINE,400) I
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
C
C Frequency must be nonnegative
C
         TEMP = A(I,N3)
         IF (TEMP.LT.ZERO) THEN
            ABORT = .TRUE.
            WRITE (LINE,500) I
            CALL PUTFAT (LINE)
            RETURN
         ELSE
            IFREQ(I) = NINT(TEMP)
         ENDIF
      ENDDO
C
C Fill out the arrays IVEC and TVEC
C
      NVEC = N0
      DO I = N1, N
         IF (IFREQ(I).GT.N0) THEN
            DO J = N1, IFREQ(I)
               NVEC = NVEC + N1
               IF (NVEC.LE.NVMAX) THEN
                  TVEC(NVEC) = T(I)
                  ICVEC(NVEC) = IC(I)
               ELSE
                  ABORT = .TRUE.
                  WRITE (LINE,600) NVMAX
                  CALL PUTFAT (LINE)
                  RETURN
               ENDIF
            ENDDO
         ENDIF
      ENDDO
      ABORT = .FALSE.
C
C Format statement
C      
  100 FORMAT ('Too few rows or too many columns')
  200 FORMAT ('Time(',I6,') < 0 ... Must be nonnegative')
  300 FORMAT ('Time(',I6,') < Time(',I6,') ... Must be nondecreasing')
  400 FORMAT ('Censoring code not 0 or 1 at data point',I6)
  500 FORMAT ('Frequency < 0 at data point',I6)
  600 FORMAT ('Too many time points ... N >',I6)
      END
C
C
