c
c
      subroutine symeig (ncmaxa, ncmaxb, ncola, ncolb, nin, nout,
     +                   nrmaxa, nrmaxb, nrowa, nrowb,
     +                   a, b,
     +                   titlea, titleb,
     +                   newdat, supply)
c
c action: symmetric eigenvalue problem (A - lambda*B)x = 0
c author: w.g.bardsley, university of manchester, u.k., 30/01/2004
c         24/02/2005 replaced dsygv by f02fdf$
c         09/01/2006 changed c and d from arguments to allocatable
c         27/02/2006 extensive revision and added newdat and supply
c         02/08/2006 made newdat an array to allow for A or B renewal 
c         17/10/2006 corrected errors when supply = .false. and revised  
c         11/05/2010 introduced NKLCFG to switch on/off the test file advice
c         30/04/2011 introduced call to TFILEQ 
c         07/11/2015 minor editing to replace lbox02 by lstbox  
c         05/11/2021 added E_NUMBERS and E_FORMATS, etc.
c
c    ncmaxa: (input/unchanged) second dimension of matrix a
c    ncmaxb: (input/unchanged) second dimension of matrix b
c     ncola: (input/output) no. cols.of a (depending on supply)
c     ncolb: (input/output) no. cols.of b (depending on supply)
c       nin: (input/unchanged) unconnected unit for data input
c      nout: (input/unchanged) preconnected unit for results
c    nrmaxa: (input/unchanged) leading dimension for matrix a
c    nrmaxb: (input/unchanged) leading dimension for matrix b
c     nrowa: (input/output) no. of rows of a (depending on supply)
c     nrowb: (input/output) no. of rows of a (depending on supply)
c         a: (input/output) matrix a (depending on supply)
c         b: (input/output) matrix b (depending on supply)
c    newdat: (output) .true. if new data required
c    supply: (input/unchanged) if .true. then supply a and b
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: ncmaxa, ncmaxb, nin, nout,
     +                                       nrmaxa, nrmaxb 
      integer,             intent (inout) :: ncola, ncolb, nrowa, nrowb
      double precision,    intent (inout) :: a(nrmaxa,ncmaxa), 
     +                                       b(nrmaxb,ncmaxb)
      character (len = *), intent (inout) :: titlea, titleb
      logical,             intent (in)    :: supply
      logical,             intent (out)   :: newdat(2)
c
c local allocatable arrays
c
      double precision, allocatable :: c(:,:), d(:,:), v(:), w(:)
c
c locals
c
      integer    itype, nblock, ntype, n1, n21
      parameter (nblock = 64, ntype = 3, n1 = 1, n21 = 21)
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 13, numsta = 11, numtxt = numsta + numopt - 1)
      integer    numbld(numtxt)
      integer    i, icount, ierr, info, j, n, na, nb, ncmax, nrmax, 
     +           nwmax
      integer    kval9, nklcfg
      double precision rtol, x02amf$
      character  fname*1024
      character  line*100, text(30)*100, titlec*80
      character  cipher(3)*30, ptype(3)*40, word13*13
      character (len = 12) form12, word12(2)
      character (len = 13) d13, showrj
      character  blank*1, jobz*1, uplo*1
      parameter (blank = ' ', jobz = 'V', uplo = 'U')
      character  done*30
      parameter (done = '(***done***)')
      logical    e_numbers, e_formats
      logical    fixcol, fixrow, label
      parameter (fixcol = .false., fixrow = .false., label = .true.)
      logical    header, qtext, qtitle
      parameter (header = .true., qtext = .true., qtitle = .true.)
      logical    abort, repeet, ok, sav1, sav2
      external   e_formats, showrj
      external   lstbox, mattin, putfat, table1, vecout, matout,
     +           dsplay, putifa, viewit, revpro, putadv
      external   nklcfg, tfileq, form12
      external   x02amf$, f02fdf$
      intrinsic  abs, max
      data       numbld / numtxt*0 /
      data       ptype / 'Case: Ax = lambda*Bx',
     +                   'Case: ABx = lambda*x',
     +                   'Case: BAx = lambda*x' /
      data       icount / 0 /
c
c initialise newdat then check dimensions
c
      newdat(1) = .false.
      newdat(2) = .false.
      if (ncmaxa.lt.2 .or. ncmaxb.lt.2 .or.
     +    nrmaxa.lt.2 .or. nrmaxb.lt.2) return
c
c allocate workspace
c
      ierr = 0
      if (allocated(c)) deallocate(c, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(d)) deallocate(d, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(v)) deallocate(v, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      nrmax = max(nrmaxa, nrmaxb)
      ncmax = max(ncmaxa, ncmaxb)
      nwmax = nblock*max(nrmax,ncmax)
      allocate(c(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(d(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(v(ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(w(nwmax), stat = ierr)
      if (ierr.ne.0) return
c
c initialise
c

      rtol = 1.0d+09*x02amf$()
      n = 0
      if (supply) then
         if (ncola.lt.2  .or. ncolb.lt.2 .or. ncola.ne.ncolb .or.
     +       ncola.ne.nrowa .or. ncola.ne.nrowb) return
         na = nrowa
         nb = nrowb
         sav1 = .true.
         sav2 = .true.
      else
         na = 0
         nb = 0
         sav1 = .false.
         sav2 = .false.
      endif
      ok = .false.
      do i = 1, 3
         cipher(i) = blank
      enddo
      e_numbers = e_formats()
      repeet = .true.
c
c main loop
c
      icount = icount + 1
      write (nout,50) icount
      do while (repeet)
         numdec = 3
         word12(1) = form12(na)
         word12(2) = form12(nb)
         write (text,100) (cipher(i), i = 1, 3), word12(1), word12(2)
         numbld(1) = 1
         numbld(6) = 1
         numbld(7) = 1
         numbld(8) = 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         numbld(6) = 0
         numbld(7) = 0
         numbld(8) = 0
         if (numdec.ge.6 .and. numdec.le.9) then
            if (.not.ok) numdec = numopt + 1
         endif
         if (numdec.eq.1) then
c
c new matrix a
c
            if (supply) then
               newdat(1) = .true.
               newdat(2) = .false.
               deallocate (c, stat = ierr)
               deallocate (d, stat = ierr)
               deallocate (v, stat = ierr)
               deallocate (w, stat = ierr)
               return
            endif
            na = 0
            ok = .false.
            sav1 = .false.
            sav2 = .false.
            kval9 = nklcfg(n21)
            if (kval9.eq.n1) then
               write (line,200) 'matrix.tf4'
               call tfileq (line)
            endif   
            i = 0
            close (unit = nin)
            call mattin (i, ncmaxa, ncola, nin, nrmaxa, nrowa,
     +                   a, v,
     +                   fname, titlea,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (abort) then
               na = 0
            elseif (ncola.ne.nrowa) then
               write (line,300)
               call putfat (line)
            elseif (ncola.lt.2 .or. nrowa.lt.2 ) then
               write (line,400)
               call putfat (line)
            else
               na = ncola
               do j = 2, na
                  if (na.ge.2) then
                     do i = 1, j - 1
                        if (na.ge.2) then
                           if (abs(a(i,j) - a(j,i)).gt.rtol) then
                               na = 0
                               write (line,500) i, j, j, i
                               call putfat (line)
                           endif
                        endif
                     enddo
                  endif
               enddo
               if (na.ge.2) then
                   write (nout,'(a)') blank
                   write (nout,'(a)') 'Current matrix A is:'
                   write (nout,'(a)') titlea
                   if (na.le.10) then
                      do i = 1, na
                         write (nout,'(1p,10e11.3)') (a(i,j), j = 1, na)
                      enddo
                   endif
               endif
            endif
         elseif (numdec.eq.2) then
c
c new matrix b
c
            if (supply) then
               newdat(1) = .false.
               newdat(2) = .true.
               deallocate (c, stat = ierr)
               deallocate (d, stat = ierr)
               deallocate (v, stat = ierr)
               deallocate (w, stat = ierr)
               return
            endif
            nb = 0
            ok = .false.
            sav1 = .false.
            sav2 = .false.
            kval9 = nklcfg(n21)
            if (kval9.eq.n1) then
               write (line,200) 'matrix.tf3'
               call tfileq (line)
            endif   
            i = 0
            close (unit = nin)
            call mattin (i, ncmaxb, ncolb, nin, nrmaxb, nrowb,
     +                   b, v,
     +                   fname, titleb,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (abort) then
               nb = 0
            elseif (ncolb.ne.nrowb) then
               write (line,300)
               call putfat (line)
            elseif (ncolb.lt.2 .or. nrowb.lt.2 ) then
               write (line,400)
               call putfat (line)
            else
               nb = ncolb
               do j = 2, nb
                  if (nb.ge.2) then
                     do i = 1, j - 1
                        if (nb.ge.2) then
                           if (abs(b(i,j) - b(j,i)).gt.rtol) then
                               nb = 0
                               write (line,500) i, j, j, i
                               call putfat (line)
                           endif
                        endif
                     enddo
                  endif
               enddo
               if (nb.ge.2) then
                   write (nout,'(a)') blank
                   write (nout,'(a)') 'Current matrix B is:'
                   write (nout,'(a)') titleb
                   if (nb.le.10) then
                      do i = 1, nb
                         write (nout,'(1p,10e11.3)') (b(i,j), j = 1, nb)
                      enddo
                   endif
               endif
            endif
         elseif (numdec.ge.3 .and. numdec.le.5) then
c
c calculate
c
            if (na.lt.2 .or. nb.lt.2) then
               write (line,400)
               call putfat (line)
            elseif (na.ne.nb) then
               write (line,300)
               call putfat (line)
            else
c
c copy a and b to prevent overwriting
c
               n = na
               do j = 1, n
                  do i = 1, n
                     c(i,j) = a(i,j)
                     d(i,j) = b(i,j)
                  enddo
               enddo
               sav1 = .false.
               sav2 = .false.
               if (numdec.eq.3) then
                  itype = 1
               elseif (numdec.eq.4) then
                  itype = 2
               else
                  itype = 3
               endif
               call f02fdf$(itype, jobz, uplo, n, c, nrmax, d, nrmax,
     +                      v, w, nwmax, info)
               do i = 1, 3
                  cipher(i) = blank
               enddo
               if (info.eq.0) then
                  ok = .true.
                  cipher(itype) = done
                  if (n.le.15) sav1 = .true.
                  if (n.le.10) sav2 = .true.
                  write (line,600)
                  call putadv (line)
               else
                  ok = .false.
                  write (word13,700)
                  call putifa (info, nout, word13)
               endif
            endif
         elseif (numdec.eq.6) then
c
c display eigenvalues
c
            if (ok) then
               j = 15
               call table1 (j, 'OPEN')
               write (line,800) ptype(itype)
               if (sav1) then
                  write (nout,'(a)') blank
                  write (nout,800) ptype(itype)
                  write (nout,'(a)') blank
               endif   
               j = 4
               call table1 (j, line)
               j = 1
               call table1 (j, titlea)
               call table1 (j, titleb)
               j = 0
               do i = 1, n
                  if (e_numbers) then
                     write (line,900) v(i)
                     if (sav1) write (nout,900) v(i)
                  else
                     d13 = showrj(v(i))
                     write (line,950) d13
                     if (sav1) write (nout,950) d13
                  endif     
                  call table1 (j, line)
               enddo
               call table1 (j, 'CLOSE')
               sav1 = .false.
            endif
         elseif (numdec.eq.7) then
c
c Display eigenvectors
c
            if (ok) then
               write (line,1000) ptype(itype)
               call dsplay (ncmax, n, nout, nrmax, n, ntype,
     +                      c,
     +                      line,
     +                      sav2)
               sav2 = .false.
            endif
         elseif (numdec.eq.8) then
c
c file eigenvalues
c
            if (ok) then
               i = 1              
               write (titlec,800) ptype(itype)
               close (unit = nin)
               call vecout (i, ncmax, nin, n,
     +                      v,
     +                      fname, titlec,
     +                      abort, qtext, qtitle)
               close (unit = nin)
            endif
         elseif (numdec.eq.9) then
c
c file eigenvectors
c
            if (ok) then
               text(1) = blank
               i = 1
               j = 1 
               write (titlec,1000) ptype(itype)
               call matout (i, n, nin, nrmax, n, j,
     +                      c,
     +                      fname, text, titlec,
     +                      abort, header, qtext, qtitle)
            endif
         elseif (numdec.eq.10) then
c
c display a
c
            if (ncola.gt.1 .and. nrowa.gt.1) then
               call viewit (ncola, nrmaxa, nrowa, ntype,
     +                      a,
     +                      titlea)
            else
               write (line,400)
               call putfat (line)
            endif
         elseif (numdec.eq.11) then
c
c display b
c
            if (ncolb.gt.1 .and. nrowb.gt.1) then
            call viewit (ncolb, nrmaxb, nrowb, ntype,
     +                   b,
     +                   titleb)
            else
               write (line,400)
               call putfat (line)
            endif
         elseif (numdec.eq.12) then
c
c results
c
            call revpro (nout)
         elseif (numdec.eq.numopt) then
c
c quit
c
             if (supply) then
                newdat(1) = .false.
                newdat(2) = .false.
             endif
             repeet = .false.
         else
c
c warning
c
            write (line,1100)
            call putfat (line)
         endif
      enddo
c
c deallocate workspace
c
      deallocate(c, stat = ierr)
      deallocate(d, stat = ierr)
      deallocate(v, stat = ierr)
      deallocate(w, stat = ierr)
c
c format statements
c
   50 Format (
     +/'Symmetric Eigenvalue problems',i3
     +/'================================'
     +/)
  100 format (
     + 'The symmetric eigenlue problems'
     +/
     +/'Given two symmetric matrices A and B with the same'
     +/'dimension this procedure calculates the eigenvalues'
     +/'and eigenvectors for the three eigenvalue problems'
     +/'Ax = lambda*Bx'
     +/'ABx = lambda*x'
     +/'BAx = lambda*x'
     +/'where B is positive definite.'
     +/
     +/'Input: new A [must be symmetric]'
     +/'Input: new B [must be symmetric pos. def.]'
     +/'Solve Ax = lambda*Bx',2x,a
     +/'Solve ABx = lambda*x',2x,a
     +/'Solve BAx = lambda*x',2x,a
     +/'View/File current eigenvalues'
     +/'View/File current eigenvectors'
     +/'Save eigenvalues As ...'
     +/'Save eigenvectors As ...'
     +/'View matrix A: current dimension =',1x,a
     +/'View matrix B: current dimension =',1x,a
     +/'Results'
     +/'Quit ... Exit symmetric eigenvalue analysis')
  200 format ('Now input a symmetric matrix like',1x,a)
  300 format ('Must have number of rows = number of columns')
  400 format ('Must have at least two rows and columns')
  500 format ('X(',i4,',',i4,') not equal to X(',i4,',',i4,')')
  600 format ('Eigenvalues/vectors have been calculated')
  700 format ('F02FDF/SYMEIG')
  800 format ('Eigenvalues...',a)
  900 format (1p,e15.7)
  950 format (1x,a)
 1000 format ('Eigenvectors by column ...',a)
 1100 format ('First calculate the eigenvalues and eigenvectors')
      end
c
c
