c
c
      subroutine t4253h (n,
     +                   x, y, z)
c
c action: t4253h twice smoother
c author: w.g.bardsley, university of manchester, u.k., 21/02/2002
c         01/06/2015 revised, added intents and calls to t4253x
c
c note: 01/06/2015
c       This version uses the end point corrections and other features described
c       in the R documentation, but it is left with very verbose code to make the
c       steps clear. It could easily be improved to dispense with the allocated
c       workspace and include code to speed up the calculation of moving medians. 
c
c         x = data (unchanged)
c         y = smooth (returned)
c         z = rough (returned)
c
      implicit   none
c
c arguments
c      
      integer,          intent (in)  :: n
      double precision, intent (in)  :: x(n)
      double precision, intent (out) :: y(n), z(n)
c
c allocatable
c      
      double precision, allocatable :: ztemp(:)
c
c locals
c      
      integer    i, isend 
      double precision zero
      parameter (zero = 0.0d+00)
      external   t4253x
c
c initialise then check n
c
      if (n.gt.0) then
         do i = 1, n
            y(i) = x(i)
            z(i) = zero
         enddo   
      endif   
      if (n.le.6) return
      i = 0
      allocate (ztemp(n),stat = i)
      if (i.ne.0) return  
c
c Part 1: generate the first smooth y from x using ztemp for workspace
c =======
c

c
c First a running median span 4 
c     
      isend = 1
      call t4253x (isend, n,
     +             y, ztemp)           
c
c Then a running median span 2 
c         
      isend = 2
      call t4253x (isend, n,
     +             y, ztemp)           
c
c Next a running median span 5 
c
      isend = 3
      call t4253x (isend, n,
     +             y, ztemp)           
c
c Now a running median span 3 
c
      isend = 4
      call t4253x (isend, n,
     +             y, ztemp)   
c
c Finally a 2 by 2 Hanning 
c
      isend = 5
      call t4253x (isend, n,
     +             y, ztemp)
     
c
c Part 2: Now x = data (unchanged) and y = first smooth, so filter z = x - y as previously
c =======
c 
      do i = 1, n
         z(i) = x(i) - y(i)
      enddo   
c
c First a running median span 4 
c     
      isend = 1
      call t4253x (isend, n,
     +             z, ztemp)           
c
c Then a running median span 2 
c         
      isend = 2
      call t4253x (isend,n,
     +             z, ztemp)           
c
c Next a running median span 5 
c
      isend = 3
      call t4253x (isend, n,
     +             z, ztemp)           
c
c Now a running median span 3 
c
      isend = 4
      call t4253x (isend, n,
     +             z, ztemp)   
c
c Finally a 2 by 2 Hanning 
c
      isend = 5
      call t4253x (isend, n,
     +             z, ztemp)
c
c Now redefine y = re-roughed y and z = new residuals
c                
      do i = 1, n 
         y(i) = y(i) + z(i)
      enddo
      do i = 1, n   
         z(i) = x(i) - y(i)
      enddo
      deallocate (ztemp, stat = i)
      end
c
c--------------------------------------------------------------------------------
c
      subroutine t4253x (isend, n,
     +                   x, ztemp)
c
c action: auxiliary calculations for subroutine t42353h  
c author: w.g.bardsley, university of manchester, u.k., 03/06/2015
c   
c isend = 1: moving median span 4
c isend = 2: moving median span 2
c isend = 3: moving median span 5
c isend = 4: moving median span 3
c isend = 5: Hanning 
c
      implicit none
c
c arguments
c        
      integer,          intent (in)    :: isend, n
      double precision, intent (inout) :: x(n), ztemp(n)
c
c locals
c     
      integer    i, nx, j, k
      double precision sum3, xsav1, xsav2, xsort(5),xtra
      double precision quart, half, two, three
      parameter (quart = 0.25d+00, half = 0.5d+00, two = 2.0d+00,
     +           three = 3.0d+00)
      logical    end_point, end_point1
      parameter (end_point1 = .true.)
      external   nxsort
      save       xtra
      data       xtra / 0.0d+00 /
      
      if (isend.lt.1 .or. isend.gt.5) return
      
      end_point = end_point1      

      if (isend.eq.1) then 
c
c isend = 1: moving median span 4 (defines xtra)
c        
         nx = 4
         do i = 1, n
            if (i.eq.1) then
               ztemp(1) = x(1)
            elseif (i.eq.2) then
               ztemp(2) = half*(x(1) + x(2))
            elseif (i.eq.n - 1) then
               ztemp(n - 1) = half*(x(n - 2) + x(n - 1)) 
            elseif (i.eq.n) then
               ztemp(n) = half*(x(n - 1) + x(n))         
            else
               k = 0
               do j = i - 2, i + 1
                  k = k + 1
                  xsort(k) = x(j)
               enddo
               call nxsort (nx,
     +                      xsort)
               xsav1 = half*(xsort(2) + xsort(3))
               ztemp(i) = xsav1
            endif
         enddo
         xtra = x(n)
      elseif (isend.eq.2) then 
c
c isend = 2: moving median span 2 (uses xtra)
c          
         do i = 1, n - 1
            xsav2 = half*(x(i) + x(i + 1))
            ztemp(i) =  xsav2
         enddo
         ztemp(n) = half*(x(n) + xtra)
      elseif (isend.eq.3) then
c
c isend = 3: moving median span 5
c      
         do i = 1, n
            if (i.eq.1) then
               ztemp(1) = x(1)
            elseif (i.eq.2) then
               xsort(1) = x(1)
               xsort(2) = x(2)
               xsort(3) = x(3)
               nx = 3
               call nxsort (nx,
     +                      xsort)
               ztemp(2) = xsort(2)
            elseif (i.eq.n - 1) then  
               xsort(1) = x(n - 2)
               xsort(2) = x(n - 1)
               xsort(3) = x(n)
               nx = 3
               call nxsort (nx,
     +                      xsort)
               ztemp(n - 1) = xsort(2) 
            elseif (i.eq.n) then
               ztemp(n) = x(n)      
            else
               nx = 5
               k = 0
               do j = i - 2, i + 2
                  k = k + 1
                  xsort(k) = x(j)
               enddo
               call nxsort (nx,
     +                      xsort)
               ztemp(i) = xsort(3)
            endif
         enddo
      elseif (isend.eq.4) then
c
c isend = 4: moving median span 3
c      
         nx = 3 
         do i = 1, n
            if (i.eq.1 .or. i.eq.n) then
               ztemp(i) = x(i)
            else
               k = 0
               do j = i - 1, i + 1
                  k = k + 1
                  xsort(k) = x(j)
               enddo
               call nxsort (nx,
     +                      xsort)
               ztemp(i) = xsort(2)
            endif
         enddo
      elseif (isend.eq.5) then
c
c isend = 5: Hanning
c      
         do i = 1, n
            if (i.eq.1 .or. i.eq.n) then
               ztemp(i) = x(i)
            else
               sum3 = quart*x(i - 1) + half*x(i) + quart*x(i + 1)
               ztemp(i) = sum3
            endif
         enddo    
      endif
c
c re-define end points
c     
      if (end_point) then 
         nx = 3
         xsort(1) = three*ztemp(2) - two*ztemp(3)
         xsort(2) = ztemp(1)
         xsort(3) = ztemp(2)
         call nxsort (nx,
     +                xsort)
         ztemp(1) = xsort(2)
         if (isend.eq.1) then
            xsort(1) = three*ztemp(n - 1) - two*ztemp(n)
            xsort(2) = xtra
            xsort(3) = ztemp(n)
         else
            xsort(1) = three*ztemp(n - 2) - two*ztemp(n - 1) 
            xsort(2) = ztemp(n)
            xsort(3) = ztemp(n - 1)
         endif  
         call nxsort (nx,
     +                xsort)
         ztemp(n) = xsort(2)
      endif   
c
c define x
c
      do i = 1, n
         x(i) = ztemp(i)
      enddo   

      end
c
c


            