c
c line 1004 for debugging output  
c

c
c driver for the table extraction code
c
c subroutines:
c ------------
c tabber ... main driver
c tabber_advice
c tabber_config
c***
c hasher ... calls the hash and related routines
c hash00 ... preliminary compacting to join words etc.
c hash01 ... the case with pre-existing tabs (no longer required)
c hash02 ... special case with 2 columns
c hash03 ... several columns
c hash04 ... check that hashtags make sense
c hash05 ... calls ex2flt for exponentials to floats
c hash06 ... final output
c***
c latex_checker
c html_checker
c ex2flt
c dot_checker
c number_checker
c
c


 
      

c
c------------------------------------------------------------------------------start of tabber 
c
      subroutine tabber
      implicit   none
      integer    isize
      integer    ios, isend, itype, jsend
      integer    numbld(30), numdec, numopt, numsta, numtxt
      integer    n1
      parameter (n1 = 1) 
      character (len = 1024) fname_in, fname_out
      character (len = 100 ) line, text(30), trim100, word100
      character (len = 30  ) decimal_point, export, hashtag, processor,
     +                       science, trailing_zeros
      character (len = 20  ) type1, type2
      character (len = 5   ) ext 
      logical    first_time
      logical    compact, commas, exp_to_floats, hash_tag, no_dots,
     +           pre_processor, swap, suppress
      logical    repeet 
      logical    abort, there
      external   hasher, getfil, lstbox, trim100 
      external   tabber_advice, tabber_config, results_file
      data       numbld /30*0 /
      data       isend / 2 /
      data       isize / 4 /
      data       compact, exp_to_floats, hash_tag, no_dots,
     +           pre_processor, swap, suppress
     +         / .true., .true., .false., .true., .false., .false.,
     +           .true. /
      data       first_time / .true. /
c
c configure if first_time = .true.
c      
      if (first_time) then
         first_time = .false.
         commas = swap
         itype = isend
         call tabber_config (isize, itype, commas, compact,
     +                       exp_to_floats, hash_tag, 
     +                       pre_processor)
         isend = itype
         swap = commas
      endif   
      numdec = 4 
c
c here for a new run
c      
   20 continue 
      repeet = .true.
      do while (repeet)
         if (isend.eq.1) then
            type1 = '*.txt'
         elseif (isend.eq.2) then
            type1 = '*.html'  
         elseif (isend.eq.3) then
            type1 = '*.xml'
         elseif (isend.eq.4) then
            type1 = '*.tex'  
         endif  
         if (exp_to_floats) then
            export = 'Transform to floats'
         else
            export = 'Not re-formatted'
         endif      
         science = '(i.e. inserted zeros)'
         if (compact) then
            trailing_zeros = 'Suppressed'
         else
            trailing_zeros = 'Not suppressed'
         endif      
         if (swap) then
            decimal_point = 'Comma (as in 1,2345)'
         else
            decimal_point = 'Full stop (as in 1.2345)'
         endif
         if (pre_processor) then
            processor = 'Switched on'      
         else
            processor = 'Suppressed'
         endif   
         if (hash_tag) then
            hashtag = 'Switched on'      
         else
            hashtag = 'Suppressed'
         endif      
         write (text,100) type1, export, isize, science, 
     +                    trailing _zeros, decimal_point,
     +                    processor, hashtag
         numsta = 11
         numopt = 5
         numtxt = numsta + numopt - 1
         numbld(1) = 4
         numbld(3) = 1
         numbld(4) = 1
         numbld(5) = 1
         numbld(6) = 1
         numbld(7) = 1
         numbld(8) = 1
         numbld(9) = 1
         if (numdec.lt.1 .or. numdec.gt.numopt) numdec = numopt - 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         numbld(3) = 0
         numbld(4) = 0
         numbld(5) = 0
         numbld(6) = 0
         numbld(7) = 0
         numbld(8) = 0
         numbld(9) = 0
         if (numdec.eq.1) then
c
c change output type
c           
            commas = swap
            itype = isend
            call tabber_config (isize, itype, commas, compact,
     +                          exp_to_floats, hash_tag, pre_processor)
            isend = itype
            swap = commas
         elseif (numdec.eq.2) then
c
c current set
c            
            jsend = 5 
            call results_file (jsend,
     +                         fname_in)
            inquire (file = fname_in, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               repeet = .false.
            else
               repeet = .true.
            endif           
         elseif (numdec.eq.3) then
c
c new file
c
            type2 = 'input text file'
            ext = 'txt'
            jsend = 1
            call getfil (jsend, 
     +                   ext, fname_in, type2,
     +                   abort)
            if (abort) then
               repeet = .true.
            else
               repeet = .false.   
            endif     
         elseif (numdec.eq.numopt - 1) then
c
c help
c
            call tabber_advice (n1)
                 
         elseif (numdec.eq.numopt) then
c
c exit
c         
            return
         endif  
         numdec = 2 
      enddo   
      
      inquire (file = fname_in, exist = there, iostat = ios)
     
      if (ios.eq.0 .and. there) then
c
c here for a re-run
c        
   40    continue
         abort = .false.
         fname_out = 'No file'
         call hasher (isend, isize,
     +                fname_in, fname_out,
     +                abort, compact, exp_to_floats, hash_tag, no_dots,
     +                pre_processor, swap)
         repeet = .true.
         numdec = 4
         do while (repeet) 
            if (abort) then
               line = 'Failure to write a table to file'
            else
               line = 'A table has been written to file'
            endif 
            if (isend.eq.1) then
               type1 = '*.txt'
            elseif (isend.eq.2) then
               type1 = '*.html'  
            elseif (isend.eq.3) then
               type1 = '*.xml'
            elseif (isend.eq.4) then
               type1 = '*.tex'  
            endif       
            word100 = trim100(fname_in)
            write (text,200) word100, line, type1
            numbld(1) = 4
            numbld(4) = 1
            numbld(7) = 1
            numbld(10) = 1
            numsta = 12
            numopt = 5
            numtxt = numsta + numopt - 1
            call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                   text)
            numbld(1) = 0
            numbld(4) = 0
            numbld(7) = 0
            numbld(1) = 0
            if (numdec.eq.1) then
               repeet = .false.
               numdec = 9
               goto 20
            elseif (numdec.eq.2) then
               repeet = .false.
               goto 40  
            elseif (numdec.eq.3) then
               commas = swap
               itype = isend
               call tabber_config (isize, itype, commas, compact,
     +                             exp_to_floats, hash_tag, 
     +                             pre_processor)
               isend = itype
               swap = commas
            elseif (numdec.eq.4) then
c
c help
c
               call tabber_advice (n1) 
            else
               repeet = .false.
            endif      
         enddo
      else
         numdec = 9
         goto 20                     
      endif  
c
c format statements
c      
  100 format (
     +'Extracting tables from Simfit results files'
     +/
     +/'Output file type`',1x,a
     +/'Output numbers  `',1x,a
     +/'Padding zeros   `',i2,2x,a
     +/'Trailing zeros  `',1x,a
     +/'Decimal point   `',1x,a
     +/'Pre-processor   `',1x,a
     +/'Hashtag table   `',1x,a 
     +/
     +/'Configure details for the output file'
     +/'Input: a results file from the Simfit archive'
     +/'Input: a results file from your own archive'
     +/'Help'
     +/'Quit ... Exit these table preparation options')
  200 format (
     +'New file, change settings, or Try again'
     +/
     +/'Current Simfit results file:'
     +/a
     +/
     +/'Status'
     +/a
     +/
     +/'Current output format'
     +/a
     +/
     +/'Open a new Simfit results file'
     +/'Try again using the same Simfit results file'
     +/'Change the output file configuration'
     +/'Help' 
     +/'Quit ... Exit table preparation procedure')
      end
c
c------------------------------------------------------------
c

      SUBROUTINE TABBER_ADVICE (ISEND)
C
C Advise user
C
      IMPLICIT   NONE
      INTEGER,   INTENT (IN) :: ISEND
      INTEGER    NUMTXT
      INTEGER    NUMBLD(30)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      CHARACTER (LEN = 100) TEXT(30)
      LOGICAL    FIRST, NEXT
      LOGICAL    FRAME, UPDOWN
      PARAMETER (FRAME = .FALSE., UPDOWN = .TRUE.)
      EXTERNAL   TUTOR1, PATCH2
      SAVE       FIRST 
      DATA       NUMBLD / 30*0  /
      DATA       FIRST  / .TRUE. /
      IF (ISEND.EQ.1) THEN
         NEXT = .TRUE.
         WRITE (TEXT,100)
         NUMTXT = 24
         NUMBLD(1) = 4
         NUMBLD(11) = 1
         NUMBLD(19) = 1
         CALL TUTOR1 (JCOLOR, NUMBLD, NUMTXT, TEXT, FRAME, NEXT,
     +                UPDOWN)
         NUMBLD(1) = 0
         NUMBLD(11) = 0
         NUMBLD(19) = 0 
      
         WRITE (TEXT,200)
         NUMTXT = 24
         NUMBLD(3) = 4
         NUMBLD(8) = 1
         NUMBLD(11) = 1
         NUMBLD(15) = 1
         CALL TUTOR1 (JCOLOR, NUMBLD, NUMTXT, TEXT, FRAME, NEXT,
     +                UPDOWN)
         NUMBLD(3) = 0
         NUMBLD(8) = 0
         NUMBLD(11) = 0
         NUMBLD(15) = 0
      
         WRITE (TEXT,300)
         NUMTXT = 24
         NUMBLD(1) = 1
         NUMBLD(10) = 1
         NUMBLD(16) = 1
         CALL TUTOR1 (JCOLOR, NUMBLD, NUMTXT, TEXT, FRAME, NEXT,
     +                UPDOWN)
         NUMBLD(1) = 0
         NUMBLD(10) = 0
         NUMBLD(16) = 0
      
         WRITE (TEXT,400)
         NUMTXT = 25
         NUMBLD(1) = 1
         NEXT = .FALSE.
         CALL TUTOR1 (JCOLOR, NUMBLD, NUMTXT, TEXT, FRAME, NEXT,
     +                UPDOWN)
         NUMBLD(1) = 0
      ELSEIF (ISEND.EQ.2) THEN
         IF (FIRST) THEN
            FIRST = .FALSE.
            WRITE (TEXT,400) 
            NUMTXT = 25
            NUMBLD(1) = 1
            CALL PATCH2 (NUMBLD, NUMTXT,
     +                   TEXT)          
            NUMBLD(1) = 0
         ENDIF   
      ENDIF   
C
C Format statements
C     
  100 FORMAT (
     + 'Editing a Simfit results table for including in documents'
     +/
     +/'First consider the various formats of Simfit results tables.'
     +/
     +/'Some tables consist of n rows each with exactly m columns,'
     +/'where each column can be a number or a word. In this case'
     +/'there would be no header or trailer sections and all that is'
     +/'needed is to output in a chosen format such as html or LaTeX.'
     +/'However, often editing is required before a table can be saved.'  
     +/
     +/'How to use this routine'
     +/
     +/'1)`Open a results file, e.g. a f$result.* file saved by Simfit'
     +/'2)`Select the table with or without header/trailer sections'
     +/'3)`Highlight header and trailer sections in contrasting colours'
     +/'4)`Save the edited table to a file'
     +/'5)`Import the saved table file into your document'
     +/     
     +/'Pre-processor editing of results files to prevent failure'
     +/
     +/'If some of the rows selected have got empty columns you must' 
     +/'replace them by the symbol ... which will be removed on output.'
     +/'Or, if column titles have blanks, you must link up words, e.g.'
     +/'replace Time of Day by Time_of_Day, then try again.')    
  200 FORMAT (
     + 'The tutorial document called'
     +/
     +/'      extracting_tables_from_simfit_results_files.pdf '
     +/
     +/'contains a detailed description of the procedure, so only a'
     +/'brief summary of the sequence of steps required is given here.'
     +/ 
     +/'Step 1'
     +/'Open a Simfit results file'
     +/
     +/'Step 2'
     +/'Select a simple table with possible header and trailer sections'
     +/'and copy to the clipboard.'
     +/
     +/'Step 3'
     +/'If the optional pre-processor editor is invoked the copied'
     +/'text will be displayed in the Simfit editor. At this point you'
     +/'can edit the complete table with header and trailer to change'
     +/'any details. This is the point when you have to check that'
     +/'every row in the rectangular table of results section has'
     +/'the same number of columns, replacing empty cells by three'
     +/'dots and joining multiword column titles using underscores.'
     +/'This is not required in special tables consisting of two' 
     +/'columns separated by vertically lined-up equals signs.')
  300 FORMAT (
     + 'Step 4'
     +/'The selected table will now be displayed in a window with'
     +/'buttons to define the header and trailer sections in colour.'
     +/'The header and trailer sections can have arbitrary content'
     +/'but the results table at this point must have the same number'
     +/'of columns in every row. There is no point proceeding further'
     +/'unless this situation exists. This does not apply to two column'
     +/'tables with vertically lined up equals signs.'
     +/
     +/'Step 5'
     +/'The table making algorithm will then place hashtags where the'
     +/'columns are separated and it would not be normally be useful'
     +/'to see this. However, switch this on if creating a table fails'
     +/'because you will see what has gone wrong.'
     +/
     +/'Step 6'
     +/'a)`Tab-separated text.' 
     +/'b)`HTML'
     +/'c)`XML'
     +/'d)`LaTeX'
     +/'For Word processors and spreadsheet programs it is best to'
     +/'choose HTML or XML as such files can be imported directly'
     +/'into documents. LaTex is preferred by many scientists who'
     +/'create documents containing technical mathematics.')
  400 FORMAT (     
     + 'What to do when extracting a table fails'
     +/
     +/'This will be due to one or more of the following errors.'
     +/'1)`The table is not a two-column equals-sign separated type.' 
     +/'2)`Not all rows have the same number of columns.'
     +/'3)`Header and trailer sections are not correctly highlighted.'
     +/
     +/'You can try again taking greater care to copy to the clipboard'
     +/'and assign header and trailer sections accurately, but to sort'
     +/'out the error you can switch on two other procedures.'
     +/'a)`The pre-processing options allows you to insert triple dots'
     +/'  `as in ... to identify empty cells, or add underscores to'
     +/'  `join multiple titles as in Time of Day to Time_of_Day.'  
     +/'  `These will be removed when the output file is Saved As.'
     +/'b)`The hashtag table indicates where the algorithm has tried'
     +/'  `to identify column separation points using hashtags.' 
     +/
     +/'Note that the algorithm does recognise and attempt to trap'
     +/'many inconsistenctes but sometimes hand-crafting is required.'
     +/'However a two column table never needs editing, as the column'
     +/'separation is completely determined by the stacked equals'
     +/'signs, which are removed when the output table is Saved As.'
     +/'Further, transformation into maths notation as with alpha,'
     +/'beta, r^2, P(chi-sq >=, etc. is done automatically with html,'
     +/'xml, and LaTeX and requires no editing.')  
      END
c       
c ---------------------------------------------------------    
c
      subroutine tabber_config (isize, itype,
     +                          commas, compact, exp_to_float, hash_tag,
     +                          pre_processor)
c
c         isize: number of padding zeros 0 =< isize =< 8
c         itype: type of output 1 =< itype =< 4
c        commas: swap decimal points for commas
c       compact: suppress trailing zeros
c  exp_to_float: exponential to float
c      hash_tag: table with hashtags
c pre_processor: pre-processing editor 
c     
      implicit none
c
c arguments
c      
      integer, intent (inout) :: isize, itype  
      logical, intent (inout) :: commas, compact, exp_to_float,
     +                           hash_tag, pre_processor       
c
c locals
c  
      integer    ibot, itop, nmax, numdec, numopt
      parameter (ibot = 0, itop = 8, nmax = 10, numdec = 1,
     +           numopt = nmax)
      integer    numsta, numtxt
      parameter (numsta = 11, numtxt = numsta + numopt + 3) 
      integer    i, numbld(numtxt)
      integer    numpos(nmax)
      integer    icolor, ixl, iyl, lshade 
      parameter (icolor = 9, ixl = 4, iyl = 4, lshade = 0)
      character (len = 100) text(numtxt)
      logical    tab_bot, tab_mid, tab_top
      parameter (tab_bot = .false., tab_mid = .false., tab_top = .true.)
      external   getjm1, rbox01
      data       numbld / numtxt*0 /
      data       numpos / numopt*0 /
c
c check
c    
      if (isize.lt.ibot .or. isize.gt.itop) isize = 4  
      if (itype.lt.1 .or. itype.gt.4) itype = 2  
c
c initialise 
c        
      do i = 1, nmax
         numpos(i) = 0
      enddo
      do i = 1, 4
         numbld(numsta + i - 1) = 100
      enddo   
      numpos(itype) = 1   
      if (exp_to_float) numpos(5) = 1
      if (compact) numpos(6) = 1
      if (commas) numpos(7) = 1
      if (pre_processor) numpos(8) = 1
      if (hash_tag) numpos(9) = 1     
      write (text,100) isize 
c
c get the values required
c             
      numbld(1) = 4
      numbld(5) = 1
      numbld(9) = 1
      call rbox01 (icolor, ixl, iyl, lshade,
     +             numbld, numdec, numopt, numpos, numsta,
     +             numtxt,
     +             text,
     +             tab_bot, tab_mid, tab_top) 
      numbld(1) = 0
      numbld(5) = 0
      numbld(9) = 0 
      do i = 1, 4
         if (numpos(i).eq.1) itype = i
      enddo
      exp_to_float = .false. 
      compact = .false.
      commas = .false. 
      pre_processor = .false.
      hash_tag = .false.
      if (numpos(5).eq.1) exp_to_float = .true.
      if (numpos(6).eq.1) compact = .true.
      if (numpos(7).eq.1) commas = .true.
      if (numpos(8).eq.1) pre_processor = .true.
      if (numpos(9).eq.1) hash_tag =.true.    
      if (numpos(10).eq.1) then
         call getjm1 (ibot, isize, itop, 'Number of zeros for padding')  
      endif  
c
c format statement
c
  100 format ( 
     + 'Configuration for extracting tables from Simfit results files'  
     +/'.'
     +/'Details are in the tutorial document called'
     +/'.'
     +/'      exporting_tables_from_simfit_results_files.pdf' 
     +/'.'
     +/'and in the collected tutorials document called'
     +/'.'
     +/'      w_examples.pdf' 
     +/'.'
     +/'Output: Tab-separated text'
     +/'Output: HTML'
     +/'Output: XML'
     +/'Output: LaTeX'
     +/'Transform from exponential to floating point notation'
     +/'Compact numbers by removing any trailing zeros'
     +/'Replace full stop decimal points by commas'
     +/'Provide a pre-processing editor facility' 
     +/'Display the intermediate hashtag table'
     +/'Change maximum number of padding zeros (N =',i2,')'
     +/'.'
     +/'Note: N sets an upper limit for inserting zeros to'
     +/'transform scientific format into ordinary notation,'
     +/'e.g., isize = 4 allows 1.2345E-04 -> 0.00012345')
      end      
c
c-----------------------------------------------------------------------------end of tabber
c
      
c
c**************************************************************************
c
      
c  
c------------------------------------------------------------------------start of hasher    
c
      subroutine hasher (isend, isize,
     +                   fname_in, fname_out,
     +                   abort, compact, exp_to_floats, hash_tag, 
     +                   no_dots, pre_processor, swap)
c
c action: input a results file and output a table file
c author: w.g.bardsley, university of manchester, u.k., 26/07/2016
c     
      implicit   none
c
c arguments
c      
      integer,             intent (in)    :: isend, isize
      character (len = *), intent (in)    :: fname_in
      character (len = *), intent (inout) :: fname_out
      logical,             intent (inout) :: abort  
      logical,             intent (in)    :: compact, exp_to_floats, 
     +                                       hash_tag, no_dots,
     +                                       pre_processor, swap
c
c locals
c      
      integer    i, ios, j, k, ksend, l, l1, l2
      integer    nhigh, nlines, nmax, nout, nwide
      integer    nhead, ntrail
      integer    nstart, nstop, ntotal
      parameter (l1 = 1, l2 = 2, nmax = 1000, nwide = 256)
      character (len = nwide) line, temp(nmax), text(nmax)
      character (len = nwide) head(nmax), trail(nmax)
      character (len = 1024 ) temp_file
      character (len = 5    ) ext
      character (len = 30   ) type1
      character (len = 1    ) blank, uscore
      parameter (blank = ' ', uscore = '_')
      logical    action(10)
      logical    askif, there
      parameter (askif = .false.)
      external   clip00, clip01, edittx, hash00, hash01,
     +           hash02, hash03, hash04, hash05,
     +           hash06, dbcolr
      external   putfat, getnou, putall, getfil, gettmp,
     +           deleet  
      external   swap_checker, dot_checker, latex_checker, html_checker,
     +           number_checker, tabber_advice 
      intrinsic  len_trim
c         
c initialise
c      
      abort = .false.
      do i = 1, nmax
         text(i) = blank
         head(i) = blank
         trail(i) = blank 
      enddo 
      do i = 1, 10
         action(i) = .true.
      enddo 
      nhead = 0
      ntrail = 0
c
c read text off the input file
c      
      nlines = 0
      call getnou (nout)
      open (unit = nout, file = fname_in, iostat=ios)
      if (ios.eq.0) then
         i = 0
         do while (ios.eq.0)
            read (nout,'(a)',iostat=ios) line
            if (ios.eq.0) then
               i = i + 1
               text(i) = line
            endif   
         enddo
         nlines = i
      else
         call putfat ('Error 140: Failure to open the selected file')
         close (nout)
         return   
      endif   
      close (nout)
      
      nhigh = i
      if (nlines.gt.0) then
c
c extract the table
c        
         call clip00 (fname_in)
         call clip01 (nlines, nmax,
     +                text,
     +                abort)
         if (abort .or. nlines.lt.1) then
            abort = .true.
            return
         endif  
c
c preliminary editing before call to edittx
c     
         if (pre_processor) call edittx (nlines, nhigh, nwide,
     +                                   text)          
c         
c
c preliminary processing for blank lines, etc. 
c           
         call hash00 (nlines, nmax,
     +                temp, text,
     +                abort)
c
c preliminary editing after call to edittx
c     
c         if (pre_processor) call edittx (nlines, nhigh, nwide,
c     +                                   text) 
         call gettmp (i,
     +                temp_file)
         if (i.ne.0) then
            abort = .true.
            return
         endif
         call getnou (nout)
         open (unit = nout, file = temp_file, iostat = ios)
         if (ios.ne.0) then
            abort = .true.
            return
         else
            if (text(nlines).eq.blank) nlines = nlines - 1
            write (nout,'(a)') 
     +'________________________________________________________________'
            do i = 1, nlines
               write (nout,'(,a)',iostat=ios) text(i)
            enddo 
            write (nout,'(a)',advance='no') 
     +'________________________________________________________________'    
          
         endif
         close (unit = nout)
         nhead = 0  
         nstart = 0
         nstop = 0
         ntotal = 0
         ntrail = 0  
         call dbcolr (nstart, nstop, ntotal,
     +                temp_file)
         call deleet (temp_file,
     +                askif, there)  

         nstart = nstart - 1
         nstop = nstop - 1
         ntotal = ntotal - 2
         
         if (nstart.eq.nstop         .or.
     +       nstop - nstart + 1.lt.1 .or.
     +       ntotal.lt.1             .or.
     +       nlines.ne.ntotal) then 
            abort = .true.
            return
         endif   
         if (nstart.gt.1) then 
            nhead = nstart - 1 
            do i = 1, nhead
               head(i) = text(i)
            enddo
         endif      
         if (nstop.lt.ntotal) then
            ntrail = ntotal - nstop 
            j = nstop  
            do i = 1, ntrail
               j = j + 1
               trail(i) = text(j)
            enddo   
         endif
         if (nstart.gt.1 .or. nstop.lt.ntotal) then
             nlines = 0
             do i = nstart, nstop
                nlines = nlines + 1
                temp(nlines) = text(i)
             enddo
             do i = 1, nlines
                text(i) = temp(i)
             enddo      
         endif  
         do i = nlines + 1, nmax
            text(i) = blank
         enddo
         do i = 1, nmax
            temp(i) = blank
         enddo      
         if (nlines.gt.0)then

c
c preliminary processing for blank lines, etc. 
c           
c            call hash00 (nlines, nmax,
c     +                   temp, text,
c     +                   abort)
c            if (abort) return
c
c prelimary processing for forbidden characters 
c           
            if (isend.gt.1 .and. isend.le.4) then    
               if (isend.eq.4) then
                  if (nhead.gt.0) then
                     do i = 1, nhead
                        call latex_checker (l1, 
     +                                      head(i))
                     enddo
                  endif  
                  do i = 1, nlines
                     call latex_checker (l1,
     +                                   text(i))
                  enddo
                   if (ntrail.gt.0) then
                     do i = 1, ntrail
                        call latex_checker (l1,
     +                                      trail(i))
                     enddo
                  endif 
               else
                  if (nhead.gt.0) then
                     do i = 1, nhead
                        call html_checker (l1,
     +                                     head(i))
                     enddo
                  endif  
                  do i = 1, nlines
                     call html_checker (l1,
     +                                  text(i))
                  enddo
                   if (ntrail.gt.0) then
                     do i = 1, ntrail
                        call html_checker (l1,
     +                                     trail(i))
                     enddo
                  endif  
               endif            
            endif
c
c check if the file is already tabbed ... checks action(1)
c              
            call hash01 (nlines, nmax,
     +                   text,
     +                   action)
c
c check for a 2-column central equal sign type ... checks action(2)
c     
            call hash02 (nlines, nmax,
     +                   text,
     +                   action) 
c
c check for columns defined by tokens ... checks action(3)
c     
            call hash03 (nlines, nmax,
     +                   text,
     +                   action)  
c
c remove temporary underscores
c      
            if (nhead.gt.0) then
               do i = 1, nhead
                  l = len_trim(head(i))
                  do k = 1, l  
                    if (head(i)(k:k).eq.uscore) head(i)(k:k) = blank
                  enddo    
               enddo
            endif   
            do i = 1, nlines
               l = len_trim(text(i))
               if (l.gt.0) then
                 do k = 1, l
                    if (text(i)(k:k).eq.uscore) text(i)(k:k) = blank
                 enddo  
               endif     
            enddo  
            if (ntrail.gt.0) then
               do i = 1, ntrail
                  l = len_trim(trail(i))
                  do k = 1, l  
                    if (trail(i)(k:k).eq.uscore) trail(i)(k:k) = blank
                  enddo    
               enddo
            endif 
c
c chance for final editing
c                   
            if (hash_tag) call edittx (nhigh, nlines, nwide,
     +                                 text)
c
c check if it looks OK ... checks action(4)
c     
            call hash04 (nlines, nmax,
     +                   text,
     +                   abort, action) 
            if (abort) then
              call tabber_advice (l2)
              return
            endif  
c
c change exponentials to floats ... checks action(5)
c     
            if (exp_to_floats) call hash05 (isize, nlines, nmax,
     +                                      text,
     +                                      action, compact, swap) 
c
c tabs/html/xml/LaTeX ... checks action(6)
c     
            call hash06 (isend, nhead, nlines, nmax, ntrail, 
     +                   head, temp, text, trail,
     +                   action)
         endif       
      endif 
c
c write the output file
c
      if (.not.abort) then
         if (isend.eq.1) then
            ext = 'txt'
            type1 = 'Tabbed table *.txt file'
            fname_out = 'table.txt'
         elseif (isend.eq.2) then 
            ext = 'html'
            type1 = 'HTML table *.html file'
            fname_out = 'table.html'   
         elseif (isend.eq.3) then 
            ext = 'xml'
            type1 = 'XML table *.xml file'
            fname_out = 'table.xml' 
         elseif (isend.eq.4) then 
            ext = 'tex'
            type1 = 'LaTeX table *.tex file'
            fname_out = 'table.tex'      
         endif   
         ksend = 1
         l = len_trim(fname_out)
         call putall (ksend,
     +  'Open an output file (e.g. '//fname_out(1:l)//')')
         ksend = 2
         call getfil (ksend, 
     +                ext, fname_out, type1,
     +                abort)
         if (abort) then
            return
         else         
            call getnou (nout)
            open (nout, file = fname_out)
            if (exp_to_floats) then
               if (nhead.gt.0) then
                  do i = 1, nhead
                     call number_checker (isize,
     +                                    text(i),
     +                                    compact, swap)
                  enddo                      
               endif 
               if (ntrail.gt.0) then
                  do i = nlines - ntrail + 1, nlines
                     call number_checker (isize,
     +                                    text(i),
     +                                    compact, swap)
                  enddo
               endif   
            endif  
            if (isend.eq.2 .or. isend.eq.3) then
               do i = 1, nlines
                  call html_checker (l2,
     +                               text(i))
               enddo
            elseif (isend.eq.4) then
               do i = 1, nlines
                  call latex_checker (l2,
     +                                text(i))
               enddo
            endif                      
            do i = 1, nlines
               line = text(i)
               if (no_dots) call dot_checker (line)
               if (swap) call swap_checker (line)  
               write (nout,'(a)') trim(line)
c
c              write (*,'(a)') line
c               
            enddo
            close (unit = nout) 
            line = 'show_garbage'
         endif   
      endif   
      end
c
c-------------------------------------------------------------------------------
c 
      subroutine hash00 (nlines, nmax,
     +                   temp, text,
     +                   abort)
c
c action: pre-process the text for blank-lines/*/Accept/Reject, etc. 
c author: w.g.bardsley, university of manchester, u.k., 21/07/2016
c     
      implicit none
c
c arguments
c      
      integer,             intent (inout) :: nlines
      integer,             intent (in)    :: nmax
      character (len = *), intent (inout) :: temp(nmax), text(nmax)
      logical,             intent (out)   :: abort
c
c locals
c      
      integer    i, iadd1, j, k, l, m, n
      character (len = 256) line
      character (len = 4  )  a,  b,  c,  d,  p,  q
      character (len = 4  ) a1, b1, c1, d1, p1, q1
      parameter ( a = ' A( ',  b = ' B( ',  c = ' C( ', 
     +            d = ' k( ',  p = ' P( ',  q = ' p( ',
     +           a1 = '  A(', b1 = '  B(', c1 = '  C(',
     +           d1 = '  k(', p1 = '  P(', q1 = '  p(' )
      character (len = 3  ) uscore3, word3
      parameter (uscore3 = '___')
      character (len = 2  ) uscore2
      parameter (uscore2 = '__')
      character (len = 1  ) blank, letter, uscore
      parameter (blank = ' ', uscore = '_')
      logical    back, ok(nlines), under
      parameter (back = .true.)
      intrinsic  index, len_trim
c
c check the arguments
c      
      if (nlines.lt.0 .or. nmax.lt.1) then
         abort = .true.
         return
      endif   
c
c check 1: initialise then set lines that should not be in tables to blank
c--------
c
      abort = .false.
      under = .false.
      n = nlines
      do i = 1, nlines
         ok(i) = .true.
         if (text(i).eq.blank) then
            ok(i) = .false.
            n = n - 1
         else   
            j = 0
            if (j.eq.0) j = index(text(i),'-------------')
            if (j.eq.0) j = index(text(i),'_____________')     
            if (j.eq.0) j = index(text(i),'=============')  
            if (j.gt.0) then
               text(i) = blank
               n = n - 1
               ok(i) = .false.
            endif   
         endif        
      enddo  
      if (n.eq.0) then
         nlines = 0
         abort = .true.
         return
      endif   
c
c check 2: remove blank lines then adjust nlines
c --------
c      
      if (n.lt.nlines) then
         do i = 1, nlines
            temp(i) = text(i)
            text(i) = blank
         enddo  
         iadd1 = 0
         do i = 1, nlines
            if (ok(i)) then
               iadd1 = iadd1 + 1
               text(iadd1) = temp(i)
            endif   
         enddo  
         if (iadd1.eq.n) then
            nlines = iadd1
         else
            abort = .true.
            return      
         endif   
      endif
c
c check 3: deal with stars
c --------
c         
      do i = 1, nlines
         l = len_trim(text(i))
         k = index(text(i),' *',back) 
         if (k.gt.l - 4) then
            under = .true.
            line = text(i)
            loop_stars: do j = k, 1, -1 
               letter = text(i)(j:j)
               if (letter.eq.blank) then
                  text(i)(j:j) = uscore
               else
                  exit loop_stars
               endif
            enddo loop_stars
         endif            
      enddo   
c
c check 4: deal with standard errors
c --------
c               
      loop_std: do i = 1, nlines
         j = index(text(i), 'Std. Err')
         if (j.gt.0) then
           text(i)(j + 4:j + 4) = uscore
           exit loop_std
         endif  
      enddo loop_std
c
c check 5: deal with Reject
c --------
c     
      do i = 1, nlines
         j = index(text(i),'Reject',back)
         if (j.gt.0) then
            loop_down_r: do k = j - 1, 1, -1
               letter = text(i)(k:k)
               if (letter.eq.blank) then
                  text(i)(k:k) = uscore
                  under = .true.
               else    
                  exit loop_down_r
               endif
            enddo loop_down_r 
            l = len_trim(text(i))
            do k = j + 5, l
               letter = text(i)(k:k)
               if (letter.eq.blank) text(i)(k:k) = uscore
            enddo
         endif             
      enddo 
c
c check 6: deal with Accept
c --------
c     
      do i = 1, nlines
         j = index(text(i),'Accept',back)
         if (j.gt.0) then
            loop_down_a: do k = j - 1, 1, -1
               letter = text(i)(k:k)
               if (letter.eq.blank) then
                  under = .true.
                  text(i)(k:k) = uscore
               else    
                  exit loop_down_a
               endif
            enddo loop_down_a 
            l = len_trim(text(i))
            do k = j + 5, l
               letter = text(i)(k:k)
               if (letter.eq.blank) text(i)(k:k) = uscore
            enddo
         endif             
      enddo 
c
c check 7: deal with Tentatively
c --------
c     
      do i = 1, nlines
         j = index(text(i),'Tentatively',back)
         if (j.gt.0) then
            loop_down_t: do k = j - 1, 1, -1
               letter = text(i)(k:k)
               if (letter.eq.blank) then
                  under = .true.
                  text(i)(k:k) = uscore
               else    
                  exit loop_down_t
               endif
            enddo loop_down_t 
            l = len_trim(text(i))
            do k = j + 5, l
               letter = text(i)(k:k)
               if (letter.eq.blank) text(i)(k:k) = uscore
            enddo
         endif             
      enddo   
c
c check 8: deal with Consider
c --------
c     
      do i = 1, nlines
         j = index(text(i),'Consider',back)
         if (j.gt.0) then
            loop_down_c: do k = j - 1, 1, -1
               letter = text(i)(k:k)
               if (letter.eq.blank) then
                  under = .true.
                  text(i)(k:k) = uscore
               else    
                  exit loop_down_c
               endif
            enddo loop_down_c 
            l = len_trim(text(i))
            do k = j + 5, l
               letter = text(i)(k:k)
               if (letter.eq.blank) text(i)(k:k) = uscore
            enddo
         endif             
      enddo              
c
c check 9: deal with Between
c --------
c     
      do i = 1, nlines
         j = index(text(i),'Between')
         if (j.gt.0) then
           text(i)(j + 7:j + 7) = uscore
           under = .true.
           if (text(i)(j + 8:j + 8).eq.blank)
     +         text(i)(j + 8:j + 8) = uscore
         endif  
      enddo     
c
c check 10: deal with not significant and Not significant
c --------
c     
      do i = 1, nlines
         j = index(text(i),'not significant')
         if (j.gt.0) text(i)(j + 3:j + 3) = uscore
         j = index(text(i),'Not significant')
         if (j.gt.0) text(i)(j + 3:j + 3) = uscore  
      enddo  
c
c check 11: deal with Odds Ratio
c --------
c     
      do i = 1, nlines
         j = index(text(i),'Odds Ratio')
         if (j.gt.0) text(i)(j + 4:j + 4) = uscore
         j = index(text(i),'odds ratio')
         if (j.gt.0) text(i)(j + 4:j + 4) = uscore  
      enddo        
c
c check 12: deal with A( 1), B( 1) etc
c --------
c
      do i = 1, nlines
         word3 = text(i)(1:3)
         if (word3.eq.'A( ' .or. word3.eq.'B( ' .or.
     +       word3.eq.'C( ' .or. word3.eq.'k( ' .or.
     +       word3.eq.'P( ' .or. word3.eq.'p( ') then
            l = len_trim(text(i)) 
            do j = l + 1, 2, -1
               text(i)(j:j) = text(i)(j - 1:j - 1)
            enddo
            text(i)(1:1) = blank
         endif 
      enddo  
      do i = 1, nlines
         m = index(text(i),a)
         do while (m.gt.0) 
            text(i)(m:m + 3) = a1
            m = index(text(i),a)
         enddo 
         m = index(text(i),b)
         do while (m.gt.0) 
            text(i)(m:m + 3) = b1
            m = index(text(i),b)
         enddo   
         m = index(text(i),c)
         do while (m.gt.0) 
            text(i)(m:m + 3) = c1
            m = index(text(i),c)
         enddo  

         m = index(text(i),d)
         do while (m.gt.0) 
            text(i)(m:m + 3) = d1
            m = index(text(i),d)
         enddo   
         
         m = index(text(i),p)
         do while (m.gt.0) 
            text(i)(m:m + 3) = p1
            m = index(text(i),p)
         enddo 
         m = index(text(i),q)
         do while (m.gt.0) 
            text(i)(m:m + 3) = q1
            m = index(text(i),q)
         enddo 
      enddo
c
c check 13: deal with < and >
c---------
c      
      do i = 1, nlines
         
         m = index(text(i),'   <')
         do while (m.gt.0)
            under = .true.
            text(i)(m:m + 2) = uscore3
            m = index(text(i),'   <')
         enddo
            
         m = index(text(i),'  <')
         do while (m.gt.0) 
            under = .true.
            text(i)(m:m + 1) = uscore2  
            m = index(text(i),'  <')
         enddo
            
         m = index(text(i),' <')
         do while (m.gt.0)
            text(i)(m:m) = uscore
            m = index(text(i),' <')
         enddo   
           
         m = index(text(i),'   >')
         do while (m.gt.0)
            under = .true.
            text(i)(m:m + 2) = uscore3
            m = index(text(i),'   >')
         enddo
             
         m = index(text(i),'  >')
         do while (m.gt.0)
            under = .true.
            text(i)(m:m + 1) = uscore2  
            m = index(text(i),'  >')
         enddo
            
         m = index(text(i),' >')
         do while (m.gt.0)
            text(i)(m:m) = uscore  
            m = index(text(i),' >')
         enddo   
           
         m = index(text(i),'<   ')
         do while (m.gt.0)
            under = .true.
            text(i)(m + 1:m + 3) = uscore3
            m = index(text(i),'<   ')
         enddo
            
         m = index(text(i),'<  ')
         do while (m.gt.0)
            under = .true.
            text(i)(m + 1:m + 2) = uscore2 
            m = index(text(i),'<  ')
         enddo

         m = index(text(i),'< ')
         do while (m.gt.0)
            text(i)(m + 1:m + 1) = uscore
            m = index(text(i),'< ')
         enddo   
           
         m = index(text(i),'>   ')
         do while (m.gt.0)
            under = .true.
            text(i)(m + 1:m + 3) = uscore3 
            m = index(text(i),'>   ')
         enddo
            
         m = index(text(i),'>  ')
         do while (m.gt.0)
            under = .true.
            text(i)(m + 1:m + 2) = uscore2 
            m = index(text(i),'>  ')
         enddo
            
         m = index(text(i),'> ')
         do while (m.gt.0)
            text(i)(m + 1:m + 1) = uscore
            m = index(text(i),'> ')
         enddo   
           
      enddo  
      
c
c check 14: contract multiple underscores
c -------
c
      if (under) then
         do i = 1, nlines
            m = index(text(i),uscore2)
            n = m
            if (n.gt.0) then
               line = blank
               line = text(i)
               l = len_trim(line) 
               do while (m.gt.0)
                  do k = m, l - 1
                     line(k:k) = line(k + 1:k + 1)
                  enddo
                  line(l:l) = blank
                  l = l - 1
                  m = index(line,uscore2)
               enddo
               text(i) = blank
               text(i) = line     
            endif
         enddo
      endif        
      end         
c
c-------------------------------------------------------------------------------
c
      subroutine hash01 (nlines, nmax,
     +                   text,
     +                   action)
c
c action: check for existing tabs and replace by hash
c author: w.g.bardsley, university of manchester, u.k., 18/07/2016
c
c If tabs are encountered it is assumed that the format is already
c tabbed so the tabs are replaced by hashes and calls to hash02 and hash03
c are cancelled.
c     
      implicit none
c
c arguments
c      
      integer,             intent (inout) :: nlines  
      integer,             intent (in)    :: nmax
      character (len = *), intent (inout) :: text(nmax)
      logical,             intent (inout) :: action(*) 
c
c locals
c      
      integer    i, j, k, ntabs, nwide
      character (len = 256) line
      character (len = 1  ) letter
      character (len = 1  ) hash, tab
      parameter (hash = '*', tab = char(9))
      intrinsic len_trim
      if (.not.action(1)) return
      nwide = 0
      do i = 1, nlines
         j = len_trim(text(i))
         if (j.gt.nwide) nwide = j
      enddo
      ntabs = 0
      k = nlines
      do i = 1, k
         line = text(i)
         do j = 1, nwide
            letter = line(j:j)
            if (letter.eq.tab) then
               ntabs = ntabs + 1
               line(j:j) = hash
            endif       
         enddo
         text(i) = line
      enddo
      if (ntabs.gt.1) then
         action(2) = .false.
         action(3) = .false.
      endif 
      end          
c
c----------------------------------------------------------------      
c
      subroutine hash02 (nlines, nmax,
     +                   text,
     +                   action)
c
c action: line up for the case of 2 columns separated in the same position by = 
c author: w.g.bardsley, university of manchester, u.k., 18/07/2016
c
      implicit none
c
c arguments
c      
      integer,             intent (inout) :: nlines  
      integer,             intent (in)    :: nmax
      character (len = *), intent (inout) :: text(nmax)
      logical,             intent (inout) :: action(*)
c
c locals
c      
      integer    i, j, k, l, npos(nlines), nsum, nwide
      double precision ratio
      character (len = 256) line
      character (len = 1  ) letter
      character (len = 1  ) equal, greater, hash, lesser
      parameter (  equal = '=',
     +           greater = '>',
     +              hash = '#', 
     +            lesser = '<') 
      intrinsic len_trim, dble
      if (.not.action(2)) return
      nwide = 0
      do i = 1, nlines
         j = len_trim(text(i))
         if (j.gt.nwide) nwide = j
         npos(i) = 0  
      enddo
      loop_1: do i = 1, nlines
         line = text(i)
         loop_2: do j = 1, nwide
            letter = line(j:j)
            if (letter.eq.equal) then
               k = j - 1
               l = j + 1
               if (k.ge.1 .and. l.le.nwide) then
                  if (line(k:k).ne.greater .and.
     +                line(k:k).ne.lesser  .and.
     +                line(l:l).ne.greater .and.
     +                line(l:l).ne.lesser) then
                      npos(i) = j 
                      exit loop_2  
                  endif   
               endif
            endif
         enddo loop_2
         text(i) = line
      enddo loop_1
      k = 0
      nsum = 0
      do i = 1, nlines
         if (npos(i).gt.0) then 
           k = k + 1
           if (i.gt.1) nsum = nsum + npos(i - 1) - npos(i)
         endif  
      enddo  
c
c At this stage we have
c nlines = number of lines
c      k = number of lines with a valid equal sign
c   npos = position of the equal sign if > 0
c   nsum = sum of the differences between successive positions    
c     
      if (k.gt.0) then
         ratio = dble(nsum)/dble(k)  
         if (k.gt.1 .and. ratio.lt.0.1d+00) then
            do i = 1, nlines
              if (npos(i).gt.0) then 
                 j = npos(i)
                 text(i)(j:j) = hash
              endif   
           enddo     
        endif  
        action(3) = .false. 
      endif     
      end 
c        
c----------------------------------------------------------------      
c
      subroutine hash03 (nlines, nmax,
     +                   text,
     +                   action)
c
c action: line up for the case of several columns with words or numbers 
c author: w.g.bardsley, university of manchester, u.k., 18/07/2016
c
c     
      implicit none
c
c arguments
c      
      integer,             intent (inout) :: nlines  
      integer,             intent (in)    :: nmax
      character (len = *), intent (inout) :: text(nmax)
      logical,             intent (inout) :: action(*)
c
c locals
c      
      integer    i, ios, j, k, l, m, n, ncols, nwide
      integer    mpos(nmax), npos(nmax)
      double precision x
      character (len = 256) line
      character (len = 256) token
      character (len = 1  ) letter
      character (len = 1  ) blank, hash, uscore
      parameter (blank = ' ', hash = '#', uscore = '_')
      intrinsic len_trim
      if (.not.action(3)) return
c
c set nwide = width of widest line
c        
      nwide = 0
      do i = 1, nlines
         j = len_trim(text(i))
         if (j.gt.nwide) nwide = j
         mpos(i) = 0  
         npos(i) = 0  
      enddo
      do i = 1, nlines
c
c copy the text and pre-process to remove ambiguities
c        
         line = blank//text(i)
                    
         do j = 1, nwide + 1
            letter = line(j:j)
            k = j + 1
            
            if (letter.eq.blank .and. line(k:k).ne.blank) then
c
c blank at position j but not at position j + 1
c
               k = 0
               do l = j + 1, nwide + 1
                  k = k + 1
                  letter = line(l:l) 
                  if (letter.eq.blank) exit
               enddo   
c
c a blank has been encountered so define the token
c                 
               token = blank
               token(1:k) = line(j + 1:j + k)
               l = index(token,'_*')
               if (l.gt.0) then
                  loop_1: do m = l - 1, 1, -1
                     letter = token(m:m)
                     if (letter.ne.uscore) then
                        do n = m + 1, k
                          token(n:n) = blank
                        enddo 
                        exit loop_1
                     endif  
                  enddo loop_1
               endif  
               l = index(token,'_Reject')
               if (l.gt.0) then
                  loop_2: do m = l - 1, 1, -1
                     letter = token(m:m)
                     if (letter.ne.uscore) then
                        do n = m + 1, k
                          token(n:n) = blank
                        enddo 
                        exit loop_2
                     endif  
                  enddo loop_2
               endif 
               l = index(token,'_Accept')
               if (l.gt.0) then
                  loop_3: do m = l - 1, 1, -1
                     letter = token(m:m)
                     if (letter.ne.uscore) then
                        do n = m + 1, k
                          token(n:n) = blank
                        enddo 
                        exit loop_3
                     endif  
                  enddo loop_3
               endif                     
               read (token,*,iostat=ios) x
               if (ios.eq.0) then
                  npos(i) = npos(i) + 1
                  k = 0
               else 
                  mpos(i) = mpos(i) + 1   
               endif   
            endif
            
         enddo  
      enddo 

      ncols = 0
      do i = 1, nlines
         if (mpos(i) + npos(i).gt.ncols) ncols = mpos(i) + npos(i) 
      enddo
        
      do i = 1, nlines
         if (mpos(i) + npos(i).eq.ncols) then
            line = blank//text(i)
            m = 0
            do j = 1, nwide + 1
               letter = line(j:j)
               k = j + 1
               if (letter.eq.blank .and. line(k:k).ne.blank) then
                  k = 0
                  do l = j + 1, nwide + 1
                     k = k + 1
                     letter = line(l:l) 
                     if (letter.eq.blank) exit
                  enddo     
c                  token = blank
c                  token(1:k) = line(j + 1:j + k)
                  m = m + 1
                  if (m.gt.1) line(j:j) = hash
               endif 
            enddo
            text(i) = line
         endif
      enddo 
      end  
c
c-------------------------------------------------------------
c
      subroutine hash04 (nlines, nmax,
     +                   text,
     +                   abort, action)
c
c action: final check for equal number of hashtag column separators on all lines
c author: w.g.bardsley, university of manchester, u.k., 26/07/2016
c
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: nlines, nmax
      character (len = *), intent (in)    :: text(nmax)
      logical,             intent (inout) :: abort, action(*)
c
c locals
c      
      integer    i, j, k, l, mhash, nhash
      character (len = 100) line
      character (len =   1) hash
      parameter (hash = '#')
      external   putadv
      intrinsic  len_trim
      if (.not.action(4)) return
      abort = .false.  
      do i = 1, nlines
         nhash = index(text(i),hash)
         if (nhash.eq.0) then
            abort = .true.
            action(5) = .false.
            action(6) = .false.
            write (line,100) i
            call putadv (line)
            return
         endif
      enddo
      do i = 1, nlines
         k = 0
         l = len_trim(text(i))
         if (i.eq.1) then
            mhash = 0
            do j = 1, l
               k = k + 1
               if (text(i)(k:k).eq.hash) then
                  mhash = mhash + 1
               endif    
            enddo
         else
            nhash = 0
            do j = 1, l
               k = k + 1
               if (text(i)(k:k).eq.hash) then
                  nhash = nhash + 1
               endif
            enddo
            if (mhash.ne.nhash) then
              abort = .false.
              action(5) = .false.
              action(6) = .false. 
              write (line,200) mhash, i, nhash
              call putadv (line)
              return
            endif  
         endif         
      enddo  
  100 format ('Failure: No hashtag column separators at line',i4) 
  200 format ('Failure:',i3,' hashtags at line 1 but',i3,' at Line',i4)       
      end       
c
c-------------------------------------------------------------
c
      subroutine hash05 (isize, nlines, nmax,
     +                   text,
     +                   action, compact, swap)
c
c action: change exponential notation to floats
c author: w.g.bardsley, university of manchester, u.k., 18/07/2016
c
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: isize, nlines, nmax   
      character (len = *), intent (inout) :: text(nmax)
      logical,             intent (in)    :: action(*), compact, swap  
c
c locals
c      
      integer    i, j, k, l, n, nlong, nwide
      integer    nexp, m(256), npos(256), nstart(256), nstop(256)
      character (len = 256) line_after, line_before
      character (len = 256) word256(256)
      character (len = 3  ) word3 
      character (len = 1  ) letter
      character (len = 1  ) blank
      parameter (blank = ' ')
      external   ex2flt
      intrinsic  len_trim, index, ichar
      if (.not.action(5)) return
c
c initialise
c
      nwide = 0
      do i = 1, nlines
         j = len_trim(text(i))
         if (j.gt.nwide) nwide = j
      enddo  
      nwide = nwide + 1
      do i = 1, nlines
         text(i)(nwide:nwide) = blank
      enddo
      do i = 1, 100
         nstart(i) = -1
         npos(i) = -1
         nstop(i) = -1
      enddo   
c
c loop over the lines supplied
c      
      do i = 1, nlines
        
         j = index(text(i),'E+0')
         k = index(text(i),'E-0')
         if (j.gt.0 .and. k.gt.0) then
            l = min(j,k)
         elseif (j.gt.0 .and. k.le.0) then
            l = j
         elseif (j.le.0 .and. k.gt.0) then
            l = k
         else
            l = 0
         endif
         if (l.eq.0) then
            j = index(text(i),'e+0')
            k = index(text(i),'e-0')
            if (j.gt.0 .and. k.gt.0) then
               l = min(j,k)
            elseif (j.gt.0 .and. k.le.0) then
               l = j
            elseif (j.le.0 .and. k.gt.0) then
               l = k
            else
               l = 0
            endif
         endif  
  
         if (l.gt.0) then
c
c an exponential term has been detected
c      
            line_after = blank 
            line_before = text(i)
            nlong = len_trim(line_before)
            do j = 1, 256
               nstart(j) = -1
               npos(j) = -1
               nstop(j) = -1
               word256(j) = blank
            enddo   
            nexp = 1
            npos(nexp) = l
c
c check if there are more than one exponentials
c             
            do j = l + 3, nlong - 2
               word3 = line_before(j:j + 2)
               if (word3.eq.'E+0' .or. word3.eq.'E-0' .or.
     +             word3.eq.'e+0' .or. word3.eq.'e-0') then
                   nexp = nexp + 1
                   npos(nexp) = j
               endif
            enddo
c
c find nstart(j), nstop(j), 256(j), m(j)
c            
            do j = 1, nexp
              
               loop_start: do n = npos(j) - 1, 1, -1
                  letter = line_before(n:n)
                  k = ichar(letter)
                  if (k.lt.48 .or. k.gt.57) then
                     if (k.ne.43 .and. k.ne.45 .and. k.ne.46) then
                        nstart(j) = n + 1
                        exit loop_start
                     endif   
                  endif
                  nstart(j) = 1
               enddo loop_start
                
               loop_stop: do n = npos(j) + 3, nlong
                  letter = line_before(n:n)
                  k = ichar(letter)
                  if (k.lt.48 .or. k.gt.57) then
                     if(k.ne.43 .and. k.ne.45 .and. k.ne.46) then
                        nstop(j) = n - 1
                        exit loop_stop
                     endif   
                  endif
                  nstop(j) = nlong
               enddo loop_stop

               k = nstart(j)
               l = nstop(j)
               n = l - k + 1
               word256(j) = blank
               word256(j)(1:n) = line_before(k:l)
               call ex2flt (isize,
     +                      word256(j),
     +                      compact, swap) 
               n = len_trim(word256(j))
               m(j) = n                                 
            enddo
c
c build up the new string
c            
            do j = 1, nexp
               if (j.eq.1) then
                  if (nstart(1).eq.1) then
                     k = 0
                  else
                     k = 0
                     do l = 1, nstart(1) - 1
                        letter = line_before(l:l)
                        k = k + 1
                        line_after(k:k) = letter
                     enddo
                  endif
                  do l = 1, m(1)
                     letter = word256(1)(l:l)
                     k = k + 1
                     line_after(k:k) = letter
                  enddo     
               else
                  do l = nstop(j - 1) + 1, nstart(j) - 1
                     letter = line_before(l:l)
                     k = k + 1
                     line_after(k:k) = letter
                  enddo
                  do l = 1, m(j)
                     letter = word256(j)(l:l)
                     k = k + 1
                     line_after(k:k) = letter
                  enddo                   
               endif  
            enddo
c
c add the final piece of text if any
c               
            if (nstop(nexp).lt.nlong) then
               do l = nstop(nexp) + 1, nlong
                  letter = line_before(l:l)
                  k = k + 1
                  line_after(k:k) = letter
               enddo
            endif  
c
c overwrite the line supplied
c            
            text(i) = line_after      
         endif
         
      enddo
      end        
c
c-------------------------------------------------------------
c
      subroutine hash06 (isend, nhead, nlines, nmax, ntrail, 
     +                   head, temp, text, trail,
     +                   action)
c
c action: final output 
c author: w.g.bardsley, university of manchester, u.k., 18/07/2016
c
c     
      implicit none
c
c arguments
c      
      integer,             intent (inout) :: nhead, nlines, ntrail  
      integer,             intent (in)    :: isend, nmax
      character (len = *), intent (inout) :: head(nmax), temp(nmax), 
     +                                       trail(nmax), text(nmax)
      logical,             intent (in)    :: action(*)           
c
c locals
c      
      integer    i, j, k, l, nhash
      character (len = 256) line
      character (len = 1  ) amp, blank, bslash, hash, tab
      parameter (amp = '&', blank = ' ', bslash = '\', hash = '#',
     +           tab = char(9))
      intrinsic  len_trim
      if (.not.action(6)) return  
      if (isend.eq.2 .or. isend.eq.3) then
c
c edit the head and trailer for html/xml
c
         if (nhead.gt.0) then
            do i = 1, nhead
               l = len_trim(head(i))
               head(i)(l + 1:l + 6) = '<br />'
            enddo     
         endif      
         nhead = nhead + 1
         head(nhead) = '<table>'
         ntrail = ntrail + 1
         do i = ntrail, 2, -1
            trail(i) = trail(i - 1)
         enddo  
         trail(1) = '</table>'
         if (ntrail.gt.1) then
            do i = 2, ntrail
               l = len_trim(trail(i))
               trail(i)(l + 1:l + 6) = '<br />'
            enddo   
         endif  
      endif   
      if (isend.eq.4) then
c
c edit the header and trailer for LaTeX
c        
         if (nhead.gt.0) then
            do i = 1, nhead
               j = len_trim(head(i))
               j = j + 1
               head(i)(j:j) = bslash
               j = j + 1
               head(i)(j:j) = bslash
            enddo
         endif
         nhead = nhead + 1
         nhash = 0
         line = text(1)
         j = len_trim(line)
         do i = 1, j
            if (line(i:i).eq.hash) nhash = nhash + 1
         enddo
         j = nhash + 3
         do i = 1, j
            if (i.eq.1) then
               line(1:1) = '{'
            elseif (i.lt.j) then
               line(i:i) = 'l'
            else
               line(j:j) = '}'
            endif
         enddo            
         head(nhead) = '\begin{tabular}'//line(1:j)  
         if (ntrail.gt.0) then
            do i = 1, ntrail
               j = len_trim(trail(i))
               j = j + 1
               trail(i)(j:j) = bslash
               j = j + 1
               trail(i)(j:j) = bslash
            enddo
         endif 
         ntrail = ntrail + 1
         do i = ntrail, 2, -1
            trail(i) = trail(i - 1)
         enddo  
         trail(1) = '\end{tabular}\\'
      endif   
      do i = 1, nlines
         l = len_trim(text(i))
         if (isend.eq.1) then
c
c isend = 1: tabs
c           
            do j = 1, l
               if (text(i)(j:j).eq.hash) text(i)(j:j) = tab
            enddo 
         elseif (isend.eq.2 .or. isend.eq.3) then   
c
c isend = 2 or 3: tags
c         
            line = blank
            k = 4
            line(1:k) = '<td>' 
            do j = 1, l
               k = k + 1
               if (text(i)(j:j).eq.hash) then 
                  line(k:k + 4) = '</td>'
                  k = k + 4
                  if (j.lt.l) then
                     line(k + 1:k + 4) = '<td>'
                     k = k + 4
                  endif
               else
                  line(k:k) = text(i)(j:j)         
               endif   
            enddo  
            l = len_trim(line)
            if (line(l - 4: l).ne.'</td>' ) line(l + 1:l + 5) = '</td>'
            text(i) = line
         elseif (isend.eq.4) then  
c
c isend = 4: LaTeX
c         
            do j = 1, l
               if (text(i)(j:j).eq.hash) text(i)(j:j) = amp
            enddo 
            text(i)(l + 1:l + 2) = bslash//bslash
         endif 
      enddo
c
c copy the text
c      
      do i = 1, nlines
         temp(i) = text(i)
         text(i) = blank
      enddo  
c
c define the head
c       
      k = 0
      if (nhead.gt.0) then
         do i = 1, nhead
            k = k + 1
            text(k) = head(i)
         enddo
      endif
c
c define the table
c      
      do i = 1, nlines
         if (isend.eq.2 .or. isend.eq.3) then
            k = k + 1
            text(k) = '<tr>'
            k = k + 1
            text(k) = temp(i)
            k = k + 1
            text(k) = '</tr>'
         else   
            k = k + 1
            text(k) = temp(i)
         endif   
      enddo
c
c define the trailer
c      
      if (ntrail.gt.0) then
         do i = 1, ntrail
            k = k + 1
            text(k) = trail(i)
         enddo
      endif
      nlines = k
      end
c
c----------------------------------------------------------------------end of hasher
c
c***              
c
c----------------------------------------------------------------------start of checker
c
c
c
c
      subroutine latex_checker (isend, 
     +                          line)
c
c action: check a line for Latex syntax
c author: w.g.bardsley, university of manchester, u.k., 04/09/2016
c
c isend = 1: correct for reserved characters $ & % _ { } but set \ = ! and & = !
c isend = 2: restore ? = blank but then set & = ? and \ = ?
c
      implicit none
c
c argument
c      
      integer,             intent (in)    :: isend
      character (len = *), intent (inout) :: line
c
c locals
c      
      integer    i, j, k, l
      character (len = 256) line_copy
      character (len = 12 ) chisqd_ge
      parameter (chisqd_ge = '$\chi^2\geq$')
      character (len = 9  ) dummy9, lambda
      parameter (lambda = '$\lambda$',
     +           dummy9 = '!dummy9!!')
      character (len = 8  ) alpha, chisqd, delta, dummy8, gamma
      parameter ( alpha = '$\alpha$', 
     +           chisqd = '$\chi^2$',
     +            delta = '$\delta$',
     +           dummy8 = '!dummy8!',
     +            gamma = '$\gamma$')
      character (len = 7  ) beta, dummy7
      parameter (beta = '$\beta$',
     +           dummy7 = '!dummy7')  
      character (len = 6  ) geq, leq
      parameter (geq = '$\geq$',
     +           leq = '$\leq$') 
      character (len = 4  ) power4
      character (len = 3  ) power3
      character (len = 1  ) amper, blank, bslash, cbl, cbr, dollar,
     +                      exclam, hash, letter, pcent, power, quest,
     +                      star, uscore
      parameter ( amper = '&', 
     +            blank = ' ',
     +           bslash = '\',
     +              cbl = '{',
     +              cbr = '}',
     +           dollar = '$',
     +           exclam = '!',
     +             hash = '#',
     +            pcent = '%', 
     +            power = '^',
     +            quest = '?',
     +             star = '*', 
     +           uscore = '_') 
      intrinsic  index, len_trim
      if (line.eq.blank) return
      if (isend.lt.1 .or. isend.gt.2) return
      if (isend.eq.1) then    
c
c------------------------------------------------------------
c isend = 1
c code required before the columns are identified by hashtags
c------------------------------------------------------------
c 
       
c
c amper: change & to !
c         
         j = index(line,amper)
         do while (j.gt.0)
            line(j:j) = exclam
            j = index(line,amper)
         enddo        
c
c bslash: change \ to !
c         
         j = index(line,bslash)
         do while (j.gt.0)
            line(j:j) = exclam
            j = index(line,bslash)
         enddo
c
c cbl: change } to \}
c         
         k = index(line,cbl) 
         if (k.gt.0) then
            line_copy = blank
            j = 0
            l = len_trim(line)
            do i = 1, l
               letter = line(i:i)
               if (letter.eq.cbl) then
                  j = j + 1
                  line_copy(j:j) = bslash
               endif    
               j = j + 1
               line_copy(j:j) = letter  
            enddo   
            line(1:j) = line_copy(1:j)
         endif
c
c cbr: change } to \}
c         
         k = index(line,cbr) 
         if (k.gt.0) then
            line_copy = blank
            j = 0
            l = len_trim(line)
            do i = 1, l
               letter = line(i:i)
               if (letter.eq.cbr) then
                  j = j + 1
                  line_copy(j:j) = bslash
               endif    
               j = j + 1
               line_copy(j:j) = letter  
            enddo   
            line(1:j) = line_copy(1:j)
         endif
c
c dollar: change $ to \$
c         
         k = index(line,dollar) 
         if (k.gt.0) then
            line_copy = blank
            j = 0
            l = len_trim(line)
            do i = 1, l
               letter = line(i:i)
               if (letter.eq.dollar) then
                  j = j + 1
                  line_copy(j:j) = bslash
               endif    
               j = j + 1
               line_copy(j:j) = letter  
            enddo   
            line(1:j) = line_copy(1:j)
         endif 
c
c hash: change # to !
c         
         j = index (line,hash)
         do while (j.gt.0)
            line(j:j) = exclam
            j = index(line,hash)
         enddo      
c
c power: change ^ to **
c      
         k = index(line,power) 
         if (k.gt.0) then
            line_copy = blank
            j = 0
            l = len_trim(line)
            do i = 1, l
               letter = line(i:i)
               if (letter.eq.power) then
                  letter = star
                  j = j + 1
                  line_copy(j:j) = star
               endif    
               j = j + 1
               line_copy(j:j) = letter  
            enddo   
            line(1:j) = line_copy(1:j)
         endif           
c
c uscore: change _ to ?
c      
         j = index(line,uscore)
         do while (j.gt.0)
            line(j:j) = quest      
            j = index(line,uscore)
         enddo    
c
c %: change to \%
c
         k = index(line,pcent) 
         if (k.gt.0) then
            line_copy = blank
            j = 0
            l = len_trim(line)
            do i = 1, l
               letter = line(i:i)
               if (letter.eq.pcent) then
                  j = j + 1
                  line_copy(j:j) = bslash
               endif    
               j = j + 1
               line_copy(j:j) = letter  
            enddo   
            line(1:j) = line_copy(1:j)
         endif
      elseif (isend.eq.2) then 
c
c----------------------------------------------------------------
c isend = 2
c code required for fine-tuning after hashtags have been inserted
c----------------------------------------------------------------
c    

         j = index(line,'Chi-sq')
         do while (j.gt.0)
            line(j:j) = 'c'
            j = index(line,'Chi-sq')
         enddo  
         
         j = index(line,'Alpha')
         do while (j.gt.0)
            line(j:j) = 'a'
            j = index(line,'Alpha')
         enddo   

         j = index(line,'Beta')
         do while (j.gt.0)
            line(j:j) = 'b'
            j = index(line,'Beta')
         enddo         

         j = index(line,'Gamma')
         do while (j.gt.0)
            line(j:j) = 'g'
            j = index(line,'Gamma')
         enddo         
           
         j = index(line,'Delta')
         do while (j.gt.0)
            line(j:j) = 'd'
            j = index(line,'Delta')
         enddo   

         j = index(line,'Lambda')
         do while (j.gt.0)
            line(j:j) = 'l'
            j = index(line,'Lambda')
         enddo   
           
         l = len_trim(line)
         j = index(line,quest)
         if (j.gt.0) then 
            do i = j, l
              letter = line(i:i)
              if (letter.eq.quest) line(i:i) = blank
            enddo
        endif
        j = index(line,exclam)
        if (j.gt.0) then 
            do i = j, l
              letter = line(i:i)
              if (letter.eq.exclam) line(i:i) = quest
            enddo
        endif
c
c chi-squared as in chi-square >=, chi-sq. >=, chi-sq >=
c      
         l = len_trim(line)
         j = index(line,'chi-square >=')!13
         do while (j.gt.0)
            line(j:j + 11) = chisqd_ge(1:12)
            do i = j + 12, l - 1
               line(i:i) = line(i + 1:i + 1)
            enddo
            line(l:l) = blank
            l = l + 1
            j = index(line,'chi-square >=')
         enddo 
      
         j = index(line,'chi-sq. >=')!10
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 2
            do i = l, j + 11, -1
               line(i:i) = line(i - 2:i - 2)
            enddo
            line(j:j + 11) = chisqd_ge(1:12)
            j = index(line,'chi-sq. >=')
         enddo    

         j = index(line,'chi-sq >=')!9
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 3
            do i = l, j + 12, -1
               line(i:i) = line(i - 3:i - 3)
            enddo
c            enddo
            line(j:j + 11) = chisqd_ge(1:12)
            j = index(line,'chi-sq >=')
         enddo        
      
         j = index(line,'chi-square')!10
         do while (j.gt.0)
            line(j:j + 7) = chisqd(1:8)
            line(j + 8:j + 8) = blank
            line(j + 9:j + 9) = blank  
            j = index(line,'chi-square') 
         enddo 

         j = index(line,'chi-sq.')!7
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 1
            do i = l, j + 8, -1
               line(i:i) = line(i - 1:i - 1)
            enddo   
            line(j:j + 7) = chisqd(1:8)
            j = index(line,'chi-sq.') 
         enddo 

         j = index(line,'chi-sq')!6
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 2
            do i = l, j + 8, -1
               line(i:i) = line(i - 2:i - 2)
            enddo  
c            l = l + 1
c           do i = l, j + 8, -1
c               line(i:i) = line(i - 1:i - 1)
c            enddo   
            line(j:j + 7) = chisqd(1:8)
            j = index(line,'chi-sq') 
         enddo 
c
c Standard Greek characters
c      

         j = index(line,'alpha')!5
         do while(j.gt.0)
            l = len_trim(line)
            l = l + 3
            do i = l, j + 8, -1
               line(i:i) = line(i - 3:i - 3)
            enddo
            line(j:j + 7) = dummy8(1:8)
            j = index(line,'alpha')
         enddo 
         j = index(line,dummy8)
         do while (j.gt.0)
            line(j:j + 7) = alpha(1:8)
            j = index(line,dummy8)
         enddo
         
          j = index(line,'beta')!4
         do while(j.gt.0)
            l = len_trim(line)
            l = l + 3
            do i = l, j + 2, -1
               line(i:i) = line(i - 3:i - 3)
            enddo
            line(j:j + 6) = dummy7(1:7)
            j = index(line,'beta')
         enddo 
         j = index(line,dummy7)
         do while (j.gt.0)
            line(j:j + 6) = beta(1:7)
            j = index(line,dummy7)
         enddo

         j = index(line,'gamma')!5
         do while(j.gt.0)
            l = len_trim(line)
            l = l + 3
            do i = l, j + 8, -1
               line(i:i) = line(i - 3:i - 3)
            enddo
            line(j:j + 7) = dummy8(1:8)
            j = index(line,'gamma')
         enddo 
         j = index(line,dummy8)
         do while (j.gt.0)
            line(j:j + 7) = gamma(1:8)
            j = index(line,dummy8)
         enddo
      
         j = index(line,'delta')!5
         do while(j.gt.0)
            l = len_trim(line)
            l = l + 3
            do i = l, j + 8, -1
               line(i:i) = line(i - 3:i - 3)
            enddo
            line(j:j + 7) = dummy8(1:8)
            j = index(line,'delta')
         enddo 
         j = index(line,dummy8)
         do while (j.gt.0)
            line(j:j + 7) = delta(1:8)
            j = index(line,dummy8)
         enddo

         j = index(line,'lambda')!6
         do while(j.gt.0)
            l = len_trim(line)
            l = l + 3
            do i = l, j + 9, -1
               line(i:i) = line(i - 3:i - 3)
            enddo
            line(j:j + 8) = dummy9(1:9)
            j = index(line,'lambda')
         enddo 
         j = index(line,dummy9)
         do while (j.gt.0)
            line(j:j + 8) = lambda(1:9)
            j = index(line,dummy9)
         enddo
c
c miscellaneous
c
         j = index(line,'>=')
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 4
            do i = l, j + 5, -1
               line(i:i) = line(i - 4:i - 4)
            enddo
            line(j:j + 5) = geq
            j = index(line,'>=') 
         enddo  

         j = index(line,'=<')
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 4
            do i = l, j + 5, -1
               line(i:i) = line(i - 4:i - 4)
            enddo
            line(j:j + 5) = leq
            j = index(line,'=<') 
         enddo   

         do k = 1, 9
            write (power3,'(a2,i1)') '**',k 
            write (power4,'(a2,i1,a1)') '$^',k,'$' 
            j = index(line,power3)
            do while (j.gt.0)
               l = len_trim(line)
               l = l + 1
               do i = l, j + 4, -1
                  line(i:i) = line(i - 1:i - 1)
               enddo
               line(j:j + 3) = power4
               j = index(line,power3)      
           enddo    
        enddo 

        j = index(line,'infinity')
        do while (j.gt.0)
           line(j:j + 7) = '$\infty$'
           j = index(line,'infinity')
        enddo   
        
      endif       
      end
c
c
c------------------------------------------------------------------
c  
c
c
c
      subroutine html_checker (isend, 
     +                         line)
c
c action: check a line for HTML syntax
c author: w.g.bardsley, university of manchester, u.k., 04/09/2016
c              
      implicit none
c
c argument
c      
      integer,             intent (in)    :: isend
      character (len = *), intent (inout) :: line
c
c locals
c      
      integer    i, j, l
c
c Greek characters
c
      character (len = 17) chisqd, dummy17
      parameter ( chisqd = '&chi;<sup>2</sup>',
     +           dummy17 = '!!!!!!!!!!!!!!!!!') 
      character (len = 8) lambda, dummy8
      parameter (dummy8 = '!!!!!!!!',
     +           lambda = '&lambda;')
      character (len = 7) alpha, delta, dummy7, gamma, sigma, theta
      parameter ( alpha = '&alpha;',
     +            delta = '&delta;', 
     +           dummy7 = '!!!!!!!',
     +            gamma = '&gamma;',
     +            sigma = '&sigma;',
     +            theta = '&theta;')
      character (len = 6) beta, dummy6
      parameter (beta = '&beta;',
     +           dummy6 = '!!!!!!') 
c
c html special characters
c      
      character (len = 5) amper_5, quest_5
      character (len = 4) ge_4, langle_4, le_4, rangle_4
      character (len = 2) le, ge
      character (len = 1) amper, blank, langle, rangle
      parameter ( amper = '&', 
     +            blank = ' ',
     +           langle = '<',
     +           rangle = '>',
     +               le = '=<',
     +               ge = '>=',
     +             le_4 = '&le;',
     +         langle_4 = '&lt;',
     +             ge_4 = '&ge;',   
     +         rangle_4 = '&gt;',
     +          amper_5 = '&amp;',
     +          quest_5 = '?????') 
      intrinsic  index, len_trim
      if (line.eq.blank) return
      if (isend.lt.1 .or. isend.gt.2) return  
      if (isend.eq.1) then  
c
c---------------------------------------------------------
c isend = 1
c---------------------------------------------------------     
c
c amper: change & to ?????
c         
         j = index(line,amper)
         do while (j.gt.0)
            l = len_trim(line) + 4
            do i = l, j + 4, -1
               line(i:i) = line(i - 4:i - 4)
            enddo    
            line(j:j + 4) = quest_5
            j = index(line,amper)
         enddo        
c
c =<: change =< to &le;
c         
         j = index(line,le) 
         do while (j.gt.0)
            l = len_trim(line) + 2
            do i = l, j + 3, -1
               line(i:i) = line(i - 2:i - 2)
            enddo   
            line(j: j + 3) = le_4
            j = index(line,le)
         enddo        
    
c
c >=: change >= to &ge;
c         
         j = index(line,ge) 
         do while (j.gt.0)
            l = len_trim(line) + 2
            do i = l, j + 3, -1
               line(i:i) = line(i - 2:i - 2)
            enddo   
            line(j: j + 3) = ge_4
            j = index(line,ge)
         enddo        
c
c <: change < to &lt;
c         
         j = index(line,langle) 
         do while (j.gt.0)
            l = len_trim(line) + 3
            do i = l, j + 4, -1
               line(i:i) = line(i - 3:i - 3)
            enddo   
            line(j: j + 3) = langle_4
            j = index(line,langle)
         enddo       
c
c >: change > to &gt;
c         
         j = index(line,rangle) 
         do while (j.gt.0)
            l = len_trim(line) + 3
            do i = l, j + 4, -1
               line(i:i) = line(i - 3:i - 3)
            enddo   
            line(j: j + 3) = rangle_4
            j = index(line,rangle)
         enddo 
c
c re-instate &
c
         j = index(line,quest_5)
         do while (j.gt.0)
            line(j:j + 4) = amper_5
            j = index(line,quest_5)
         enddo
      elseif (isend.eq.2) then  
c
c -----------------------------------------------------------------
c isend = 2
c -----------------------------------------------------------------
c       
         j = index(line,'Chi-sq')
         do while (j.gt.0)
            line(j:j) = 'c'
            j = index(line,'Chi-sq')
         enddo  
         
         j = index(line,'Alpha')
         do while (j.gt.0)
            line(j:j) = 'a'
            j = index(line,'Alpha')
         enddo   

         j = index(line,'Beta')
         do while (j.gt.0)
            line(j:j) = 'b'
            j = index(line,'Beta')
         enddo         

         j = index(line,'Gamma')
         do while (j.gt.0)
            line(j:j) = 'g'
            j = index(line,'Gamma')
         enddo         
           
         j = index(line,'Delta')
         do while (j.gt.0)
            line(j:j) = 'd'
            j = index(line,'Delta')
         enddo   

         j = index(line,'Lambda')
         do while (j.gt.0)
            line(j:j) = 'l'
            j = index(line,'Lambda')
         enddo   


      
         j = index(line,'alpha')
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 2
            do i = l, j + 7, -1
              line(i:i) = line(i - 2:i - 2)
            enddo
            line (j:j + 6) = dummy7
            j = index(line,'alpha')
         enddo
         j = index(line,dummy7)
         do while (j.gt.0) 
           line(j:j + 6) = alpha
           j = index(line,dummy7)
         enddo  
    
         j = index(line,'beta')
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 2
            do i = l, j + 6, -1
              line(i:i) = line(i - 2:i - 2)
            enddo
            line (j:j + 5) = dummy6
            j = index(line,'beta')
         enddo
         j = index(line,dummy6)
         do while (j.gt.0) 
           line(j:j + 5) = beta
           j = index(line,dummy6)
         enddo     
         
         j = index(line,'gamma')
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 2
            do i = l, j + 7, -1
              line(i:i) = line(i - 2:i - 2)
            enddo
            line (j:j + 6) = dummy7
            j = index(line,'gamma')
         enddo
         j = index(line,dummy7)
         do while (j.gt.0) 
           line(j:j + 6) = gamma
           j = index(line,dummy7)
         enddo 

         j = index(line,'delta')
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 2
            do i = l, j + 7, -1
              line(i:i) = line(i - 2:i - 2)
            enddo
            line (j:j + 6) = dummy7
            j = index(line,'delta')
         enddo
         j = index(line,dummy7)
         do while (j.gt.0) 
           line(j:j + 6) = delta
           j = index(line,dummy7)
         enddo  
         
         j = index(line,'lambda')
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 2
            do i = l, j + 8, -1
              line(i:i) = line(i - 2:i - 2)
            enddo
            line (j:j + 7) = dummy8
            j = index(line,'lambda')
         enddo
         j = index(line,dummy8)
         do while (j.gt.0) 
           line(j:j + 7) = lambda
           j = index(line,dummy8)
         enddo   

         j = index(line,'theta')
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 2
            do i = l, j + 7, -1
              line(i:i) = line(i - 2:i - 2)
            enddo
            line (j:j + 6) = dummy7
            j = index(line,'theta')
         enddo
         j = index(line,dummy7)
         do while (j.gt.0) 
           line(j:j + 6) = theta
           j = index(line,dummy7)
         enddo  

         j = index(line,'sigma')
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 2
            do i = l, j + 7, -1
              line(i:i) = line(i - 2:i - 2)
            enddo
            line (j:j + 6) = dummy7
            j = index(line,'sigma')
         enddo
         j = index(line,dummy7)
         do while (j.gt.0) 
           line(j:j + 6) = sigma
           j = index(line,dummy7)
         enddo  
c
c chi-square
c
         j = index(line,'chi-square')
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 7
            do i = l, j + 7, -1
               line(i:i) = line(i - 7:i - 7)
            enddo
            line(j:j + 16) = dummy17   
            j = index(line,'chi-square')
         enddo
         j = index(line,'chi-sq.')
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 10
            do i = l, j + 10, -1
               line(i:i) = line(i - 10:i - 10)
            enddo
            line(j:j + 16) = dummy17   
            j = index(line,'chi-sq.')
         enddo
         j = index(line,'chi-sq')
         do while (j.gt.0)
            l = len_trim(line)
            l = l + 11
            do i = l, j + 11, -1
               line(i:i) = line(i - 11:i - 11)
            enddo
            line(j:j + 16) = dummy17   
            j = index(line,'chi-sq')
         enddo
         j = index(line,dummy17)
         do while (j.gt.0)
            line(j:j + 16) = chisqd
            j = index(line,dummy17)
         enddo            
         
         j = index(line,'infinity')
         do while (j.gt.0)
            line(j:j + 7) = '&infin; '
            l = len_trim(line)
            if (l.gt.j + 7) then
               do i = j + 7, l - 1
                 line(i:i) = line(i + 1:i + 1)
               enddo
               line(l:l) = blank  
            endif   
            j = index(line,'infinity')
         enddo   

      endif
      end
c
c
c---------------------------------------------------------------------
c   
      subroutine dot_checker (line)
c
c action: replace '...' by '   ' but no action with '....' or '.....' 
c author: w.g.bardsley, university of manchester, u.k., 11/09/2016
c 
      implicit none
c
c argument
c      
      character (len = *), intent (inout) :: line
c
c locals
c      
      integer    i, j, k, l
      character (len = 3) blank3, dot3
      character (len = 1) dot1, letter
      parameter (blank3 = '   ', dot1 = '.', dot3 = '...')
      intrinsic  index, len_trim
c
c see if dot3 is found in the line
c      
      l = len_trim(line)
      if (l.lt.3) return
      i = index(line,dot3)
      do while (i.gt.0)  
         j = i + 2
         if (j.gt.l) then
c
c the case j > l
c           
            i = 0
         elseif (j.eq.l) then
c
c the case j = l
c         
            line(i:j) = blank3
            i = 0
         else
c
c the case j > l but check for an extra dot
c           
            k = j + 1
            letter = line(k:k)
            if (letter.ne.dot1) then
               line(i:j) = blank3
            endif
         endif 
         do while (k.lt.l)
            k = k + 1
            letter = line(k:k)
            if (letter.ne.dot1) exit
         enddo
         if (k + 2.lt.l) then        
            i = index(line(k:l),dot3)
         else
           i = 0
         endif     
         if (i.gt.0) then
c
c adjust i to the current start position for dot3
c           
            i = i + k - 1   
         endif   
      enddo        
      end

C
C
      subroutine swap_checker (line)
      implicit none
      character (len = *), intent (inout) :: line
      integer    i, m
      character (len = 2) all_words(10), word2
      character (len = 1) comma
      parameter (comma = ',')
      data       all_words / '.0', '.1', '.2', '.3', '.4', 
     +                       '.5', '.6', '.7', '.8', '.9' / 
      do i = 1, 10
         word2 = all_words(i) 
         m = index(line,word2)
         do while (m.gt.0)
            line(m:m) = comma
            m = index(line,word2)
         enddo
      enddo   
      end

c
c
      subroutine number_checker (isize,
     +                           line,  
     +                           compact, swap)
      implicit none
c
c arguments
c             
      integer,             intent (in)    :: isize
      character (len = *), intent (inout) :: line
      logical,             intent (in)    :: compact, swap
c locals
c      
      integer    i, icount, j, k, l, m
      integer    nmax
      parameter (nmax = 100)
      integer    lw(nmax), nstart(nmax), nstop(nmax)
      character (len = 256) line_copy
      character (len = 20 ) word(nmax)
      character (len = 1  ) big_e, blank, letter, value(13)
      parameter (big_e = 'E',  blank = ' ')
      logical    number, started
      logical    done(nmax)
      external   ex2flt, triml1
      intrinsic  len_trim
      data       value / '+', '-', '.',  
     +                   '0', '1', '2', '3', '4',  
     +                   '5', '6', '7', '8', '9' /
c
c check then initialise
c     
      j = index (line,big_e)
      if (j.le.0) return  
      do i = 1, nmax
         lw(i) = 0
         nstart(i) = 0
         nstop(i) = 0
         word(i) = blank
         done(i) = .false.
      enddo     
      line_copy = blank
      icount = 0
      started = .false.
      l = len_trim(line)
c
c locate sets of digits
c      
      do i = 1, l
c
c set letter = line(i:i)
c      
         letter = line(i:i)
         number = .false.
         loop_j: do j = 1, 13
            if (letter.eq.value(j)) then
               number = .true.
               exit loop_j
            endif
         enddo loop_j      
c
c see if letter is a digit
c       
         if (.not.started) then
            if (number) then      
               started = .true.
               icount = icount + 1
               nstart(icount) = i
            endif
         else
            if (number .and. i.eq.l) then
               nstop(icount) = l
            elseif (.not.number .and. letter.ne.big_e) then
               nstop(icount) = i  - 1
               started = .false.
               j = index(line(nstart(icount):nstop(icount)),big_e)
               if (j.le.0) icount = icount - 1
            endif   
         endif
      enddo 
c
c stop if there are no exponentials or change exponentials to floats
c         
      if (icount.le.0) return
      do i = 1, icount
         word(i) = line(nstart(i):nstop(i))  
         call ex2flt (isize,
     +                word(i),
     +                compact, swap)
         call triml1 (word(i))
         lw(i) = len_trim(word(i))
      enddo
c
c build up line_copy then overwrite line
c      
      j = 0
      k = 1
      line_copy = blank
      do i = 1, l
         if (i.lt.nstart(k)) then
            j = j + 1
            line_copy(j:j) = line(i:i)
         elseif (i.eq.nstop(k)) then
            if (k.lt.icount) k = k + 1
         elseif (i.gt.nstop(k)) then
            j = j + 1
            line_copy(j:j) = line(i:i)      
         elseif (.not.done(k)) then
            do m = 1, lw(k)
              j = j + 1        
              line_copy(j:j) = word(k)(m:m)
            enddo
            done(k) = .true.
         endif      
      enddo      
      l = len_trim(line_copy)
      line = blank
      line(1:l) = line_copy(1:l)
      end
c
c-------------------------------------------------------------------------end of checker                   
c
c***         
c
c------------------------------------------------------------------------start of ex2flt
c
      subroutine ex2flt (isize,
     +                   word,
     +                   compact, swap)
c
c action: replace exponential notation by floating point if possible
c author: w.g.bardsley, university of manchester, u.k., 05/09/2016
c     
c     isize: number of padding zeros to be added
c            isize < 0 means leave in exponential notation 
c      word: number in exponential notation returned as floating point if isize >= 0
c   compact: if .true. remove trailing 0's and this will return, e.g., xyz.0
c      swap: replace decimal point by comma if .true.
c
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: isize
      character (len = *), intent (inout) :: word
      logical,             intent (in)    :: compact, swap
c
c locals
c      
      integer    i, ios, itype, j, k, l, n
      integer    nmax
      parameter (nmax = 256)
      double precision x
      character (len = nmax) line, start1, stop1
      character (len = 2   ) word2
      character (len = 1   ) blank, bige, comma, dot, plus, letter, 
     +                       minus, zero
      parameter (bige = 'E', blank = ' ', comma = ',', dot = '.',
     +           plus = '+', minus = '-',  zero = '0')
      external  triml1
      intrinsic index, len_trim
c
c return if no dot or E
c      
      i = index(word,dot)
      if (i.le.0) return 
      j = index(word,bige)  
      if (j.le.0) return
c
c check if not a number an integer or too small or too large
c      
      read (word,*,iostat=ios) x
      if (ios.ne.0) return
      call triml1 (word)  
      l = len_trim(word) 
      if (l.gt.nmax - 1) return
c
c pad out if not +/- as first character
c      
      i = index(word,'E')
      line = blank
      line(1:i - 1) = word(1:i - 1)    
      l = len_trim(line)
      if (line(1:1).ne.plus .and. line(1:1).ne.minus) then
         l = l + 1
         do i = l, 2, -1
            line(i:i) = line(i - 1:i - 1)
         enddo
         line(1:1) = blank
      endif    
c
c check if the exponent is within limits
c        
      if (index(word,'E+08').gt.0) then
         itype = 8
      elseif (index(word,'E+07').gt.0) then
         itype = 7
      elseif (index(word,'E+06').gt.0) then
         itype = 6   
      elseif (index(word,'E+05').gt.0) then
         itype = 5
      elseif (index(word,'E+04').gt.0) then
         itype = 4
      elseif (index(word,'E+03').gt.0) then
         itype = 3
      elseif (index(word,'E+02').gt.0) then
         itype = 2
      elseif (index(word,'E+01').gt.0) then
         itype = 1
      elseif (index(word,'E+00').gt.0) then
         itype = 0
      elseif (index(word,'E-01').gt.0) then
         itype = -1
      elseif (index(word,'E-02').gt.0) then
         itype = -2
      elseif (index(word,'E-03').gt.0) then
         itype = -3   
      elseif (index(word,'E-04').gt.0) then
         itype = -4     
      elseif (index(word,'E-05').gt.0) then
         itype = -5 
      elseif (index(word,'E-06').gt.0) then
         itype = -6           
      else
         goto 20
      endif
      
      if (line(3:3).ne.dot) return
c        
c pad out with zeros
c
      if (isize.lt.0 .or. isize.gt.8) goto 20
      if (isize.gt.0) then
         do i = 1, isize
            l = l + 1
            line(l:l) = zero
         enddo 
      endif  
c
c deal with some special cases
c        
      if (itype.eq.0) then
         word = blank
         word(1:l) = line(1:l)   
         goto 20
      endif
      if (isize.eq.0 .and. itype.lt.0) then
         if (itype.eq.-1) then
            letter = line(2:2)
            line(3:3) = letter
            line(2:2) = dot
            k = len_trim(line)
            word = blank
            word(1:k) = line(1:k)   
         endif 
         goto 20     
      endif
c
c itype < 0
c
      if (itype.lt.0) then
         n = abs(itype)
         if (n.gt.isize) goto 20
         letter = line(2:2)
         line(2:2) = zero
         do i = l, 5, -1
            line(i:i) = line(i - 1:i - 1)
         enddo
         line(4:4) = letter
         do i = 1, n - 1
            do j = l, 5, -1
               line(j:j) = line(j - 1:j - 1)
            enddo   
            line(4:4) = zero
         enddo 
         word = blank
         word(1:l) = line(1:l)
         goto 20   
      endif
      j = l - 3
      if (itype.gt.0 .and. itype.le.j) then
         start1 = blank
         stop1 = blank
         word2 = blank
         word2 = line(1:2)
         i = 4
         j = i + itype - 1
         start1 = line(i:j)
         stop1 = line(j + 1:l) 
         i = len_trim(start1)
         j = len_trim(stop1) 
        
c         write (*,'(a,2x,a)')'word2 =', word2 
c         write (*,'(a,2x,a)')'start1 =', start1 
c         write (*,'(a,2x,a)')'stop1 =', stop1 

         word = blank
         word = word2//start1(1:i)//dot//stop1(1:j) 
      endif  
c
c trim trailing 0's if compact = .true. and change dot to comma if swap = .true.
c      
   20 continue 
      i = index(word,bige)
      if (i.le.0 .and. compact) then
         l = len_trim(word)
         compact_loop: do i = l, 2, -1
            letter = word(i:i)
            if (letter.eq.zero) then
               word(i:i) = blank
            else
               exit compact_loop
            endif      
         enddo compact_loop
      endif  
      l = len_trim(word)
      if (word(l:l).eq.dot) word(l + 1:l + 1) = zero
      if (swap) then
         k = index(word,dot)
         if (k.gt.0) word(k:k) = comma
      endif   
      end
      