C
C
      SUBROUTINE TESTDC (NGRAF, NIN, NMAX, NOUT,
     +                   CDF, X, XGRAF, XSTEP, Y, YGRAF, YSTEP,
     +                   FNAME2, PTITLE,
     +                   CHKNEG)
C
C ACTION : Kolmogorov-Smirnov and chi-square tests on X-values
C AUTHOR : W. G. Bardsley, 11/2/91
C          4/7/92 Added PTITLE, changed argument lists and call to IAXOUT
C          10/3/93 GET???, PUT??? and introduced D1 and D5
C          DBOS version ... 23/2/94
C          22/4/97 win32 version ... added CDF to argument list
C          07/02/2001 added CHOP80
C          27/09/2002 replaced patch1 by table1
C          29/04/2004 suppressed CAUTION since TESTDC now calls PROBKS
C                     which returns exact p for small n
C
C ADVICE : Function CDF(X) is required to map X to Y = Uniform (0,1)
C          Subroutine PARAMS must be called to declare parameters
C          NGRAF: (input/unchanged) dimension
C            NIN: (input/unchanged) unconnected unit for data input
C           NMAX: (input/unchanged) dimension
C           NOUT: (input/unchanged) connected unit for writing results
C           X, XGRAF, XSTEP, Y, YGRAF, YSTEP: workspace
C           FNAME2, PTITLE: workspace
C         CHKNEG: (input/unchanged) check for negative numbers if .true.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NGRAF, NIN, NMAX, NOUT
      DOUBLE PRECISION CDF, X(NMAX), Y(NMAX)
      DOUBLE PRECISION XSTEP(2*NMAX), YSTEP(2*NMAX)
      DOUBLE PRECISION XGRAF(NGRAF), YGRAF(NGRAF)
      CHARACTER  FNAME2*(*), PTITLE*(*)
      LOGICAL    CHKNEG
C
C Locals
C
      INTEGER    NBIG, N0, N1, N2, N3
      PARAMETER (NBIG = 500, N0 = 0, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    ICOUNT(NBIG)
      INTEGER    I, ISUM, J, JCOUNT, K, NDOF, NRECC, NBINS, NUM
      INTEGER    ICOLOR, NUMTXT
      PARAMETER (NUMTXT = 17)
      DOUBLE PRECISION BOUND(0:NBIG), EXPECT(NBIG), OBSERV(NBIG)
      DOUBLE PRECISION DELTA, FACT, RECCN, RNUM
      DOUBLE PRECISION DBIG, DNEG, DPOS, D1, D5, PGDBIG
      DOUBLE PRECISION CHISQ, PGCHI, P95, P99
      DOUBLE PRECISION FIVE, ONE, PNT01, PNT05, PNT4, ZERO
      PARAMETER (FIVE = 5.0D+00, ONE = 1.0D+00, PNT01 = 0.01D+00,
     +           PNT05 = 0.05D+00, PNT4 = 0.4D+00, ZERO = 0.0D+00)
      CHARACTER  RESUL*30, SYMBOL(3)*30, VERDIC*30
      CHARACTER  FNAME1*1024, TITLE*80
      CHARACTER  CHOP80*80, LINE*100, TEXT(NUMTXT)*100
      LOGICAL    ABORT, FIXNPT, LABEL
      EXTERNAL   CHISQD, GETIL1, IAXOUT, KSTEST, NXSORT, PUTFAT,
     +           PUTWAR, VEC1IN, TABLE1, CHOP80
      EXTERNAL   CDF
      INTRINSIC  DBLE, MIN, NINT
      SAVE       JCOUNT
      DATA       JCOUNT / 0 /
      DATA       SYMBOL /'Consider accepting H0',
     +                   'Reject H0 at 5% level',
     +                   'Reject H0 at 1% level'/
C
C First read in the data
C
      I = N3
      J = NIN
      K = NMAX
      FIXNPT = .FALSE.
      LABEL = .TRUE.
      CLOSE (UNIT = J)
      CALL VEC1IN (I, J, K, NUM, X, FNAME1, TITLE, ABORT, FIXNPT, LABEL)
      CLOSE (UNIT = J)
      IF (ABORT) RETURN
      IF (NUM.LT.N1) RETURN
C
C Sort then check that variables are positive if CHKNEG is .TRUE.
C
      CALL NXSORT (NUM, X)
      IF (CHKNEG .AND. X(N1).LT.ZERO) THEN
         CALL PUTFAT ('Numbers must be >= 0 ... Try again')
         RETURN
      ENDIF
C
C Set up bins for the chi-square test
C
      RNUM = DBLE(NUM)
      RECCN = RNUM**PNT4
      NRECC = MIN(NBIG, NINT(RECCN))
      IF (NRECC.LT.N1) NRECC = N1
      WRITE (LINE,100) NBIG, NRECC
      CALL GETIL1 (N1, NBINS, NBIG, LINE)
      DELTA = ONE/DBLE(NBINS)
      FACT = DELTA*NUM
      IF (FACT.LT.FIVE) THEN
         WRITE (LINE,200) FACT
         CALL PUTWAR (LINE)
      ENDIF
      BOUND(N0) = ZERO
      DO I = N1, NBINS - N1
         BOUND(I) = BOUND(I - N1) + DELTA
      ENDDO
      BOUND(N0) = - PNT05
      BOUND(NBINS) = ONE + PNT05
C
C Generate Y from X
C
      DO I = N1, NUM
         Y(I) = CDF(X(I))
C
C Code added to make sure that inversion is monotonic
C
         IF (I.GT.N1) THEN
            IF (Y(I).LT.Y(I - N1)) Y(I) = Y(I - N1)
         ENDIF
      ENDDO
C
C Kolmogorov-Smirnov test
C
      CALL KSTEST (NUM, Y, DBIG, DNEG, DPOS, D1, D5, PGDBIG)
      IF (DBIG.GE.D1) THEN
         RESUL = SYMBOL(N3)
      ELSEIF (DBIG.GE.D5) THEN
         RESUL = SYMBOL(N2)
      ELSE
         RESUL = SYMBOL(N1)
      ENDIF
C
C Fill up bins ready for chi-square test
C
      DO I = N1, NBINS
         ICOUNT(I) = N0
      ENDDO
      DO I = N1, NUM
         DO J = N1, NBINS
            IF (Y(I).GE.BOUND(J - N1) .AND. Y(I).LT.BOUND(J)) THEN
               ICOUNT(J) = ICOUNT(J) + N1
               GOTO 20
            ENDIF
         ENDDO
   20    CONTINUE
      ENDDO
      ISUM = N0
      DO I = N1, NBINS
         OBSERV(I) = ICOUNT(I)
         EXPECT(I) = FACT
         ISUM = ISUM + ICOUNT(I)
      ENDDO
      IF (ISUM.NE.NUM) THEN
         WRITE (LINE,300) ISUM, NUM
         CALL PUTWAR (LINE)
      ENDIF
C
C Now the chi-square test
C
      NDOF = NBINS - N1
      CALL CHISQD (NBINS, NDOF, NOUT, CHISQ, EXPECT, OBSERV, PGCHI,
     +             P95, P99)
      IF (PGCHI.GE.PNT05) THEN
         VERDIC = SYMBOL(N1)
      ELSEIF (PGCHI.GE.PNT01) THEN
         VERDIC = SYMBOL(N2)
      ELSE
         VERDIC = SYMBOL(N3)
      ENDIF
      JCOUNT = JCOUNT + 1
      WRITE (NOUT,400) JCOUNT, TITLE
      WRITE (NOUT,500) DNEG, DPOS, DBIG, PGDBIG, D5, D1, RESUL
      WRITE (NOUT,600) NBINS, NDOF, CHISQ, PGCHI, P95, P99, VERDIC
      WRITE (TEXT,700) JCOUNT, CHOP80(TITLE),
     +                 DNEG, DPOS, DBIG, PGDBIG, D5, D1, RESUL,
     +                 NBINS, NDOF, CHISQ, PGCHI, P95, P99, VERDIC
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1 .OR. I.EQ.5) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
      CALL IAXOUT (ICOUNT, NBINS, NGRAF, NOUT, NUM, CDF, FACT, X, XGRAF,
     +             XSTEP, Y, YGRAF, YSTEP, FNAME2, PTITLE)
  100 FORMAT (
     +'No. chi-sq. cells (bins), max. =', I5,', recommended. =',I5)
  200 FORMAT (
     +'Expected per bin =',F7.2,1X,'... Should be >= 5')
  300 FORMAT (
     +'Sum of cells =',I8,', No. of items =',I8,' ... Should be equal')
  400 FORMAT (
     +/1X,'Kolmogorov-Smirnov and chi-square tests',I4
     +/1X,'==========================================='
     +/1X,'H0: Data are consistent with the current distribution'
     +/1X,'Data: ',A)
  500 FORMAT (
     + 1X,'D-mimimum                    =',F8.4
     +/1X,'D-maximum                    =',F8.4
     +/1X,'D-absolute                   =',F8.4
     +/1X,'p = P([K-S-D] >= D-absolute) =',F8.4
     +/1X,'Upper tail 5% crit. point    =',F8.4
     +/1X,'Upper tail 1% crit. point    =',F8.4,7X,A)
  600 FORMAT (
     + 1X,'No. of chi-square bins    =',I8
     +/1X,'No. of degrees of freedom =',I8
     +/1X,'Chi-square test stat. X   =',1P,E11.3
     +/1X,'p = P(chi-square >= X)    =',0P,F8.4
     +/1X,'Upper tail 5% crit. point =',1P,E11.3
     +/1X,'Upper tail 1% crit. point =',   E11.3,4X,A)
  700 FORMAT (
     + 'Kolmogorov-Smirnov and chi-square tests',I4
     +/
     +/'H0: Data are consistent with the current distribution'
     +/'Data: '
     +/A
     +/'D-mimimum                  =',F8.4
     +/'D-maximum                  =',F8.4
     +/'D-absolute                 =',F8.4
     +/'p = P(K-S-D >= D-absolute) =',F8.4
     +/'Upper tail 5% crit. point  =',F8.4
     +/'Upper tail 1% crit. point  =',F8.4,7X,A
     +/'No. of chi-square bins     =',I8
     +/'No. degrees of freedom     =',I8
     +/'Chi-square test stat. X    =',1P,E11.3
     +/'p = P(chi-square >= X)     =',0P,F8.4
     +/'Upper tail 5% crit. point  =',1P,E11.3
     +/'Upper tail 1% crit. point  =',E11.3,4X,A)
      END
C
C
