C      
C
      SUBROUTINE TESTEO (ISEND, NDOF, NIN, NOUT, NRMAX,
     +                   EXPECT, OBSERV, RTOL,
     +                   FNAMEE, FNAMEO, TITLEE, TITLEO, 
     +                   SUPPLY)
C
C ACTION: Chi-square test on expected and observed frequencies
C AUTHOR: W.G.Bardsley, University of manchester, U.K.
C         13/09/2007 derived from TESTEO of program CHISQD
C         22/09/2007 added ISEND and NDOF to argument list 
C         23/07/2021 added E_NUMBERS and E_FORMATS, etc.  
C
C ISEND = 0: ask for degrees of freedom NDOF
C ISEND = 1: provide degrees of freedom NDOF
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, NIN, NOUT, NRMAX
      INTEGER,             INTENT (INOUT) :: NDOF
      DOUBLE PRECISION,    INTENT (IN)    :: RTOL
      DOUBLE PRECISION,    INTENT (INOUT) :: EXPECT(NRMAX),
     +                                       OBSERV(NRMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAMEE, FNAMEO,
     +                                       TITLEE, TITLEO
      LOGICAL,             INTENT (IN)    :: SUPPLY
C
C Locals
C      
      INTEGER    N0, N1, N3, N8, N10, NY
      PARAMETER (N0 = 0, N1 = 1, N3 = 3, N8 = 8, N10 = 10, NY = 1)
      INTEGER    I, ICOUNT, J, M, NPARS, NUME, NUMO
      INTEGER    JCOLOR
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMTXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMTXT = 18)
      INTEGER    NUMBLD(N8)
      DOUBLE PRECISION CHISQ, PGCHI, P95, P99
      DOUBLE PRECISION SUME, SUMO
      DOUBLE PRECISION ZERO, PNT01, PNT05, FIVE, Y(NY)
      PARAMETER (ZERO = 0.0D+00, PNT01 = 0.01D+00, PNT05 = 0.05D+00,
     +           FIVE = 5.0D+00)
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER (LEN = 13) D13(5), SHOWLJ
      CHARACTER  RESUL*21
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  TEMP(10)*100
      LOGICAL    E_FORMATS, E_NUMBERS   
      LOGICAL    ABORT, FIRST, FIXNPT, LABEL, YES
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   PUTADV, VEC1IN, PUTFAT, GETJGE, CHISQD, PATCH1, TABLE1,
     +           XSTAT2
      SAVE       ICOUNT, FIRST
      DATA       ICOUNT / 0 /
      DATA       FIRST / .TRUE. /
      DATA       NUMBLD / N8*0 /
      IF (ISEND.LT.0 .OR. ISEND.GT.1) RETURN
      IF (.NOT.SUPPLY) THEN
         WRITE (LINE,100)
C
C SUPPLY = .FALSE. so read in observed frequencies 
C         
         CALL PUTADV (LINE)
         I = N3
         J = NIN
         FIXNPT = .FALSE.
         LABEL = .TRUE.
         CLOSE (UNIT = J)
         CALL VEC1IN (I, J, NRMAX, NUMO,
     +                OBSERV,
     +                FNAMEO, TITLEO,
     +                ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = J)
         IF (ABORT) RETURN
C
C SUPLY = .FALSE. so read in expected frequencies
C           
         WRITE (LINE,200)
         CALL PUTADV (LINE)
         I = N3
         J = NIN
         FIXNPT = .FALSE.
         LABEL = .TRUE.
         CLOSE (UNIT = J)
         CALL VEC1IN (I, J, NRMAX, NUME, 
     +                EXPECT,
     +                FNAMEE, TITLEE, 
     +                ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = J)
         IF (ABORT) RETURN
      ELSE
C
C SUPPLY = .TRUE. so define NUME and NUMO
C        
         NUME = NRMAX
         NUMO = NRMAX     
      ENDIF
C
C Check data supplied
C           
      IF (NUME.NE.NUMO .OR. NUME.LT.N1) THEN
         WRITE (LINE,300) NUMO, NUME
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
      SUMO = ZERO
      M = NUME
      DO I = N1, M
         IF (OBSERV(I).LT.ZERO) THEN
            WRITE (LINE,400) I
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         SUMO = SUMO + OBSERV(I)
      ENDDO
      SUME = ZERO
      YES = .FALSE.
      DO I = N1, M
         IF (EXPECT(I).LE.RTOL) THEN
            WRITE (LINE,400) I
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         IF (EXPECT(I).LT.FIVE) THEN
            IF (.NOT.YES) THEN
               JCOLOR = 15
               CALL TABLE1 (JCOLOR, 'OPEN')
               JCOLOR = 0
               YES = .TRUE.
            ENDIF
            WRITE (LINE,500) I
            CALL TABLE1 (JCOLOR, LINE)
         ENDIF
         SUME = SUME + EXPECT(I)
      ENDDO
      IF (YES) CALL TABLE1 (JCOLOR, 'CLOSE')
C
C Get no. of parameters estimated
C 
      IF (ISEND.EQ.0 .AND. FIRST) THEN
         FIRST = .FALSE.    
         WRITE (TEXT,600)
         NUMBLD(1) = N1
         CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, N8,
     +                TEXT,
     +                BORDER)   
      ENDIF
      IF (ISEND.EQ.0) THEN
         NPARS = N0  
         CALL GETJGE (NPARS, N0,
     +'No. of parameters estimated from current observed frequencies')
         NDOF = M - N1 - NPARS
      ENDIF   
      IF (NDOF.LT.N1) THEN
         CALL PUTFAT ('Not enough degrees of freedom ... Try again')
         RETURN
      ENDIF
C
C Do the chi-square calculations 
C      
      CALL CHISQD (M, NDOF, NOUT,
     +             CHISQ, EXPECT, OBSERV, PGCHI, P95, P99)
      IF (PGCHI.GE.PNT05) THEN
         RESUL = 'Consider accepting H0'
      ELSEIF (PGCHI.GE.PNT01) THEN
         RESUL = 'Reject H0 at 5% level'
      ELSE
         RESUL = 'Reject H0 at 1% level'
      ENDIF
C
C Output the results
C      
      E_NUMBERS = E_FORMATS()
      WRITE (NOUT,'(A)') ' '
      WRITE (NOUT,'(A)') '***'
      ICOUNT = ICOUNT + N1
      WRITE (TEXT,700) ICOUNT, TITLEO, TITLEE
      WRITE (NOUT,800) ICOUNT, TITLEO, TITLEE
      IF (E_NUMBERS) THEN
         WRITE (TEMP,900) SUMO, SUME, M, NDOF, CHISQ, PGCHI, RESUL,
     +                    P95, P99
         WRITE (NOUT,900) SUMO, SUME, M, NDOF, CHISQ, PGCHI, RESUL,
     +                    P95, P99
      ELSE
         I12(1) = FORM12(M)
         I12(2) = FORM12(NDOF)
         D13(1) = SHOWLJ(SUMO)
         D13(2) = SHOWLJ(SUME)
         D13(3) = SHOWLJ(CHISQ)
         D13(4) = SHOWLJ(P95)
         D13(5) = SHOWLJ(P99)
         WRITE (TEMP,950) D13(1), D13(2), I12(1), I12(2), D13(3),
     +                    PGCHI, RESUL,
     +                    D13(4), D13(5)
         WRITE (NOUT,950) D13(1), D13(2), I12(1), I12(2), D13(3),
     +                    PGCHI, RESUL,
     +                    D13(4), D13(5)
      ENDIF  
      DO I = N1, N8
         TEXT(N10 + I) = TEMP(I)
      ENDDO
      JCOLOR = 15
      CALL TABLE1 (JCOLOR, 'OPEN')
      DO I = N1, NUMTXT
         IF (I.EQ.2) THEN
            JCOLOR = 4
         ELSEIF (I.EQ.7 .OR. I.EQ.9) THEN
            JCOLOR = 1   
         ELSE
            JCOLOR = 0
         ENDIF     
         CALL TABLE1 (JCOLOR, TEXT(I))
      ENDDO  
      CALL TABLE1 (JCOLOR, 'CLOSE') 
      WRITE (LINE,1000)
C
C Display/Plot frequencies
C      
      CALL XSTAT2 (M, NY,
     +             EXPECT, OBSERV, Y,
     +             LINE)
C
C Format statements 
C     
  100 FORMAT ('Now you must input a column of observed frequencies')
  200 FORMAT ('Now input the corresponding expected frequencies')
  300 FORMAT ('n obs. =',I4,', n exp. =',I4,' ... Must be equal')
  400 FORMAT ('freq. must be >= 0 ... Check line',I4)
  500 FORMAT (1X,'CAUTION : Number. in expected bin',I4,1X,'< 5')
  600 FORMAT (
     + 'Using the correct number of degrees of freedom'
     +/
     +/'The current expected frequencies may be calculated'
     +/'using some parameters estimated from the sample of'
     +/'observed frequencies. If so, this will decrease the'
     +/'number of degrees of freedom in the chi-square test.'
     +/
     +/'You must now input the number of parameters estimated')
  700 FORMAT (
     +/1X,'Chi-square test on O/E data set',I4
     +/
     +/1X,'H0: Observed frequencies are a random sample from'
     +/1X,'    a distribution defined by the expected values'
     +/1X,'Title of observed data'
     +/A
     +/1X,'Title of expected data'
     +/A
     +/)
  800 FORMAT (
     +/1X,'Chi-square test on O/E data set',I4
     +/1X,'-----------------------------------'
     +/1X,'H0: Observed frequencies are a random sample from'
     +/1X,'    a distribution defined by the expected values'
     +/1X,'Title of observed data'
     +/A
     +/1X,'Title of expected data'
     +/A)
  900 FORMAT (
     + 1X,'Sum of observed values       =',1P,E12.5
     +/1X,'Sum of expected values       =',   E12.5
     +/1X,'Number of partitions (bins)  =',I7
     +/1X,'Number of degrees of freedom =',I7
     +/1X,'chi-square test statistic C  =',1P,E12.5
     +/1X,'p = P(chi-square >= C)       =',0P,F7.4,5X,A21
     +/1X,'Upper tail 5% critical point =',1P,E12.5
     +/1X,'Upper tail 1% critical point =',   E12.5)
  950 FORMAT (
     + 1X,'Sum of observed values       =',1X,A
     +/1X,'Sum of expected values       =',1X,A
     +/1X,'Number of partitions (bins)  =',1X,A
     +/1X,'Number of degrees of freedom =',1X,A
     +/1X,'chi-square test statistic C  =',1X,A
     +/1X,'p = P(chi-square >= C)       =',F7.4,5X,A21     
     +/1X,'Upper tail 5% critical point =',1X,A
     +/1X,'Upper tail 1% critical point =',1X,A)
 1000 FORMAT ('Observed and Expected Frequencies')     
      END
C
C
