C
C
      SUBROUTINE TESTFS (NOUT,
     +                   RTOL)
C
C ACTION: F test on sums of squares
C AUTHOR: W.G.Bardsley, University of Manchester, U.K.
C         Derived from subroutine TESTFS in FTEST 09/08/99
C         03/02/2001 now displays defaults
C         24/09/2002 replaced patch1 by table1
C         08/05/2011 added INTENTS and improved
C         28/07/2021 added E_FORMATS and E_NUMBERS etc.
C
C NOUT: unit conected for results
C RTOL: tolerance parameter
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: RTOL 
C
C Locals
C       
      INTEGER    ICOUNT
      INTEGER    I, IFAIL, MDIFF, M1, M2, NDIFF, NPTS
      INTEGER    M1_1, M2_1, NPTS_1
      INTEGER    N0, N1, N3, N4, N14, N15
      PARAMETER (N0 = 0, N1 = 1, N3 = 3, N4 = 4, N14 = 14, N15 = 15)
      INTEGER    ICOLOR, NUMTXT
      PARAMETER (NUMTXT = 17)
      DOUBLE PRECISION EPSI
      DOUBLE PRECISION ZERO, ONE, PNT95, PNT99
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, PNT95 = 0.95D+00,
     +           PNT99 = 0.99D+00)
      DOUBLE PRECISION EMAX, EMIN
      PARAMETER (EMAX = 1.0D-200, EMIN = 1.0D-300)
      DOUBLE PRECISION BOT, QDIFF, Q1, Q2, FSTAT, TOP
      DOUBLE PRECISION Q1_1, Q2_1
      DOUBLE PRECISION ALPHA, BETA, P95, P99
      DOUBLE PRECISION G01EDF$, G01FDF$
      CHARACTER (LEN = 12) I12(5), FORM12
      CHARACTER (LEN = 13) D13(5), SHOWLJ
      CHARACTER  TEMP(4)*100, TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    REPEET
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   PUTIFA, TABLE1, PUTFAT
      EXTERNAL   GETDGT, GETJGE
      EXTERNAL   G01EDF$, G01FDF$
      INTRINSIC  DBLE
      SAVE       ICOUNT
      SAVE       M1, M2, NPTS, Q1, Q2
      DATA       M1, M2, NPTS, Q1, Q2 / 2, 3, 12, 12.0D+00, 10.0D+00 /
      DATA       ICOUNT / 0 /
C
C Check NOUT then define EPSI
C     
      IF (NOUT.LE.N0) RETURN 
      E_NUMBERS = E_FORMATS()
      EPSI = RTOL
      IF (EPSI.LT.EMIN) THEN
         EPSI = EMIN
      ELSEIF (EPSI.GT.EMAX) THEN
         EPSI = EMAX
      ENDIF      
C
C Get Q1 and Q2
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         Q1_1 = Q1
         Q2_1 = Q2

         IF (Q2_1.LT.EPSI) Q2_1 = EPSI
         CALL GETDGT (Q2_1, ZERO,
     +'Smaller sum of squares Q2 (for best fitting model)')

         IF (Q1_1.LE.Q2_1) Q1_1 = Q2_1 + EPSI
         CALL GETDGT (Q1_1, Q2_1,
     +'Larger sum of squares Q1 (for worse fitting model)')         
         
         QDIFF = Q1_1 - Q2_1
         IF (QDIFF.LE.EPSI) THEN
            CALL PUTFAT ('Q1 must be greater than Q2  ...  Try again')
         ELSE
            Q1 = Q1_1
            Q2 = Q2_1
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Get M1 and M2
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         M1_1 = M1
         M2_1 = M2

         IF (M1_1.LT.N1) M1_1 = N1
         CALL GETJGE (M1_1, N1,
     +'Smaller number of parameters M1 (worse fitting model)')

         IF (M1_1.LE.M2_1) M2_1 = M1_1 + N1
         I = M1_1 + N1
         CALL GETJGE (M2_1, I,
     +'Larger number of parameters M2 (best fitting model)')
      
         MDIFF = M2_1 - M1_1
         IF (MDIFF.LE.N0) THEN
            CALL PUTFAT ('M2 must be greater than M1  ...  Try again')
         ELSE
            M1 = M1_1
            M2 = M2_1
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Get NPTS
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         NPTS_1 = NPTS
         IF (NPTS_1.LE.M2) NPTS_1 = M2 + N1
           
         I = M2 + N1
         CALL GETJGE (NPTS_1, I,
     +'Number of experimental points N')
         
         NDIFF = NPTS_1 - M2
         IF (NDIFF.LE.N0) THEN
            CALL PUTFAT ('NPTS must be greater than M2  ...  Try again')
         ELSE
            NPTS = NPTS_1
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C F test
C      
      TOP = QDIFF/DBLE(MDIFF)
      BOT = Q2/DBLE(NDIFF)
      FSTAT = TOP/BOT
      IFAIL = N1
      ALPHA = G01EDF$('Upper-tail', FSTAT, DBLE(MDIFF), DBLE(NDIFF),
     +                IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01EDF/TESTFS')
      BETA = ONE - ALPHA
      IFAIL = N1
      P95 = G01FDF$(PNT95, DBLE(MDIFF), DBLE(NDIFF), IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FDF/TESTFS')
      IFAIL = N1
      P99 = G01FDF$(PNT99, DBLE(MDIFF), DBLE(NDIFF), IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FDF/TESTFS')
      ICOUNT = ICOUNT + 1
      IF (E_NUMBERS) THEN
         WRITE (TEXT,100) ICOUNT, 
     +                    Q1, Q2, M1, M2, NPTS, MDIFF, NDIFF, FSTAT,
     +                    ALPHA, BETA, P95, P99
         WRITE (NOUT,'(A)') BLANK
         WRITE (NOUT,'(A)') '***'
         WRITE (NOUT,'(A)') BLANK
         WRITE (NOUT,200) ICOUNT, 
     +                    Q1, Q2, M1, M2, NPTS, MDIFF, NDIFF, FSTAT,
     +                    ALPHA, BETA, P95, P99
      ELSE
         I12(1) = FORM12(M1)
         I12(2) = FORM12(M2)
         I12(3) = FORM12(NPTS)
         I12(4) = FORM12(MDIFF)
         I12(5) = FORM12(NDIFF)
         D13(1) = SHOWLJ(Q1)
         D13(2) = SHOWLJ(Q2)
         D13(3) = SHOWLJ(FSTAT)
         D13(4) = SHOWLJ(P95)
         D13(5) = SHOWLJ(P99)
         WRITE (TEXT,150) ICOUNT, 
     +                    D13(1), D13(2), I12(1), I12(2), I12(3),
     +                    I12(4), I12(5), D13(3),
     +                    ALPHA, BETA, D13(4), D13(5)
         WRITE (NOUT,'(A)') BLANK
         WRITE (NOUT,'(A)') '***'
         WRITE (NOUT,'(A)') BLANK
         WRITE (NOUT,250) ICOUNT, 
     +                    D13(1), D13(2), I12(1), I12(2), I12(3),
     +                    I12(4), I12(5), D13(3),
     +                    ALPHA, BETA, D13(4), D13(5)         
      ENDIF 
      IF (BETA.GE.PNT99) THEN
         WRITE (TEMP,300)
         WRITE (NOUT,300)
      ELSEIF (BETA.GE.PNT95) THEN
         WRITE (TEMP,400)
         WRITE (NOUT,400)
      ELSE
         WRITE (TEMP,500)
         WRITE (NOUT,500)
      ENDIF
      WRITE (NOUT,'(A)') BLANK
      DO IFAIL = N1, N3
         TEXT(N14 + IFAIL) = TEMP(IFAIL)
      ENDDO
      ICOLOR = N15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = N1, NUMTXT
         IF (I.EQ.N1 .OR. I .EQ.NUMTXT - N1) THEN
            ICOLOR = N4
         ELSE
            ICOLOR = N0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
C
C Format statements
C      
  100 FORMAT (
     + 'F test results', I4
     +/
     +/'Q1 (WSSQ or SSQ for model 1)      =',1P,E12.5
     +/'Q2 (WSSQ or SSQ for model 2)      =',   E12.5
     +/'M1 (number of model 1 parameters) =',I7
     +/'M2 (number of model 2 parameters) =',I7
     +/'NPTS (number of data points)      =',I7
     +/'Numerator degrees of freedom      =',I7
     +/'Denominator degrees of freedom    =',I7
     +/'F test statistic TS               =',1P,E12.5
     +/'p = P(F >= TS)                    =',0P,F7.4
     +/'p = P(F =< TS)                    =',F7.4
     +/'5% upper tail critical point      =',1P,E12.5
     +/'1% upper tail critical point      =',   E12.5)
  150 FORMAT (
     + 'F test results', I4
     +/
     +/'Q1 (WSSQ or SSQ for model 1)      =',1X,A
     +/'Q2 (WSSQ or SSQ for model 2)      =',1X,A
     +/'M1 (number of model 1 parameters) =',1X,A
     +/'M2 (number of model 2 parameters) =',1X,A
     +/'NPTS (number of data points)      =',1X,A
     +/'Numerator degrees of freedom      =',1X,A
     +/'Denominator degrees of freedom    =',1X,A
     +/'F test statistic TS               =',1X,A
     +/'p = P(F >= TS)                    =',F7.4
     +/'p = P(F =< TS)                    =',F7.4
     +/'5% upper tail critical point      =',1X,A
     +/'1% upper tail critical point      =',1X,A)     
  200 FORMAT (
     + 1X,'F test results',I4
     +/1X,'------------------'
     +/1X,'Q1 (WSSQ or SSQ for model 1)      =',1P,E12.5
     +/1X,'Q2 (WSSQ or SSQ for model 2)      =',   E12.5
     +/1X,'M1 (number of model 1 parameters) =',I7
     +/1X,'M2 (number of model 2 parameters) =',I7
     +/1X,'NPTS (number of data points)      =',I7
     +/1X,'Numerator degrees of freedom      =',I7
     +/1X,'Denominator degrees of freedom    =',I7
     +/1X,'F test statistic TS               =',1P,E12.5
     +/1X,'p = P(F >= TS)                    =',0P,F7.4
     +/1X,'p = P(F =< TS)                    =',F7.4
     +/1X,'5% upper tail critical point      =',1P,E12.5
     +/1X,'1% upper tail critical point      =',   E12.5)
  250 FORMAT (
     + 1X,'F test results',I4
     +/1X,'------------------'
     +/1X,'Q1 (WSSQ or SSQ for model 1)      =',1X,A
     +/1X,'Q2 (WSSQ or SSQ for model 2)      =',1X,A
     +/1X,'M1 (number of model 1 parameters) =',1X,A
     +/1X,'M2 (number of model 2 parameters) =',1X,A
     +/1X,'NPTS (number of data points)      =',1X,A
     +/1X,'Numerator degrees of freedom      =',1X,A
     +/1X,'Denominator degrees of freedom    =',1X,A
     +/1X,'F test statistic TS               =',1X,A
     +/1X,'p = P(F >= TS)                    =',F7.4
     +/1X,'p = P(F =< TS)                    =',F7.4
     +/1X,'5% upper tail critical point      =',1X,A
     +/1X,'1% upper tail critical point      =',1X,A)               
  300 FORMAT (/'Conclusion:'
     +/'Model 1 can be rejected at the 1% sig. level')
  400 FORMAT (/'Conclusion:'
     +/'Model 1 can be rejected at the 5% sig. level')
  500 FORMAT (/'Conclusion:'
     +/'Model 2 is not justified ... Tentatively accept model 1')
      END
C
C
