C
C
      SUBROUTINE THWEIB (BETA, CORR, GAMMA, SEBETA, SEGAM, TH, TE)
C
C ACTION: Estimate t-half and S.E.t-half for Weibull MLE estimates
C
C      IMPLICIT NONE
       DOUBLE PRECISION BETA, CORR, GAMMA, SEBETA, SEGAM, TH, TE
       DOUBLE PRECISION ONE, TWO, RTOL
       PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, RTOL = 1.0D-250)
       DOUBLE PRECISION ARGVAL, CV, D1, D2, RATIO
       INTRINSIC EXP, LOG, MAX, SQRT
       RATIO = LOG(TWO)/EXP(BETA)
       TH = RATIO**(ONE/GAMMA)
       CV = CORR*SEBETA*SEGAM
       D1 = - TH/GAMMA
       D2 = - TH*LOG(RATIO)/GAMMA**2
       ARGVAL = (D1*SEBETA)**2 + (D2*SEGAM)**2 + TWO*D1*D2*CV
       TE = SQRT(MAX(ARGVAL, RTOL))
       END
C
C
