C
C
      SUBROUTINE TIME01 (NIN, NOUT, NRMAX,
     +                   AR, ERROR1, ERROR2, P, VR, R, X, XD)
C
C ACTION : Sample autocorrelations
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 29/1/99
C          07/02/2001 added CHOP80
C          28/05/2001 added graphics
C          07/06/2001 added partial autocorrelations
C          11/05/2010 introduced NKLCFG to switch on/off the test file advice 
C          30/04/2011 introduced call to TFILEQ 
C          21/03/2012 replaced TSPLOT$ by TSPLOT
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    NIN, NOUT, NRMAX
      DOUBLE PRECISION AR(NRMAX), ERROR1(NRMAX), ERROR2(NRMAX),
     +                 P(NRMAX), R(NRMAX), VR(NRMAX), X(NRMAX),
     +                 XD(NRMAX)
C
C Locals
C      
      INTEGER     COLOUR, I, IFAIL, NSAV
      INTEGER     ND, NDS, NK, NL, NS, NVL, NX, NXD
      INTEGER     ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER  (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 12,
     +            NSTART = 10)
      INTEGER     NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER     ISEND
      INTEGER     KVAL9, NKLCFG
      INTEGER     LVEC, MVEC, N1, N21
      PARAMETER  (LVEC = 1, MVEC = 0, N1 = 1, N21 = 21)
      DOUBLE PRECISION DELTA, DF, ERROR, PSIG, START, XM, XV, STAT
      DOUBLE PRECISION G01ECF$
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      LOGICAL    FIXNPT, LABEL, REPEET
      PARAMETER (FIXNPT = .FALSE., LABEL = .TRUE.)
      CHARACTER  FNAME*1024, SIGLEV*30, TITLE*80
      CHARACTER  CHOP80*80, LINE*100, TEXT(30)*100, WORD80*80
      CHARACTER  BLANK*1, TAIL*1
      PARAMETER (BLANK = ' ', TAIL = 'U')
      LOGICAL    ABORT, OK, READY
      LOGICAL    FIXED, FLASH, HIGH
      PARAMETER (FIXED = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   VEC1IN, LBOX01, GETJM1, TABLE1, PUTIFA, CHOP80, PUTFAT,
     +           PATCH1, PLEVEL
      EXTERNAL   NKLCFG, TFILEQ
      EXTERNAL   G13AAF$, G13ABF$, G13ACF$, G01ECF$, TSPLOT
      INTRINSIC  DBLE, SQRT, MIN
      SAVE       ND, NDS, NK, NL, NS
      DATA       ND, NDS, NK, NL, NS / 0, 0, 10, 10, 0 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Initialise
C
      NX = 0
      NXD = 0
      DELTA = ONE
      START = ZERO
      OK = .FALSE.
      READY = .FALSE.
C
C Main loop to analyse X
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (READY) THEN
            IF (NK.GT.NX - 1) NK = MIN(NX - 1, 10)
            IF (NL.GT.NK) NL = NK
            NXD = NX - ND - NDS*NS
            IF (NXD.LT.1) THEN
               OK = .FALSE.
               CALL PUTFAT (
     +         'Change data or settings: NXD = NX - ND - NDS*NS < 1')
            ENDIF
            IF (OK) THEN
               NUMDEC = 1
            ELSE
               NUMDEC = 2
            ENDIF
            WORD80 = CHOP80(TITLE)
         ELSE
            WORD80 = 'No current data'
            NUMDEC = 1
         ENDIF
         WRITE (TEXT,100) WORD80, NX, NXD, ND, NDS, NS, NK, NL
         NTEXT = 21
         NUMBLD(2) = 1
         
         IF (NUMDEC.LT.1) THEN
            NUMDEC = 1
         ELSEIF (NUMDEC.GT.NUMOPT) THEN
            NUMDEC = NUMOPT
         ENDIF
         
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT,
     +                FIXED, FLASH, HIGH)
         NUMBLD(2) = 0
C
C Check for current data
C
         IF (.NOT.READY .AND. NUMDEC.GE.2 .AND. NUMDEC.LE.10) THEN
            NUMDEC = 0
            CALL PUTFAT ('First input some time series data')
         ENDIF
         IF (READY .AND. NUMDEC.EQ.2) THEN
            OK = .FALSE.
            IF (NXD.LT.1) THEN
               NUMDEC = 0
               CALL PUTFAT ('First adjust so NX > ND + NDS*NS')
            ELSEIF (NL.GT.NK) THEN
               NUMDEC = 0
               CALL PUTFAT ('First adjust so NK >= NL')
            ELSEIF (NS.EQ.0 .AND. NDS.GT.0) THEN
               NUMDEC = 0
               CALL PUTFAT ('First adjust so NS > 0 if NDS > 0')
            ENDIF
         ENDIF
C
C Check for current analysis
C
         IF (.NOT.OK .AND. NUMDEC.GE.8 .AND. NUMDEC.LE.10) THEN
            NUMDEC = 0
            CALL PUTFAT ('First analyse the current time series data')
         ENDIF
         IF (NUMDEC.EQ.1) THEN
C
C New data
C
            NX = 0
            NXD = 0
            READY = .FALSE.
            OK = .FALSE.
            KVAL9 = NKLCFG(N21)
            IF (KVAL9.EQ.N1) CALL TFILEQ (
     +'Now input a time series vector type file like times.tf1')
            ISEND = 3
            CLOSE (UNIT = NIN)
            CALL VEC1IN (ISEND, NIN, NRMAX, NX, X, FNAME, TITLE,
     +                   ABORT, FIXNPT, LABEL)
            CLOSE (UNIT = NIN)
            IF (ABORT) THEN
               NX = 0
               NXD = 0
               READY = .FALSE.
            ELSE
               IF (NX.LT.6) THEN
                  CALL PUTFAT ('Sample size too small (< 6)')
                  NX = 0
                  NXD = 0
                  READY = .FALSE.
               ELSE
                  READY = .TRUE.
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Calculate
C
            IF (READY) THEN
               IFAIL = 1
               CALL G13AAF$(X, NX, ND, NDS, NS, XD, NXD, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G13AAF/TIME01')
               IF (NK.GT.NXD - 1) NK = NXD - 1
               IF (NL.GT.NK) NL = NK
               IF (IFAIL.EQ.0) THEN
                  CALL G13ABF$(XD, NXD, NK, XM, XV, R, STAT, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G13ABF/TIME01')
                  IF (IFAIL.EQ.2) CALL PUTFAT (
     +               'Sample values are all identical')
               ELSEIF (IFAIL.EQ.1) THEN
                  CALL PUTFAT ('NS = 0 when NDS > 0')
               ELSEIF (IFAIL.EQ.2) THEN
                  CALL PUTFAT ('NX =< ND + NDS*NS')
               ENDIF
               IF (IFAIL.EQ.0) THEN
                  CALL G13ACF$(R, NK, NL, P, VR, AR, NVL, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G13ACF/TIME01')
                  IF (IFAIL.EQ.1) THEN
                     CALL PUTFAT ('NK < NL')
                  ELSEIF (IFAIL.EQ.2) THEN
                     CALL PUTFAT ('ABS(R(1)).GE.1')
                  ELSEIF (IFAIL.EQ.3) THEN
                     CALL PUTFAT (
     +                   'Singular sample ... Calculation failed')
                     IF (NVL.GE.1) IFAIL = 0
                  ENDIF
               ENDIF
            ELSE
               IFAIL = 1
               CALL PUTFAT ('First input some time series data')
               OK = .FALSE.
            ENDIF
            IF (IFAIL.EQ.0) THEN
               OK = .TRUE.
               DF = DBLE(NK)
               IFAIL = 1
               PSIG = G01ECF$(TAIL, STAT, DF, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01ECF/TIME01')
            ELSE
               OK = .FALSE.
            ENDIF
            IF (IFAIL.EQ.0) THEN
C
C Results
C
               CALL PLEVEL (PSIG,
     +                      SIGLEV)              
               COLOUR = 15
               CALL TABLE1 (COLOUR, 'OPEN')
               WRITE (TEXT,200) WORD80, NX, NXD, ND, NDS, NS, NK,
     +                          NVL, XM, XV, STAT, PSIG, SIGLEV
               WRITE (NOUT,200) TITLE, NX, NXD, ND, NDS, NS, NK,
     +                          NVL, XM, XV, STAT, PSIG, SIGLEV
               COLOUR = 0
               DO I = 1, 14
                  CALL TABLE1 (COLOUR, TEXT(I))
               ENDDO
               WRITE (NOUT,'(A)') BLANK
               WRITE (NOUT,300)
               WRITE (LINE,300)
               COLOUR = 4
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = 0
               DO I = 1, NK
                  IF (I.LE.NVL) THEN
                     WRITE (LINE,400) I, R(I), P(I), VR(I), AR(I)
                     WRITE (NOUT,400) I, R(I), P(I), VR(I), AR(I)
                  ELSE
                     WRITE (LINE,500) I, R(I)
                     WRITE (NOUT,500) I, R(I)
                  ENDIF
                  CALL TABLE1 (COLOUR, LINE)
               ENDDO
               CALL TABLE1 (COLOUR, 'CLOSE')
            ENDIF
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Change ND
C
            I = 0
            IF (ND.GT.NX - 1 .OR. ND.LE.0) ND = 0
            NSAV = ND
            CALL GETJM1 (I, NSAV, NX - 1,
     +     'Order of non-seasonal differencing required (ND)')
            IF (NSAV.NE.ND) THEN
               OK = .FALSE.
               ND = NSAV
            ENDIF
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Change NDS
C
            I = 0
            IF (NDS.GT.NX - 1 .OR. NDS.LT.0) NDS = 0
            NSAV = NDS
            CALL GETJM1 (I, NSAV, NX - 1,
     +     'Order of seasonal differencing required (NDS)')
            IF (NSAV.NE.NDS) THEN
               OK = .FALSE.
               NDS = NSAV
            ENDIF
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Change NS
C
            I = 0
            IF (NS.GT.NX - 1 .OR. NS.LT.0) NS = 0
            NSAV = NS
            CALL GETJM1 (I, NSAV, NX - 1,
     +     'Seasonality required (NS)')
            IF (NSAV.NE.NS) THEN
               OK = .FALSE.
               NS = NSAV
            ENDIF
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Change NK
C
            I = 1
            IF (NK.GT.NX - 1 .OR. NK.LT.1) NK = 1
            NSAV = NK
            CALL GETJM1 (I, NSAV, NX - 1,
     +     'No. of lags required')
            IF (NSAV.NE.NK) THEN
               OK = .FALSE.
               NK = NSAV
            ENDIF
            IF (NL.GT.NK) NL = NK
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Change NL
C
            I = 1
            IF (NL.GT.NK) NL = NK
            NSAV = NL
            CALL GETJM1 (I, NSAV, NK,
     +     'No. of partial autocorrelations required')
            IF (NSAV.NE.NL) THEN
               OK = .FALSE.
               NL = NSAV
            ENDIF
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Plot time series
C
            ISEND = 1
            CALL TSPLOT (ISEND, LVEC, MVEC, NXD,
     +                   DELTA, ERROR1, ERROR2, START, XD,
     +                   WORD80, 'Time', 'Differenced Values')
         ELSEIF (NUMDEC.EQ.9) THEN
C
C Plot autocorrelations
C
            ERROR = ONE/SQRT(DBLE(NXD))
            DO I = 1, NK
               ERROR1(I) = TWO*ERROR
               ERROR2(I) = - ERROR1(I)
            ENDDO
            ISEND = 6
            CALL TSPLOT (ISEND, LVEC, MVEC, NK,
     +                   DELTA, ERROR1, ERROR2, START, R,
     +                   'Autocorrelation Function',
     +                   'Lags', 'ACF values')
         ELSEIF (NUMDEC.EQ.10) THEN
C
C Plot partial autocorrelations
C
            ERROR = ONE/SQRT(DBLE(NXD))
            DO I = 1, NK
               ERROR1(I) = TWO*ERROR
               ERROR2(I) = - ERROR1(I)
            ENDDO
            ISEND = 6
            CALL TSPLOT (ISEND, LVEC, MVEC, NVL,
     +                   DELTA, ERROR1, ERROR2, START, P,
     +                   'Partial Autocorrelation Function',
     +                   'Lags', 'PACF values')
         ELSEIF (NUMDEC.EQ.11) THEN
C
C Help
C
            WRITE (TEXT,600)
            NTEXT = 22
            NUMBLD(1) = 1
            NUMBLD(22) = 1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT, TEXT,
     +                   BORDER)
            NUMBLD(1) = 0
            NUMBLD(22) = 0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Title for current time series data is:-'
     +/A
     +/'Current sample size (NX) =',I5
     +/'Size after differencing (NXD) =',I5
     +/'Non-seasonal differencing order (ND) =',I5
     +/'Seasonal differencing order (NDS) =',I5
     +/'Assigned seasonality (NS) =',I5
     +/'Number of lags requested (NK) =',I5
     +/'Number of partial autocorrelations (NL) =',I5
     +/'New data'
     +/'Calculate'
     +/'Change ND (non-seasonal differencing)'
     +/'Change NDS (seasonal differencing)'
     +/'Change NS (seasonality)'
     +/'Change NK (number of lags requested)'
     +/'Change NL (number of PACFs requested)'
     +/'Plot the differenced time series (XD)'
     +/'Plot autocorrelations +- 2/sqrt(NXD)'
     +/'Plot partial autocorrelations +- 2/sqrt(NXD)'
     +/'Help'
     +/'Quit ... Exit time series analysis')
  200 FORMAT (
     + '...'
     +/'Current data title is:-'
     +/A
     +/'Original dimension (NX)  =',I6
     +/'After differencing (NXD) =',I6
     +/'Non-seasonal order (ND)  =',I6
     +/'Seasonal order (NDS)     =',I6
     +/'Seasonality (NS)         =',I6
     +/'Number of lags (NK)      =',I6
     +/'Number of PACF (NVL      =',I6
     +/'X-mean (differenced)     =',1P,E13.5
     +/'X-variance (differenced) =',   E13.5
     +/'Statistic (S)            =',   E13.5
     +/'p = P(chi-sq >= S)       =',0P,F8.4,2X,A)
  300 FORMAT (' Lag      R         PACF         VR           ARP')
  400 FORMAT (I4,2X,F8.4,1P,3E13.5)
  500 FORMAT (I4,F8.4)
  600 FORMAT (
     + 'Definitions for model free time series calculations'
     +/
     +/'The procedures assume you have a sample of values measured'
     +/'at equal increments of time (or space, etc.) and wish to'
     +/'explore the data for possible autocorrelations.'
     +/'X     `the sample (i.e. vector of data with no missing values)'
     +/'NX    `dimension of X'
     +/'XD    `transformed vector derived from X by differencing'
     +/'NXD   `dimension of XD (i.e. NXD = NX - ND - NS*NDS)'
     +/'ND    `order of non-seasonal differencing'
     +/'NDS   `order of seasonal differencing'
     +/'NS    `seasonality of seasonal differencing'
     +/'NK    `number of lags requested'
     +/'NL    `number of partial correlations requested'
     +/'NVL   `number of valid partial correlations'
     +/'R     `calculated autocorrelation coefficients'
     +/'PACF  `calculated partial autocorrelation coefficients'
     +/'VR    `calculated predictor error variance ratios'
     +/'AR    `calculated autoregressive parameters of maximum order'
     +/'S     `statistic for testing H0: all autocorrelations zero'
     +/
     +/'Note: if ND = NDS = NS = 0, the original sample X is analysed.')
      END
C
C
