C
C
      SUBROUTINE TIME02 (LW, NIN, NOUT, NRMAX,
     +                   AL, EX, EXR, ST, W, X)
C
C ACTION : ARIMA
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 06/07/2001
C          07/07/2001 Derived from TIME01
C          11/05/2010 introduced NKLCFG to switch on/off the test file advice 
C          30/04/2011 introduced call to TFILEQ
C
C          LW and NRMAX dimension the workspaces but note that
C          AL, EX, EXR, ST and W should be of sufficient length to
C          hold the time series data plus extra information (see
C          NAG G13 descriptions)
C          The maximum no. of predictions is set by NFVMAX and the
C          maximum no. of parameters is set by NPMAX through IHMAX
C          KFC = 1 implies that the constant C must be estimated
C          KZSP = 1 implies that tolerances are set using ZSP
C
      IMPLICIT    NONE
C
C Arguments
C      
      INTEGER     LW, NIN, NOUT, NRMAX
      DOUBLE PRECISION AL(NRMAX), EX(NRMAX), EXR(NRMAX), ST(NRMAX),
     +                 W(LW), X(NRMAX)      
C
C Locals
C      
      INTEGER     COLOUR, I, J, L1, L2, M1, M2, N1, N2, NSAV
      INTEGER     ND, NDS, NF, NK, NP, NPAR, NPP, NQ, NQQ, NS, NX, NXD
      INTEGER     KVAL9, NKLCFG
      INTEGER     K1, K21
      PARAMETER  (K1 = 1, K21 = 21)
      INTEGER     ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER  (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1)
      INTEGER     NUMBLD(30), NUMPOS(20)
      INTEGER     ICOUNT(6), ISF(4), IEX, IST, ITC, MR(7), NST,
     +            NWA
      INTEGER     IACC, IFAIL, IGH, IH, ISEND, ISTART, IWA, KPIV, NIT
      INTEGER     IHMAX, KFC, KZSP, NFVMAX, NPMAX
      PARAMETER  (IHMAX = 250, NFVMAX = 250, NPMAX = IHMAX/5)
      DOUBLE PRECISION FABOVE(NFVMAX), FBELOW(NFVMAX), FSD(NFVMAX),
     +                 FTIME(NFVMAX),
     +                 FVA(NFVMAX), G(IHMAX), H(IHMAX,IHMAX),
     +                 HC(IHMAX,IHMAX), PAR(IHMAX), SD(IHMAX)
      DOUBLE PRECISION C, DELTA, RMS, RV, S, START, STAT, XM, XV, ZSP(4)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION G01FBF$, DOF, PROB, TVAL
      PARAMETER (PROB = 0.95D+00)
      CHARACTER  CIPHER*30, FNAME*1024, TITLE*80, TYPE1*6, TOLVAL*10
      CHARACTER  CHOP80*80, LINE*100, TEXT(30)*100, WORD80*80
      CHARACTER  F1TYPE*3, MONIT*3, STYPE*10, T1TYPE*3
      CHARACTER  PTITLE*40, XTITLE*20, YTITLE*20
      CHARACTER  BLANK*1, TAIL*1
      PARAMETER (BLANK = ' ', TAIL = 'C')
      LOGICAL    FIXNPT, LABEL
      PARAMETER (FIXNPT = .FALSE., LABEL = .TRUE.)
      LOGICAL    ABORT, AGAIN, OK, READY, REPEET
      LOGICAL    FIXED, FLASH, HIGH
      PARAMETER (FIXED = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FRAME, NEXT, TITLES, UPDOWN
      PARAMETER (FRAME = .FALSE., TITLES = .TRUE., UPDOWN = .TRUE.)
      LOGICAL    AXES, GSAVE
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE.)
      LOGICAL    FILE1, FILE2, TSHOW1, TSHOW2
      EXTERNAL   VEC1IN, LBOX01, GETJM1, TABLE1, PUTIFA, CHOP80, PUTFAT,
     +           TUTOR1, PUTADV, LVIEW2, GETD01, LBOX02, GKS004, TIME03
      EXTERNAL   NKLCFG, TFILEQ
      EXTERNAL   G13AAF$, G13AEF$, G13ABF$, G13ADF$, G13AHF$, AFZG13,
     +           G01FBF$
      INTRINSIC  DBLE, MIN, MAX
      SAVE       DELTA, START
      SAVE       IACC, ISTART, KPIV, NIT
      SAVE       ND, NDS, NF, NP, NPP, NQ, NQQ, NS
      SAVE       FILE1, FILE2, TSHOW1, TSHOW2
      DATA       DELTA, START / ONE, ONE /
      DATA       IACC, ISTART, KPIV,  NIT
     +          /   2,      1,    0,   25 /
      DATA         ND, NDS, NF, NP, NPP, NQ, NQQ, NS
     +          /   1,   0,  3,  1,   0,  0,   0,  0 /
      DATA       FILE1, FILE2, TSHOW1, TSHOW2
     +          / .FALSE., .TRUE., .TRUE., .TRUE. /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
C
C Initialise
C
      KFC = 1
      KZSP = 1
      NX = 0
      NXD = 0
      DO I = 1, IHMAX
         PAR(I) = ZERO
      ENDDO
      C = ZERO
      XM = ZERO
      OK = .FALSE.
      READY = .FALSE.
C
C Main loop to analyse X ...............................................
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (READY) THEN
            NXD = NX - ND - NDS*NS
            IF (NXD.LT.1) THEN
               OK = .FALSE.
               CALL PUTFAT (
     +         'Change data or settings: NXD = NX - ND - NDS*NS < 1')
            ENDIF
            IF (OK) THEN
               NUMDEC = 1
            ELSE
               NUMDEC = 2
            ENDIF
            WORD80 = CHOP80(TITLE)
         ELSE
            WORD80 = 'No current data'
            NUMDEC = 1
         ENDIF
         NPAR = NP + NPP + NQ + NQQ
         IF (IACC.EQ.1) THEN
            TOLVAL = 'very low'
         ELSEIF (IACC.EQ.2) THEN
            TOLVAL = 'low'
         ELSEIF (IACC.EQ.3) THEN
            TOLVAL = 'normal'
         ELSEIF (IACC.EQ.4) THEN
            TOLVAL = 'medium'
         ELSEIF (IACC.EQ.5) THEN
            TOLVAL = 'high'
         ELSEIF (IACC.EQ.6) THEN
            TOLVAL = 'very high'
         ENDIF
         WRITE (TEXT,100) WORD80, NX, NXD, ND, NDS, NS, NF, NPAR,
     +                    NP, NQ, NPP, NQQ, TOLVAL
         NSTART = 10
         NTEXT = 22
         NUMOPT = 13
         NUMBLD(2) = 1
C
C Main menu
C

         IF (NUMDEC.LT.1) THEN
            NUMDEC = 1
         ELSEIF (NUMDEC.GT.NUMOPT) THEN
            NUMDEC = NUMOPT
         ENDIF
         
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, TEXT, FIXED, FLASH, HIGH)
         NUMBLD(2) = 0
C
C Check for current data
C
         IF (.NOT.READY .AND. NUMDEC.GE.2 .AND. NUMDEC.LE.10) THEN
            NUMDEC = 0
            CALL PUTFAT ('First input some time series data')
         ENDIF
         IF (READY .AND. NUMDEC.EQ.2) THEN
            OK = .FALSE.
            IF (NXD.LT.1) THEN
               NUMDEC = 0
               CALL PUTFAT ('First adjust so NX > ND + NDS*NS')
            ELSEIF (NF.GT.NX - 1) THEN
               NUMDEC = 0
               CALL PUTFAT ('First adjust so NF < NX')
            ELSEIF (NS.EQ.0 .AND. NDS.GT.0) THEN
               NUMDEC = 0
               CALL PUTFAT ('First adjust so NS > 0 if NDS > 0')
            ENDIF
            I = NPP + NDS + NQQ
            IF (NS.EQ.0 .AND. I.NE.0) THEN
               NUMDEC = 0
               CALL PUTFAT ('NS = 0 but (NPP + NDS + NQQ) .NE. 0')
            ELSEIF (NS.EQ.1) THEN
               NUMDEC = 0
               CALL PUTFAT ('NS cannot be set to 1')
            ELSEIF (NS.GT.1 .AND. I.LE.0) THEN
               NUMDEC = 0
               CALL PUTFAT ('NS > 1 but (NPP + NDS + NQQ) .LE. 0')
            ENDIF
         ENDIF
C
C Check for current analysis
C
         IF (.NOT.OK .AND. NUMDEC.GE.8 .AND. NUMDEC.LE.11) THEN
            NUMDEC = 0
            CALL PUTFAT ('First analyse the current time series data')
         ENDIF
         IF (NUMDEC.EQ.1) THEN
C
C New data
C
            NX = 0
            NXD = 0
            READY = .FALSE.
            OK = .FALSE.
            KVAL9 = NKLCFG(K21)
            IF (KVAL9.EQ.K1) CALL TFILEQ (
     +'Now input a time series vector type file like times.tf1')
            ISEND = 3
            CLOSE (UNIT = NIN)
            CALL VEC1IN (ISEND, NIN, NRMAX, NX, X, FNAME, TITLE,
     +                   ABORT, FIXNPT, LABEL)
            CLOSE (UNIT = NIN)
            IF (ABORT) THEN
               NX = 0
               NXD = 0
               READY = .FALSE.
            ELSE
               IF (NX.LT.6) THEN
                  CALL PUTFAT ('Sample size too small (< 6)')
                  NX = 0
                  NXD = 0
                  READY = .FALSE.
               ELSE
                  READY = .TRUE.
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Fit ARIMA
C
            IF (READY) THEN
C
C Step 1: differencing
C
               IFAIL = 1
               CALL G13AAF$(X, NX, ND, NDS, NS, AL, NXD, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G13AAF/TIME02')
               NK = MAX(NP + NQ, NS*(NPP + NQQ))
               IF (NK.GT.NXD - 1) THEN
                  CALL PUTFAT ('Too many parameters requested')
                  IFAIL = 1
               ENDIF
               IF (IFAIL.EQ.0) THEN
C
C Step 2: autocorrelations
C
                  CALL G13ABF$(AL, NXD, NK, XM, XV, EX, STAT, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G13ABF/TIME02')
                  IF (IFAIL.EQ.2) CALL PUTFAT (
     +               'Sample values are all identical')
               ELSEIF (IFAIL.EQ.1) THEN
                  CALL PUTFAT ('NS = 0 when NDS > 0')
               ELSEIF (IFAIL.EQ.2) THEN
                  CALL PUTFAT ('NX =< ND + NDS*NS')
               ENDIF
               IF (IFAIL.EQ.0) THEN
C
C Step 3: starting estimates
C
                  MR(1) = NP
                  MR(2) = ND
                  MR(3) = NQ
                  MR(4) = NPP
                  MR(5) = NDS
                  MR(6) = NQQ
                  MR(7) = NS
                  NPAR = NP + NPP + NQ + NQQ
                  IF (ISTART.EQ.1) THEN
                     DO I = 1, NPAR
                        PAR(I) = ZERO
                     ENDDO
                     C = ZERO
                  ELSEIF (ISTART.EQ.2) THEN
                     C = XM
                     NWA = MAX(NP**2 + NP, NPP**2 + NPP, 4*(NQ + 1),
     +                         4*(NQQ + 1))
                     CALL G13ADF$(MR, EX, NK, XV, NPAR, W, NWA, PAR,
     +                            RV, ISF, IFAIL)
                     CALL PUTIFA (IFAIL, NOUT, 'G13ADF/TIME02')
                     IF (IFAIL.EQ.1) THEN
                        J = 0
                        DO I = 1, 7
                           IF (MR(I).LT.0) J = J + 1
                        ENDDO
                        IF (J.GT.0) CALL PUTADV (
     +                  'one of NP, ND, NQ, NPP, NDS, NQQ, NS < 0')
                        J = NP + NQ + NPP + NQQ
                        IF (J.LE.0) CALL PUTADV (
     +                      'NP + NQ + NPP + NQQ not greater than zero')
                        IF (NS.EQ.1) CALL PUTADV (
     +                   'NS should not equal 1')
                        J = NPP + NDS + NQQ
                        IF (NS.EQ.0 .AND. J.NE.0) CALL PUTADV (
     +                  'NPP + NDS + NQQ not equal to zero')
                        IF (NS.GT.1 .AND. J.LE.0) CALL PUTADV(
     +                  'NPP + NDS + NQQ not greater than 0')
                     ELSEIF (IFAIL.EQ.7) THEN
                        CALL PUTADV (
     +                  'Will proceed with starting estimates set = 0')
                         IFAIL = 0
                        DO I = 1, NPAR
                           PAR(I) = ZERO
                        ENDDO
                        C = ZERO
                     ENDIF
                  ELSEIF (ISTART.EQ.3) THEN
                     DO I = 1, NPAR
                        WRITE (LINE,200) I
                        CALL GETD01 (PAR(I), LINE)
                     ENDDO
                     CALL GETD01 (C, 'Constant term')
                  ENDIF
               ENDIF
            ELSE
               IFAIL = 1
               CALL PUTFAT ('First input some time series data')
               OK = .FALSE.
            ENDIF
            IF (IFAIL.EQ.0) THEN
C
C Step 4: fit ARIMA model
C
               IEX = NQ + NQQ*NS + NX
               IH = IHMAX
               IGH = NQ + NQQ*NS + NPAR + KFC
               IST = NPP*NS + ND + NDS*NS + NQ + MAX(NP,NQQ*NS)
               I = NX + 1 + NP + NPP*NS + NQ + NQQ*NS
               IF (KFC.EQ.1) THEN
                  J = 8
               ELSEIF (NQQ.GT.0) THEN
                  J = 7
               ELSEIF (NPP.GT.0) THEN
                  J = 6
               ELSEIF (NPP.EQ.0 .AND. NQ.GT.0) THEN
                  J = 5
               ELSE
                  J = 4
               ENDIF
               IWA = I*J + 9*NPAR
               IF (KZSP.EQ.1) THEN
                  ZSP(1) = 0.001D+00
                  ZSP(2) = 10.0D+00
                  ZSP(3) = 1000.0D+00
                  IF (IACC.EQ.1) THEN
                     ZSP(4) = 1.0D-02
                  ELSEIF (IACC.EQ.2) THEN
                     ZSP(4) = 1.0D-03
                  ELSEIF (IACC.EQ.3) THEN
                     ZSP(4) = 1.0D-04
                  ELSEIF (IACC.EQ.4) THEN
                     ZSP(4) = 1.0D-05
                  ELSEIF (IACC.EQ.5) THEN
                     ZSP(4) = 1.0D-06
                  ELSEIF (IACC.EQ.6) THEN
                     ZSP(4) = 1.0D-07
                  ENDIF
               ENDIF
               MR(1) = NP
               MR(2) = ND
               MR(3) = NQ
               MR(4) = NPP
               MR(5) = NDS
               MR(6) = NQQ
               MR(7) = NS
               NPAR = NP + NPP + NQ + NQQ
               CALL G13AEF$(MR, PAR, NPAR, C, KFC, X, NX, ICOUNT, EX,
     +                      EXR, AL, IEX, S, G, IGH, SD, H, IH, ST, IST,
     +                      NST, AFZG13, KPIV, NIT, ITC, ZSP, KZSP, ISF,
     +                      W, IWA, HC, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G13AEF/TIME02')
               IF (IFAIL.GE.7 .AND. IFAIL.LE.10) THEN
                  IFAIL = 0
                  CALL PUTADV (
     +'ARIMA failure: Parameters and standard errors are ill-defined')
               ENDIF
            ELSE
               OK = .FALSE.
            ENDIF
            IF (IFAIL.EQ.0 .AND. NF.GT.0) THEN
C
C Step 5: forecasts
C
               RMS = S/DBLE(ICOUNT(5))
               NWA = 4*NPAR + 3*NST
               CALL G13AHF$(ST, NST, MR, PAR, NPAR, C, RMS, NF, FVA,
     +                      FSD, W, NWA, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G13AHF/TIME02')
            ENDIF
            IF (IFAIL.EQ.0) THEN
C
C Results
C
               OK = .TRUE.
               COLOUR = 15
               CALL TABLE1 (COLOUR, 'OPEN')
               WRITE (TEXT,300) WORD80, NX, NXD, ND, NDS, NS, NF,
     +                          NPAR, ITC, S
               WRITE (NOUT,300) TITLE, NX, NXD, ND, NDS, NS, NF,
     +                          NPAR, ITC, S
               COLOUR = 0
               DO I = 1, 12
                  CALL TABLE1 (COLOUR, TEXT(I))
               ENDDO
               WRITE (NOUT,'(A)') BLANK
               WRITE (NOUT,400)
               WRITE (LINE,400)
               COLOUR = 4
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = 0
               DO I = 1, NPAR
                  IF (I.LE.NP) THEN
                     J = I
                     CIPHER = 'Autoregressive'
                     TYPE1 = '  phi('
                  ELSEIF (I.LE.NP + NQ) THEN
                     J = I - NP
                     CIPHER = 'Moving average'
                     TYPE1 = 'theta('
                  ELSEIF (I.LE.NP + NQ + NPP) THEN
                     J = I - NP - NQ
                     CIPHER = 'Seasonal autoregressive'
                     TYPE1 = '  PHI('
                  ELSE
                     J = I - NP - NQ - NPP
                     CIPHER = 'Seasonal moving average'
                     TYPE1 = 'THETA('
                  ENDIF
                  WRITE (LINE,500) TYPE1, J, PAR(I), SD(I), CIPHER
                  WRITE (NOUT,500) TYPE1, J, PAR(I), SD(I), CIPHER
                  CALL TABLE1 (COLOUR, LINE)
               ENDDO
               CIPHER = 'Constant term'
               TYPE1 = '    C('
               J = 0
               I = NPAR + 1
               WRITE (LINE,500) TYPE1, J, C, SD(I), CIPHER
               WRITE (NOUT,500) TYPE1, J, C, SD(I), CIPHER
               CALL TABLE1 (COLOUR, LINE)
               IF (NF.GT.0) THEN
                  TYPE1 = ' pred('
                  CIPHER = 'Forecast'
                  DO I = 1, NF
                     WRITE (LINE,500) TYPE1, I, FVA(I), FSD(I), CIPHER
                     WRITE (NOUT,500) TYPE1, I, FVA(I), FSD(I), CIPHER
                     CALL TABLE1 (COLOUR, LINE)
                  ENDDO
               ENDIF
               CALL TABLE1 (COLOUR, 'CLOSE')
            ENDIF
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Change ND
C
            I = 0
            IF (ND.GT.NX - 1 .OR. ND.LE.0) ND = 0
            NSAV = ND
            CALL GETJM1 (I, NSAV, NX - 1,
     +     'Order of non-seasonal differencing required (ND)')
            IF (NSAV.NE.ND) THEN
               OK = .FALSE.
               ND = NSAV
            ENDIF
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Change NDS
C
            I = 0
            IF (NDS.GT.NX - 1 .OR. NDS.LT.0) NDS = 0
            NSAV = NDS
            CALL GETJM1 (I, NSAV, NX - 1,
     +     'Order of seasonal differencing required (NDS)')
            IF (NSAV.NE.NDS) THEN
               OK = .FALSE.
               NDS = NSAV
            ENDIF
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Change NS
C
            I = 0
            IF (NS.GT.NX - 1 .OR. NS.LT.0) NS = 0
            NSAV = NS
            CALL GETJM1 (I, NSAV, NX - 1,
     +     'Seasonality required (NS)')
            IF (NSAV.NE.NS) THEN
               OK = .FALSE.
               NS = NSAV
            ENDIF
            IF (NS.EQ.1) THEN
               NS = 0
               CALL PUTADV ('Seasonality requires NS > 1')
            ENDIF
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Change NF
C
            I = 0
            IF (NF.GT.NFVMAX .OR. NF.GT.NX - 1 .OR. NF.LT.0) NF = 0
            NSAV = NF
            CALL GETJM1 (I, NSAV, MIN(NFVMAX,NX - 1),
     +     'No. of forecasts required')
            IF (NSAV.NE.NF) THEN
               OK = .FALSE.
               NF = NSAV
            ENDIF
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Change NP and tolerances
C
            AGAIN = .TRUE.
            DO WHILE (AGAIN)
               IF (IACC.EQ.1) THEN
                  TOLVAL = 'very low'
               ELSEIF (IACC.EQ.2) THEN
                  TOLVAL = 'low'
               ELSEIF (IACC.EQ.3) THEN
                  TOLVAL = 'normal'
               ELSEIF (IACC.EQ.4) THEN
                  TOLVAL = 'medium'
               ELSEIF (IACC.EQ.5) THEN
                  TOLVAL = 'high'
               ELSEIF (IACC.EQ.6) THEN
                  TOLVAL = 'very high'
               ENDIF
               IF (ISTART.EQ.1) THEN
                  STYPE = 'all zero'
               ELSEIF (ISTART.EQ.2) THEN
                  STYPE = 'calculated'
               ELSEIF (ISTART.EQ.3) THEN
                  STYPE = 'input'
               ENDIF
               IF (KPIV.EQ.0) THEN
                  MONIT = 'no'
               ELSE
                  MONIT = 'yes'
               ENDIF
               IF (FILE1) THEN
                  F1TYPE = 'yes'
               ELSE
                  F1TYPE = 'no'
               ENDIF
               IF (TSHOW1) THEN
                  T1TYPE = 'yes'
               ELSE
                  T1TYPE = 'no'
               ENDIF
C
C Menu for parameters and tolerances
C
               WRITE (TEXT,600) NP, NQ, NPP, NQQ, TOLVAL, NIT, STYPE,
     +                          MONIT, T1TYPE, F1TYPE, START, DELTA
               NUMOPT = 13
               NUMDEC = NUMOPT
               CALL LVIEW2 (IX, IY, NUMDEC, NUMOPT, TEXT, TITLES)
               IF (NUMDEC.EQ.1) THEN
                  I = 0
                  J = MIN(NPMAX,NX - 1)
                  NSAV = MIN(NP,J)
                  CALL GETJM1 (I, NSAV, J,
     +'No. of autogressive parameters (phi) required')
                  IF (NSAV.NE.NP) THEN
                     OK = .FALSE.
                     NP = NSAV
                  ENDIF
               ELSEIF (NUMDEC.EQ.2) THEN
                  I = 0
                  J = MIN(NPMAX,NX - 1)
                  NSAV = MIN(NQ,J)
                  CALL GETJM1 (I, NSAV, J,
     +'No. of moving average parameters (theta) required')
                  IF (NSAV.NE.NQ) THEN
                     OK = .FALSE.
                     NQ = NSAV
                  ENDIF
               ELSEIF (NUMDEC.EQ.3) THEN
                  I = 0
                  J = MIN(NPMAX,NX - 1)
                  NSAV = MIN(NPP,J)
                  CALL GETJM1 (I, NSAV, J,
     +'No. of seasonal autogressive parameters (PHI) required')
                  IF (NSAV.NE.NPP) THEN
                     OK = .FALSE.
                     NPP = NSAV
                  ENDIF
               ELSEIF (NUMDEC.EQ.4) THEN
                  I = 0
                  J = MIN(NPMAX,NX - 1)
                  NSAV = MIN(NQQ,J)
                  CALL GETJM1 (I, NSAV, J,
     +'No. of seasonal moving average parameters (THETA) required')
                  IF (NSAV.NE.NQQ) THEN
                     OK = .FALSE.
                     NQQ = NSAV
                  ENDIF
               ELSEIF (NUMDEC.EQ.5) THEN
                  WRITE (TEXT,700)
                  NUMOPT = 6
                  CALL LBOX02 (ICOLOR, IX, IY, IACC, NUMOPT, NUMPOS,
     +                         TEXT)
               ELSEIF (NUMDEC.EQ.6) THEN
                  I = 5
                  J = 250
                  CALL GETJM1 (I, NIT, J, 'max. no. iterations allowed')
               ELSEIF (NUMDEC.EQ.7) THEN
                  WRITE (TEXT,800)
                  NUMOPT = 3
                  CALL LBOX02 (ICOLOR, IX, IY, ISTART, NUMOPT, NUMPOS,
     +                         TEXT)
               ELSEIF (NUMDEC.EQ.8) THEN
                  CALL PUTADV (
     +'Closing the monitoring window disables subsequent monitoring')
                  IF (KPIV.EQ.0) THEN
                     KPIV = 1
                  ELSE
                     KPIV = 0
                  ENDIF
               ELSEIF (NUMDEC.EQ.9) THEN
                  TSHOW1 = .NOT.TSHOW1
               ELSEIF (NUMDEC.EQ.10) THEN
                  FILE1 = .NOT.FILE1
               ELSEIF (NUMDEC.EQ.11) THEN
                  CALL GETD01 (START, 'Starting value for plots')
               ELSEIF (NUMDEC.EQ.12) THEN
                  CALL GETD01 (DELTA, 'Increment value for plots')
                  IF (DELTA.LT.1.0D-07) THEN
                     CALL PUTFAT ('Too small  ...  Re-set to 1')
                     DELTA = ONE
                  ENDIF
               ELSEIF (NUMDEC.EQ.NUMOPT) THEN
                  AGAIN = .FALSE.
               ENDIF
            ENDDO
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Plot time series
C
            L1 = 1
            N1 = NX
            M1 = 0
            W(1) = START
            DO I = 2, NX
               W(I) = W(I - 1) + DELTA
            ENDDO
            XTITLE = 'Time'
            YTITLE = 'Values'
            IF (NF.GT.0) THEN
               L2 = 1
               M2 = 1
               N2 = NF
               DOF = DBLE(ICOUNT(5))
               IFAIL = 0
               TVAL = G01FBF$(TAIL, PROB, DOF, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01FBF/TIME02')
               FTIME(1) = W(NX) + DELTA
               DO I = 2, NF
                  FTIME(I) = FTIME(I - 1) + DELTA
               ENDDO
               DO I = 1, NF
                  FABOVE(I) = FVA(I) + TVAL*FSD(I)
                  FBELOW(I) = FVA(I) - TVAL*FSD(I)
               ENDDO
               PTITLE = 'Predictions with 95% con. lims.'
            ELSE
               L2 = 0
               M2 = 0
               N2 = 0
               PTITLE = 'Time Series'
            ENDIF
            CALL GKS004 (L1, L2, L2, L2, M1, M2, M2, M2, N1, N2, N2, N2,
     +                   W, FTIME, FTIME, FTIME,
     +                   X, FABOVE, FVA, FBELOW,
     +                   PTITLE, XTITLE, YTITLE,
     +                   AXES, GSAVE)
         ELSEIF (NUMDEC.EQ.9) THEN
C
C Plot residuals
C
            L1 = 0
            L2 = 0
            M1 = 4
            M2 = 0
            N1 = ICOUNT(2)
            N2 = 0
            W(1) = START
            DO I = 2, NX
               W(I) = W(I - 1) + DELTA
            ENDDO
            PTITLE = 'Differenced ARIMA Residuals'
            XTITLE = 'Time'
            YTITLE = 'Residuals'
            I = ICOUNT(1) + 1
            CALL GKS004 (L1, L2, L2, L2, M1, M2, M2, M2, N1, N2, N2, N2,
     +                   W, FTIME, FTIME, FTIME,
     +                   EXR(I), FABOVE, FVA, FBELOW,
     +                   PTITLE, XTITLE, YTITLE,
     +                   AXES, GSAVE)
         ELSEIF (NUMDEC.EQ.10) THEN
C
C Plot best fit: Note that AL is re-defined
C
            L1 = 0
            L2 = 1
            M1 = 1
            M2 = 0
            N1 = ICOUNT(2)
            N2 = 0
            W(1) = START
            DO I = 2, N1
               W(I) = W(I - 1) + DELTA
            ENDDO
            DO I = ICOUNT(1) + 1, ICOUNT(1) + ICOUNT(2)
               AL(I) = EX(I) + EXR(I)
            ENDDO
            PTITLE = 'Differenced Series (.) & ARIMA-fit'
            XTITLE = 'Time'
            YTITLE = 'Fit'
            I = ICOUNT(1) + 1
            CALL GKS004 (L1, L2, L2, L2, M1, M2, M2, M2, N1, N1, N2, N2,
     +                   W, W, FTIME, FTIME,
     +                   EX(I), AL(I), FVA, FBELOW,
     +                   PTITLE, XTITLE, YTITLE,
     +                   AXES, GSAVE)
         ELSEIF (NUMDEC.EQ.11) THEN
C
C Analyse residuals: Note that AL is re-defined
C
            DO I = ICOUNT(1) + 1, ICOUNT(1) + ICOUNT(2)
               AL(I) = EX(I) + EXR(I)
            ENDDO
            I = ICOUNT(1) + 1
            CALL TIME03 (NOUT, NPAR, ICOUNT(2), EXR(I), AL(I), EX(I),
     +                   FILE1, FILE2, TSHOW1, TSHOW2)
         ELSEIF (NUMDEC.EQ.12) THEN
C
C Help
C
            WRITE (TEXT,900)
            NTEXT = 22
            NUMBLD(1) = 1
            NEXT = .TRUE.
            CALL TUTOR1 (ICOLOR, NUMBLD, NTEXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            NUMBLD(1) = 0
            WRITE (TEXT,1000)
            NTEXT = 22
            NUMBLD(1) = 1
            NUMBLD(22) = 1
            NEXT = .FALSE.
            CALL TUTOR1 (ICOLOR, NUMBLD, NTEXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            NUMBLD(1) = 0
            NUMBLD(22) = 0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Title for current time series data is:-'
     +/A
     +/'Current sample size (NX) =',I5
     +/'Size after differencing (NXD) =',I5
     +/'Non-seasonal differencing order (ND) =',I5
     +/'Seasonal differencing order (NDS) =',I5
     +/'Assigned seasonality (NS) =',I5
     +/'No. of forecasts requested (NF) =',I5
     +/'Parameters and tolerance requested =',I5,':',4I3,2X,A
     +/'Input new data'
     +/'Fit an ARIMA model'
     +/'Change ND (non-seasonal differencing)'
     +/'Change NDS (seasonal differencing)'
     +/'Change NS (seasonality)'
     +/'Change NF (no. of forecasts)'
     +/'Configure parameters and settings'
     +/'Plot undifferenced series and forecasts'
     +/'Plot differenced ARIMA residuals'
     +/'Plot differenced series and ARIMA fit'
     +/'Analyse differenced residuals'
     +/'Help'
     +/'Quit ... Exit time series analysis')
  200 FORMAT ('Starting value for parameter',I3)
  300 FORMAT (
     + '...'
     +/'Current data title is:-'
     +/A
     +/'Original dimension (NX)  =',I6
     +/'After differencing (NXD) =',I6
     +/'Non-seasonal order (ND)  =',I6
     +/'Seasonal order (NDS)     =',I6
     +/'Seasonality (NS)         =',I6
     +/'No. of forecasts (NF)    =',I6
     +/'No. of parameters (NP)   =',I6
     +/'No. of iterations (ITC)  =',I6
     +/'Sum of squares (SSQ)     =',   E11.3)
  400 FORMAT ('  Parameter     Value       Std. err.     Type')
  500 FORMAT (1X,A6,I3,')',1P,2E13.5,2X,A)
  600 FORMAT (
     + 'Parameters, controls and tolerances `Comment'
     +/'Autoregressive phi(i)               `',I4
     +/'Moving average theta(i)             `',I4
     +/'Seasonal autoregressive PHI(i)      `',I4
     +/'Seasonal moving average THETA(i)    `',I4
     +/'Convergence criteria                `',A
     +/'Max. no. of iterations              `',I4
     +/'Starting estimates method           `',A
     +/'Monitor convergence                 `',A
     +/'Display table of residuals          `',A
     +/'Write residuals to log files        `',A
     +/'Series start value for plotting     `',1P,E11.3
     +/'Series increment for plotting       `',   E11.3
     +/'Quit                                `Exit')
  700 FORMAT (
     + '1.0E-02'
     +/'1.0E-03'
     +/'1.0E-04'
     +/'1.0E-05'
     +/'1.0E-06'
     +/'1.0E-07')
  800 FORMAT (
     + 'All zero'
     +/'Estimated'
     +/'User inputs')
  900 FORMAT (
     + 'Fitting autoregressive integrated moving average models'
     +/
     +/'The classic definitions are used (see Box G.P.E. and Jenkins'
     +/'G.M. Time Series Analysis, Holden Day 1976) but users should'
     +/'realise that ARIMA does not give unique parameter estimates;'
     +/'it is a nonlinear regression procedure that depends critically'
     +/'on the choice of model, orders of differencing, inclusion of'
     +/'a constant, convergence criteria, etc. So, before attempting'
     +/'to fit, you should use the SIMFIT Time Series Analysis routines'
     +/'to explore the autocorrelation structure in your data and note'
     +/'as follows.'
     +/'1) `Fitting can fail if too high an accuracy is requested, too'
     +/'   `few iterations are used, unsuitable starting estimates are'
     +/'   `employed, too many parameters are used or an inappropriate'
     +/'   `model is fitted.'
     +/'2) `Only use the minimum numbers of parameters and be careful'
     +/'   `not to request any unjustified parameters.'
     +/'3) `The procedure will return error messages if there are any'
     +/'   `inconsistencies between the differencing settings and the'
     +/'   `model parameters so be careful when choosing the model.'
     +/'4) `Only change the default methods and convergence criteria'
     +/'   `if you know what you are doing.')
 1000 FORMAT (
     + 'Definitions for ARIMA time series fitting'
     +/
     +/'The procedure assumes you have a sample of values measured'
     +/'at equal increments of time (or space, etc.) and wish to'
     +/'fit the data after exploring possible autocorrelations.'
     +/'X      `vector of data with no missing values'
     +/'NX     `dimension of X'
     +/'XD     `transformed vector from X by differencing'
     +/'NXD    `dimension of XD (i.e. NXD = NX - ND - NS*NDS)'
     +/'ND     `order of non-seasonal differencing'
     +/'NDS    `order of seasonal differencing'
     +/'NS     `seasonality of seasonal differencing'
     +/'NF     `number of forecasts requested'
     +/'NP     `number of parameters requested'
     +/'phi    `autogressive parameters'
     +/'theta  `moving average parameters'
     +/'PHI    `seasonal autogregressive parameters'
     +/'THETA  `seasonal moving average parameters'
     +/'C      `constant term'
     +/'SSQ    `sum of squares'
     +/'ITC    `no. of iterations performed'
     +/'Note: if ND = NDS = NS = 0, the original sample X is analysed.')
      END
C
C
