C
C
      SUBROUTINE TIME03 (NOUT, NPAR, NPTS,
     +                   RESID, THEORY, Y,
     +                   FILE1, FILE2, TSHOW1, TSHOW2)
C
C ACTION : Analyse residuals for time series
C AUTHOR : W. G. Bardsley, University of Manchester, U.K
C ADVICE : Derived from GKSR01 07/07/2001
C          27/09/2002 replaced patch1 by table1
C          21/08/2004 added -nlog(n) to AIC and SC
C          24/08/2004 deleted /TWO from SC formula
C          05/05/2009 changed TABLE1 to TABLE5 and added INTENTS 
C          18/10/2021 added E_NUMBERS and E_FORMATS, etc.
C
C          The criteria for qualitative decision have been relaxed
C          for goodness of fit to time series
C          NOUT = Unit for output of tables to main data file
C          FILE1 = .TRUE. then write residuals table to a file (NOUT)
C          FILE2 = .TRUE. then write analysis details to a file (NOUT)
C          TSHOW1 = .TRUE. then display residuals table
C          TSHOW2 = .TRUE. then display analysis table
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT, NPAR, NPTS
      DOUBLE PRECISION, INTENT (IN) :: RESID(NPTS), THEORY(NPTS),
     +                                 Y(NPTS)
      LOGICAL,          INTENT (IN) :: FILE1, FILE2, TSHOW1, TSHOW2
C
C Locals
C      
      INTEGER    NUMHDR
      PARAMETER (NUMHDR = 23)
      INTEGER    KCOLOR, KAT, LAT, MAT, NAT
      PARAMETER (KCOLOR = 15, KAT = 0, LAT = 4, MAT = 1, NAT = 4)
      INTEGER    COLOUR
      INTEGER    I, NSCORE
      INTEGER    NNEG, NPOS, NRUN, NR1, NR5
      DOUBLE PRECISION TOL1, TOL2, TOL3
      PARAMETER (TOL1 = 1.0D+35, TOL2 = 1.0D-06, TOL3 = 1.0D-10)
      DOUBLE PRECISION PNT01, PNT05
      PARAMETER  (PNT01 = 0.01D+00, PNT05 = 0.05D+00)
      DOUBLE PRECISION CENT, ONE, TWO, ZERO
      PARAMETER (CENT = 100.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           ZERO = 0.0D+00)
      DOUBLE PRECISION AVRR, DW, PROBR, PROBS, PROBT, RBIG, RSMALL
      DOUBLE PRECISION PGCHI, RTOL, SSQ, WSSQ, X02AMF$
      DOUBLE PRECISION PC1, PC2, PC3, PC4, R, TMAX, TMIN, YABS
      DOUBLE PRECISION AIC, DNPTS, DNPAR, P, SC, W
      CHARACTER (LEN = 13) D13(3), SHOWLJ, SHOWRJ 
      CHARACTER (LEN = 12) I12(5), FORM12 
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  REJECT*10, SLEVEL*12
      PARAMETER (REJECT = 'Reject at ', SLEVEL = '% sig. level')
      CHARACTER  CIPHER*6, LINE1*29, LINE2*29, SYMBOL(3)*23, VERDIC*10
      CHARACTER  HDR1*100, HDR2(2)*100, HDR20(20)*100, HDR23(23)*100
      CHARACTER  LINE*100, PTITLE*40
      CHARACTER  MSSAGE*16
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    STARS
      LOGICAL    ACCEPT
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ, SHOWRJ
      EXTERNAL   CORCOF, PROBRS, TABLE1, GKSR03, TABLE5
      EXTERNAL   X02AMF$
      INTRINSIC  ABS, MAX, SQRT, DBLE, LOG
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      RTOL = 1.0D+09*X02AMF$()
      DNPTS = DBLE(NPTS)
      DNPAR = DBLE(NPAR)
C
C Initialise counters then calculate YABS, and assign CIPHER
C
      AVRR = ZERO
      PC1 = ZERO
      PC2 = ZERO
      PC3 = ZERO
      PC4 = ZERO
      RBIG = ZERO
      RSMALL = TOL1
      TMAX = THEORY(1)
      TMIN = TMAX
      YABS = ZERO
      STARS = .FALSE.
      IF (FILE1) THEN
         WRITE (NOUT,'(A)') BLANK
         WRITE (NOUT,200)
      ENDIF
      IF (TSHOW1) THEN
         CALL TABLE5 (KCOLOR, 'OPEN')
         WRITE (LINE,200)
         CALL TABLE5 (LAT, LINE)
      ENDIF
C
C Main loop to set up residuals and counters
C
      DO I = 1, NPTS
         IF (THEORY(I).GT.TMAX) TMAX = THEORY(I)
         IF (THEORY(I).LT.TMIN) TMIN = THEORY(I)
         YABS = YABS + ABS(Y(I))
         WSSQ = ABS(RESID(I)/MAX(TOL2,(ABS(Y(I)) + ABS(THEORY(I)))/TWO))
         AVRR = AVRR + WSSQ
         IF (WSSQ.GT.RBIG) RBIG = WSSQ
         IF (WSSQ.LT.RSMALL) RSMALL = WSSQ
         IF (WSSQ.GT.3.2D+00) THEN
            COLOUR = NAT
            PC4 = PC4 + ONE
            CIPHER = '******'
            STARS = .TRUE.
         ELSEIF (WSSQ.GT.1.6D+00) THEN
            COLOUR = NAT
            PC4 = PC4 + ONE
            CIPHER = '*****'
            STARS = .TRUE.
         ELSEIF (WSSQ.GT.0.8D+00) THEN
            COLOUR = MAT
            PC3 = PC3 + ONE
            CIPHER = '****'
            STARS = .TRUE.
         ELSEIF (WSSQ.GT.0.4D+00) THEN
            COLOUR = MAT
            PC2 = PC2 + ONE
            CIPHER = '***'
            STARS = .TRUE.
         ELSEIF (WSSQ.GT.0.2D+00) THEN
            COLOUR = KAT
            PC1 = PC1 + ONE
            CIPHER = '**'
            STARS = .TRUE.
         ELSEIF (WSSQ.GT.0.1D+00) THEN
            COLOUR = KAT
            CIPHER = '*'
            STARS = .TRUE.
         ELSE
            COLOUR = KAT
            CIPHER = BLANK
         ENDIF
C
C Display or Display/File Residuals
C         
         IF (E_NUMBERS) THEN
            IF (FILE1) WRITE (NOUT,400) I, Y(I), THEORY(I), RESID(I),
     +                                  CIPHER
            IF (TSHOW1) THEN
                WRITE (LINE,400) I, Y(I), THEORY(I), RESID(I),
     +                           CIPHER
               CALL TABLE5 (COLOUR, LINE)
            ENDIF
         ELSE
            D13(1) = SHOWRJ(Y(I))
            D13(2) = SHOWRJ(THEORY(I))
            D13(3) = SHOWRJ(RESID(I))
            IF (FILE1) WRITE (NOUT,450) I, D13(1), D13(2), D13(3),
     +                                  CIPHER
            IF (TSHOW1) THEN
                WRITE (LINE,450) I, D13(1), D13(2), D13(3),
     +                           CIPHER
               CALL TABLE5 (COLOUR, LINE)
            ENDIF
         ENDIF  
      ENDDO
C
C End of loop. Write warning if required.
C
      IF (STARS) THEN
         IF (FILE1) WRITE (NOUT,500)
         IF (TSHOW1) THEN
            WRITE (LINE,500)
            CALL TABLE5 (LAT, LINE)
         ENDIF
      ENDIF
      IF (TSHOW1) CALL TABLE5 (KCOLOR, 'CLOSE')
C
C Transform all counters
C
      AVRR = CENT*AVRR/DNPTS
      RBIG = CENT*RBIG
      RSMALL = CENT*RSMALL
      YABS = YABS/DNPTS
      PC1 = CENT*PC1/DNPTS
      PC2 = CENT*PC2/DNPTS
      PC3 = CENT*PC3/DNPTS
      PC4 = CENT*PC4/DNPTS
C
C Work out DW, SSQ, WSSQ then AIC and SC and R-squared
C
      DW = ZERO
      SSQ = RESID(1)**2
      DO I = 2, NPTS
         DW = DW + (RESID(I) - RESID(I - 1))**2
         SSQ = SSQ + RESID(I)**2
      ENDDO
      WSSQ = SSQ
      DW = DW/MAX(SSQ, TOL3**2)
      IF (DW.LT.1.5D+00) THEN
         PTITLE = '<1.5, +ve serial correlation?'
      ELSEIF (DW.LT.2.5D+00) THEN
         PTITLE = BLANK
      ELSE
         PTITLE = '>2.5, -ve serial correlation?'
      ENDIF
      AIC = DNPTS*LOG(MAX(RTOL,WSSQ/DNPTS)) + TWO*DNPAR
      SC = DNPTS*LOG(MAX(RTOL,WSSQ/DNPTS)) + DNPAR*LOG(DNPTS)
      CALL CORCOF (NPTS, R, Y, THEORY)
      I = NPTS - NPAR
      IF (I.GT.0 .AND. YABS.GT.TOL3) THEN
         PGCHI = 100.0D+00*SQRT(WSSQ/DBLE(I))/YABS
      ELSE
         PGCHI = 100.0D+00
      ENDIF
      LINE1 = 'Analysis of residuals:    SSQ'
      LINE2 = 'Est. average % coeff.var.    '
      SYMBOL(1) = BLANK
C
C Run and sign tests then work out the verdict
C
      IF (FILE2 .OR. TSHOW2) THEN
         I = 1
         CALL PROBRS (I, NOUT, NNEG, NPOS, NPTS, NRUN, NR1, NR5,
     +                PROBR, PROBS, PROBT, RESID)
         IF (PROBR.GT.PNT05) THEN
            SYMBOL(2) = BLANK
         ELSEIF (PROBR.GT.PNT01) THEN
            SYMBOL(2) = REJECT//'5'//SLEVEL
         ELSE
            SYMBOL(2) = REJECT//'1'//SLEVEL
         ENDIF
         IF (PROBS.GT.PNT05) THEN
            SYMBOL(3) = BLANK
         ELSEIF (PROBS.GT.PNT01) THEN
            SYMBOL(3) = REJECT//'5'//SLEVEL
         ELSE
            SYMBOL(3) = REJECT//'1'//SLEVEL
         ENDIF
         NSCORE = 0
         IF (PGCHI.LT.40.0D+00) NSCORE = NSCORE + 1
         IF (PGCHI.LT.80.0D+00) NSCORE = NSCORE + 1
         IF (PROBR.GT.PNT01) NSCORE = NSCORE + 1
         IF (PROBR.GT.PNT05) NSCORE = NSCORE + 2
         IF (AVRR.LT.10.0D+00) NSCORE = NSCORE + 1
         IF (AVRR.LT.20.0D+00) NSCORE = NSCORE + 1
         IF (AVRR.LT.40.0D+00) NSCORE = NSCORE + 1
         IF (RBIG.LT.80.0D+00) NSCORE = NSCORE + 1
         IF (RSMALL.LT.5.0D+00) NSCORE = NSCORE + 1
         IF (PC3+PC4.LT.20.0D+00) NSCORE = NSCORE + 1
         IF (PC1+PC2+PC3+PC4.LT.50.0D+00) NSCORE = NSCORE + 1
         CALL GKSR03 (NOUT, NPTS, P, RESID, W, MSSAGE, ACCEPT)
         IF (ACCEPT) THEN
            NSCORE = NSCORE + 2
         ENDIF
         IF (NSCORE.EQ.0) THEN
            VERDIC = 'terrible'
         ELSEIF (NSCORE.EQ.1) THEN
            VERDIC = 'very bad'
         ELSEIF (NSCORE.EQ.2) THEN
            VERDIC = 'bad'
         ELSEIF (NSCORE.EQ.3) THEN
            VERDIC = 'very poor'
         ELSEIF (NSCORE.EQ.4) THEN
            VERDIC = 'poor'
         ELSEIF (NSCORE.EQ.5) THEN
            VERDIC = 'fair'
         ELSEIF (NSCORE.EQ.6) THEN
            VERDIC = 'reasonable'
         ELSEIF (NSCORE.EQ.7) THEN
            VERDIC = 'quite good'
         ELSEIF (NSCORE.EQ.8) THEN
            VERDIC = 'good'
         ELSEIF (NSCORE.EQ.9) THEN
            VERDIC = 'very good'
         ELSEIF (NSCORE.EQ.10) THEN
            VERDIC = 'excellent'
         ELSEIF (NSCORE.EQ.11) THEN
            VERDIC = 'fantastic'
         ELSE
            VERDIC = 'incredible'
         ENDIF
      ENDIF
C
C File GOFFIT if required
C      
      IF (FILE2) THEN
         WRITE (NOUT,600)
         IF (E_NUMBERS) THEN
            WRITE (NOUT,800) LINE1, WSSQ, LINE2, PGCHI, SYMBOL(1)
         ELSE
            D13(1) = SHOWLJ(WSSQ)
            WRITE (NOUT,850) LINE1, D13(1), LINE2, PGCHI, SYMBOL(1) 
         ENDIF  
         IF (E_NUMBERS) THEN
            WRITE (NOUT,900) R**2, RBIG, RSMALL, AVRR,
     +                       PC1, PC2, PC3, PC4, NNEG,
     +                       NPOS, NRUN, PROBR, SYMBOL(2), NR5, NR1,
     +                       PROBT, PROBS, SYMBOL(3), DW, PTITLE,
     +                       W, P, MSSAGE, AIC, SC
         ELSE
            D13(1) = SHOWLJ(AIC)
            D13(2) = SHOWLJ(SC)
            I12(1) = FORM12(NNEG)
            I12(2) = FORM12(NPOS)
            I12(3) = FORM12(NRUN)
            I12(4) = FORM12(NR5)
            I12(5) = FORM12(NR1)
            WRITE (NOUT,950) R**2, RBIG, RSMALL, AVRR,
     +                       PC1, PC2, PC3, PC4, I12(1), I12(2),
     +                       I12(3), PROBR, SYMBOL(2), I12(4), I12(5),
     +                       PROBT, PROBS, SYMBOL(3), DW, PTITLE,
     +                       W, P, MSSAGE, TRIM(D13(1)), TRIM(D13(2))
         ENDIF  
         WRITE (NOUT,1000) VERDIC
      ENDIF
C
C Display GOFFIT if required
C      
      IF (TSHOW2) THEN
         IF (E_NUMBERS) THEN
            WRITE (HDR2,800) LINE1, WSSQ, LINE2, PGCHI, SYMBOL(1)
         ELSE
            D13(1) = SHOWLJ(WSSQ) 
            WRITE (HDR2,850) LINE1, D13(1), LINE2, PGCHI, SYMBOL(1)   
         ENDIF
         IF (E_NUMBERS) THEN  
            WRITE (HDR20,900) R**2, RBIG, RSMALL, AVRR,
     +                        PC1, PC2, PC3, PC4, NNEG,
     +                        NPOS, NRUN, PROBR, SYMBOL(2), NR5, NR1,
     +                        PROBT, PROBS, SYMBOL(3), DW, PTITLE,
     +                        W, P, MSSAGE, AIC, SC
         ELSE
            D13(1) = SHOWLJ(AIC)
            D13(2) = SHOWLJ(SC)
            I12(1) = FORM12(NNEG)
            I12(2) = FORM12(NPOS)
            I12(3) = FORM12(NRUN)
            I12(4) = FORM12(NR5)
            I12(5) = FORM12(NR1)
            WRITE (HDR20,950) R**2, RBIG, RSMALL, AVRR,
     +                       PC1, PC2, PC3, PC4, I12(1), I12(2),
     +                       I12(3), PROBR, SYMBOL(2), I12(4), I12(5),
     +                       PROBT, PROBS, SYMBOL(3), DW, PTITLE,
     +                       W, P, MSSAGE, TRIM(D13(1)), TRIM(D13(2)) 
         ENDIF 
         HDR23(1) = HDR2(1)
         HDR23(2) = HDR2(2)
         DO I = 1, 20
            HDR23(I + 2) = HDR20(I)
         ENDDO
         WRITE (HDR1,1000) VERDIC
         HDR23(23) = HDR1
         CALL TABLE1 (KCOLOR, 'OPEN')
         DO I = 1, NUMHDR - 1
            CALL TABLE1 (KAT, HDR23(I))
         ENDDO
         CALL TABLE1 (LAT, HDR23(NUMHDR))
         CALL TABLE1 (KAT, 'CLOSE')
      ENDIF
C
C Format statements
C      
  200 FORMAT (1X,'Number   Observation        Theory     Residuals')
  400 FORMAT (I7,1P,3(1X,E13.5),A)
  450 FORMAT (I7,3(1X,A13),A)
  500 FORMAT (2X,
     +'Abs.rel.res.',1X,'****** >320%,***** >160%,**** >80%,*** >40%,',
     +'** >20%,* >10%')
  600 FORMAT (
     +/'Goodness of Fit'
     +/'===============')
  800 FORMAT (A29,5X,'=',1P,E10.3
     +/A29,5X,'=',0P,F10.4,4X,A)
  850 FORMAT (A29,5X,'=',1X,A13
     +/A29,5X,'=',F10.4,4X,A)   
  900 FORMAT (
     + 'R-squared, cc(theory,data)^2      =',F7.4
     +/'Largest  Abs.rel.res.             =',F8.2,1X,'%'
     +/'Smallest Abs.rel.res.             =',F8.2,1X,'%'
     +/'Average  Abs.rel.res.             =',F8.2,1X,'%'
     +/'Abs.rel.res. in range 20-40 %     =',F8.2,1X,'%'
     +/'Abs.rel.res. in range 40-80 %     =',F8.2,1X,'%'
     +/'Abs.rel.res. in range 80-160%     =',F8.2,1X,'%'
     +/'Abs.rel.res.           > 160%     =',F8.2,1X,'%'
     +/'Number of residuals < 0 (m)       =',I6
     +/'Number of residuals > 0 (n)       =',I6
     +/'Number of runs observed (r)       =',I6
     +/'P = P(runs =< r : given m and n)  =',F7.4,8X,A
     +/'5% lower tail point               =',I6
     +/'1% lower tail point               =',I6
     +/'p = P(runs =< r : given m plus n) =',F7.4
     +/'p = P(signs =<least no. observed) =',F7.4,8X,A
     +/'Durbin-Watson test statistic      =',F7.4,2X,A
     +/'Shapiro-Wilks W (wtd. res.)       =',F7.4
     +/'Significance level of W           =',F7.4,2X,A
     +/'Akaike AIC (Schwarz SC) stats     =',1P,E10.3,' (',E10.3,')')
  950 FORMAT (
     + 'R-squared, cc(theory,data)^2      =',F7.4
     +/'Largest  Abs.rel.res.             =',F8.2,1X,'%'
     +/'Smallest Abs.rel.res.             =',F8.2,1X,'%'
     +/'Average  Abs.rel.res.             =',F8.2,1X,'%'
     +/'Abs.rel.res. in range 20-40 %     =',F8.2,1X,'%'
     +/'Abs.rel.res. in range 40-80 %     =',F8.2,1X,'%'
     +/'Abs.rel.res. in range 80-160%     =',F8.2,1X,'%'
     +/'Abs.rel.res.           > 160%     =',F8.2,1X,'%'
     +/'Number of residuals < 0 (m)       =',1X,A
     +/'Number of residuals > 0 (n)       =',1X,A
     +/'Number of runs observed (r)       =',1X,A
     +/'P = P(runs =< r : given m and n)  =',F7.4,8X,A
     +/'5% lower tail point               =',1X,A
     +/'1% lower tail point               =',1X,A
     +/'p = P(runs =< r : given m plus n) =',F7.4
     +/'p = P(signs =<least no. observed) =',F7.4,8X,A
     +/'Durbin-Watson test statistic      =',F7.4,2X,A
     +/'Shapiro-Wilks W (wtd. res.)       =',F7.4
     +/'Significance level of W           =',F7.4,2X,A
     +/'Akaike AIC (Schwarz SC) stats     =',1X,A,' (',A,')')
 1000 FORMAT ('Verdict on goodness of fit:',1X,A)
      END
C
C
