C
C
      SUBROUTINE TIME04 (NIN, NOUT, NRMAX,
     +                   V, W, X, Y, Z)
C
C ACTION : Time series smoothing
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 20/0/2002
C          11/05/2010 introduced NKLCFG to switch on/off the test file advice 
C          30/04/2011 introduced call to TFILEQ 
C
C          NIN = input unit
C          NOUT = output unit
C          NRMAX = maximum dimension
C          V = workspace for primary time
C          W = workspace fro secondary time (after smoothing)
C          X = time series data
C          Y = smooth
C          Z = rough
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    NIN, NOUT, NRMAX
      DOUBLE PRECISION V(NRMAX), W(NRMAX), X(NRMAX), Y(NRMAX),
     +                 Z(NRMAX)
C
C Locals
C      
      INTEGER    COLOUR, I, J, NBEGIN, NDIFF, NSTART, NTOTAL, NTYPE, NX
      INTEGER    NOUT1, NPAR, NPTS
      INTEGER    KVAL9, NKLCFG
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, KSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, KSTART = 7)
      INTEGER    N0, N1, N2, N21, NTMAX
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N21 = 21, NTMAX = 5)
      INTEGER    NUMBLD(30), NUMPOS(20)
      INTEGER    ISEND
      DOUBLE PRECISION X2(2), X3(2), X4(2), Y2(2), Y3(2), Y4(2)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      LOGICAL    FIXNPT, LABEL, REPEET
      PARAMETER (FIXNPT = .FALSE., LABEL = .TRUE.)
      CHARACTER  FNAME*1024, TITLE*80
      CHARACTER  CHOP80*80, LINE*100, TEXT(30)*100, WORD80*80
      CHARACTER  PTITLE*40, TYPE1(NTMAX)*40, XTITLE*40, YTITLE*40
      LOGICAL    ABORT, OK, READY
      LOGICAL    FIXED, FLASH, HIGH
      PARAMETER (FIXED = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    AXES, BORDER, GSAVE, FILE1, FILE2, TSHOW1, TSHOW2
      PARAMETER (AXES = .TRUE., BORDER = .FALSE., GSAVE = .TRUE.)
      LOGICAL    QTEXT, QTITLE
      PARAMETER (QTEXT = .TRUE., QTITLE = .TRUE.)
      EXTERNAL   VEC1IN, LBOX01, TABLE1, CHOP80, PUTFAT, LBOX02,
     +           PATCH1, TIME03, TIME05, GKS004, GETNOU, VECOUT,
     +           GETJ01, GETJGE, HNPLOT
      EXTERNAL   NKLCFG, TFILEQ
      SAVE       NDIFF, NSTART, NTYPE
      DATA       NDIFF, NSTART, NTYPE / 1, 1, 5 /
      DATA       TYPE1 / 'Running median span 4 then 2',
     +                   'Running median span 5',
     +                   'Running median span 3',
     +                   'Moving average span 3 Hanning',
     +                   '4253H twice smoother' /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
C
C Initialise
C
      NX = 0
      NUMDEC = 11
      OK = .FALSE.
      READY = .FALSE.
C
C Main loop to analyse X
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NUMDEC.LT.0) NUMDEC = - NUMDEC
         IF (READY) THEN
            IF (.NOT.OK) NUMDEC = 2
            WORD80 = CHOP80(TITLE)
         ELSE
            WORD80 = 'No current data'
            NUMDEC = 1
         ENDIF
         WRITE (TEXT,100) WORD80, NX, NSTART, NDIFF, TYPE1(NTYPE)
         NTEXT = 20
         NUMOPT = 14
         NUMBLD(2) = 1

         IF (NUMDEC.LT.1) THEN
            NUMDEC = 1
         ELSEIF (NUMDEC.GT.NUMOPT) THEN
            NUMDEC = NUMOPT
         ENDIF
                  
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, KSTART, NTEXT,
     +                TEXT,
     +                FIXED, FLASH, HIGH)
         NUMBLD(2) = 0
C
C Check for current data
C
         IF (.NOT.READY) THEN
            IF (NUMDEC.EQ.2 .OR. (NUMDEC.GE.6 .AND. NUMDEC.LE.12)) THEN
               NUMDEC = -1
               CALL PUTFAT ('First input some time series data')
            ENDIF
         ENDIF
C
C Check for current analysis
C
         IF (.NOT.OK) THEN
            IF (NUMDEC.GE.6 .AND. NUMDEC.LE.12) THEN
               NUMDEC = -2
               CALL PUTFAT ('First analyse current time series data')
            ENDIF
         ENDIF
         IF (NUMDEC.EQ.1) THEN
C
C New data
C
            NX = 0
            READY = .FALSE.
            OK = .FALSE.
            KVAL9 = NKLCFG(N21)
            IF (KVAL9.EQ.N1) CALL TFILEQ (
     +'Now input a time series vector type file like times.tf1')
            ISEND = 3
            CLOSE (UNIT = NIN)
            CALL VEC1IN (ISEND, NIN, NRMAX, NX, X, FNAME, TITLE,
     +                   ABORT, FIXNPT, LABEL)
            CLOSE (UNIT = NIN)
            IF (ABORT) THEN
               NX = 0
               READY = .FALSE.
            ELSE
               IF (NX.LT.5) THEN
                  CALL PUTFAT ('Sample size too small (< 5)')
                  NX = 0
                  READY = .FALSE.
               ELSE
                  READY = .TRUE.
                  NUMDEC = 2
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Calculate after copying X into V since V may be altered by TIME05
C
            IF (READY) THEN
               DO I = N1, NX
                  V(I) = X(I)
               ENDDO
               CALL TIME05 (NTYPE, NX, NBEGIN, NTOTAL, V, Y, Z)
               OK = .TRUE.
               NUMDEC = 8
            ENDIF
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Change NSTART
C
            CALL GETJ01 (NSTART,
     +     'First time value required for plotting')
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Change NDIFF
C
            CALL GETJGE (NDIFF, N1,
     +     'Time increments required for plotting')
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Change TYPE
C
            J = NTYPE
            NUMOPT = NTMAX
            DO I = N1, NTMAX
               TEXT(I) = TYPE1(I)
            ENDDO
            CALL LBOX02 (ICOLOR, IX, IY, J, NUMOPT, NUMPOS, TEXT)
            IF (J.NE.NTYPE) THEN
                NTYPE = J
                OK = .FALSE.
                NUMDEC = 2
            ELSE
               NUMDEC = 1
            ENDIF
         ELSEIF (NUMDEC.EQ.6 .OR. NUMDEC.EQ.7) THEN
C
C Table (and file if requested)
C
            V(N1) = NSTART
            DO I = N2, NX
               V(I) = V(I - N1) + NDIFF
            ENDDO
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            COLOUR = 4
            CALL TABLE1 (COLOUR, WORD80)
            CALL TABLE1 (COLOUR, TYPE1(NTYPE))
            WRITE (LINE,200)
            CALL TABLE1 (COLOUR, LINE)
            COLOUR = 0
            IF (NUMDEC.EQ.6) THEN
               WRITE (NOUT,'(A)') ' '
               WRITE (NOUT,'(A)') 'Data smoothing:'
               WRITE (NOUT,'(A)') WORD80
               WRITE (NOUT,'(A)') TYPE1(NTYPE)
               WRITE (NOUT,'(A)') LINE
            ENDIF
            J = NBEGIN + NTOTAL - N1
            DO I = N1, NX
               IF (I.LT.NBEGIN .OR. I.GT.J) THEN
                  WRITE (LINE,300) V(I), X(I)
               ELSE
                  WRITE (LINE,400) V(I), X(I), Y(I), Z(I)
               ENDIF
               CALL TABLE1 (COLOUR, LINE)
               IF (NUMDEC.EQ.6) WRITE (NOUT,'(A)') LINE
            ENDDO
            CALL TABLE1 (COLOUR, 'CLOSE')
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Plot smooth
C
           V(N1) = NSTART
           DO I = N2, NX
              V(I) = V(I - N1) + NDIFF
           ENDDO
           DO I = N1, NX
             W(I) = V(I)
           ENDDO
           DO I = N1, N2
              X3(I) = ZERO
              X4(I) = ZERO
              Y3(I) = ZERO
              Y4(I) = ZERO
           ENDDO
           PTITLE = TYPE1(NTYPE)
           XTITLE = 'Time'
           YTITLE = 'Data and Smooth'
           CALL GKS004 (N1, N2, N0, N0, N1, N0, N0, N0,
     +                  NX, NTOTAL, N0, N0,
     +                  V, W(NBEGIN), X3, X4,
     +                  X, Y(NBEGIN), Y3, Y4,
     +                  PTITLE, XTITLE, YTITLE,
     +                  AXES, GSAVE)
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.9) THEN
C
C Plot rough
C
           V(N1) = NSTART
           DO I = N2, NX
              V(I) = V(I - N1) + NDIFF
           ENDDO
           DO I = N1, N2
              X2(I) = ZERO
              Y2(I) = ZERO
              X3(I) = ZERO
              X4(I) = ZERO
              Y3(I) = ZERO
              Y4(I) = ZERO
           ENDDO
           PTITLE = TYPE1(NTYPE)
           XTITLE = 'Time'
           YTITLE = 'Rough'
           CALL GKS004 (N0, N0, N0, N0, N2, N0, N0, N0,
     +                  NTOTAL, N0, N0, n0,
     +                  V(NBEGIN), X2, X3, X4,
     +                  Z(NBEGIN), Y2, Y3, Y4,
     +                  PTITLE, XTITLE, YTITLE,
     +                  AXES, GSAVE)
            ISEND = 1
            CALL HNPLOT (ISEND, NTOTAL,
     +                   Z(NBEGIN))         
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.10 .OR. NUMDEC.EQ.11) THEN
C
C Residuals
C
            NPAR = N0
            NPTS = NTOTAL
            IF (NUMDEC.EQ.10) THEN
               FILE1 =.TRUE.
            ELSE
               FILE1 = .FALSE.
            ENDIF
            FILE2 = .TRUE.
            TSHOW1 = .TRUE.
            TSHOW2 = .TRUE.
            CALL TIME03 (NOUT, NPAR, NPTS,
     +                   Z(NBEGIN), Y(NBEGIN), X(NBEGIN),
     +                   FILE1, FILE2, TSHOW1, TSHOW2)
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.12) THEN
C
C File the smooth
C
            CALL GETNOU (NOUT1)
            NPTS = NTOTAL
            ISEND = 1
            TITLE = 'Smoothed data'
            CLOSE (UNIT = NOUT1)
            CALL VECOUT (ISEND, NTOTAL, NOUT1, NPTS,
     +                   Y(NBEGIN),
     +                   FNAME, TITLE,
     +                   ABORT, QTEXT, QTITLE)
            CLOSE (UNIT = NOUT1)
         ELSEIF (NUMDEC.EQ.13) THEN
C
C Help
C
            WRITE (TEXT,500)
            NTEXT = 21
            NUMBLD(1) = 1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT, TEXT,
     +                   BORDER)
            NUMBLD(1) = 0
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Title for current time series data is:-'
     +/A
     +/'Current sample size =',I5
     +/'Starting time (Start) =',I3
     +/'Time increment (Diff) =',I3
     +/'Filter type =',1X,A
     +/'New data'
     +/'Calculate'
     +/'Change starting time'
     +/'Change time increment'
     +/'Change smoothing type'
     +/'Table (show-save)'
     +/'Table (show-only)'
     +/'Plot smooth'
     +/'Plot rough'
     +/'Analyse residuals (show-save)'
     +/'Analyse residuals (show-only)'
     +/'Save smooth As...'
     +/'Help'
     +/'Quit ... Exit these time series analysis options')
  200 FORMAT (
     +'         Time         Data       Smooth        Rough')
  300 FORMAT (1P,2E13.5)
  400 FORMAT (1P,5E13.5)
  500 FORMAT (
     + 'Definitions for time series smoothing'
     +/
     +/'The procedures assume you have a sample of values measured'
     +/'at equal increments of time (or space, etc.) and wish to'
     +/'generate smooth (i.e. best-fit) and rough (i.e. residuals).'
     +/'Start `first time value'
     +/'Diff  `increment between time values'
     +/
     +/'Type  `type of smoothing filter required as follows:'
     +/'1)    `Running median span 4 then 2'
     +/'2)    `Running median span 5'
     +/'3)    `Running median span 3'
     +/'4)    `Moving average span 3 Hanning'
     +/'5)    `4253H twice smoother'
     +/
     +/'Even span moving averages use Hanning, 4253H twice does 4 by 2,'
     +/'then 5, then 3 running medians, then Hanning, then re-roughs.'
     +/'Try 3) for sparse data, 4253H twice for extensive data.'
     +/'Data can be plotted, tables of smooth and rough can be saved'
     +/'to file and/or displayed, residuals can be analysed, and the'
     +/'smooth can be written to a file for time series analysis.')
      END
C
C
