c
c
      subroutine time05 (isend, n, nstart, ntotal,
     +                   x, y, z)
c
c action: smooth a time series
c author: w.g.bardsley, university of manchester, u.k., 18/02/2002
c         01/06/2015 added intents, now calls t4253hx, and returns nstart = 1, ntotal = n
c
c         supply x and return y and z after smoothing as follows:
c
c         x = original data (unchanged)
c         y = smooth (best-fit)
c         z = rough (residuals)
c                                     
c         isend = 1: running median span 4 then 2
c         isend = 2: running median span 5
c         isend = 3: running span median 3
c         isend = 4: moving average span 3 Hanning
c         isend = 5: t4253h                        
c
c         nstart = starting position for smoothed series
c         ntotal = number of smoothed data points
c
      implicit   none
c
c arguments
c      
      integer,          intent (in)  :: isend, n
      integer,          intent (out) :: nstart, ntotal
      double precision, intent (in)  :: x(n)
      double precision, intent (out) :: y(n), z(n)
c
c locals
c      
      integer    i, jsend
      double precision zero
      parameter (zero = 0.0d+00)
      external   t4253h, t4253x
c
c initialise ntotal, nstart, and y
c      
      nstart = 1
      ntotal = n

      if (isend.lt.5) then
         do i = 1, n
            y(i) = x(i)
         enddo
      endif
               
      if (isend.eq.1) then
c
c running median span 4 then 2
c
         jsend = 1
         call t4253x (jsend, n,
     +                y, z)   
         jsend = 2   
         call t4253x (jsend, n,
     +                y, z)      
      elseif (isend.eq.2) then
c
c running median span 5
c
         jsend = 3
         call t4253x (jsend, n,
     +                y, z)   
      elseif (isend.eq.3) then
c
c running median span 3
c
         jsend = 4
         call t4253x (jsend, n,
     +                y, z) 
      elseif (isend.eq.4) then
c
c moving average Hanning
c
         jsend = 5
         call t4253x (jsend, n,
     +                y, z) 
      elseif (isend.eq.5) then   
c
c t4253h
c       
         call t4253h (n,
     +                x, y, z)  
      else
         nstart = 0
         ntotal = 0
         do i = 1, n
            y(i) = zero
            z(i) = zero
         enddo
         return
      endif
c
c now work out the rough
c     
      if (isend.ne.5) then
         do i = 1, n  
            z(i) = x(i) - y(i)
         enddo
      endif   
      end
c
c
