C
C
      SUBROUTINE TRAPZD (N, AREA, X, Y)
C
C ACTION : Supply N, X, Y ...  Calculate AREA by trapezoidal rule
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 3/6/91
C          Date of this version 19/10/95
C
      IMPLICIT   NONE
      INTEGER    N
      INTEGER    I
      DOUBLE PRECISION AREA, X(N), Y(N)
      DOUBLE PRECISION HALF, ZERO
      PARAMETER (HALF = 0.5D+00, ZERO = 0.0D+00)
      CHARACTER  LINE*100
      EXTERNAL   PUTFAT
      AREA = ZERO
      DO I = 2, N
         IF (X(I).LT.X(I - 1)) THEN
            WRITE (LINE,100) I
            CALL PUTFAT (LINE)
            AREA = ZERO
            RETURN
         ENDIF
         AREA = AREA + (X(I) - X(I - 1))*(Y(I) + Y(I - 1))
      ENDDO
      AREA = HALF*AREA
  100 FORMAT ('X decreasing at line',I6,' in TRAPZD .. AREA set = 0')
      END
C
C
