C
C
      SUBROUTINE TTEST1 (NIN, NMAX, NOUT, NUMX, 
     +                   X, XSTEP, YSTEP,
     +                   TITLEX)
C
C ACTION : 1-sample t test
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 02/12/2003
C          02/12/2003 derived from subroutine TTESTS
C

      IMPLICIT   NONE
      INTEGER    NIN, NMAX, NOUT, NUMX
      INTEGER    I, ICOLOR, ICOUNT, IFAIL, NDOF, NUMTXT
      INTEGER    ISEND
      PARAMETER (ISEND = 4)
      INTEGER    IX, IY, K0, K1, K2, K3
      PARAMETER (IX = 4, IY = 4, K0 = 0, K1 = 1, K2 = 2, K3 = 3)
      DOUBLE PRECISION PNT01, PNT05, PNT975
      PARAMETER (PNT01 = 0.01D+00, PNT05 = 0.05D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION X(NMAX), XSTEP(2*NMAX), YSTEP(2*NMAX)
      DOUBLE PRECISION RTOL
      DOUBLE PRECISION SEMEAN, XMU
      DOUBLE PRECISION ALPHA, BETA, GAMMA, XBAR, XVAR
      DOUBLE PRECISION DIFF, DHIGH, DLOW, DNDF
      DOUBLE PRECISION TU, T95
      DOUBLE PRECISION G01EBF$, G01FBF$, X02AMF$
      CHARACTER  TITLEX*(*)
      CHARACTER  LINE*100, TEXT(30)*100, TTEXT(4)*100
      CHARACTER  CHOP60*60, WORD60*60, TEMP(4)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, REPEET
      LOGICAL    FIXNPT
      PARAMETER (FIXNPT = .FALSE.)
      EXTERNAL   G01EBF$, G01FBF$, X02AMF$
      EXTERNAL   NXXBAR, PUTFAT, PUTIFA, TABLE1, MIDDLE, VECONE,
     +           NORDIS, GETD01, CHOP60, YESNO2
      INTRINSIC  SQRT, MIN, DBLE
      SAVE       XMU
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
      DATA       XMU / ZERO /
C
C First read in data ... Use a larger RTOL than usual
C
      RTOL = 1.0D+09*X02AMF$()
      RTOL = 1.0D+09*RTOL
      CALL VECONE (NIN, NMAX, NUMX, X, TITLEX, ABORT, FIXNPT)
      IF (ABORT) RETURN
      IF (NUMX.LT.K2) THEN
         WRITE (LINE,100) NUMX
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C Calculate means and variances
C
      CALL NXXBAR (NUMX, X, XBAR, XVAR)
      SEMEAN = SQRT(XVAR/DBLE(NUMX))
      IF (XVAR.LE.RTOL) THEN
         WRITE (LINE,200)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C Shapiro-Wilks
C
      WORD60 = CHOP60(TITLEX)
      CALL NORDIS (ISEND, NUMX, NOUT,
     +             X, XSTEP, YSTEP, 
     +             TTEXT, WORD60)
C
C Get reference
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (LINE,300)
         CALL GETD01 (XMU, LINE)
C
C t test
C
         DIFF = XBAR - XMU
         TU = DIFF/SEMEAN
         NDOF = NUMX - K1
         DNDF = DBLE(NDOF)
         IFAIL = K1
         BETA = G01EBF$('Lower-tail', TU, DNDF, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G01EBF/TTEST1')
         ALPHA = ONE - BETA
         GAMMA = TWO*MIN(ALPHA, BETA)
         CALL MIDDLE (ZERO, ALPHA, ONE)
         CALL MIDDLE (ZERO, BETA, ONE)
         CALL MIDDLE (ZERO, GAMMA, ONE)
         ICOUNT = ICOUNT + K1
         WRITE (TEXT,400) ICOUNT,
     +                    NUMX, NDOF, XMU, XBAR, SEMEAN, TU,
     +                    ALPHA, BETA, GAMMA
         WRITE (NOUT,500) ICOUNT,
     +                    NUMX, NDOF, XMU, XBAR, SEMEAN, TU,
     +                    ALPHA, BETA, GAMMA
         NUMTXT = 11
         IFAIL = K1
         T95 = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
         IF (IFAIL.EQ.K0) THEN
            DLOW = DIFF - T95*SEMEAN
            DHIGH = DIFF + T95*SEMEAN
            WRITE (TEMP,600) DIFF, DLOW, DHIGH
            WRITE (NOUT,700) DIFF, DLOW, DHIGH
            DO I = K1, K3
               NUMTXT = NUMTXT + K1
               TEXT(NUMTXT) = TEMP(I)
            ENDDO
         ELSE
            CALL PUTIFA (IFAIL, NOUT, 'G01FBF/TTEST1')
         ENDIF
         IF (GAMMA.LE.PNT01) THEN
            WRITE (LINE,800)
            WRITE (NOUT,800)
         ELSEIF (GAMMA.LE.PNT05) THEN
            WRITE (LINE,900)
            WRITE (NOUT,900)
         ELSE
            WRITE (LINE,1000)
            WRITE (NOUT,1000)
         ENDIF
         NUMTXT = NUMTXT + K1
         TEXT(NUMTXT) = BLANK
         NUMTXT = NUMTXT + K1
         TEXT(NUMTXT) = LINE
         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         DO I = K1, NUMTXT
            IF (I.EQ.1 .OR. I.EQ.NUMTXT) THEN
               ICOLOR = 4
            ELSE
               ICOLOR = 0
            ENDIF
            CALL TABLE1 (ICOLOR, TEXT(I))
         ENDDO
         CALL TABLE1 (ICOLOR, 'CLOSE')
         ICOLOR = 1
         WRITE (LINE,1100)
         CALL YESNO2 (ICOLOR, IX, IY, LINE, REPEET)
      ENDDO
  100 FORMAT ('Nx =',I2,' ... Sample size too small')
  200 FORMAT ('Variance too small for analysis')
  300 FORMAT ('Theoretical population mean mu_0')
  400 FORMAT (
     + 'One sample t test',I4
     +/
     +/'No. of x-values           =',I8
     +/'No. of degrees of freedom =',I8
     +/'Theoretical mean (mu_0)   =',1P,E11.3
     +/'Sample mean (x_bar)       =',   E11.3
     +/'Std. err. of mean (SE)    =',   E11.3
     +/'TS = (x_bar - mu_0)/SE    =',   E11.3
     +/'P(t >= TS) (upper tail p) =',0P,F8.4
     +/'P(t =< TS) (lower tail p) =',   F8.4
     +/'p for two tailed t test   =',   F8.4)
  500 FORMAT (
     +/1X,'One sample t test',I4
     +/1X,'====================='
     +/1X,'No. of x-values           =',I8
     +/1X,'No. of degrees of freedom =',I8
     +/1X,'Theoretical mean (mu_0)   =',1P,E11.3
     +/1X,'Sample mean (x_bar)       =',   E11.3
     +/1X,'Std. err. of mean (SE)    =',   E11.3
     +/1X,'TS = (x_bar - mu_0)/SE    =',   E11.3
     +/1X,'P(t >= TS) (upper tail p) =',0P,F8.4
     +/1X,'P(t =< TS) (lower tail p) =',F8.4
     +/1X,'p for two tailed t test   =',F8.4)
  600 FORMAT (
     + 'Diffn. D = x_bar - mu_0   =',1P,E11.3
     +/'Lower 95% con. lim. for D =',   E11.3
     +/'Upper 95% con. lim. for D =',   E11.3)
  700 FORMAT (
     + 1X,'Diffn. D = x_bar - x_mu   =',1P,E11.3
     +/1X,'Lower 95% con. lim. for D =',   E11.3
     +/1X,'Upper 95% con. lim. for D =',   E11.3)
  800 FORMAT (
     +1X,'Conclusion: Reject equality of means at 1% sig. level' )
  900 FORMAT (
     +1X,'Conclusion: Reject equality of means at 5% sig. level' )
 1000 FORMAT (
     +1X,'Conclusion: Consider accepting equality of means')
 1100 FORMAT ('Try again with a different mu_0 value')
      END
C
C
