c
c
      subroutine ttest2 (nout)
c
c action: corrected t test on two parameters
c author: w.g.bardsley, university of manchester, u.k., 29/01/2003
c         29/11/2021 added E_NUMBERS and E_FORMATS, etc
c
c         nout: (input/unchanged) preconnected unit for results
c
      implicit   none
c
c argument
c
      integer    nout
c
c locals
c
      integer    npar1, npar2, npts1, npts2
      integer    i, icount, ifail
      integer    n0, n1, n2
      parameter (n0 = 0, n1 = 1, n2 = 2)
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart,
     +           numtxt
      parameter (ix = 4, iy = 4, lshade = 1, numopt = 12, nstart = 3)
      integer    numbld(30), numpos(numopt)
      double precision se1, se2, var1, var2, xbar1, xbar2
      double precision ph1, ph2, pl1, pl2
      double precision bot, pval, top, tval
      double precision dof, dof1, dof2
      double precision one, two, epsi, pnt975
      parameter (one = 1.0d+00, two = 2.0d+00, epsi = 1.0d-10, 
     +           pnt975 = 0.975d+00)
      double precision g01ebf$, g01fbf$
      character (len = 13) d13(9), showlj, showrj
      character (len = 12) i12(5), form12
      character  cipher*40, text(30)*100, word6(4)*6
      character  blank*1
      parameter (blank = ' ')
      logical    e_numbers, e_formats
      logical    repeet
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .false.)
      external   e_formats, form12, showlj, showrj
      external   getjge, getdge, putfat, triml1, revpro, plevel, lbox01,
     +           patch1, getd01, putifa, table1
      external   g01ebf$, g01fbf$
      intrinsic  dble, sqrt, nint
      save       npar1, npar2, npts1, npts2
      save       se1, se2, xbar1, xbar2
      data       npar1, npar2, npts1, npts2 / 1, 1, 10, 20 /
      data       se1, se2, xbar1, xbar2 / one, two, one, two /
      data       numbld / 30*0 /
      data       numpos /numopt*1 /
      data       icount / 0 / 
c
c initialise so help is first menu item
c    
      e_numbers = e_formats()
      icount = icount + 1
      write (nout,50) icount
      numdec = numopt - n2
      repeet = .true.
      do while (repeet)
c
c main loop starts so left justify integers and throw out the menu
c
         if (e_numbers) then
            write (word6(1),'(i6)') npts1
            write (word6(2),'(i6)') npts2
            write (word6(3),'(i6)') npar1
            write (word6(4),'(i6)') npar2
            do i = 1, 4
               call triml1 (word6(i))
            enddo
         else   
            i12(1) = form12(npts1)
            i12(2) = form12(npts2)
            i12(3) = form12(npar1)
            i12(4) = form12(npar2)
            d13(1) = showlj(xbar1)
            d13(2) = showlj(xbar2)
            d13(3) = showlj(se1)
            d13(4) = showlj(se2)	
         endif   
         
         if (e_numbers) then 
            write (text,100) icount, xbar1, xbar2, se1, se2, 
     +                       (word6(i), i = 1, 4)
         else
            write (text,150) icount, (d13(i), i = 1, 4),  
     +                       (i12(i), i = 1, 4) 
         endif  
         numtxt = nstart + numopt - 1
         numbld(1) = 4
         icolor = 3
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, numtxt,
     +                text,
     +                border, flash, high)
         numbld(1) = 0
         if (numdec.eq.1) then
c
c get parameter 1
c
            call getd01 (xbar1,'mean or parameter estimate 1')
         elseif (numdec.eq.2) then
c
c get parameter 2
c
            call getd01 (xbar2,'mean or parameter estimate 2')
         elseif (numdec.eq.3) then
c
c get std. err. 1
c
            call getdge (se1, epsi,'standard error 1')
         elseif (numdec.eq.4) then
c
c get std. err. 2
c
            call getdge (se2, epsi,'standard error 2')
         elseif (numdec.eq.5) then
c
c get npts 1
c
            call getjge (npts1, n2, 'sample size or number of points 1')
         elseif (numdec.eq.6) then
c
c get npts 2
c
            call getjge (npts2, n2, 'sample size or number of points 2')
         elseif (numdec.eq.7) then
c
c get npar 1
c
            call getjge (npar1, n1, 'no. parameters for sample 1')
         elseif (numdec.eq.8) then
c
c get npar 2
c
            call getjge (npar2, n1, 'no. parameters for sample 2')
         elseif (numdec.eq.9) then
c
c do the corrected t test
c
            if (npar1.ge.npts1 .or. npar2.ge.npts2) then
               call putfat ('Must have npts > npar for t test')
            else
c
c calculate 95% confidence limits
c
               dof1 = dble(npts1 - npar1)
               ifail = n0
               tval = g01fbf$('L', pnt975, dof1, ifail)
               call putifa (ifail, nout, 'G01FBF/TTEST2')
               ph1 = xbar1 + tval*se1
               pl1 = xbar1 - tval*se1
               dof2 = dble(npts2 - npar2)
               ifail = n0
               tval = g01fbf$('L', pnt975, dof2, ifail)
               call putifa (ifail, nout, 'G01FBF/TTEST2')
               ph2 = xbar2 + tval*se2
               pl2 = xbar2 - tval*se2
c
c calculate the t statistic
c
               var1 = se1**2
               var2 = se2**2
               top = xbar1 - xbar2
               bot = sqrt(var1 + var2)
               tval = top/bot
c
c calculate the degrees of freedom (using n - 1 not n - 3 as Welch suggests)
c
               top = (var1 + var2)**2
               bot = var1**2/dof1 + var2**2/dof2
               dof = top/bot
               ifail = n0
               pval = g01ebf$('S', tval, dof, ifail)
               call putifa (ifail, nout, 'G01EBF/TTEST2')
               call plevel (pval, cipher)
c
c output results
c
               if (e_numbers) then
                  write (text,200) xbar1, se1, pl1, ph1, npts1, npar1,
     +                             xbar2, se2, pl2, ph2, npts2, npar2,
     +                             tval, nint(dof), pval, cipher
               else
                  d13(1) = showrj(xbar1)
                  d13(2) = showrj(se1)
                  d13(3) = showrj(pl1)
                  d13(4) = showrj(ph1)
                  d13(5) = showrj(xbar2)
                  d13(6) = showrj(se2) 
                  d13(7) = showrj(pl2)
                  d13(8) = showrj(ph2)
                  d13(9) = showlj(tval)
                  i = nint(dof)
                  i12(5) = form12(i)
                  write (text,250) d13(1), d13(2), d13(3), d13(4), 
     +                             npts1, npar1,
     +                             d13(5), d13(6), d13(7), d13(8),
     +                             npts2, npar2,
     +                             d13(9), i12(5), pval, cipher 
               endif  
               write (nout,'(a)') blank
               icolor = 15
               call table1 (icolor, 'OPEN')
               do i = 1, 7
                  if (i.eq.1) then
                     icolor = 1
                  elseif (i.eq.2) then
                     icolor = 4
                  else
                     icolor = 0
                  endif
                  call table1 (icolor, text(i))
                  write (nout,'(a)') text(i)
               enddo
               call table1 (icolor, 'CLOSE')
            endif
         elseif (numdec.eq.10) then
c
c help
c
            write (text, 300)
            numbld(1) = 1
            numtxt = 22
            icolor = 9
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = 0
         elseif (numdec.eq.11) then
c
c review progress
c
            call revpro (nout)
         elseif (numdec.eq.12) then
c
c cancel
c
            repeet = .false.
         endif
      enddo
   50 format (
     + ' Comparing two means or regression parameters:',i3 
     +/' ------------------------------------------------'
     +/)  
  100 format (
     + 'Comparing two means or regression parameters:',i3 
     +/
     +/'Change p_hat 1: current =',1p,e11.3
     +/'Change p_hat 2: current =',1p,e11.3
     +/'Change std.err. 1: current =',1p,e11.3
     +/'Change std.err. 2: current =',1p,e11.3
     +/'Change npts 1: current = ',a
     +/'Change npts 2: current = ',a
     +/'Change npar 1: current = ',a
     +/'Change npar 2: current = ',a
     +/'Test'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit these options')
  150 format (
     + 'Comparing two means or regression parameters:',i3 
     +/
     +/'Change p_hat 1: current =',1x,a
     +/'Change p_hat 2: current =',1x,a
     +/'Change std.err. 1: current =',1x,a
     +/'Change std.err. 2: current =',1x,a
     +/'Change npts 1: current = ',1x,a
     +/'Change npts 2: current = ',1x,a
     +/'Change npar 1: current = ',1x,a
     +/'Change npar 2: current = ',1x,a
     +/'Test'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit these options')   
  200 format (
     + ' Unequal variance t test for H0: parameter_1 = parameter_2'
     +/'      estimate      std.err.       ...95% conf.lim. ...',
     +'         npts        npar'
     +/1p,4(1x,e13.5),i12,i12
     +/1p,4(1x,e13.5),i12,i12
     +/' CT (corrected test statistic)      =',1p,e13.5
     +/' DOF (corrected degrees of freedom) =',i8
     +/' p = P(t =< -|CT|) + P(t >= |CT|)   =',0p,f8.4,2x,a)
  250 format (
     + ' Unequal variance t test for H0: parameter_1 = parameter_2'
     +/'      estimate      std.err.       95% confidence limits',
     +'        npts        npar'
     +/4(1x,a),i12,i12
     +/4(1x,a),i12,i12
     +/' CT (corrected test statistic)      =',1x,a
     +/' DOF (corrected degrees of freedom) =',1x,a
     +/' p = P(t =< -|CT|) + P(t >= |CT|)   =',f7.4,2x,a)   
  300 format (
     + 'Comparing two means (x_bar) or parameter estimates (p_hat)'
     +/
     +/'This does a 2-tail t test for H0: mu_1 =  mu_2, corrected for'
     +/'unequal variances. It is used to do a t test retrospectively'
     +/'with sample means, variances and sizes, or else to compare two'
     +/'parameters and standard errors estimated by regression.'
     +/
     +/'With samples from normal distributions you need:'
     +/'npts = sample size'
     +/'p_hat = x_bar (i.e. sum values/npts)'
     +/'s^2  = sample variance (sum of (values - x_bar)^2/(npts - 1))'
     +/'std.err. = standard error of the mean (i.e. sqrt(s^2/npts))'
     +/'npar = 1 (number of parameters estimated, i.e. x_bar)'
     +/
     +/'With parameters estimated by regression you need:'
     +/'npts = number of points fitted (including all replicates)'
     +/'p_hat = parameter estimate'
     +/'std.err. = estimated standard error'
     +/'npar = number of parameters estimated in the regression'
     +/'For example, comparing two LD50 estimates from GLM would need:'
     +/'npts = no. of proportions (i.e. sets of y out of N given x)'
     +/'npar = 2 (since a slope and intercept are estimated by GLM).')
      end
c
c
